<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:css="http://www.w3.org/TR/XSL-for-CSS" xmlns:util="com.ge.med.cse.cvf.sr.SRUtils">
  <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	
	<!-- Global variables -->
	<xsl:variable name="DICOM" select="/DICOM" />
	<xsl:variable name="ImageDir" select="$DICOM/@SRImage" />
	<xsl:variable name="langdoc" select="$DICOM/@langDoc" />
	<xsl:variable name="BLANK" select="''"/>
	<xsl:variable name="BLANKSPACE" select="' '"/>
	<xsl:variable name="DATETIMESEPARATOR" select="' / '"/>
	
	<xsl:template match="/">
	<html>
      <head> <link rel="stylesheet" type="text/css" href="CUIStyle_html.css"/> </head>
       <body class="bodystyle">
       <a><img src="GE_Healthcare_Logo.png" name="Logo"></img></a>
          <h1 class="titleheading"><xsl:value-of select="document($langdoc)/Dictionary/Title"/> <span style="color: #ff0000"> (<xsl:value-of select="document($langdoc)/Dictionary/NotForClinicalUse"/>)</span></h1>
		  <p class="sectionlabel"><xsl:value-of select="document($langdoc)/Dictionary/PatInfo/PatInfoTitle"/></p>
		  <form class="frame">
		   <table width="100%" border="0" class="tableprop">
		    <tr>
		    <th width="5%"></th>
		    <th width="25%"></th>
		    <th width="5%"></th>
		    <th width="5%"></th>
		    <th width="5%"></th>
		    <th width="25%"></th>
		    <th width="7%"></th>
		    <th width="23%"></th>
		    </tr>
			 <tr>
				<td class="fieldlabel"><b><xsl:value-of select="document($langdoc)/Dictionary/PatInfo/PatName"/></b></td>
				<td class="fieldvalue">
				<xsl:variable name="patName">
         		 <xsl:value-of select="$DICOM/PatientName"/>
                </xsl:variable>
                <xsl:value-of select="util:getPatientName($patName)"/>
				</td>
				<td class="fieldlabel"><b><xsl:value-of select="document($langdoc)/Dictionary/PatInfo/PatSex"/></b></td>
				<td class="fieldvalue"><xsl:value-of select="$DICOM/PatientSex"/></td>
				<td class="fieldlabel"><b><xsl:value-of select="document($langdoc)/Dictionary/PatInfo/PatBirthDay"/></b></td>
				<td class="fieldvalue"><xsl:variable name="patDOB"><xsl:value-of select="$DICOM/PatientBirthDate"/></xsl:variable>
         	    <xsl:value-of select="util:getDateValue($patDOB)"/></td>
				<td class="fieldlabel"><b><xsl:value-of select="document($langdoc)/Dictionary/PatInfo/PatID"/></b></td>
				<td class="fieldvalue"><xsl:value-of select="$DICOM/PatientID"/></td>
			 </tr>
		  </table>
		  </form>
		  <p class="sectionlabel"><xsl:value-of select="document($langdoc)/Dictionary/DeviceInfo/DeviceInfoTitle"/></p>
		   <form class="frame">
		    <table border="0" width="100%">
		    <tr>
		    <th width="10%"></th>
		    <th WIDTH="20%"></th>
		    <th WIDTH="20%"></th>
		    <th width="20%"></th>
		    <th WIDTH="10%"></th>
		    <th WIDTH="30%"></th>
		    </tr>
			 <tr>
				<td class="fieldlabel"><b><xsl:value-of select="document($langdoc)/Dictionary/DeviceInfo/Organization"/></b></td>
				<td class="fieldvalue"><xsl:value-of select="$DICOM/InstitutionName"/></td>
				<td class="fieldlabel"><b><xsl:value-of select="document($langdoc)/Dictionary/DeviceInfo/Manufacturer"/></b></td>
				<td class="fieldvalue"><xsl:value-of select="$DICOM/Manufacturer"/></td>
				<td class="fieldlabel"><b><xsl:value-of select="document($langdoc)/Dictionary/DeviceInfo/Model"/></b></td>
				<td class="fieldvalue"><xsl:value-of select="$DICOM/ManufacturerModelName"/></td>
			 </tr>
			 </table>
			  <table border="0" width="100%">
			  <tr>
			    <th width="10%"></th>
			    <th WIDTH="20%"></th>
			    <th WIDTH="20%"></th>
			    <th width="50%"></th>
		    </tr>
		    <tr>
				<td class="fieldlabel"><b><xsl:value-of select="document($langdoc)/Dictionary/DeviceInfo/SerialNo"/></b></td>
				<td class="fieldvalue"><xsl:value-of select="$DICOM/DeviceSerialNumber"/></td>
				<td class="fieldlabel"><b><xsl:value-of select="document($langdoc)/Dictionary/DeviceInfo/SoftwareVersion"/></b></td>
				<td class="fieldvalue"><xsl:value-of select="$DICOM/SoftwareVersion"/></td>
			 </tr>
		    </table>
		  </form>
		  
		  <xsl:call-template name="writeAccumulatedDoseData">
			<xsl:with-param name="curNode" select="$DICOM" />
		  </xsl:call-template>
		  
			<xsl:call-template name="writeXRayIrradiationData">
			 <xsl:with-param name="curNode" select="$DICOM" />
		    </xsl:call-template>
		 
		 <p>
          <font size="3">
	       <xsl:for-each select="$DICOM/ContentSequence/Item">
		    <xsl:if test="ConceptNameCodeSequence/Item/CodeValue ='113705'">
			 <xsl:value-of select="document($langdoc)/Dictionary/ObservationContext/ObservationContextTitle"/> <xsl:value-of select="ConceptNameCodeSequence/Item/CodeMeaning"/> : <xsl:value-of select="ConceptCodeSequence/Item/CodeMeaning"/>
		    </xsl:if>
	       </xsl:for-each>
          </font>
         </p>
         <table border="0" width="1000">
	      <tr>
	       <th width="30%"></th>
	       <th WIDTH="70%"></th>
	      </tr>
		  <tr>
		   <td><b><xsl:value-of select="document($langdoc)/Dictionary/CompletionFlag"/></b></td>
		   <td><xsl:value-of select="$DICOM/CompletionFlag"/></td>
		  </tr>
		  <tr>
		   <td><b><xsl:value-of select="document($langdoc)/Dictionary/VerificationFlag"/></b></td>
		   <td><xsl:value-of select="$DICOM/VerificationFlag"/></td>
		  </tr>
		  <tr>
		   <td><b><xsl:value-of select="document($langdoc)/Dictionary/ContentDateTime"/></b></td>
		   <td><xsl:variable name="contentDate">
		         <xsl:value-of select="$DICOM/ContentDate"/>
		       </xsl:variable>
         	   <xsl:value-of select="util:getDateValue($contentDate)"/><xsl:value-of select="$DATETIMESEPARATOR"/>
         	   <xsl:variable name="contentTime">
		         <xsl:value-of select="$DICOM/ContentTime"/>
		       </xsl:variable>
         	   <xsl:value-of select="util:getTimeValue($contentTime)"/>
            </td>
		  </tr>
	     </table>
	     <xsl:for-each select="$DICOM/ContentSequence/Item">
	      <xsl:if test="ValueType_IMAGE = 'IMAGE'">
	       <xsl:if test="util:hasImgeOrWaveForm()">
	        <xsl:call-template name="addImage">
			 <xsl:with-param name="pSOPClassUID"
				select="ReferencedSOPSequence/Item/ReferencedSOPClassUID" />
			 <xsl:with-param name="pSOPInstUID"
				select="ReferencedSOPSequence/Item/ReferencedSOPInstanceUID" />
			 <xsl:with-param name="pIconImageSeq"
				select="ReferencedSOPSequence/Item/IconImageSequence" />
		    </xsl:call-template>
	       </xsl:if>
	      </xsl:if>
	     </xsl:for-each>
       </body>
      </html>
	</xsl:template>
	
	<xsl:template name="writeXRayIrradiationData">
	 <xsl:param name="curNode"/>
	 <p class="sectionlabel"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/IrradiationEventXRayDataTitle"/></p>
	 <form class="frame">
	  <table width="100%" border="0">
	 <form class="frame">
      <table border="1" width="100%" cellspacing="0" frame="box" rules="all">
      <tr>    
        <th width="8%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/AcquistionPlane"/></th>
        <th WIDTH="8%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/DateTimeStarted"/></th>
        <th WIDTH="8%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/IrradiationEventType"/></th>
        <th WIDTH="8%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/AcquisitionProtocol"/></th>
        <th WIDTH="4%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/DAP"/></th>
        <th WIDTH="4%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/DoseRP"/></th>
        <th WIDTH="9%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/CollimatedFieldArea"/></th>
        <th WIDTH="8%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/FluoroMode"/></th>
        <th WIDTH="8%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/PulseRate"/></th>
        <th WIDTH="4%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/kVp"/></th>
        <th WIDTH="4%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/mA"/></th>
        <th WIDTH="7%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/PulseWidth"/></th>
        <th WIDTH="4%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/Exposure"/></th>
        <th WIDTH="9%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/FocalSpotSize"/></th>
        <th WIDTH="7%" class="tableheader2"><xsl:value-of select="document($langdoc)/Dictionary/IrradiationEventXRayData/PatientOrientation"/></th>
      </tr>
      <xsl:for-each select="$curNode/ContentSequence/Item">
	   <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113706'">
	    <tr>
            <td class="tablecell2">
             <xsl:call-template name="writeAcquisitionPlaneValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
            <td class="tablecell2">
             <xsl:call-template name="writeDateTimeValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writeIrrEventTypeValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writeAcqProtocolValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writeDAPValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writeDoseRPValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writeCollFieldAreaValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writeFluoroModeValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writePulseRateValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writekVpValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writemAValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writePulseWidthValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
            <td class="tablecell2">
             <xsl:call-template name="writeExposureValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writeFocalSpotSizeValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
            </td>
           <td class="tablecell2">
             <xsl:call-template name="writePatientOrientationValue">
             <xsl:with-param name="curNode" select="current()"/>
             </xsl:call-template>
           </td>
	    </tr>
	   </xsl:if>
	   </xsl:for-each>
     </table>
     </form>
      </table>
     </form>
	</xsl:template>
	
    <xsl:template name="writeAcquisitionPlaneValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113764'">
         <xsl:value-of select="ConceptCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
      <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writeDateTimeValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '111526'">
         <xsl:variable name="dateTimeVal">
         <xsl:value-of select="DateTime"/>
         </xsl:variable>
         <xsl:value-of select="util:getDateTimeValue($dateTimeVal, 0)"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
     <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writeIrrEventTypeValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113721'">
         <xsl:value-of select="ConceptCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
     <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writeAcqProtocolValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '125203'">
         <xsl:value-of select="TextValue"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
     <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writeDAPValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '122130'">
         <xsl:value-of select="MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
       </xsl:for-each>
      </xsl:variable>
     <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writeDoseRPValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113738'">
         <xsl:value-of select="MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
      <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writeCollFieldAreaValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113790'">
         <xsl:value-of select="MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
      <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writeFluoroModeValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113732'">
         <xsl:value-of select="ConceptCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
     <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writePulseRateValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113791'">
         <xsl:value-of select="MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
      <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writekVpValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113733'">
         <xsl:value-of select="MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
      <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writemAValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
       <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113734'">
        <xsl:value-of select="MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
       </xsl:if>
      </xsl:for-each>
      </xsl:variable>
     <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writePulseWidthValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113793'">
        <xsl:value-of select="MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
      <xsl:choose>
      <xsl:when test="$value != ''">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writeExposureValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113736'">
         <xsl:value-of select="MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
      <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writeFocalSpotSizeValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113766'">
         <xsl:value-of select="MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
      <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>
	
	<xsl:template name="writePatientOrientationValue">
	 <xsl:param name="curNode"/>
	 <xsl:variable name="value">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
        <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113743'">
         <xsl:value-of select="ConceptCodeSequence/Item/CodeMeaning"/>
        </xsl:if>
      </xsl:for-each>
      </xsl:variable>
      <xsl:choose>
      <xsl:when test="string-length($value) > 0">
       <xsl:value-of select="$value"/>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="$BLANK"/><!-- Fill with blank if it does not have a value -->
      </xsl:otherwise>
      </xsl:choose>
	</xsl:template>

	
	<xsl:template name="writeAccumulatedDoseData">
	 <xsl:param name="curNode"/>
      <xsl:for-each select="$curNode/ContentSequence/Item">
	   <xsl:if test="ConceptNameCodeSequence/Item/CodeValue = '113702'">
	   <p class="sectionlabel"><xsl:value-of select="document($langdoc)/Dictionary/AccumulatedDose/AccumulatedDoseTitle"/></p>
	   <form class="frame">
        <table width="100%" border="0">
	      <xsl:for-each select="ContentSequence/Item">
	      <xsl:choose>
	       <xsl:when test="ConceptNameCodeSequence/Item/CodeValue = '122505'">
	        <xsl:call-template name="writeCalibrationData">
	         <xsl:with-param name="cuNode" select="current()" />
	        </xsl:call-template>
	       </xsl:when>
	       <xsl:when test="not(ConceptNameCodeSequence/Item/CodeMeaning = '')">
	        <tr>
			 <td class="fieldlabel" style="width: 35%; vertical-align: center;">
				<b><xsl:value-of select="ConceptNameCodeSequence/Item/CodeMeaning"/></b>
			 </td>
			 <td style="vertical-align: center;">
				<b>:</b>  <td class="fieldvalue">
				<xsl:call-template name="getFieldValue">
				 <xsl:with-param name="currentNode" select="current()"/>
				 <xsl:with-param name="field" select="ConceptNameCodeSequence/Item/CodeValue"/>
				</xsl:call-template>
			 </td></td>
		     </tr>
	        </xsl:when>
	        <xsl:otherwise>
	       </xsl:otherwise>
	      </xsl:choose>
          </xsl:for-each>
	     </table>
        </form>
	   </xsl:if>
	   </xsl:for-each>
	</xsl:template>
	
	<xsl:template name="getFieldValue">
	 <xsl:param name="currentNode"/>
	 <xsl:param name="field"/>
	 <xsl:if test="$field = '113764'">
        <xsl:value-of select="$currentNode/ConceptCodeSequence/Item/CodeMeaning"/>
     </xsl:if>
	 <xsl:if test="$field = '113722'">
        <xsl:value-of select="$currentNode/MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="$currentNode/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
     </xsl:if>
      <xsl:if test="$field = '113725'">
        <xsl:value-of select="$currentNode/MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="$currentNode/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
     </xsl:if>
      <xsl:if test="$field = '113726'">
        <xsl:value-of select="$currentNode/MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="$currentNode/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
     </xsl:if>
      <xsl:if test="$field = '113728'">
        <xsl:value-of select="$currentNode/MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="$currentNode/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
     </xsl:if>
      <xsl:if test="$field = '113730'">
        <xsl:value-of select="$currentNode/MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="$currentNode/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
     </xsl:if>
      <xsl:if test="$field = '113727'">
        <xsl:value-of select="$currentNode/MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="$currentNode/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
     </xsl:if>
      <xsl:if test="$field = '113729'">
        <xsl:value-of select="$currentNode/MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="$currentNode/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
     </xsl:if>
      <xsl:if test="$field = '113855'">
        <xsl:value-of select="$currentNode/MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="$currentNode/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/>
     </xsl:if>
     <xsl:if test="$field = '113731'">
        <xsl:value-of select="$currentNode/MeasuredValueSequence/Item/NumericValue"/>
     </xsl:if>
     <xsl:if test="$field = '113780'">
     <xsl:choose>
        <xsl:when test="$currentNode/ValueType_TEXT = 'TEXT'">
        	<xsl:value-of select="$currentNode/TextValue"/>
        </xsl:when>	
        <xsl:otherwise>
        	<xsl:value-of select="$currentNode/ConceptCodeSequence/Item/CodeMeaning"/>
        </xsl:otherwise>
     </xsl:choose>
     </xsl:if>
	</xsl:template>
	
	<xsl:template name="writeCalibrationData">
	 <xsl:param name="cuNode"/>
	 <tr>
	  <td class="fieldlabel" style="width: 35%; vertical-align: center;">
	   <b><xsl:value-of select="$cuNode/ConceptNameCodeSequence/Item/CodeMeaning"/></b>
	  </td>
	 </tr>
       <tr>
		<xsl:call-template name="getDoseMeasurementDevice">
         <xsl:with-param name="curNode" select="$cuNode" />
        </xsl:call-template>
       </tr>
       <tr>
        <xsl:call-template name="getCalibrationDate">
         <xsl:with-param name="curNode" select="$cuNode" />
        </xsl:call-template>
       </tr>
       <tr>
        <xsl:call-template name="getCalibrationFactor">
         <xsl:with-param name="curNode" select="$cuNode" />
        </xsl:call-template>
       </tr>
       <tr>
        <xsl:call-template name="getCalibrationUncertainity">
         <xsl:with-param name="curNode" select="$cuNode" />
        </xsl:call-template>
       </tr>
       <tr>
        <xsl:call-template name="getCalibrationResponsibleParty">
         <xsl:with-param name="curNode" select="$cuNode" />
        </xsl:call-template>
       </tr>
	</xsl:template>
	
	<xsl:template name="getDoseMeasurementDevice">
	 <xsl:param name="curNode"/>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue = '113794'">
	 <td class="fieldlabel" style="width: 35%; vertical-align: center;">
		<li><b><xsl:value-of select="$curNode/ConceptNameCodeSequence/Item/CodeMeaning"/></b></li>
	 </td>
	 <td style="vertical-align: center;">
		<b>:</b><td class="fieldvalue"><xsl:value-of select="$curNode/ConceptCodeSequence/Item/CodeMeaning"/></td>
	 </td>
	 </xsl:if>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue != '113794'">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
	    <xsl:call-template name="getDoseMeasurementDevice">
	     <xsl:with-param name="curNode" select="current()"/>
	    </xsl:call-template>
	   </xsl:for-each>
	  </xsl:if>
	</xsl:template>
	
	<xsl:template name="getCalibrationDate">
	 <xsl:param name="curNode"/>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue = '113723'">
	  <xsl:variable name="dateTimeVal">
       <xsl:value-of select="DateTime"/>
      </xsl:variable>
	 <td class="fieldlabel" style="width: 35%; vertical-align: center;">
		<li><b><xsl:value-of select="$curNode/ConceptNameCodeSequence/Item/CodeMeaning"/></b></li>
	 </td>
	 <td style="vertical-align: center;">
		<b>:</b><td class="fieldvalue"><xsl:value-of select="util:getDateTimeValue($dateTimeVal, 1)"/></td>
	 </td>
	 </xsl:if>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue != '113723'">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
	    <xsl:call-template name="getCalibrationDate">
	     <xsl:with-param name="curNode" select="current()"/>
	    </xsl:call-template>
	   </xsl:for-each>
	  </xsl:if>
	</xsl:template>
	
	<xsl:template name="getCalibrationFactor">
	 <xsl:param name="curNode"/>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue = '122322'">
	  <td class="fieldlabel" style="width: 35%; vertical-align: center;">
		<li><b><xsl:value-of select="$curNode/ConceptNameCodeSequence/Item/CodeMeaning"/></b></li>
	  </td>
	  <td style="vertical-align: center;">
		<b>:</b><td class="fieldvalue"><xsl:value-of select="$curNode/MeasuredValueSequence/Item/NumericValue"/></td>
	  </td>
	 </xsl:if>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue != '122322'">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
	    <xsl:call-template name="getCalibrationFactor">
	     <xsl:with-param name="curNode" select="current()"/>
	    </xsl:call-template>
	   </xsl:for-each>
	  </xsl:if>
	</xsl:template>
	
	<xsl:template name="getCalibrationUncertainity">
	 <xsl:param name="curNode"/>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue = '113763'">
	   <td class="fieldlabel" style="width: 35%; vertical-align: center;">
		<li><b><xsl:value-of select="$curNode/ConceptNameCodeSequence/Item/CodeMeaning"/></b></li>
	  </td>
	  <td style="vertical-align: center;">
		<b>:</b><td class="fieldvalue"><xsl:value-of select="$curNode/MeasuredValueSequence/Item/NumericValue"/></td>
	  </td>
	 </xsl:if>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue != '113763'">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
	    <xsl:call-template name="getCalibrationUncertainity">
	     <xsl:with-param name="curNode" select="current()"/>
	    </xsl:call-template>
	   </xsl:for-each>
	  </xsl:if>
	</xsl:template>
	
	<xsl:template name="getCalibrationResponsibleParty">
	 <xsl:param name="curNode"/>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue = '113724'">
	  <td class="fieldlabel" style="width: 35%; vertical-align: center;">
		<li><b><xsl:value-of select="$curNode/ConceptNameCodeSequence/Item/CodeMeaning"/></b></li>
	  </td>
	  <td style="vertical-align: center;">
		<b>:</b><td class="fieldvalue"><xsl:value-of select="$curNode/TextValue"/></td>
	  </td>
	 
	 </xsl:if>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue != '113724'">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
	    <xsl:call-template name="getCalibrationResponsibleParty">
	     <xsl:with-param name="curNode" select="current()"/>
	    </xsl:call-template>
	   </xsl:for-each>
	  </xsl:if>
	</xsl:template>
	
	<xsl:template name="getTotalAcquiredFrames">
	 <xsl:param name="curNode"/>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue = '113731'">
	  <td class="fieldlabel"><b><xsl:value-of select="$curNode/ConceptNameCodeSequence/Item/CodeMeaning"/></b></td>
	  <td class="fieldvalue"><xsl:value-of select="$curNode/MeasuredValueSequence/Item/NumericValue"/></td>
	 </xsl:if>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue != '113731'">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
	    <xsl:call-template name="getTotalAcquiredFrames">
	     <xsl:with-param name="curNode" select="current()"/>
	    </xsl:call-template>
	   </xsl:for-each>
	  </xsl:if>
	</xsl:template>
	
	<xsl:template name="getTotalFluoroTime">
	 <xsl:param name="curNode"/>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeMeaning = '113730'">
	  <td class="fieldlabel"><b><xsl:value-of select="$curNode/ConceptNameCodeSequence/Item/CodeMeaning"/></b></td>
	  <td class="fieldvalue"><xsl:value-of select="$curNode/MeasuredValueSequence/Item/NumericValue"/><xsl:value-of select="$BLANKSPACE"/><xsl:value-of select="$curNode/MeasuredValueSequence/Item/MeasurementUnitsCodeSequence/Item/CodeMeaning"/></td>
	 </xsl:if>
	 <xsl:if test="$curNode/ConceptNameCodeSequence/Item/CodeValue != '113730'">
	  <xsl:for-each select="$curNode/ContentSequence/Item">
	    <xsl:call-template name="getTotalFluoroTime">
	     <xsl:with-param name="curNode" select="current()"/>
	    </xsl:call-template>
	   </xsl:for-each>
	  </xsl:if>
	</xsl:template>
	
	<xsl:template name="addImage">
		<xsl:param name="pSOPClassUID" />
		<xsl:param name="pSOPInstUID" />
		<xsl:param name="pIconImageSeq" />
		<a>
			<img width="256" height="256" name="temp"
					onclick="this.height=512;this.width=512" ondblclick="this.height=256;this.width=256">
			
			<xsl:attribute name="src">
	           <xsl:value-of select="util:getURI(concat($ImageDir, $pSOPInstUID, '.jpg'))" />
	         </xsl:attribute>
			</img>
		</a>
	</xsl:template>
</xsl:stylesheet>