/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.jca.JCAUtil;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ECUtil;

abstract class ECDSASignature
extends SignatureSpi {
    private final MessageDigest messageDigest;
    private SecureRandom random;
    private boolean needsReset;
    private ECPrivateKey privateKey;
    private ECPublicKey publicKey;

    ECDSASignature() {
        this.messageDigest = null;
    }

    ECDSASignature(String digestName) {
        try {
            this.messageDigest = MessageDigest.getInstance(digestName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
        this.needsReset = false;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = (ECPublicKey)ECKeyFactory.toECKey(publicKey);
        this.privateKey = null;
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.privateKey = (ECPrivateKey)ECKeyFactory.toECKey(privateKey);
        this.publicKey = null;
        this.random = random;
        this.resetDigest();
    }

    protected void resetDigest() {
        if (this.needsReset) {
            if (this.messageDigest != null) {
                this.messageDigest.reset();
            }
            this.needsReset = false;
        }
    }

    protected byte[] getDigestValue() throws SignatureException {
        this.needsReset = false;
        return this.messageDigest.digest();
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.messageDigest.update(b);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.messageDigest.update(b, off, len);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        int len = byteBuffer.remaining();
        if (len <= 0) {
            return;
        }
        this.messageDigest.update(byteBuffer);
        this.needsReset = true;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] s = this.privateKey.getS().toByteArray();
        ECParameterSpec params = this.privateKey.getParams();
        byte[] encodedParams = ECUtil.encodeECParameterSpec(null, params);
        int keySize = params.getCurve().getField().getFieldSize();
        byte[] seed = new byte[((keySize + 7 >> 3) + 1) * 2];
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        this.random.nextBytes(seed);
        try {
            return this.encodeSignature(ECDSASignature.signDigest(this.getDigestValue(), s, encodedParams, seed));
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException("Could not sign data", e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        ECParameterSpec params = this.publicKey.getParams();
        byte[] encodedParams = ECUtil.encodeECParameterSpec(null, params);
        byte[] w = this.publicKey instanceof ECPublicKeyImpl ? ((ECPublicKeyImpl)this.publicKey).getEncodedPublicValue() : ECUtil.encodePoint(this.publicKey.getW(), params.getCurve());
        try {
            return ECDSASignature.verifySignedDigest(this.decodeSignature(signature), this.getDigestValue(), w, encodedParams);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException("Could not verify signature", e);
        }
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    private byte[] encodeSignature(byte[] signature) throws SignatureException {
        try {
            int n = signature.length >> 1;
            byte[] bytes = new byte[n];
            System.arraycopy(signature, 0, bytes, 0, n);
            BigInteger r = new BigInteger(1, bytes);
            System.arraycopy(signature, n, bytes, 0, n);
            BigInteger s = new BigInteger(1, bytes);
            DerOutputStream out = new DerOutputStream(signature.length + 10);
            out.putInteger(r);
            out.putInteger(s);
            DerValue result = new DerValue(48, out.toByteArray());
            return result.toByteArray();
        }
        catch (Exception e) {
            throw new SignatureException("Could not encode signature", e);
        }
    }

    private byte[] decodeSignature(byte[] sig) throws SignatureException {
        try {
            DerInputStream in = new DerInputStream(sig, 0, sig.length, false);
            DerValue[] values = in.getSequence(2);
            if (values.length != 2 || in.available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            BigInteger r = values[0].getPositiveBigInteger();
            BigInteger s = values[1].getPositiveBigInteger();
            byte[] rBytes = ECDSASignature.trimZeroes(r.toByteArray());
            byte[] sBytes = ECDSASignature.trimZeroes(s.toByteArray());
            int k = Math.max(rBytes.length, sBytes.length);
            byte[] result = new byte[k << 1];
            System.arraycopy(rBytes, 0, result, k - rBytes.length, rBytes.length);
            System.arraycopy(sBytes, 0, result, result.length - sBytes.length, sBytes.length);
            return result;
        }
        catch (Exception e) {
            throw new SignatureException("Invalid encoding for signature", e);
        }
    }

    private static byte[] trimZeroes(byte[] b) {
        int i;
        for (i = 0; i < b.length - 1 && b[i] == 0; ++i) {
        }
        if (i == 0) {
            return b;
        }
        byte[] t = new byte[b.length - i];
        System.arraycopy(b, i, t, 0, t.length);
        return t;
    }

    private static native byte[] signDigest(byte[] var0, byte[] var1, byte[] var2, byte[] var3) throws GeneralSecurityException;

    private static native boolean verifySignedDigest(byte[] var0, byte[] var1, byte[] var2, byte[] var3) throws GeneralSecurityException;

    public static final class SHA512
    extends ECDSASignature {
        public SHA512() {
            super("SHA-512");
        }
    }

    public static final class SHA384
    extends ECDSASignature {
        public SHA384() {
            super("SHA-384");
        }
    }

    public static final class SHA256
    extends ECDSASignature {
        public SHA256() {
            super("SHA-256");
        }
    }

    public static final class SHA224
    extends ECDSASignature {
        public SHA224() {
            super("SHA-224");
        }
    }

    public static final class SHA1
    extends ECDSASignature {
        public SHA1() {
            super("SHA1");
        }
    }

    public static final class Raw
    extends ECDSASignature {
        private static final int RAW_ECDSA_MAX = 64;
        private final byte[] precomputedDigest = new byte[64];
        private int offset = 0;

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            this.precomputedDigest[this.offset++] = b;
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            System.arraycopy(b, off, this.precomputedDigest, this.offset, len);
            this.offset += len;
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            int len = byteBuffer.remaining();
            if (len <= 0) {
                return;
            }
            if (this.offset + len >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            byteBuffer.get(this.precomputedDigest, this.offset, len);
            this.offset += len;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }

        @Override
        protected byte[] getDigestValue() throws SignatureException {
            if (this.offset > 64) {
                throw new SignatureException("Message digest is too long");
            }
            byte[] result = new byte[this.offset];
            System.arraycopy(this.precomputedDigest, 0, result, 0, this.offset);
            this.offset = 0;
            return result;
        }
    }
}

