/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import srjdom.SRCommon;
import srjdom.SRDateTime;

public class SRDOMEncoder {
    private static DicomObject dcmObject;
    private static DicomObject metaInfo;
    private static String tagID;
    private static boolean beginSQ;
    private static int transferSyntax;

    protected SRDOMEncoder() {
        throw new UnsupportedOperationException();
    }

    static void encode(Document srDomDoc) throws DicomException, UnknownUIDException {
        dcmObject = new DicomObject();
        metaInfo = new DicomObject();
        tagID = null;
        SRDOMEncoder.parseDOMtoDCM(dcmObject, srDomDoc, 0, 0);
        dcmObject.setFileMetaInformation(metaInfo);
        transferSyntax = UID.getUIDEntry(SRCommon.getJDTString(metaInfo, 31)).getConstant();
    }

    static void saveDCM(File file) throws IOException, DicomException {
        FileOutputStream fout = new FileOutputStream(file);
        dcmObject.write(fout, true, transferSyntax, true, false);
        fout.close();
    }

    private static void help() {
        System.out.println(" Usage: \n XMLEncoder XMLfilename ");
        System.out.println("  XMLfilename -  the name of XML file to be encoded");
    }

    private static void parseDOMtoDCM(DicomObject dcm, Node node, int itemNumber, int openedSeq) throws DicomException {
        int itemNr = itemNumber;
        int openedSQ = openedSeq;
        String nodeName = node.getNodeName();
        String nodeValue = node.getNodeValue();
        if (nodeValue == null) {
            nodeValue = "";
        }
        int dct = SRDOMEncoder.getJDTtagID(tagID);
        int typeCode = DDict.getTypeCode(dct);
        SRCommon.logger.info(tagID + ", " + DDict.getTypeCodeName(dct) + "\tnodeName: " + nodeName + "\tnodeValue: " + nodeValue);
        switch (node.getNodeType()) {
            case 3: {
                if (tagID == null) break;
                switch (typeCode) {
                    case 11: {
                        nodeValue = nodeValue.replaceAll("-", "");
                        break;
                    }
                    case 12: {
                        nodeValue = nodeValue.replaceAll(":", "");
                        break;
                    }
                    case 28: {
                        nodeValue = SRDateTime.xsdDateTimeToDICOM(nodeValue);
                        break;
                    }
                }
                if (!SRDOMEncoder.inMetaHeader(tagID)) {
                    if (nodeValue.indexOf(92) >= 0 && typeCode != 18 && typeCode != 13 && typeCode != 27) {
                        String[] values = nodeValue.split("\\\\");
                        for (int i = 0; i < values.length; ++i) {
                            dcm.append(dct, values[i]);
                        }
                    } else {
                        dcm.set(dct, nodeValue);
                    }
                } else if (dct == 28) {
                    byte[] b = new byte[]{0, 1};
                    metaInfo.set(dct, b);
                } else {
                    metaInfo.set(dct, nodeValue);
                }
                tagID = null;
                break;
            }
            case 9: {
                for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    SRDOMEncoder.parseDOMtoDCM(dcm, childNode, itemNr, openedSQ);
                }
                break;
            }
            case 1: {
                NamedNodeMap attributes = node.getAttributes();
                String vr2 = null;
                if (attributes != null) {
                    if (attributes.getNamedItem("tag") != null) {
                        tagID = attributes.getNamedItem("tag").getNodeValue();
                    }
                    if (attributes.getNamedItem("vr") != null) {
                        vr2 = attributes.getNamedItem("vr").getNodeValue();
                    }
                } else {
                    tagID = null;
                }
                dct = SRDOMEncoder.getJDTtagID(tagID);
                Node pChild = node.getFirstChild();
                if (pChild != null) {
                    DicomObject item = null;
                    if (vr2 != null && vr2.equalsIgnoreCase("SQ")) {
                        if (tagID == null) {
                            return;
                        }
                        openedSQ = dct;
                        beginSQ = true;
                        tagID = null;
                    }
                    if (nodeName.equalsIgnoreCase("ITEM")) {
                        if (beginSQ) {
                            itemNr = 0;
                            beginSQ = false;
                        } else {
                            itemNr = dcm.getSize(openedSQ);
                        }
                        item = new DicomObject();
                        dcm.set(openedSQ, item, itemNr);
                        tagID = null;
                    }
                    while (pChild != null) {
                        if (item != null) {
                            SRDOMEncoder.parseDOMtoDCM(item, pChild, itemNr, openedSQ);
                        } else {
                            SRDOMEncoder.parseDOMtoDCM(dcm, pChild, itemNr, openedSQ);
                        }
                        pChild = pChild.getNextSibling();
                    }
                    break;
                }
                if (!SRDOMEncoder.inMetaHeader(tagID)) {
                    dcm.set(dct, null);
                } else {
                    metaInfo.set(dct, null);
                }
                tagID = null;
                break;
            }
            default: {
                SRCommon.logger.info("Not recognized node found in DOM");
            }
        }
    }

    private static int getJDTtagID(String sTagID) {
        if (sTagID != null) {
            String element = sTagID.substring(sTagID.indexOf(44) + 1, sTagID.length());
            String group = sTagID.substring(0, sTagID.indexOf(44));
            int e = Integer.parseInt(element, 16);
            int g = Integer.parseInt(group, 16);
            return DDict.lookupDDict(g, e);
        }
        return -1;
    }

    private static boolean inMetaHeader(String sTagID) {
        if (sTagID != null) {
            String group = sTagID.substring(0, sTagID.indexOf(44));
            return Integer.parseInt(group, 16) == 2;
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            SRDOMEncoder.help();
            return;
        }
        try {
            dcmObject = new DicomObject();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new File(args[0]));
            metaInfo = new DicomObject();
            SRDOMEncoder.parseDOMtoDCM(dcmObject, document, 0, 0);
            dcmObject.setFileMetaInformation(metaInfo);
            FileOutputStream fout = new FileOutputStream("sr_new_impl.dcm");
            dcmObject.write(fout, true);
            fout.close();
            SRCommon.logger.info("conversion done, check sr_new.dcm");
        }
        catch (Exception ex) {
            SRCommon.logger.log(Level.WARNING, null, ex);
        }
    }

    static {
        tagID = null;
        beginSQ = false;
        try {
            DDict.addEntry(new DDictEntry(57, 16, 6, "PrivateCreator", "1"));
            DDict.addEntry(new DDictEntry(57, 4245, 6, "ApplicationSpecificData", "1"));
        }
        catch (DicomException dcmEx) {
            SRCommon.logger.warning("Entry already present in dictionary file");
        }
    }
}

