/*
 * Decompiled with CFR 0.152.
 */
package srjdom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.SOPClass;
import com.archimed.dicom.TransferSyntax;
import com.archimed.dicom.tools.Sequences;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringWriter;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SRCommon {
    public static final String USER_DATA = "srnode";
    public static final String MANUFACTURER = "GE MEDICAL SYSTEMS";
    public static final int PRIVATE_GROUP = 57;
    public static final int PRIVATE_CREATOR_ELEMENT = 16;
    public static final int APP_SPECIFIC_INFO_ELEMENT = 4245;
    public static final String FS = System.getProperty("file.separator");
    public static final String NO_CONTENT = "-";
    public static final String TMP_DIRECTORY = System.getProperty("java.io.tmpdir");
    public static final String LOGFILES_HOME = System.getProperty("LOGFILES_HOME");
    public static Logger logger = Logger.getLogger("srjdomLogger");
    public static final String CT = "CT";
    public static final String SR = "SR";
    public static final String TS_IMPLICIT_LITTLE_ENDIAN;
    public static final String TS_EXPLICIT_LITTLE_ENDIAN;
    public static final String TS_EXPLICIT_BIG_ENDIAN;
    public static final String BASIC_TEXT_SR;
    public static final String ENHANCED_SR;
    public static final String COMPREHENSIVE_SR;
    public static final String PROCEDURE_LOG;
    public static final String MAMMOGRAPHY_CAD_SR;
    public static final String KEY_OBJECT_SELECTION_DOCUMENT;
    public static final String CHEST_CAD_SR;
    public static final String XRAY_RADIATION_DOSE_SR;
    public static final String CF_PARTIAL = "PARTIAL";
    public static final String CF_COMPLETE = "COMPLETE";
    public static final String VF_UNVERIFIED = "UNVERIFIED";
    public static final String VF_VERIFIED = "VERIFIED";
    public static final String COC_SEPARATE = "SEPARATE";
    public static final String COC_CONTINUOUS = "CONTINUOUS";
    public static final String CSD_DICOM = "DCM";
    public static final String CSD_LOINC = "LN";
    public static final String CSD_SNOMED = "SNM3";
    public static final String CSD_SNOMED_RT = "SRT";
    public static final String CSD_UCUM = "UCUM";
    public static final String CSD_99GEMS = "99GEMS";

    protected SRCommon() {
        throw new UnsupportedOperationException();
    }

    public static String getMultipleValue(int[] nums) {
        StringBuffer strBuf = new StringBuffer();
        if (nums != null) {
            for (int i = 0; i < nums.length; ++i) {
                strBuf.append(nums[i]);
                if (i >= nums.length - 1) continue;
                strBuf.append("\\");
            }
        }
        return strBuf.toString();
    }

    public static String getMultipleValue(double[] nums) {
        StringBuffer strBuf = new StringBuffer();
        if (nums != null) {
            for (int i = 0; i < nums.length; ++i) {
                strBuf.append(nums[i]);
                if (i >= nums.length - 1) continue;
                strBuf.append("\\");
            }
        }
        return strBuf.toString();
    }

    public static String getMultipleValue(long[] nums) {
        StringBuffer strBuf = new StringBuffer();
        if (nums != null) {
            for (int i = 0; i < nums.length; ++i) {
                strBuf.append(nums[i]);
                if (i >= nums.length - 1) continue;
                strBuf.append("\\");
            }
        }
        return strBuf.toString();
    }

    public static String getJDTString(DicomObject dcm, int dname) {
        int g = DDict.getGroup(dname);
        int e = DDict.getElement(dname);
        return SRCommon.getJDTString(dcm, g, e);
    }

    public static String getJDTString(DicomObject dcm, int g, int e) {
        String str = null;
        try {
            int size = dcm.getSize_ge(g, e);
            if (size <= 0) {
                str = null;
            } else {
                StringBuffer strBuf = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    strBuf.append(dcm.getS_ge(g, e, i));
                    if (i >= size - 1) continue;
                    strBuf.append("\\");
                }
                str = strBuf.toString();
            }
            if (str != null) {
                str = str.trim();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, null, ex);
        }
        return str;
    }

    public static String getJDTSeqString(Sequences seq, int seqDname, int itemnr, int dname) {
        int g = DDict.getGroup(dname);
        int e = DDict.getElement(dname);
        return SRCommon.getJDTSeqString(seq, seqDname, itemnr, g, e);
    }

    public static String getJDTSeqString(Sequences seq, int seqDname, int itemnr, int g, int e) {
        String str = null;
        try {
            int size = seq.getSize_ge(seqDname, itemnr, g, e);
            if (size <= 0) {
                str = null;
            } else {
                StringBuffer strBuf = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    strBuf.append(seq.getS_ge(seqDname, itemnr, g, e, i));
                    if (i >= size - 1) continue;
                    strBuf.append("\\");
                }
                str = strBuf.toString();
            }
            if (str != null) {
                str = str.trim();
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, null, ex);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDICOMFile(File dcmFile) {
        logger.info("> isDICOMFile(): " + dcmFile);
        boolean isDICOMFile = false;
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(dcmFile);
            DicomReader dcmReader = new DicomReader();
            isDICOMFile = dcmReader.checkIfDicomFile(fin);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        logger.info("< isDICOMFile(): " + isDICOMFile);
        return isDICOMFile;
    }

    public static DicomObject openDCM(File dcmFile) {
        return SRCommon.openDCM(dcmFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DicomObject openDCM(File dcmFile, boolean parsePixelData) {
        logger.info("> openDCM(): " + dcmFile + "\tparsePixelData: " + parsePixelData);
        DicomObject dcm = null;
        FileInputStream fin = null;
        try {
            if (SRCommon.isDICOMFile(dcmFile)) {
                fin = new FileInputStream(dcmFile);
                dcm = new DicomObject();
                dcm.read(fin, parsePixelData);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, null, ex);
            dcm = null;
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, null, ex);
            dcm = null;
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, null, ex);
            }
        }
        logger.info("< openDCM(): " + dcm);
        return dcm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DicomObject openDCM(File dcmFile, DicomReader dcmReader) {
        logger.info("> openDCM(): " + dcmFile + "\tdcmReader: " + dcmReader);
        DicomObject dcm = null;
        FileInputStream fin = null;
        try {
            if (SRCommon.isDICOMFile(dcmFile)) {
                fin = new FileInputStream(dcmFile);
                dcm = dcmReader.read(fin, false);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, null, ex);
        }
        catch (Throwable ex) {
            logger.log(Level.WARNING, null, ex);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, null, ex);
            }
        }
        logger.info("< openDCM(): " + dcm);
        return dcm;
    }

    public static String getPatientIdentificationKey(String name, String id, String birthDate, String sex) {
        StringBuffer sb = new StringBuffer("");
        try {
            logger.info("<SRCommon.getPatientIdentificationKey() : PatientName : " + name + "; PatientID:" + id + "; birthDate:" + birthDate + "; sex:" + sex);
            if (name != null && !name.isEmpty()) {
                sb.append(name).append("_");
            }
            if (id != null && !id.isEmpty()) {
                sb.append(id).append("_");
            }
            if (birthDate != null && !birthDate.isEmpty()) {
                sb.append(birthDate).append("_");
            }
            if (sex != null && !sex.isEmpty()) {
                sb.append(sex);
            }
        }
        catch (Exception e) {
            logger.warning("< getPatientIdentificationKey(): " + e.getLocalizedMessage());
        }
        logger.info("< getPatientIdentificationKey(): " + sb.toString());
        return sb.toString();
    }

    public static String getPatientIdentificationKey(DicomObject dcm) {
        logger.info("> getPatientIdentificationKey(): " + dcm);
        String patientKey = null;
        if (dcm != null) {
            String name = SRCommon.getJDTString(dcm, 147);
            String id = SRCommon.getJDTString(dcm, 148);
            String birthDate = SRCommon.getJDTString(dcm, 150);
            String sex = SRCommon.getJDTString(dcm, 152);
            patientKey = SRCommon.getPatientIdentificationKey(name, id, birthDate, sex);
        }
        logger.info("< getPatientIdentificationKey(): " + patientKey);
        return patientKey;
    }

    public static void copyTag(DicomObject source, DicomObject target, int tagID) {
        SRCommon.copyTag(source, target, tagID, null);
    }

    public static void copyTag(DicomObject source, DicomObject target, int tagID, Object defaultValue) {
        try {
            if ("SQ".equalsIgnoreCase(DDict.getTypeCodeName(tagID))) {
                SRCommon.copySequence(source, target, tagID);
            } else {
                Object obj = source.get(tagID);
                if (obj == null) {
                    obj = defaultValue;
                }
                target.set(tagID, obj);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, null, ex);
        }
    }

    public static void copyType1CTag(DicomObject source, DicomObject target, int tagID, Object defaultValue) {
        try {
            Object obj = source.get(tagID);
            if (obj == null || obj.toString() == null || obj.toString().equalsIgnoreCase("")) {
                obj = defaultValue;
            }
            if (obj != null && obj.toString() != null && !obj.toString().equalsIgnoreCase("")) {
                target.set(tagID, obj);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, null, ex);
        }
    }

    private static void copySequence(DicomObject source, DicomObject target, int tagID) {
        if (source != null && target != null) {
            logger.info("> copySequence():\t" + DDict.getDescription(tagID) + " size: " + source.getSize(tagID));
            for (int i = 0; i < source.getSize(tagID); ++i) {
                try {
                    DicomObject item = (DicomObject)source.get(tagID, i);
                    if (item == null) continue;
                    target.set(tagID, item, i);
                    continue;
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
        }
    }

    public static void writeXML(Node node, boolean omitXMLDeclaration) {
        SRCommon.writeXML(node, new StreamResult(System.out), omitXMLDeclaration);
    }

    public static void writeXML(Node node, String fileName, boolean omitXMLDeclaration) {
        SRCommon.writeXML(node, new StreamResult(new File(fileName)), omitXMLDeclaration);
    }

    public void writeXML(Node node, File file, boolean omitXMLDeclaration) {
        SRCommon.writeXML(node, new StreamResult(file), omitXMLDeclaration);
    }

    public static void writeXML(Node node, Result res, boolean omitXMLDeclaration) {
        DOMSource source = new DOMSource(node);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            if (omitXMLDeclaration) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.transform(source, res);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String toXMLString(Node node) {
        StringWriter strWriter = new StringWriter();
        SRCommon.writeXML(node, new StreamResult(strWriter), true);
        return strWriter.toString();
    }

    public static Document createDOM() {
        logger.info("> createDOM()");
        Document dom = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            dom = builder.newDocument();
            Element root = dom.createElement("DICOM");
            dom.appendChild(root);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, null, ex);
        }
        logger.info("< createDOM(): " + dom);
        return dom;
    }

    static {
        String logfile = "srjdom.log";
        logfile = LOGFILES_HOME == null || LOGFILES_HOME.trim().equalsIgnoreCase("") ? TMP_DIRECTORY + FS + logfile : LOGFILES_HOME + FS + logfile;
        logger.setUseParentHandlers(false);
        try {
            FileHandler fileHandler = new FileHandler(logfile);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, null, ex);
        }
        TS_IMPLICIT_LITTLE_ENDIAN = TransferSyntax.ImplicitVRLittleEndianUID.getValue();
        TS_EXPLICIT_LITTLE_ENDIAN = TransferSyntax.ExplicitVRLittleEndianUID.getValue();
        TS_EXPLICIT_BIG_ENDIAN = TransferSyntax.ExplicitVRBigEndianUID.getValue();
        BASIC_TEXT_SR = SOPClass.BasicTextSRUID.getValue();
        ENHANCED_SR = SOPClass.EnhancedSRUID.getValue();
        COMPREHENSIVE_SR = SOPClass.ComprehensiveSRUID.getValue();
        PROCEDURE_LOG = SOPClass.ProcedureLogStorageUID.getValue();
        MAMMOGRAPHY_CAD_SR = SOPClass.MammographyCADSRUID.getValue();
        KEY_OBJECT_SELECTION_DOCUMENT = SOPClass.KeyObjectSelectionDocumentUID.getValue();
        CHEST_CAD_SR = SOPClass.ChestCADSRUID.getValue();
        XRAY_RADIATION_DOSE_SR = SOPClass.XRayRadiationDoseSRUID.getValue();
    }
}

