/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermIdent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Variator {
    protected static final int ALL_VARIANTS = -1;
    protected int variants;
    protected boolean[] variantPassed;
    protected List<String> names;
    protected List<Class<? extends CSSProperty>> types;
    protected List<Term<?>> terms;

    public Variator(int n) {
        this.variants = n;
        this.variantPassed = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.variantPassed[i] = false;
        }
        this.names = new ArrayList<String>(n);
        this.types = new ArrayList<Class<? extends CSSProperty>>(n);
    }

    protected abstract boolean variant(int var1, IntegerRef var2, Map<String, CSSProperty> var3, Map<String, Term<?>> var4);

    protected boolean checkInherit(int n, Term<?> term, Map<String, CSSProperty> map) {
        if (!(term instanceof TermIdent) || !"INHERIT".equalsIgnoreCase((String)((TermIdent)term).getValue())) {
            return false;
        }
        if (n == -1) {
            for (int i = 0; i < this.variants; ++i) {
                map.put(this.names.get(i), this.createInherit(i));
            }
            return true;
        }
        map.put(this.names.get(n), this.createInherit(n));
        return true;
    }

    private CSSProperty createInherit(int n) {
        try {
            Class<? extends CSSProperty> clazz = this.types.get(n);
            CSSProperty cSSProperty = CSSProperty.Translator.createInherit(clazz);
            if (cSSProperty != null) {
                return cSSProperty;
            }
            throw new IllegalAccessException("No inherit value for: " + clazz.getName());
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Unable to create inherit value", exception);
        }
    }

    protected boolean variantCondition(int n, IntegerRef integerRef) {
        return true;
    }

    public boolean vary(Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (this.terms.size() == 1 && this.checkInherit(-1, this.terms.get(0), map)) {
            return true;
        }
        IntegerRef integerRef = new IntegerRef(0);
        while (integerRef.get() < this.terms.size()) {
            boolean bl = false;
            for (int i = 0; i < this.variants; ++i) {
                if (!this.variantCondition(i, integerRef) || this.variantPassed[i] || !(bl = this.variant(i, integerRef, map, map2))) continue;
                this.variantPassed[i] = true;
                break;
            }
            if (!bl) {
                return false;
            }
            integerRef.inc();
        }
        return true;
    }

    public boolean tryOneTermVariant(int n, Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() != 1) {
            return false;
        }
        if (this.checkInherit(n, (Term)declaration.get(0), map)) {
            return true;
        }
        this.terms = new ArrayList();
        this.terms.add((Term<?>)declaration.get(0));
        return this.variant(n, new IntegerRef(0), map, map2);
    }

    public boolean tryMultiTermVariant(int n, Map<String, CSSProperty> map, Map<String, Term<?>> map2, Term<?> ... termArray) {
        this.terms = Arrays.asList(termArray);
        if (this.terms.size() == 1 && this.checkInherit(n, this.terms.get(0), map)) {
            return true;
        }
        return this.variant(n, new IntegerRef(0), map, map2);
    }

    public void assignVariantPropertyNames(String ... stringArray) {
        this.names = Arrays.asList(stringArray);
    }

    public void assignTerms(Term<?> ... termArray) {
        this.terms = Arrays.asList(termArray);
    }

    public void assignTermsFromDeclaration(Declaration declaration) {
        this.terms = declaration.asList();
    }

    public void assignDefaults(Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        SupportedCSS supportedCSS = CSSFactory.getSupportedCSS();
        for (String string : this.names) {
            Term<?> term;
            CSSProperty cSSProperty = supportedCSS.getDefaultProperty(string);
            if (cSSProperty != null) {
                map.put(string, cSSProperty);
            }
            if ((term = supportedCSS.getDefaultValue(string)) == null) continue;
            map2.put(string, term);
        }
    }

    protected static class IntegerRef {
        private int i;

        public IntegerRef(int n) {
            this.i = n;
        }

        public int get() {
            return this.i;
        }

        public void set(int n) {
            this.i = n;
        }

        public void inc() {
            ++this.i;
        }
    }
}

