/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.domassign.GenericTreeWalker;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Traversal<T> {
    protected Object source;
    protected TreeWalker walker;

    public Traversal(TreeWalker treeWalker, Object object) {
        this.source = object;
        this.walker = treeWalker;
    }

    public Traversal(Document document, Object object, int n) {
        if (document instanceof DocumentTraversal) {
            DocumentTraversal documentTraversal = (DocumentTraversal)((Object)document);
            this.walker = documentTraversal.createTreeWalker(document.getDocumentElement(), n, null, false);
        } else {
            this.walker = new GenericTreeWalker(document.getDocumentElement(), n);
        }
        this.source = object;
    }

    public void listTraversal(T t) {
        Node node = null;
        Node node2 = this.walker.nextNode();
        while (node2 != null) {
            node = this.walker.getCurrentNode();
            this.processNode(t, node2, this.source);
            this.walker.setCurrentNode(node);
            node2 = this.walker.nextNode();
        }
    }

    public void levelTraversal(T t) {
        Node node = null;
        Node node2 = node = this.walker.getCurrentNode();
        this.processNode(t, node2, this.source);
        this.walker.setCurrentNode(node);
        Node node3 = this.walker.firstChild();
        while (node3 != null) {
            this.levelTraversal(t);
            node3 = this.walker.nextSibling();
        }
        this.walker.setCurrentNode(node);
    }

    protected abstract void processNode(T var1, Node var2, Object var3);

    public Traversal<T> reset(TreeWalker treeWalker, Object object) {
        this.walker = treeWalker;
        this.source = object;
        return this;
    }
}

