/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.css.TermList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportedCSS21
implements SupportedCSS {
    private static Logger log = LoggerFactory.getLogger(SupportedCSS21.class);
    private static final int TOTAL_SUPPORTED_DECLARATIONS = 116;
    private static final TermFactory tf = CSSFactory.getTermFactory();
    private static final CSSProperty DEFAULT_UA_FONT_FAMILY = CSSProperty.FontFamily.SANS_SERIF;
    private static final CSSProperty DEFAULT_UA_TEXT_ALIGN = CSSProperty.TextAlign.BY_DIRECTION;
    private static final Term<?> DEFAULT_UA_COLOR = tf.createColor("#000000");
    private static final Term<?> DEFAULT_UA_TEXT_IDENT = tf.createLength(Float.valueOf(0.0f));
    private static final Term<?> DEFAULT_UA_MARGIN = tf.createLength(Float.valueOf(0.0f));
    private static final Term<?> DEFAULT_UA_PADDING = tf.createLength(Float.valueOf(0.0f));
    private static final Term<?> DEFAULT_UA_MIN_WIDTH = tf.createLength(Float.valueOf(0.0f));
    private static final Term<?> DEFAULT_UA_MIN_HEIGHT = tf.createLength(Float.valueOf(0.0f));
    private static final TermList DEFAULT_UA_BACKGROUND_POSITION = tf.createList(2);
    private static final TermList DEFAULT_UA_BORDER_SPACING;
    private static final Term<?> DEFAULT_UA_WIDOWS;
    private static final Term<?> DEFAULT_UA_ORPHANS;
    private static final Term<?> DEFAULT_UA_PAUSE_BEFORE;
    private static final Term<?> DEFAULT_UA_PAUSE_AFTER;
    private static final Term<?> DEFAULT_UA_RICHNESS;
    private static final Term<?> DEFAULT_UA_PITCH_RANGE;
    private static final Term<?> DEFAULT_UA_STRESS;
    private static final CSSProperty DEFAULT_UA_VOICE_FAMILY;
    private static final SupportedCSS21 instance;
    private Map<String, CSSProperty> defaultCSSproperties;
    private Map<String, Term<?>> defaultCSSvalues;
    private Map<String, Integer> ordinals;
    private Map<Integer, String> ordinalsRev;
    private Set<String> supportedMedias;

    public static final SupportedCSS21 getInstance() {
        return instance;
    }

    private SupportedCSS21() {
        this.setSupportedCSS();
        this.setOridinals();
        this.setSupportedAtKeywords();
    }

    @Override
    public boolean isSupportedMedia(String string) {
        if (string == null) {
            return false;
        }
        return this.supportedMedias.contains(string.toLowerCase());
    }

    @Override
    public final boolean isSupportedCSSProperty(String string) {
        return this.defaultCSSproperties.get(string) != null;
    }

    @Override
    public final CSSProperty getDefaultProperty(String string) {
        CSSProperty cSSProperty = this.defaultCSSproperties.get(string);
        log.debug("Asked for property {}'s default value: {}", (Object)string, (Object)cSSProperty);
        return cSSProperty;
    }

    @Override
    public final Term<?> getDefaultValue(String string) {
        return this.defaultCSSvalues.get(string);
    }

    @Override
    public final int getTotalProperties() {
        return this.defaultCSSproperties.size();
    }

    @Override
    public final Set<String> getDefinedPropertyNames() {
        return this.defaultCSSproperties.keySet();
    }

    @Override
    public String getRandomPropertyName() {
        Random random = new Random();
        int n = random.nextInt(this.getTotalProperties());
        return this.getPropertyName(n);
    }

    @Override
    public int getOrdinal(String string) {
        Integer n = this.ordinals.get(string);
        return n == null ? -1 : n;
    }

    @Override
    public String getPropertyName(int n) {
        return this.ordinalsRev.get(n);
    }

    private void setSupportedCSS() {
        HashMap<String, CSSProperty> hashMap = new HashMap<String, CSSProperty>(116, 1.0f);
        HashMap hashMap2 = new HashMap(116, 1.0f);
        hashMap.put("color", CSSProperty.Color.color);
        hashMap2.put("color", DEFAULT_UA_COLOR);
        hashMap.put("font", CSSProperty.Font.component_values);
        hashMap.put("font-family", DEFAULT_UA_FONT_FAMILY);
        hashMap.put("font-size", CSSProperty.FontSize.MEDIUM);
        hashMap.put("font-style", CSSProperty.FontStyle.NORMAL);
        hashMap.put("font-variant", CSSProperty.FontVariant.NORMAL);
        hashMap.put("font-weight", CSSProperty.FontWeight.NORMAL);
        hashMap.put("text-decoration", CSSProperty.TextDecoration.NONE);
        hashMap.put("text-transform", CSSProperty.TextTransform.NONE);
        hashMap.put("white-space", CSSProperty.WhiteSpace.NORMAL);
        hashMap.put("text-align", DEFAULT_UA_TEXT_ALIGN);
        hashMap.put("text-indent", CSSProperty.TextIndent.length);
        hashMap2.put("text-indent", DEFAULT_UA_TEXT_IDENT);
        hashMap.put("line-height", CSSProperty.LineHeight.NORMAL);
        hashMap.put("word-spacing", CSSProperty.WordSpacing.NORMAL);
        hashMap.put("letter-spacing", CSSProperty.LetterSpacing.NORMAL);
        hashMap.put("vertical-align", CSSProperty.VerticalAlign.BASELINE);
        hashMap.put("direction", CSSProperty.Direction.LTR);
        hashMap.put("unicode-bidi", CSSProperty.UnicodeBidi.NORMAL);
        hashMap.put("margin", CSSProperty.Margin.component_values);
        hashMap.put("margin-top", CSSProperty.Margin.length);
        hashMap2.put("margin-top", DEFAULT_UA_MARGIN);
        hashMap.put("margin-right", CSSProperty.Margin.length);
        hashMap2.put("margin-right", DEFAULT_UA_MARGIN);
        hashMap.put("margin-bottom", CSSProperty.Margin.length);
        hashMap2.put("margin-bottom", DEFAULT_UA_MARGIN);
        hashMap.put("margin-left", CSSProperty.Margin.length);
        hashMap2.put("margin-left", DEFAULT_UA_MARGIN);
        hashMap.put("padding", CSSProperty.Padding.component_values);
        hashMap.put("padding-top", CSSProperty.Padding.length);
        hashMap2.put("padding-top", DEFAULT_UA_PADDING);
        hashMap.put("padding-right", CSSProperty.Padding.length);
        hashMap2.put("padding-right", DEFAULT_UA_PADDING);
        hashMap.put("padding-bottom", CSSProperty.Padding.length);
        hashMap2.put("padding-bottom", DEFAULT_UA_PADDING);
        hashMap.put("padding-left", CSSProperty.Padding.length);
        hashMap2.put("padding-left", DEFAULT_UA_PADDING);
        hashMap.put("border", CSSProperty.Border.component_values);
        hashMap.put("border-top", CSSProperty.Border.component_values);
        hashMap.put("border-right", CSSProperty.Border.component_values);
        hashMap.put("border-bottom", CSSProperty.Border.component_values);
        hashMap.put("border-left", CSSProperty.Border.component_values);
        hashMap.put("border-width", CSSProperty.BorderWidth.component_values);
        hashMap.put("border-top-width", CSSProperty.BorderWidth.MEDIUM);
        hashMap.put("border-right-width", CSSProperty.BorderWidth.MEDIUM);
        hashMap.put("border-bottom-width", CSSProperty.BorderWidth.MEDIUM);
        hashMap.put("border-left-width", CSSProperty.BorderWidth.MEDIUM);
        hashMap.put("border-style", CSSProperty.BorderStyle.component_values);
        hashMap.put("border-top-style", CSSProperty.BorderStyle.NONE);
        hashMap.put("border-right-style", CSSProperty.BorderStyle.NONE);
        hashMap.put("border-bottom-style", CSSProperty.BorderStyle.NONE);
        hashMap.put("border-left-style", CSSProperty.BorderStyle.NONE);
        hashMap.put("border-color", CSSProperty.BorderColor.component_values);
        hashMap.put("border-top-color", CSSProperty.BorderColor.taken);
        hashMap.put("border-right-color", CSSProperty.BorderColor.taken);
        hashMap.put("border-bottom-color", CSSProperty.BorderColor.taken);
        hashMap.put("border-left-color", CSSProperty.BorderColor.taken);
        hashMap.put("width", CSSProperty.Width.AUTO);
        hashMap.put("min-width", CSSProperty.MinWidth.length);
        hashMap2.put("min-width", DEFAULT_UA_MIN_WIDTH);
        hashMap.put("max-width", CSSProperty.MaxWidth.NONE);
        hashMap.put("height", CSSProperty.Width.AUTO);
        hashMap.put("min-height", CSSProperty.MinHeight.length);
        hashMap2.put("min-height", DEFAULT_UA_MIN_HEIGHT);
        hashMap.put("max-height", CSSProperty.MaxHeight.NONE);
        hashMap.put("overflow", CSSProperty.Overflow.VISIBLE);
        hashMap.put("clip", CSSProperty.Clip.AUTO);
        hashMap.put("display", CSSProperty.Display.INLINE);
        hashMap.put("position", CSSProperty.Position.STATIC);
        hashMap.put("top", CSSProperty.Top.AUTO);
        hashMap.put("right", CSSProperty.Right.AUTO);
        hashMap.put("bottom", CSSProperty.Bottom.AUTO);
        hashMap.put("left", CSSProperty.Left.AUTO);
        hashMap.put("float", CSSProperty.Float.NONE);
        hashMap.put("clear", CSSProperty.Clear.NONE);
        hashMap.put("z-index", CSSProperty.ZIndex.AUTO);
        hashMap.put("visibility", CSSProperty.Visibility.VISIBLE);
        hashMap.put("background", CSSProperty.Background.component_values);
        hashMap.put("background-attachement", CSSProperty.BackgroundAttachment.SCROLL);
        hashMap.put("background-color", CSSProperty.BackgroundColor.TRANSPARENT);
        hashMap.put("background-image", CSSProperty.BackgroundImage.NONE);
        hashMap.put("background-position", CSSProperty.BackgroundPosition.list_values);
        hashMap2.put("background-position", DEFAULT_UA_BACKGROUND_POSITION);
        hashMap.put("background-repeat", CSSProperty.BackgroundRepeat.REPEAT);
        hashMap.put("list-style", CSSProperty.ListStyle.component_values);
        hashMap.put("list-style-type", CSSProperty.ListStyleType.DISC);
        hashMap.put("list-style-position", CSSProperty.ListStylePosition.OUTSIDE);
        hashMap.put("list-style-image", CSSProperty.ListStyleImage.NONE);
        hashMap.put("border-collapse", CSSProperty.BorderCollapse.SEPARATE);
        hashMap.put("border-spacing", CSSProperty.BorderSpacing.list_values);
        hashMap2.put("border-spacing", DEFAULT_UA_BORDER_SPACING);
        hashMap.put("empty-cells", CSSProperty.EmptyCells.SHOW);
        hashMap.put("table-layout", CSSProperty.TableLayout.AUTO);
        hashMap.put("caption-side", CSSProperty.CaptionSide.TOP);
        hashMap.put("content", CSSProperty.Content.NORMAL);
        hashMap.put("quotes", CSSProperty.Quotes.NONE);
        hashMap.put("counter-increment", CSSProperty.CounterIncrement.NONE);
        hashMap.put("counter-reset", CSSProperty.CounterReset.NONE);
        hashMap.put("cursor", CSSProperty.Cursor.AUTO);
        hashMap.put("outline", CSSProperty.Outline.component_values);
        hashMap.put("outline-width", CSSProperty.OutlineWidth.MEDIUM);
        hashMap.put("outline-style", CSSProperty.OutlineStyle.NONE);
        hashMap.put("outline-color", CSSProperty.OutlineColor.INVERT);
        hashMap.put("page-break", CSSProperty.PageBreak.AUTO);
        hashMap.put("page-break-before", CSSProperty.PageBreak.AUTO);
        hashMap.put("page-break-after", CSSProperty.PageBreak.AUTO);
        hashMap.put("page-break-inside", CSSProperty.PageBreakInside.AUTO);
        hashMap.put("widows", CSSProperty.Widows.integer);
        hashMap2.put("widows", DEFAULT_UA_WIDOWS);
        hashMap.put("orphans", CSSProperty.Orphans.integer);
        hashMap2.put("orphans", DEFAULT_UA_ORPHANS);
        hashMap.put("azimuth", CSSProperty.Azimuth.CENTER);
        hashMap.put("cue", CSSProperty.Cue.component_values);
        hashMap.put("cue-before", CSSProperty.Cue.NONE);
        hashMap.put("cue-after", CSSProperty.Cue.NONE);
        hashMap.put("elevation", CSSProperty.Elevation.LEVEL);
        hashMap.put("pause", CSSProperty.Pause.component_values);
        hashMap.put("pause-before", CSSProperty.Pause.time);
        hashMap2.put("pause-before", DEFAULT_UA_PAUSE_BEFORE);
        hashMap.put("pause-after", CSSProperty.Pause.time);
        hashMap2.put("pause-after", DEFAULT_UA_PAUSE_AFTER);
        hashMap.put("pitch-range", CSSProperty.PitchRange.number);
        hashMap2.put("pitch-range", DEFAULT_UA_PITCH_RANGE);
        hashMap.put("pitch", CSSProperty.Pitch.MEDIUM);
        hashMap.put("play-during", CSSProperty.PlayDuring.AUTO);
        hashMap.put("richness", CSSProperty.Richness.number);
        hashMap2.put("richness", DEFAULT_UA_RICHNESS);
        hashMap.put("speak-header", CSSProperty.SpeakHeader.ONCE);
        hashMap.put("speak-numeral", CSSProperty.SpeakNumeral.CONTINUOUS);
        hashMap.put("speak-punctuation", CSSProperty.SpeakPunctuation.NONE);
        hashMap.put("speak", CSSProperty.Speak.NORMAL);
        hashMap.put("speech-rate", CSSProperty.SpeechRate.MEDIUM);
        hashMap.put("stress", CSSProperty.Stress.number);
        hashMap2.put("stress", DEFAULT_UA_STRESS);
        hashMap.put("voice-family", DEFAULT_UA_VOICE_FAMILY);
        hashMap.put("volume", CSSProperty.Volume.MEDIUM);
        this.defaultCSSproperties = hashMap;
        this.defaultCSSvalues = hashMap2;
    }

    private void setOridinals() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(this.getTotalProperties(), 1.0f);
        HashMap<Integer, String> hashMap2 = new HashMap<Integer, String>(this.getTotalProperties(), 1.0f);
        int n = 0;
        for (String string : this.defaultCSSproperties.keySet()) {
            hashMap.put(string, n);
            hashMap2.put(n, string);
            ++n;
        }
        this.ordinals = hashMap;
        this.ordinalsRev = hashMap2;
    }

    private void setSupportedAtKeywords() {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList("all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"));
        this.supportedMedias = hashSet;
    }

    static {
        DEFAULT_UA_BACKGROUND_POSITION.add(tf.createPercent(Float.valueOf(0.0f)));
        DEFAULT_UA_BACKGROUND_POSITION.add(tf.createPercent(Float.valueOf(0.0f)));
        DEFAULT_UA_BORDER_SPACING = tf.createList(2);
        DEFAULT_UA_BORDER_SPACING.add(tf.createLength(Float.valueOf(0.0f)));
        DEFAULT_UA_BORDER_SPACING.add(tf.createLength(Float.valueOf(0.0f)));
        DEFAULT_UA_WIDOWS = tf.createInteger(2);
        DEFAULT_UA_ORPHANS = tf.createInteger(2);
        DEFAULT_UA_PAUSE_BEFORE = tf.createTime(Float.valueOf(0.0f));
        DEFAULT_UA_PAUSE_AFTER = tf.createTime(Float.valueOf(0.0f));
        DEFAULT_UA_RICHNESS = tf.createNumber(Float.valueOf(50.0f));
        DEFAULT_UA_PITCH_RANGE = tf.createNumber(Float.valueOf(50.0f));
        DEFAULT_UA_STRESS = tf.createNumber(Float.valueOf(50.0f));
        DEFAULT_UA_VOICE_FAMILY = CSSProperty.VoiceFamily.MALE;
        instance = new SupportedCSS21();
    }
}

