/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.domassign.DeclarationTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleMapNodeData
implements NodeData {
    private static final int COMMON_DECLARATION_SIZE = 7;
    protected static DeclarationTransformer transformer = CSSFactory.getDeclarationTransformer();
    protected static SupportedCSS css = CSSFactory.getSupportedCSS();
    private Map<String, Quadruple> map = new HashMap<String, Quadruple>(css.getTotalProperties(), 1.0f);

    @Override
    public <T extends CSSProperty> T getProperty(String string) {
        return this.getProperty(string, true);
    }

    @Override
    public <T extends CSSProperty> T getProperty(String string, boolean bl) {
        Quadruple quadruple = this.map.get(string);
        if (quadruple == null) {
            return null;
        }
        CSSProperty cSSProperty = bl ? (quadruple.curProp != null ? quadruple.curProp : quadruple.inhProp) : quadruple.curProp;
        CSSProperty cSSProperty2 = cSSProperty;
        return (T)cSSProperty2;
    }

    @Override
    public Term<?> getValue(String string, boolean bl) {
        Quadruple quadruple = this.map.get(string);
        if (quadruple == null) {
            return null;
        }
        if (bl) {
            if (quadruple.curValue != null) {
                return quadruple.curValue;
            }
            return quadruple.inhValue;
        }
        return quadruple.curValue;
    }

    @Override
    public <T extends Term<?>> T getValue(Class<T> clazz, String string) {
        return this.getValue(clazz, string, true);
    }

    @Override
    public <T extends Term<?>> T getValue(Class<T> clazz, String string, boolean bl) {
        Quadruple quadruple = this.map.get(string);
        if (quadruple == null) {
            return null;
        }
        if (bl) {
            if (quadruple.curValue != null) {
                return (T)((Term)clazz.cast(quadruple.curValue));
            }
            return (T)((Term)clazz.cast(quadruple.inhValue));
        }
        return (T)((Term)clazz.cast(quadruple.curValue));
    }

    @Override
    public NodeData push(Declaration declaration) {
        HashMap<String, CSSProperty> hashMap = new HashMap<String, CSSProperty>(7);
        HashMap hashMap2 = new HashMap(7);
        boolean bl = transformer.parseDeclaration(declaration, hashMap, hashMap2);
        if (!bl) {
            return this;
        }
        for (String string : hashMap.keySet()) {
            Quadruple quadruple = this.map.get(string);
            if (quadruple == null) {
                quadruple = new Quadruple();
            }
            quadruple.curProp = (CSSProperty)hashMap.get(string);
            quadruple.curValue = (Term)hashMap2.get(string);
            if (quadruple.curValue != null) {
                quadruple.curValue = quadruple.curValue.setOperator(null);
            }
            this.map.put(string, quadruple);
        }
        return this;
    }

    @Override
    public NodeData concretize() {
        for (String string : this.map.keySet()) {
            Quadruple quadruple = this.map.get(string);
            if (quadruple.inhProp != null && quadruple.inhProp.equalsInherit()) {
                quadruple.inhProp = css.getDefaultProperty(string);
                Term<?> term = css.getDefaultValue(string);
                if (term != null) {
                    quadruple.inhValue = term;
                }
            }
            if (quadruple.curProp != null && quadruple.curProp.equalsInherit()) {
                quadruple.curProp = quadruple.inhProp == null ? css.getDefaultProperty(string) : quadruple.inhProp;
                quadruple.curValue = quadruple.inhValue == null ? css.getDefaultValue(string) : quadruple.inhValue;
            }
            this.map.put(string, quadruple);
        }
        return this;
    }

    @Override
    public NodeData inheritFrom(NodeData nodeData) throws ClassCastException {
        if (nodeData == null) {
            return this;
        }
        if (!(nodeData instanceof SingleMapNodeData)) {
            throw new ClassCastException("Cant't inherit from NodeData different from " + this.getClass().getName() + "(" + nodeData.getClass().getName() + ")");
        }
        SingleMapNodeData singleMapNodeData = (SingleMapNodeData)nodeData;
        for (String string : singleMapNodeData.map.keySet()) {
            Quadruple quadruple = singleMapNodeData.map.get(string);
            Quadruple quadruple2 = this.map.get(string);
            if (quadruple2 == null) {
                quadruple2 = new Quadruple();
            }
            if (quadruple.inhProp != null && quadruple.inhProp.inherited()) {
                quadruple2.inhProp = quadruple.inhProp;
                quadruple2.inhValue = quadruple.inhValue;
            }
            if (quadruple.curProp != null && quadruple.curProp.inherited()) {
                quadruple2.inhProp = quadruple.curProp;
                quadruple2.inhValue = quadruple.curValue;
            }
            if (quadruple2.isEmpty()) continue;
            this.map.put(string, quadruple2);
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>(this.map.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Term<?> term;
            Quadruple quadruple = this.map.get(string);
            CSSProperty cSSProperty = quadruple.curProp;
            if (cSSProperty == null) {
                cSSProperty = quadruple.inhProp;
            }
            if ((term = quadruple.curValue) == null) {
                term = quadruple.inhValue;
            }
            stringBuilder.append(string).append(": ");
            if (term != null) {
                stringBuilder.append(term.toString());
            } else {
                stringBuilder.append(cSSProperty.toString());
            }
            stringBuilder.append(";\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public Collection<String> getPropertyNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.map.keySet());
        return arrayList;
    }

    static class Quadruple {
        CSSProperty inhProp = null;
        CSSProperty curProp = null;
        Term<?> inhValue = null;
        Term<?> curValue = null;

        public boolean isEmpty() {
            return this.inhProp == null && this.curProp == null && this.inhValue == null && this.curValue == null;
        }
    }
}

