/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermIdent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Repeater {
    protected int times;
    protected List<Term<?>> terms;
    protected List<String> names;
    protected Class<? extends CSSProperty> type;

    public Repeater(int n) {
        this.times = n;
        this.terms = new ArrayList(n);
        this.names = new ArrayList<String>(n);
    }

    protected abstract boolean operation(int var1, Map<String, CSSProperty> var2, Map<String, Term<?>> var3);

    public boolean repeat(Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        for (int i = 0; i < this.times; ++i) {
            if (this.operation(i, map, map2)) continue;
            return false;
        }
        return true;
    }

    public boolean repeatOverFourTermDeclaration(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) throws IllegalArgumentException {
        switch (declaration.size()) {
            case 1: {
                Term term = (Term)declaration.get(0);
                if (term instanceof TermIdent && "INHERIT".equalsIgnoreCase((String)((TermIdent)term).getValue())) {
                    CSSProperty cSSProperty = CSSProperty.Translator.createInherit(this.type);
                    for (int i = 0; i < this.times; ++i) {
                        map.put(this.names.get(i), cSSProperty);
                    }
                    return true;
                }
                this.assignTerms(term, term, term, term);
                return this.repeat(map, map2);
            }
            case 2: {
                Term term = (Term)declaration.get(0);
                Term term2 = (Term)declaration.get(1);
                this.assignTerms(term, term2, term, term2);
                return this.repeat(map, map2);
            }
            case 3: {
                Term term = (Term)declaration.get(0);
                Term term3 = (Term)declaration.get(1);
                Term term4 = (Term)declaration.get(2);
                this.assignTerms(term, term3, term4, term3);
                return this.repeat(map, map2);
            }
            case 4: {
                Term term = (Term)declaration.get(0);
                Term term5 = (Term)declaration.get(1);
                Term term6 = (Term)declaration.get(2);
                Term term7 = (Term)declaration.get(3);
                this.assignTerms(term, term5, term6, term7);
                return this.repeat(map, map2);
            }
        }
        throw new IllegalArgumentException("Invalid length of terms in Repeater.");
    }

    public void assignPropertyNames(String ... stringArray) throws IllegalArgumentException {
        if (stringArray.length != this.times) {
            throw new IllegalArgumentException("Invalid length of propertyNames in Repeater.");
        }
        this.names = Arrays.asList(stringArray);
    }

    public void assignTerms(Term<?> ... termArray) throws IllegalArgumentException {
        if (termArray.length != this.times) {
            throw new IllegalArgumentException("Invalid length of terms in Repeater.");
        }
        this.terms = Arrays.asList(termArray);
    }

    public void assignDefaults(Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        SupportedCSS supportedCSS = CSSFactory.getSupportedCSS();
        for (String string : this.names) {
            Term<?> term;
            CSSProperty cSSProperty = supportedCSS.getDefaultProperty(string);
            if (cSSProperty != null) {
                map.put(string, cSSProperty);
            }
            if ((term = supportedCSS.getDefaultValue(string)) == null) continue;
            map2.put(string, term);
        }
    }
}

