/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultiMap<E, P, D> {
    private HashMap<E, D> mainMap;
    private HashMap<E, HashMap<P, D>> pseudoMaps;

    public MultiMap() {
        this.mainMap = new HashMap();
        this.pseudoMaps = new HashMap();
    }

    public MultiMap(int n) {
        this.mainMap = new HashMap(n);
        this.pseudoMaps = new HashMap();
    }

    protected abstract D createDataInstance();

    public int size() {
        return this.mainMap.size();
    }

    public D get(E e, P p) {
        HashMap<P, D> hashMap;
        Object object = p == null ? this.mainMap.get(e) : ((hashMap = this.pseudoMaps.get(e)) == null ? null : hashMap.get(p));
        return object;
    }

    public D get(E e) {
        return this.mainMap.get(e);
    }

    public D getOrCreate(E e, P p) {
        D d;
        if (p == null) {
            d = this.mainMap.get(e);
            if (d == null) {
                d = this.createDataInstance();
                this.mainMap.put(e, d);
            }
        } else {
            HashMap<Object, Object> hashMap = this.pseudoMaps.get(e);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.pseudoMaps.put(e, hashMap);
            }
            if ((d = hashMap.get(p)) == null) {
                d = this.createDataInstance();
                hashMap.put(p, d);
            }
        }
        return d;
    }

    public void put(E e, P p, D d) {
        if (p == null) {
            this.mainMap.put(e, d);
        } else {
            HashMap<Object, Object> hashMap = this.pseudoMaps.get(e);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.pseudoMaps.put(e, hashMap);
            }
            hashMap.put(p, d);
        }
    }

    public Set<E> keySet() {
        return this.mainMap.keySet();
    }

    public Set<P> pseudoSet(E e) {
        HashMap<P, D> hashMap = this.pseudoMaps.get(e);
        if (hashMap == null) {
            return Collections.emptySet();
        }
        return hashMap.keySet();
    }

    public boolean hasPseudo(E e, P p) {
        HashMap<P, D> hashMap = this.pseudoMaps.get(e);
        if (hashMap == null) {
            return false;
        }
        return hashMap.containsKey(p);
    }
}

