/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class GenericTreeWalker
implements TreeWalker {
    int whatToShow;
    Node currentNode;
    Node root;

    public GenericTreeWalker(Node node, int n) {
        this.root = node;
        this.currentNode = node;
        this.whatToShow = n;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node node) {
        this.currentNode = node;
    }

    public Node parentNode() {
        if (this.currentNode == null) {
            return null;
        }
        Node node = this.getParentNode(this.currentNode);
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    public Node firstChild() {
        if (this.currentNode == null) {
            return null;
        }
        Node node = this.getFirstChild(this.currentNode);
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    public Node lastChild() {
        if (this.currentNode == null) {
            return null;
        }
        Node node = this.getLastChild(this.currentNode);
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    public Node previousSibling() {
        if (this.currentNode == null) {
            return null;
        }
        Node node = this.getPreviousSibling(this.currentNode);
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    public Node nextSibling() {
        if (this.currentNode == null) {
            return null;
        }
        Node node = this.getNextSibling(this.currentNode);
        if (node != null) {
            this.currentNode = node;
        }
        return node;
    }

    public Node previousNode() {
        Node node;
        if (this.currentNode == null) {
            return null;
        }
        Node node2 = this.getPreviousSibling(this.currentNode);
        if (node2 == null) {
            node2 = this.getParentNode(this.currentNode);
            if (node2 != null) {
                this.currentNode = node2;
                return node2;
            }
            return null;
        }
        Node node3 = node = this.getLastChild(node2);
        while (node != null) {
            node3 = node;
            node = this.getLastChild(node3);
        }
        node = node3;
        if (node != null) {
            this.currentNode = node;
            return node;
        }
        this.currentNode = node2;
        return node2;
    }

    public Node nextNode() {
        if (this.currentNode == null) {
            return null;
        }
        Node node = this.getFirstChild(this.currentNode);
        if (node != null) {
            this.currentNode = node;
            return node;
        }
        node = this.getNextSibling(this.currentNode);
        if (node != null) {
            this.currentNode = node;
            return node;
        }
        Node node2 = this.getParentNode(this.currentNode);
        while (node2 != null) {
            node = this.getNextSibling(node2);
            if (node != null) {
                this.currentNode = node;
                return node;
            }
            node2 = this.getParentNode(node2);
        }
        return null;
    }

    private Node getParentNode(Node node) {
        if (node == null || node == this.root) {
            return null;
        }
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return null;
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        return this.getParentNode(node2);
    }

    private Node getNextSibling(Node node) {
        if (node == null || node == this.root) {
            return null;
        }
        Node node2 = node.getNextSibling();
        if (node2 == null) {
            node2 = node.getParentNode();
            if (node2 == null || node == this.root) {
                return null;
            }
            short s = this.acceptNode(node2);
            if (s == 3) {
                return this.getNextSibling(node2);
            }
            return null;
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        if (s == 3) {
            Node node3 = this.getFirstChild(node2);
            if (node3 == null) {
                return this.getNextSibling(node2);
            }
            return node3;
        }
        return this.getNextSibling(node2);
    }

    private Node getPreviousSibling(Node node) {
        if (node == null || node == this.root) {
            return null;
        }
        Node node2 = node.getPreviousSibling();
        if (node2 == null) {
            node2 = node.getParentNode();
            if (node2 == null || node == this.root) {
                return null;
            }
            short s = this.acceptNode(node2);
            if (s == 3) {
                return this.getPreviousSibling(node2);
            }
            return null;
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        if (s == 3) {
            Node node3 = this.getLastChild(node2);
            if (node3 == null) {
                return this.getPreviousSibling(node2);
            }
            return node3;
        }
        return this.getPreviousSibling(node2);
    }

    private Node getFirstChild(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return null;
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        if (s == 3 && node2.hasChildNodes()) {
            return this.getFirstChild(node2);
        }
        return this.getNextSibling(node2);
    }

    private Node getLastChild(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = node.getLastChild();
        if (node2 == null) {
            return null;
        }
        short s = this.acceptNode(node2);
        if (s == 1) {
            return node2;
        }
        if (s == 3 && node2.hasChildNodes()) {
            return this.getLastChild(node2);
        }
        return this.getPreviousSibling(node2);
    }

    private short acceptNode(Node node) {
        if ((this.whatToShow & 1 << node.getNodeType() - 1) != 0) {
            return 1;
        }
        return 3;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Traversal<T> {
        protected Object source;
        protected TreeWalker walker;

        public Traversal(TreeWalker treeWalker, Object object) {
            this.source = object;
            this.walker = treeWalker;
        }

        public Traversal(Document document, Object object, int n) {
            this.walker = new GenericTreeWalker(document.getDocumentElement(), n);
            this.source = object;
        }

        public void listTraversal(T t) {
            Node node = null;
            Node node2 = this.walker.nextNode();
            while (node2 != null) {
                node = this.walker.getCurrentNode();
                this.processNode(t, node2, this.source);
                this.walker.setCurrentNode(node);
                node2 = this.walker.nextNode();
            }
        }

        public void levelTraversal(T t) {
            Node node = null;
            Node node2 = node = this.walker.getCurrentNode();
            this.processNode(t, node2, this.source);
            this.walker.setCurrentNode(node);
            Node node3 = this.walker.firstChild();
            while (node3 != null) {
                this.levelTraversal(t);
                node3 = this.walker.nextSibling();
            }
            this.walker.setCurrentNode(node);
        }

        protected abstract void processNode(T var1, Node var2, Object var3);

        public Traversal<T> reset(TreeWalker treeWalker, Object object) {
            this.walker = treeWalker;
            this.source = object;
            return this;
        }
    }
}

