/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.ElementUtil;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.AssignedDeclaration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectAnalyzer
extends Analyzer {
    private static final Logger log = LoggerFactory.getLogger(DirectAnalyzer.class);

    public DirectAnalyzer(StyleSheet styleSheet) {
        super(styleSheet);
    }

    public DirectAnalyzer(List<StyleSheet> list) {
        super(list);
    }

    public NodeData getElementStyle(Element element, Selector.PseudoDeclaration pseudoDeclaration, String string) {
        Analyzer.Holder holder = "all".equals(string) ? (Analyzer.Holder)this.rules.get("all") : Analyzer.Holder.union((Analyzer.Holder)this.rules.get("all"), (Analyzer.Holder)this.rules.get(string));
        List<Declaration> list = this.getDeclarationsForElement(element, pseudoDeclaration, holder);
        NodeData nodeData = CSSFactory.createNodeData();
        for (Declaration declaration : list) {
            nodeData.push(declaration);
        }
        return nodeData;
    }

    protected List<Declaration> getDeclarationsForElement(Element element, Selector.PseudoDeclaration pseudoDeclaration, Analyzer.Holder holder) {
        List<RuleSet> list;
        List<RuleSet> list2;
        if (log.isDebugEnabled()) {
            log.debug("Traversal of {} {}.", (Object)element.getNodeName(), (Object)element.getNodeValue());
        }
        HashSet<RuleSet> hashSet = new HashSet<RuleSet>();
        for (String object2 : ElementUtil.elementClasses(element)) {
            list2 = holder.get(Analyzer.HolderItem.CLASS, object2.toLowerCase());
            if (list2 == null) continue;
            hashSet.addAll(list2);
        }
        log.trace("After CLASSes {} total candidates.", (Object)hashSet.size());
        String string = ElementUtil.elementID(element);
        if (string != null && string.length() != 0 && (list = holder.get(Analyzer.HolderItem.ID, string.toLowerCase())) != null) {
            hashSet.addAll(list);
        }
        log.trace("After IDs {} total candidates.", (Object)hashSet.size());
        String string2 = ElementUtil.elementName(element);
        if (string2 != null && (list2 = holder.get(Analyzer.HolderItem.ELEMENT, string2.toLowerCase())) != null) {
            hashSet.addAll(list2);
        }
        log.trace("After ELEMENTs {} total candidates.", (Object)hashSet.size());
        hashSet.addAll(holder.get(Analyzer.HolderItem.OTHER, null));
        list2 = new ArrayList<RuleSet>(hashSet);
        Collections.sort(list2);
        log.debug("Totally {} candidates.", (Object)hashSet.size());
        log.trace("With values: {}", (Object)list2);
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        for (RuleSet ruleSet : list2) {
            StyleSheet styleSheet = ruleSet.getStyleSheet();
            StyleSheet.Origin origin = styleSheet == null ? StyleSheet.Origin.AGENT : styleSheet.getOrigin();
            for (CombinedSelector combinedSelector : ruleSet.getSelectors()) {
                if (!this.matchSelector(combinedSelector, element)) {
                    log.trace("CombinedSelector \"{}\" NOT matched!", (Object)combinedSelector);
                    continue;
                }
                log.trace("CombinedSelector \"{}\" matched", (Object)combinedSelector);
                Selector.PseudoDeclaration pseudoDeclaration2 = combinedSelector.getPseudoElement();
                CombinedSelector.Specificity specificity = combinedSelector.computeSpecificity();
                if (pseudoDeclaration2 != pseudoDeclaration) continue;
                for (Declaration declaration : ruleSet) {
                    arrayList.add(new AssignedDeclaration(declaration, specificity, origin));
                }
            }
        }
        Collections.sort(arrayList);
        log.debug("Sorted {} declarations.", (Object)arrayList.size());
        log.trace("With values: {}", (Object)arrayList);
        return arrayList;
    }

    protected boolean matchSelector(CombinedSelector combinedSelector, Element element) {
        boolean bl = false;
        Selector.Combinator combinator = null;
        for (int i = combinedSelector.size() - 1; i >= 0; --i) {
            Node node;
            Selector selector = (Selector)combinedSelector.get(i);
            log.trace("Iterating loop with selector {}, combinator {}", (Object)selector, (Object)combinator);
            if (combinator == null) {
                bl = selector.matches(element);
            } else if (combinator == Selector.Combinator.ADJACENT) {
                node = element.getPreviousSibling();
                bl = false;
                if (node != null && node.getNodeType() == 1) {
                    bl = selector.matches((Element)node);
                }
            } else if (combinator == Selector.Combinator.DESCENDANT) {
                node = element.getParentNode();
                bl = false;
                do {
                    if (node == null) continue;
                    if (node.getNodeType() == 1 && selector.matches((Element)node)) {
                        bl = true;
                        continue;
                    }
                    node = node.getParentNode();
                } while (!bl && node != null);
            } else if (combinator == Selector.Combinator.CHILD) {
                node = element.getParentNode();
                bl = false;
                if (node != null && node.getNodeType() == 1) {
                    bl = selector.matches((Element)node);
                }
            }
            combinator = selector.getCombinator();
            if (!bl) break;
        }
        return bl;
    }
}

