/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermNumeric;
import cz.vutbr.web.css.TermPair;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.css.TermURI;
import cz.vutbr.web.domassign.Repeater;
import cz.vutbr.web.domassign.Variator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationTransformer {
    private static Logger log = LoggerFactory.getLogger(DeclarationTransformer.class);
    private static final boolean AVOID_INH = true;
    private static final boolean ALLOW_INH = false;
    private Map<String, Method> methods = this.parsingMethods();
    private static final DeclarationTransformer instance;
    private static final TermFactory tf;
    private static final SupportedCSS css;

    public static final DeclarationTransformer getInstance() {
        return instance;
    }

    public static final String camelCase(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '-') {
                bl = true;
                continue;
            }
            if (bl && Character.isLetter(c)) {
                stringBuilder.append(Character.toUpperCase(c));
                bl = false;
                continue;
            }
            if (!bl && Character.isLetter(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (c != '_') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public boolean parseDeclaration(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        String string = declaration.getProperty().toLowerCase();
        if (!css.isSupportedCSSProperty(string)) {
            return false;
        }
        try {
            Method method = this.methods.get(string);
            if (method != null) {
                boolean bl = (Boolean)method.invoke((Object)this, declaration, map, map2);
                log.debug("Parsing /{}/ {}", (Object)bl, (Object)declaration);
                return bl;
            }
            boolean bl = this.processAdditionalCSSGenericProperty(declaration, map, map2);
            log.debug("Parsing with proxy /{}/ {}", (Object)bl, (Object)declaration);
            return bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Illegal argument", illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn("Illegal access", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            log.warn("Invocation target", invocationTargetException);
            log.warn("Invotation target cause", invocationTargetException.getCause());
        }
        return false;
    }

    private DeclarationTransformer() {
    }

    protected Map<String, Method> parsingMethods() {
        HashMap<String, Method> hashMap = new HashMap<String, Method>(css.getTotalProperties(), 1.0f);
        for (String string : css.getDefinedPropertyNames()) {
            try {
                Method method = DeclarationTransformer.class.getDeclaredMethod(DeclarationTransformer.camelCase("process-" + string), Declaration.class, Map.class, Map.class);
                hashMap.put(string, method);
            }
            catch (Exception exception) {
                log.warn("Unable to find method for property {}.", (Object)string);
            }
        }
        log.info("Totally found {} parsing methods", (Object)hashMap.size());
        return hashMap;
    }

    public <T extends CSSProperty> T genericPropertyRaw(Class<T> clazz, Set<T> set, TermIdent termIdent) {
        try {
            String string = ((String)termIdent.getValue()).replace("-", "_").toUpperCase();
            T t = CSSProperty.Translator.valueOf(clazz, string);
            if (set != null && set.contains(t)) {
                return t;
            }
            return t;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected <T extends CSSProperty> boolean genericProperty(Class<T> clazz, TermIdent termIdent, boolean bl, Map<String, CSSProperty> map, String string) {
        T t = this.genericPropertyRaw(clazz, null, termIdent);
        if (t == null || bl && t.equalsInherit()) {
            return false;
        }
        map.put(string, (CSSProperty)t);
        return true;
    }

    protected <T extends CSSProperty> boolean genericTermIdent(Class<T> clazz, Term<?> term, boolean bl, String string, Map<String, CSSProperty> map) {
        if (term instanceof TermIdent) {
            return this.genericProperty(clazz, (TermIdent)term, bl, map, string);
        }
        return false;
    }

    protected <T extends CSSProperty> boolean genericTermColor(Term<?> term, String string, T t, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (term instanceof TermColor) {
            map.put(string, t);
            map2.put(string, term);
            return true;
        }
        return false;
    }

    protected <T extends CSSProperty> boolean genericTermLength(Term<?> term, String string, T t, boolean bl, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (term instanceof TermInteger && ((TermInteger)term).getUnit().equals((Object)TermNumeric.Unit.none)) {
            if (CSSFactory.getImplyPixelLength() || ((Float)((TermInteger)term).getValue()).floatValue() == 0.0f) {
                TermLength termLength = tf.createLength((Float)((TermInteger)term).getValue(), TermNumeric.Unit.px);
                return this.genericTerm(TermLength.class, termLength, string, t, bl, map, map2);
            }
            return false;
        }
        if (term instanceof TermLength) {
            return this.genericTerm(TermLength.class, term, string, t, bl, map, map2);
        }
        return false;
    }

    protected <T extends CSSProperty> boolean genericTerm(Class<? extends Term<?>> clazz, Term<?> term, String string, T t, boolean bl, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (clazz.isInstance(term)) {
            if (bl) {
                Float f;
                if (term.getValue() instanceof Integer) {
                    Integer n = new Integer(0);
                    if (n.compareTo((Integer)term.getValue()) > 0) {
                        ((TermInteger)term).setValue(n);
                    }
                } else if (term.getValue() instanceof Float && (f = new Float(0.0f)).compareTo((Float)term.getValue()) > 0) {
                    ((TermNumber)term).setValue(f);
                }
            }
            map.put(string, t);
            map2.put(string, term);
            return true;
        }
        return false;
    }

    protected <T extends CSSProperty> boolean genericOneIdent(Class<T> clazz, Declaration declaration, Map<String, CSSProperty> map) {
        if (declaration.size() != 1) {
            return false;
        }
        return this.genericTermIdent(clazz, (Term)declaration.get(0), false, declaration.getProperty(), map);
    }

    protected <T extends CSSProperty> boolean genericOneIdentOrColor(Class<T> clazz, T t, Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() != 1) {
            return false;
        }
        return this.genericTermIdent(clazz, (Term)declaration.get(0), false, declaration.getProperty(), map) || this.genericTermColor((Term)declaration.get(0), declaration.getProperty(), t, map, map2);
    }

    protected <T extends CSSProperty> boolean genericOneIdentOrInteger(Class<T> clazz, T t, boolean bl, Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() != 1) {
            return false;
        }
        return this.genericTermIdent(clazz, (Term)declaration.get(0), false, declaration.getProperty(), map) || this.genericTerm(TermInteger.class, (Term)declaration.get(0), declaration.getProperty(), t, bl, map, map2);
    }

    protected <T extends CSSProperty> boolean genericOneIdentOrIntegerOrNumber(Class<T> clazz, T t, T t2, boolean bl, Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() != 1) {
            return false;
        }
        return this.genericTermIdent(clazz, (Term)declaration.get(0), false, declaration.getProperty(), map) || this.genericTerm(TermInteger.class, (Term)declaration.get(0), declaration.getProperty(), t, bl, map, map2) || this.genericTerm(TermNumber.class, (Term)declaration.get(0), declaration.getProperty(), t2, bl, map, map2);
    }

    protected <T extends CSSProperty> boolean genericOneIdentOrLength(Class<T> clazz, T t, boolean bl, Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() != 1) {
            return false;
        }
        return this.genericTermIdent(clazz, (Term)declaration.get(0), false, declaration.getProperty(), map) || this.genericTermLength((Term)declaration.get(0), declaration.getProperty(), t, bl, map, map2);
    }

    protected <T extends Enum<T>> boolean genericOneIdentOrLengthOrPercent(Class<T> clazz, T t, T t2, boolean bl, Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() != 1) {
            return false;
        }
        return this.genericTermIdent(clazz, (Term)declaration.get(0), false, declaration.getProperty(), map) || this.genericTermLength((Term)declaration.get(0), declaration.getProperty(), (CSSProperty)((Object)t), bl, map, map2) || this.genericTerm(TermPercent.class, (Term)declaration.get(0), declaration.getProperty(), (CSSProperty)((Object)t2), bl, map, map2);
    }

    protected <T extends Enum<T>> boolean genericTwoIdentsOrLengthsOrPercents(Class<T> clazz, T t, boolean bl, Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() == 1) {
            String string;
            Term term = (Term)declaration.get(0);
            if (this.genericTermIdent(clazz, term, false, string = declaration.getProperty(), map) || this.genericTermLength(term, string, (CSSProperty)((Object)t), bl, map, map2) || this.genericTerm(TermPercent.class, term, string, (CSSProperty)((Object)t), bl, map, map2)) {
                if (map.get(string) == t) {
                    TermList termList = tf.createList(2);
                    termList.add(term);
                    termList.add(term);
                    map2.put(string, termList);
                }
                return true;
            }
            return false;
        }
        if (declaration.size() == 2) {
            Term term = (Term)declaration.get(0);
            Term term2 = (Term)declaration.get(1);
            String string = declaration.getProperty();
            if ((this.genericTermLength(term, string, (CSSProperty)((Object)t), bl, map, map2) || this.genericTerm(TermPercent.class, term, string, (CSSProperty)((Object)t), bl, map, map2)) && (this.genericTermLength(term2, string, (CSSProperty)((Object)t), bl, map, map2) || this.genericTerm(TermPercent.class, term2, string, (CSSProperty)((Object)t), bl, map, map2))) {
                TermList termList = tf.createList(2);
                termList.add(term);
                termList.add(term2);
                map2.put(string, termList);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean processColor(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrColor(CSSProperty.Color.class, CSSProperty.Color.color, declaration, map, map2);
    }

    private boolean processBackground(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BackgroundVariator backgroundVariator = new BackgroundVariator();
        backgroundVariator.assignTermsFromDeclaration(declaration);
        backgroundVariator.assignDefaults(map, map2);
        return backgroundVariator.vary(map, map2);
    }

    private boolean processBackgroundAttachement(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BackgroundVariator backgroundVariator = new BackgroundVariator();
        return backgroundVariator.tryOneTermVariant(3, declaration, map, map2);
    }

    private boolean processBackgroundColor(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BackgroundVariator backgroundVariator = new BackgroundVariator();
        return backgroundVariator.tryOneTermVariant(0, declaration, map, map2);
    }

    private boolean processBackgroundImage(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BackgroundVariator backgroundVariator = new BackgroundVariator();
        return backgroundVariator.tryOneTermVariant(1, declaration, map, map2);
    }

    private boolean processBackgroundRepeat(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BackgroundVariator backgroundVariator = new BackgroundVariator();
        return backgroundVariator.tryOneTermVariant(2, declaration, map, map2);
    }

    private boolean processBackgroundPosition(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BackgroundVariator backgroundVariator = new BackgroundVariator();
        return backgroundVariator.tryMultiTermVariant(4, map, map2, declaration.toArray(new Term[0]));
    }

    private boolean processBorder(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderVariator borderVariator = new BorderVariator();
        borderVariator.assignTermsFromDeclaration(declaration);
        ((Variator)borderVariator).assignDefaults(map, map2);
        return borderVariator.vary(map, map2);
    }

    private boolean processBorderCollapse(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.BorderCollapse.class, declaration, map);
    }

    private boolean processBorderTopColor(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("top");
        return borderSideVariator.tryOneTermVariant(0, declaration, map, map2);
    }

    private boolean processBorderRightColor(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("right");
        return borderSideVariator.tryOneTermVariant(0, declaration, map, map2);
    }

    private boolean processBorderBottomColor(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("bottom");
        return borderSideVariator.tryOneTermVariant(0, declaration, map, map2);
    }

    private boolean processBorderLeftColor(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("left");
        return borderSideVariator.tryOneTermVariant(0, declaration, map, map2);
    }

    private boolean processBorderTopStyle(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("top");
        return borderSideVariator.tryOneTermVariant(1, declaration, map, map2);
    }

    private boolean processBorderRightStyle(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("right");
        return borderSideVariator.tryOneTermVariant(1, declaration, map, map2);
    }

    private boolean processBorderBottomStyle(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("bottom");
        return borderSideVariator.tryOneTermVariant(1, declaration, map, map2);
    }

    private boolean processBorderLeftStyle(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("left");
        return borderSideVariator.tryOneTermVariant(1, declaration, map, map2);
    }

    private boolean processBorderSpacing(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() == 1) {
            String string;
            Term term = (Term)declaration.get(0);
            if (this.genericTermIdent(CSSProperty.BorderSpacing.class, term, false, string = declaration.getProperty(), map) || this.genericTermLength(term, string, CSSProperty.BorderSpacing.list_values, true, map, map2)) {
                if (map.get(string) == CSSProperty.BorderSpacing.list_values) {
                    TermList termList = tf.createList(2);
                    termList.add(term);
                    termList.add(term);
                    map2.put(string, termList);
                }
                return true;
            }
        } else if (declaration.size() == 2) {
            Term term = (Term)declaration.get(0);
            Term term2 = (Term)declaration.get(1);
            String string = declaration.getProperty();
            if (this.genericTermLength(term, string, CSSProperty.BorderSpacing.list_values, true, map, map2) && this.genericTermLength(term2, string, CSSProperty.BorderSpacing.list_values, true, map, map2)) {
                TermList termList = tf.createList(2);
                termList.add(term);
                termList.add(term2);
                map2.put(string, termList);
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean processBorderColor(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderColorRepeater borderColorRepeater = new BorderColorRepeater();
        return borderColorRepeater.repeatOverFourTermDeclaration(declaration, map, map2);
    }

    private boolean processBorderStyle(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderStyleRepeater borderStyleRepeater = new BorderStyleRepeater();
        return borderStyleRepeater.repeatOverFourTermDeclaration(declaration, map, map2);
    }

    private boolean processBorderTopWidth(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("top");
        return borderSideVariator.tryOneTermVariant(2, declaration, map, map2);
    }

    private boolean processBorderRightWidth(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("right");
        return borderSideVariator.tryOneTermVariant(2, declaration, map, map2);
    }

    private boolean processBorderBottomWidth(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("bottom");
        return borderSideVariator.tryOneTermVariant(2, declaration, map, map2);
    }

    private boolean processBorderLeftWidth(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("left");
        return borderSideVariator.tryOneTermVariant(2, declaration, map, map2);
    }

    private boolean processBorderWidth(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderWidthRepeater borderWidthRepeater = new BorderWidthRepeater();
        return borderWidthRepeater.repeatOverFourTermDeclaration(declaration, map, map2);
    }

    private boolean processBorderTop(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("top");
        borderSideVariator.assignTermsFromDeclaration(declaration);
        borderSideVariator.assignDefaults(map, map2);
        return borderSideVariator.vary(map, map2);
    }

    private boolean processBorderRight(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("right");
        borderSideVariator.assignTermsFromDeclaration(declaration);
        borderSideVariator.assignDefaults(map, map2);
        return borderSideVariator.vary(map, map2);
    }

    private boolean processBorderBottom(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("bottom");
        borderSideVariator.assignTermsFromDeclaration(declaration);
        borderSideVariator.assignDefaults(map, map2);
        return borderSideVariator.vary(map, map2);
    }

    private boolean processBorderLeft(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderSideVariator borderSideVariator = new BorderSideVariator("left");
        borderSideVariator.assignTermsFromDeclaration(declaration);
        borderSideVariator.assignDefaults(map, map2);
        return borderSideVariator.vary(map, map2);
    }

    private boolean processBorderTopLeftRadius(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericTwoIdentsOrLengthsOrPercents(CSSProperty.BorderRadius.class, CSSProperty.BorderRadius.list_values, false, declaration, map, map2);
    }

    private boolean processBorderTopRightRadius(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericTwoIdentsOrLengthsOrPercents(CSSProperty.BorderRadius.class, CSSProperty.BorderRadius.list_values, false, declaration, map, map2);
    }

    private boolean processBorderBottomRightRadius(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericTwoIdentsOrLengthsOrPercents(CSSProperty.BorderRadius.class, CSSProperty.BorderRadius.list_values, false, declaration, map, map2);
    }

    private boolean processBorderBottomLeftRadius(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericTwoIdentsOrLengthsOrPercents(CSSProperty.BorderRadius.class, CSSProperty.BorderRadius.list_values, false, declaration, map, map2);
    }

    private boolean processBorderRadius(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        BorderRadiusRepeater borderRadiusRepeater = new BorderRadiusRepeater();
        return borderRadiusRepeater.repeatOverMultiTermDeclaration(declaration, map, map2);
    }

    private boolean processFontFamily(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        FontVariator fontVariator = new FontVariator();
        return fontVariator.tryMultiTermVariant(5, map, map2, declaration.toArray(new Term[0]));
    }

    private boolean processFontSize(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        FontVariator fontVariator = new FontVariator();
        return fontVariator.tryOneTermVariant(3, declaration, map, map2);
    }

    private boolean processFontStyle(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        FontVariator fontVariator = new FontVariator();
        return fontVariator.tryOneTermVariant(0, declaration, map, map2);
    }

    private boolean processFontVariant(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        FontVariator fontVariator = new FontVariator();
        return fontVariator.tryOneTermVariant(2, declaration, map, map2);
    }

    private boolean processFontWeight(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        FontVariator fontVariator = new FontVariator();
        return fontVariator.tryOneTermVariant(2, declaration, map, map2);
    }

    private boolean processFont(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        FontVariator fontVariator = new FontVariator();
        fontVariator.assignTermsFromDeclaration(declaration);
        fontVariator.assignDefaults(map, map2);
        return ((Variator)fontVariator).vary(map, map2);
    }

    private boolean processLineHeight(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        FontVariator fontVariator = new FontVariator();
        return fontVariator.tryOneTermVariant(4, declaration, map, map2);
    }

    private boolean processTop(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Top.class, CSSProperty.Top.length, CSSProperty.Top.percentage, false, declaration, map, map2);
    }

    private boolean processRight(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Right.class, CSSProperty.Right.length, CSSProperty.Right.percentage, false, declaration, map, map2);
    }

    private boolean processBottom(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Bottom.class, CSSProperty.Bottom.length, CSSProperty.Bottom.percentage, false, declaration, map, map2);
    }

    private boolean processLeft(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Left.class, CSSProperty.Left.length, CSSProperty.Left.percentage, false, declaration, map, map2);
    }

    private boolean processWidth(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Width.class, CSSProperty.Width.length, CSSProperty.Width.percentage, false, declaration, map, map2);
    }

    private boolean processHeight(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Height.class, CSSProperty.Height.length, CSSProperty.Height.percentage, false, declaration, map, map2);
    }

    private boolean processCaptionSide(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.CaptionSide.class, declaration, map);
    }

    private boolean processClear(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.Clear.class, declaration, map);
    }

    private boolean processClip(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        TermFunction termFunction;
        if (declaration.size() != 1) {
            return false;
        }
        Term term = (Term)declaration.get(0);
        if (term instanceof TermIdent) {
            EnumSet<CSSProperty.Clip> enumSet = EnumSet.allOf(CSSProperty.Clip.class);
            CSSProperty.Clip clip = this.genericPropertyRaw(CSSProperty.Clip.class, enumSet, (TermIdent)term);
            if (clip != null) {
                map.put("clip-top", clip);
                map.put("clip-right", clip);
                map.put("clip-bottom", clip);
                map.put("clip-left", clip);
                return true;
            }
            return false;
        }
        if (term instanceof TermFunction && "rect".equals((termFunction = (TermFunction)term).getFunctionName()) && termFunction.size() == 4) {
            ClipRepeater clipRepeater = new ClipRepeater();
            clipRepeater.assignTerms(((List)termFunction.getValue()).toArray(new Term[0]));
            return clipRepeater.repeat(map, map2);
        }
        return false;
    }

    private boolean processCounterIncrement(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() == 1 && this.genericOneIdent(CSSProperty.CounterIncrement.class, declaration, map)) {
            return true;
        }
        LinkedHashSet<TermPair<String, Integer>> linkedHashSet = new LinkedHashSet<TermPair<String, Integer>>();
        String string = null;
        for (Term term : declaration.asList()) {
            if (term instanceof TermIdent) {
                string = (String)((TermIdent)term).getValue();
                linkedHashSet.add(tf.createPair(string, new Integer(1)));
                continue;
            }
            if (term instanceof TermInteger && string != null) {
                linkedHashSet.add(tf.createPair(string, ((TermInteger)term).getValue()));
                string = null;
                continue;
            }
            return false;
        }
        if (!linkedHashSet.isEmpty()) {
            TermList termList = tf.createList(linkedHashSet.size());
            termList.addAll(linkedHashSet);
            map.put("counter-increment", CSSProperty.CounterIncrement.list_values);
            map2.put("counter-increment", termList);
            return true;
        }
        return false;
    }

    private boolean processCounterReset(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() == 1 && this.genericOneIdent(CSSProperty.CounterReset.class, declaration, map)) {
            return true;
        }
        LinkedHashSet<TermPair<String, Integer>> linkedHashSet = new LinkedHashSet<TermPair<String, Integer>>();
        String string = null;
        for (Term term : declaration.asList()) {
            if (term instanceof TermIdent) {
                string = (String)((TermIdent)term).getValue();
                linkedHashSet.add(tf.createPair(string, new Integer(1)));
                continue;
            }
            if (term instanceof TermInteger && string != null) {
                linkedHashSet.add(tf.createPair(string, ((TermInteger)term).getValue()));
                string = null;
                continue;
            }
            return false;
        }
        if (!linkedHashSet.isEmpty()) {
            TermList termList = tf.createList(linkedHashSet.size());
            termList.addAll(linkedHashSet);
            map.put("counter-reset", CSSProperty.CounterReset.list_values);
            map2.put("counter-reset", termList);
            return true;
        }
        return false;
    }

    private boolean processCursor(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() == 1 && this.genericOneIdent(CSSProperty.Cursor.class, declaration, map)) {
            return true;
        }
        EnumSet<CSSProperty.Cursor> enumSet = EnumSet.complementOf(EnumSet.of(CSSProperty.Cursor.INHERIT));
        TermList termList = tf.createList();
        CSSProperty.Cursor cursor = null;
        for (Term term : declaration.asList()) {
            if (term instanceof TermURI) {
                termList.add(term);
                continue;
            }
            if (term instanceof TermIdent && (cursor = this.genericPropertyRaw(CSSProperty.Cursor.class, enumSet, (TermIdent)term)) != null) {
                if (declaration.indexOf(term) != declaration.size() - 1) {
                    return false;
                }
                map.put("cursor", cursor);
                if (!termList.isEmpty()) {
                    map2.put("cursor", termList);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean processDirection(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.Direction.class, declaration, map);
    }

    private boolean processDisplay(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.Display.class, declaration, map);
    }

    private boolean processEmptyCells(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.EmptyCells.class, declaration, map);
    }

    private boolean processFloat(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.Float.class, declaration, map);
    }

    private boolean processListStyleImage(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        ListStyleVariator listStyleVariator = new ListStyleVariator();
        return listStyleVariator.tryOneTermVariant(2, declaration, map, map2);
    }

    private boolean processListStylePosition(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        ListStyleVariator listStyleVariator = new ListStyleVariator();
        return listStyleVariator.tryOneTermVariant(1, declaration, map, map2);
    }

    private boolean processListStyleType(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        ListStyleVariator listStyleVariator = new ListStyleVariator();
        return listStyleVariator.tryOneTermVariant(0, declaration, map, map2);
    }

    private boolean processListStyle(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        ListStyleVariator listStyleVariator = new ListStyleVariator();
        listStyleVariator.assignTermsFromDeclaration(declaration);
        listStyleVariator.assignDefaults(map, map2);
        return listStyleVariator.vary(map, map2);
    }

    private boolean processMarginTop(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Margin.class, CSSProperty.Margin.length, CSSProperty.Margin.percentage, false, declaration, map, map2);
    }

    private boolean processMarginRight(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Margin.class, CSSProperty.Margin.length, CSSProperty.Margin.percentage, false, declaration, map, map2);
    }

    private boolean processMarginBottom(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Margin.class, CSSProperty.Margin.length, CSSProperty.Margin.percentage, false, declaration, map, map2);
    }

    private boolean processMarginLeft(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Margin.class, CSSProperty.Margin.length, CSSProperty.Margin.percentage, false, declaration, map, map2);
    }

    private boolean processMargin(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        MarginRepeater marginRepeater = new MarginRepeater();
        return marginRepeater.repeatOverFourTermDeclaration(declaration, map, map2);
    }

    private boolean processMaxHeight(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.MaxHeight.class, CSSProperty.MaxHeight.length, CSSProperty.MaxHeight.percentage, true, declaration, map, map2);
    }

    private boolean processMaxWidth(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.MaxWidth.class, CSSProperty.MaxWidth.length, CSSProperty.MaxWidth.percentage, true, declaration, map, map2);
    }

    private boolean processMinHeight(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.MinHeight.class, CSSProperty.MinHeight.length, CSSProperty.MinHeight.percentage, true, declaration, map, map2);
    }

    private boolean processMinWidth(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.MinWidth.class, CSSProperty.MinWidth.length, CSSProperty.MinWidth.percentage, true, declaration, map, map2);
    }

    private boolean processOpacity(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrIntegerOrNumber(CSSProperty.Opacity.class, CSSProperty.Opacity.number, CSSProperty.Opacity.number, false, declaration, map, map2);
    }

    private boolean processOrphans(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrInteger(CSSProperty.Orphans.class, CSSProperty.Orphans.integer, true, declaration, map, map2);
    }

    private boolean processOutlineColor(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        OutlineVariator outlineVariator = new OutlineVariator();
        return outlineVariator.tryOneTermVariant(0, declaration, map, map2);
    }

    private boolean processOutlineStyle(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        OutlineVariator outlineVariator = new OutlineVariator();
        return outlineVariator.tryOneTermVariant(1, declaration, map, map2);
    }

    private boolean processOutlineWidth(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        OutlineVariator outlineVariator = new OutlineVariator();
        return outlineVariator.tryOneTermVariant(2, declaration, map, map2);
    }

    private boolean processOutline(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        OutlineVariator outlineVariator = new OutlineVariator();
        outlineVariator.assignTermsFromDeclaration(declaration);
        outlineVariator.assignDefaults(map, map2);
        return outlineVariator.vary(map, map2);
    }

    private boolean processOverflow(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.Overflow.class, declaration, map);
    }

    private boolean processPaddingTop(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Padding.class, CSSProperty.Padding.length, CSSProperty.Padding.percentage, true, declaration, map, map2);
    }

    private boolean processPaddingRight(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Padding.class, CSSProperty.Padding.length, CSSProperty.Padding.percentage, true, declaration, map, map2);
    }

    private boolean processPaddingBottom(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Padding.class, CSSProperty.Padding.length, CSSProperty.Padding.percentage, true, declaration, map, map2);
    }

    private boolean processPaddingLeft(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.Padding.class, CSSProperty.Padding.length, CSSProperty.Padding.percentage, true, declaration, map, map2);
    }

    private boolean processPadding(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        PaddingRepeater paddingRepeater = new PaddingRepeater();
        return paddingRepeater.repeatOverFourTermDeclaration(declaration, map, map2);
    }

    private boolean processPageBreakAfter(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.PageBreak.class, declaration, map);
    }

    private boolean processPageBreakBefore(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.PageBreak.class, declaration, map);
    }

    private boolean processPageBreakInside(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.PageBreakInside.class, declaration, map);
    }

    private boolean processPosition(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.Position.class, declaration, map);
    }

    private boolean processQuotes(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() == 1 && this.genericTermIdent(CSSProperty.Quotes.class, (Term)declaration.get(0), false, "quotes", map)) {
            return true;
        }
        TermList termList = tf.createList();
        for (Term term : declaration.asList()) {
            if (term instanceof TermString) {
                termList.add(term);
                continue;
            }
            return false;
        }
        if (!termList.isEmpty() && termList.size() % 2 == 0) {
            map.put("quotes", CSSProperty.Quotes.list_values);
            map2.put("quotes", termList);
            return true;
        }
        return false;
    }

    private boolean processTableLayout(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.TableLayout.class, declaration, map);
    }

    private boolean processTextAlign(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.TextAlign.class, declaration, map);
    }

    private boolean processTextDecoration(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        EnumSet<CSSProperty.TextDecoration> enumSet = EnumSet.of(CSSProperty.TextDecoration.BLINK, CSSProperty.TextDecoration.LINE_THROUGH, CSSProperty.TextDecoration.OVERLINE, CSSProperty.TextDecoration.UNDERLINE);
        if (declaration.size() == 1) {
            return this.genericOneIdent(CSSProperty.TextDecoration.class, declaration, map);
        }
        TermList termList = tf.createList();
        CSSProperty.TextDecoration textDecoration = null;
        for (Term term : declaration.asList()) {
            if (term instanceof TermIdent && (textDecoration = this.genericPropertyRaw(CSSProperty.TextDecoration.class, enumSet, (TermIdent)term)) != null) {
                termList.add(tf.createTerm(textDecoration));
                continue;
            }
            return false;
        }
        if (!termList.isEmpty()) {
            map.put("text-decoration", CSSProperty.TextDecoration.list_values);
            map2.put("text-decoration", termList);
            return true;
        }
        return false;
    }

    private boolean processTextIndent(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.TextIndent.class, CSSProperty.TextIndent.length, CSSProperty.TextIndent.percentage, false, declaration, map, map2);
    }

    private boolean processTextTransform(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.TextTransform.class, declaration, map);
    }

    private boolean processUnicodeBidi(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.UnicodeBidi.class, declaration, map);
    }

    private boolean processVerticalAlign(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLengthOrPercent(CSSProperty.VerticalAlign.class, CSSProperty.VerticalAlign.length, CSSProperty.VerticalAlign.percentage, false, declaration, map, map2);
    }

    private boolean processVisibility(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.Visibility.class, declaration, map);
    }

    private boolean processWhiteSpace(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdent(CSSProperty.WhiteSpace.class, declaration, map);
    }

    private boolean processWidows(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrInteger(CSSProperty.Widows.class, CSSProperty.Widows.integer, true, declaration, map, map2);
    }

    private boolean processWordSpacing(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLength(CSSProperty.WordSpacing.class, CSSProperty.WordSpacing.length, false, declaration, map, map2);
    }

    private boolean processLetterSpacing(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrLength(CSSProperty.LetterSpacing.class, CSSProperty.LetterSpacing.length, false, declaration, map, map2);
    }

    private boolean processZIndex(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        return this.genericOneIdentOrInteger(CSSProperty.ZIndex.class, CSSProperty.ZIndex.integer, false, declaration, map, map2);
    }

    private boolean processAdditionalCSSGenericProperty(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() == 1) {
            Term term = (Term)declaration.get(0);
            if (term instanceof TermIdent) {
                return this.genericProperty(CSSProperty.GenericCSSPropertyProxy.class, (TermIdent)term, true, map, declaration.getProperty());
            }
            return this.genericTerm(TermLength.class, term, declaration.getProperty(), null, false, map, map2) || this.genericTerm(TermPercent.class, term, declaration.getProperty(), null, false, map, map2) || this.genericTerm(TermInteger.class, term, declaration.getProperty(), null, false, map, map2) || this.genericTermColor(term, declaration.getProperty(), null, map, map2);
        }
        log.warn("Ignoring unsupported property " + declaration.getProperty() + " with multiple values");
        return false;
    }

    private boolean processContent(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
        if (declaration.size() == 1 && this.genericOneIdent(CSSProperty.Content.class, declaration, map)) {
            return true;
        }
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList("open-quote", "close-quote", "no-open-quote", "no-close-quote"));
        HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList("counter", "counters", "attr"));
        TermList termList = tf.createList();
        for (Term term : declaration.asList()) {
            if (term instanceof TermIdent && hashSet.contains(((String)((TermIdent)term).getValue()).toLowerCase())) {
                termList.add(term);
                continue;
            }
            if (term instanceof TermString) {
                termList.add(term);
                continue;
            }
            if (term instanceof TermURI) {
                termList.add(term);
                continue;
            }
            if (term instanceof TermFunction && hashSet2.contains(((TermFunction)term).getFunctionName().toLowerCase())) {
                termList.add(term);
                continue;
            }
            return false;
        }
        if (termList.isEmpty()) {
            return false;
        }
        map.put("content", CSSProperty.Content.list_values);
        map2.put("content", termList);
        return true;
    }

    static {
        tf = CSSFactory.getTermFactory();
        css = CSSFactory.getSupportedCSS();
        instance = new DeclarationTransformer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClipRepeater
    extends Repeater {
        public ClipRepeater() {
            super(4);
            this.names.add("clip-top");
            this.names.add("clip-right");
            this.names.add("clip-bottom");
            this.names.add("clip-left");
            this.type = CSSProperty.Clip.class;
        }

        @Override
        protected boolean operation(int n, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            EnumSet<CSSProperty.Clip> enumSet = EnumSet.of(CSSProperty.Clip.AUTO);
            CSSProperty.Clip clip = null;
            if (this.terms.get(n) instanceof TermIdent && (clip = DeclarationTransformer.this.genericPropertyRaw(CSSProperty.Clip.class, enumSet, (TermIdent)this.terms.get(n))) != null) {
                map.put((String)this.names.get(n), clip);
                return true;
            }
            return DeclarationTransformer.this.genericTermLength((Term)this.terms.get(n), (String)this.names.get(n), CSSProperty.Clip.rect, false, map, map2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PaddingRepeater
    extends Repeater {
        public PaddingRepeater() {
            super(4);
            this.names.add("padding-top");
            this.names.add("padding-right");
            this.names.add("padding-bottom");
            this.names.add("padding-left");
            this.type = CSSProperty.Padding.class;
        }

        @Override
        protected boolean operation(int n, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            return DeclarationTransformer.this.genericTermIdent(this.type, (Term)this.terms.get(n), true, (String)this.names.get(n), map) || DeclarationTransformer.this.genericTermLength((Term)this.terms.get(n), (String)this.names.get(n), CSSProperty.Padding.length, false, map, map2) || DeclarationTransformer.this.genericTerm(TermPercent.class, (Term)this.terms.get(n), (String)this.names.get(n), CSSProperty.Padding.percentage, false, map, map2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MarginRepeater
    extends Repeater {
        public MarginRepeater() {
            super(4);
            this.type = CSSProperty.Margin.class;
            this.names.add("margin-top");
            this.names.add("margin-right");
            this.names.add("margin-bottom");
            this.names.add("margin-left");
        }

        @Override
        protected boolean operation(int n, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            return DeclarationTransformer.this.genericTermIdent(this.type, (Term)this.terms.get(n), true, (String)this.names.get(n), map) || DeclarationTransformer.this.genericTermLength((Term)this.terms.get(n), (String)this.names.get(n), CSSProperty.Margin.length, false, map, map2) || DeclarationTransformer.this.genericTerm(TermPercent.class, (Term)this.terms.get(n), (String)this.names.get(n), CSSProperty.Margin.percentage, false, map, map2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BorderRadiusRepeater
    extends Repeater {
        public BorderRadiusRepeater() {
            super(4);
            this.type = CSSProperty.BorderRadius.class;
            this.names.add("border-top-left-radius");
            this.names.add("border-top-right-radius");
            this.names.add("border-bottom-right-radius");
            this.names.add("border-bottom-left-radius");
        }

        @Override
        protected boolean operation(int n, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            Term term = (Term)this.terms.get(n);
            String string = (String)this.names.get(n);
            if (DeclarationTransformer.this.genericTermIdent(this.type, (Term)this.terms.get(n), true, (String)this.names.get(n), map)) {
                return true;
            }
            if (term instanceof TermList) {
                map.put(string, CSSProperty.BorderRadius.list_values);
                map2.put(string, term);
                return true;
            }
            return false;
        }

        public boolean repeatOverMultiTermDeclaration(Declaration declaration, Map<String, CSSProperty> map, Map<String, Term<?>> map2) throws IllegalArgumentException {
            Term<?>[] termArray;
            Term term;
            if (declaration.size() == 1 && (term = (Term)declaration.get(0)) instanceof TermIdent && "INHERIT".equalsIgnoreCase((String)((TermIdent)term).getValue())) {
                Object t = CSSProperty.Translator.createInherit(this.type);
                for (int i = 0; i < this.times; ++i) {
                    map.put((String)this.names.get(i), (CSSProperty)t);
                }
                return true;
            }
            int n = -1;
            for (int i = 0; i < declaration.size(); ++i) {
                termArray = (Term<?>[])declaration.get(i);
                if (termArray.getOperator() != Term.Operator.SLASH) continue;
                n = i;
                break;
            }
            if (n == -1) {
                Term<?>[] termArray2 = this.createFourTerms(declaration, 0, declaration.size());
                for (int i = 0; i < 4; ++i) {
                    TermList termList = tf.createList(2);
                    termList.add(termArray2[i]);
                    termList.add(termArray2[i]);
                    this.terms.add(termList);
                }
            } else {
                Term<?>[] termArray3 = this.createFourTerms(declaration, 0, n);
                termArray = this.createFourTerms(declaration, n, declaration.size());
                for (int i = 0; i < 4; ++i) {
                    TermList termList = tf.createList(2);
                    termList.add(termArray3[i]);
                    termList.add(termArray[i]);
                    this.terms.add(termList);
                }
            }
            return this.repeat(map, map2);
        }

        private Term<?>[] createFourTerms(Declaration declaration, int n, int n2) throws IllegalArgumentException {
            int n3;
            int n4 = n2 - n;
            Term[] termArray = new Term[4];
            switch (n4) {
                case 1: {
                    termArray[2] = termArray[3] = (Term)declaration.get(n);
                    termArray[1] = termArray[3];
                    termArray[0] = termArray[3];
                    break;
                }
                case 2: {
                    termArray[0] = termArray[2] = (Term)declaration.get(n);
                    termArray[1] = termArray[3] = (Term)declaration.get(n + 1);
                    break;
                }
                case 3: {
                    termArray[0] = (Term)declaration.get(n);
                    termArray[1] = termArray[3] = (Term)declaration.get(n + 1);
                    termArray[2] = (Term)declaration.get(n + 2);
                    break;
                }
                case 4: {
                    for (n3 = 0; n3 < 4; ++n3) {
                        termArray[n3] = (Term)declaration.get(n + n3);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid length of terms in Repeater.");
                }
            }
            if (n != 0) {
                for (n3 = 0; n3 < 4; ++n3) {
                    if (termArray[n3].getOperator() != Term.Operator.SLASH) continue;
                    termArray[n3] = this.stripSlash(termArray[n3]);
                }
            }
            return termArray;
        }

        private Term<?> stripSlash(Term<?> term) {
            if (term.getOperator() == Term.Operator.SLASH) {
                if (term instanceof TermLength) {
                    return tf.createLength((Float)term.getValue(), ((TermLength)term).getUnit());
                }
                if (term instanceof TermPercent) {
                    return tf.createPercent((Float)term.getValue());
                }
                return term;
            }
            return term;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BorderWidthRepeater
    extends Repeater {
        public BorderWidthRepeater() {
            super(4);
            this.type = CSSProperty.BorderWidth.class;
            this.names.add("border-top-width");
            this.names.add("border-right-width");
            this.names.add("border-bottom-width");
            this.names.add("border-left-width");
        }

        @Override
        protected boolean operation(int n, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            return DeclarationTransformer.this.genericTermIdent(this.type, (Term)this.terms.get(n), true, (String)this.names.get(n), map) || DeclarationTransformer.this.genericTermLength((Term)this.terms.get(n), (String)this.names.get(n), CSSProperty.BorderWidth.length, true, map, map2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BorderColorRepeater
    extends Repeater {
        public BorderColorRepeater() {
            super(4);
            this.type = CSSProperty.BorderColor.class;
            this.names.add("border-top-color");
            this.names.add("border-right-color");
            this.names.add("border-bottom-color");
            this.names.add("border-left-color");
        }

        @Override
        protected boolean operation(int n, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            return DeclarationTransformer.this.genericTermIdent(this.type, (Term)this.terms.get(n), true, (String)this.names.get(n), map) || DeclarationTransformer.this.genericTerm(TermColor.class, (Term)this.terms.get(n), (String)this.names.get(n), CSSProperty.BorderColor.color, false, map, map2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BorderStyleRepeater
    extends Repeater {
        public BorderStyleRepeater() {
            super(4);
            this.type = CSSProperty.BorderStyle.class;
            this.names.add("border-top-style");
            this.names.add("border-right-style");
            this.names.add("border-bottom-style");
            this.names.add("border-left-style");
        }

        @Override
        protected boolean operation(int n, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            return DeclarationTransformer.this.genericTermIdent(CSSProperty.BorderStyle.class, (Term)this.terms.get(n), true, (String)this.names.get(n), map);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BorderVariator
    extends Variator {
        public static final int WIDTH = 0;
        public static final int STYLE = 1;
        public static final int COLOR = 2;
        private List<Repeater> repeaters;

        public BorderVariator() {
            super(3);
            this.types.add(CSSProperty.BorderWidth.class);
            this.types.add(CSSProperty.BorderStyle.class);
            this.types.add(CSSProperty.BorderColor.class);
            this.repeaters = new ArrayList<Repeater>(this.variants);
            this.repeaters.add(new BorderWidthRepeater());
            this.repeaters.add(new BorderStyleRepeater());
            this.repeaters.add(new BorderColorRepeater());
        }

        @Override
        protected boolean variant(int n, Variator.IntegerRef integerRef, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            int n2 = integerRef.get();
            Term term = (Term)this.terms.get(n2);
            switch (n) {
                case 0: {
                    Repeater repeater = this.repeaters.get(0);
                    repeater.assignTerms(term, term, term, term);
                    return repeater.repeat(map, map2);
                }
                case 1: {
                    Repeater repeater = this.repeaters.get(1);
                    repeater.assignTerms(term, term, term, term);
                    return repeater.repeat(map, map2);
                }
                case 2: {
                    Repeater repeater = this.repeaters.get(2);
                    repeater.assignTerms(term, term, term, term);
                    return repeater.repeat(map, map2);
                }
            }
            return false;
        }

        @Override
        protected boolean checkInherit(int n, Term<?> term, Map<String, CSSProperty> map) {
            if (!(term instanceof TermIdent) || !"INHERIT".equalsIgnoreCase((String)((TermIdent)term).getValue())) {
                return false;
            }
            if (n == -1) {
                for (int i = 0; i < this.variants; ++i) {
                    Repeater repeater = this.repeaters.get(i);
                    repeater.assignTerms(term, term, term, term);
                    repeater.repeat(map, null);
                }
                return true;
            }
            Repeater repeater = this.repeaters.get(n);
            repeater.assignTerms(term, term, term, term);
            repeater.repeat(map, null);
            return true;
        }

        @Override
        public void assignDefaults(Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            for (Repeater repeater : this.repeaters) {
                repeater.assignDefaults(map, map2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BackgroundVariator
    extends Variator {
        public static final int COLOR = 0;
        public static final int IMAGE = 1;
        public static final int REPEAT = 2;
        public static final int ATTACHEMENT = 3;
        public static final int POSITION = 4;

        public BackgroundVariator() {
            super(5);
            this.names.add("background-color");
            this.types.add(CSSProperty.BackgroundColor.class);
            this.names.add("background-image");
            this.types.add(CSSProperty.BackgroundImage.class);
            this.names.add("background-repeat");
            this.types.add(CSSProperty.BackgroundRepeat.class);
            this.names.add("background-attachement");
            this.types.add(CSSProperty.BackgroundAttachment.class);
            this.names.add("background-position");
            this.types.add(CSSProperty.BackgroundPosition.class);
        }

        @Override
        protected boolean variant(int n, Variator.IntegerRef integerRef, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            switch (n) {
                case 0: {
                    int n2;
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(0), (Term)this.terms.get(n2), true, (String)this.names.get(0), map) || DeclarationTransformer.this.genericTermColor((Term)this.terms.get(n2), (String)this.names.get(0), CSSProperty.BackgroundColor.color, map, map2);
                }
                case 1: {
                    int n2;
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(1), (Term)this.terms.get(n2), true, (String)this.names.get(1), map) || DeclarationTransformer.this.genericTerm(TermURI.class, (Term)this.terms.get(n2), (String)this.names.get(1), CSSProperty.BackgroundImage.uri, false, map, map2);
                }
                case 2: {
                    int n2;
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(2), (Term)this.terms.get(n2), true, (String)this.names.get(2), map);
                }
                case 3: {
                    int n2;
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(3), (Term)this.terms.get(n2), true, (String)this.names.get(3), map);
                }
                case 4: {
                    Term<List<Term<?>>> term;
                    int n2;
                    EnumSet<CSSProperty.BackgroundPosition> enumSet = EnumSet.complementOf(EnumSet.of(CSSProperty.BackgroundPosition.list_values, CSSProperty.BackgroundPosition.INHERIT));
                    CSSProperty.BackgroundPosition backgroundPosition = null;
                    Term[] termArray = new Term[]{null, null};
                    for (n2 = integerRef.get(); n2 <= n2 + 1 && n2 < this.terms.size(); ++n2) {
                        term = (Term)this.terms.get(n2);
                        if (term instanceof TermIdent) {
                            backgroundPosition = DeclarationTransformer.this.genericPropertyRaw(CSSProperty.BackgroundPosition.class, enumSet, (TermIdent)term);
                            if (backgroundPosition == null) continue;
                            this.storeBackgroundPosition(termArray, backgroundPosition, term);
                            continue;
                        }
                        if (term instanceof TermPercent) {
                            this.storeBackgroundPosition(termArray, null, term);
                            continue;
                        }
                        if (!(term instanceof TermLength)) continue;
                        this.storeBackgroundPosition(termArray, null, term);
                    }
                    term = tf.createList(2);
                    for (int i = 0; i < 2; ++i) {
                        if (termArray[i] == null) {
                            term.add((TermPercent)tf.createPercent(Float.valueOf(50.0f)));
                            continue;
                        }
                        term.add((Term)termArray[i]);
                    }
                    if (term.isEmpty()) {
                        return false;
                    }
                    if (term.size() == 1) {
                        term.add(1, term.get(0));
                    } else if (term.size() == 2) {
                        integerRef.inc();
                    }
                    map.put((String)this.names.get(4), CSSProperty.BackgroundPosition.list_values);
                    map2.put((String)this.names.get(4), term);
                    return true;
                }
            }
            return false;
        }

        private void storeBackgroundPosition(Term<?>[] termArray, CSSProperty.BackgroundPosition backgroundPosition, Term<?> term) {
            if (backgroundPosition == CSSProperty.BackgroundPosition.LEFT) {
                this.setPositionValue(termArray, 0, tf.createPercent(Float.valueOf(0.0f)));
            } else if (backgroundPosition == CSSProperty.BackgroundPosition.RIGHT) {
                this.setPositionValue(termArray, 0, tf.createPercent(Float.valueOf(100.0f)));
            } else if (backgroundPosition == CSSProperty.BackgroundPosition.TOP) {
                this.setPositionValue(termArray, 1, tf.createPercent(Float.valueOf(0.0f)));
            } else if (backgroundPosition == CSSProperty.BackgroundPosition.BOTTOM) {
                this.setPositionValue(termArray, 1, tf.createPercent(Float.valueOf(100.0f)));
            } else if (backgroundPosition == CSSProperty.BackgroundPosition.CENTER) {
                this.setPositionValue(termArray, -1, tf.createPercent(Float.valueOf(50.0f)));
            } else {
                this.setPositionValue(termArray, -1, term);
            }
        }

        private void setPositionValue(Term<?>[] termArray, int n, Term<?> term) {
            switch (n) {
                case -1: {
                    if (termArray[0] == null) {
                        termArray[0] = term;
                        break;
                    }
                    termArray[1] = term;
                    break;
                }
                case 0: {
                    if (termArray[0] != null) {
                        termArray[1] = termArray[0];
                    }
                    termArray[0] = term;
                    break;
                }
                case 1: {
                    if (termArray[1] != null) {
                        termArray[0] = termArray[1];
                    }
                    termArray[1] = term;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FontVariator
    extends Variator {
        public static final int STYLE = 0;
        public static final int VARIANT = 1;
        public static final int WEIGHT = 2;
        public static final int SIZE = 3;
        public static final int LINE_HEIGHT = 4;
        public static final int FAMILY = 5;

        public FontVariator() {
            super(6);
            this.names.add("font-style");
            this.types.add(CSSProperty.FontStyle.class);
            this.names.add("font-variant");
            this.types.add(CSSProperty.FontVariant.class);
            this.names.add("font-weight");
            this.types.add(CSSProperty.FontWeight.class);
            this.names.add("font-size");
            this.types.add(CSSProperty.FontSize.class);
            this.names.add("line-height");
            this.types.add(CSSProperty.LineHeight.class);
            this.names.add("font-family");
            this.types.add(CSSProperty.FontFamily.class);
        }

        @Override
        protected boolean variant(int n, Variator.IntegerRef integerRef, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            int n2 = integerRef.get();
            switch (n) {
                case 0: {
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(0), (Term)this.terms.get(n2), true, (String)this.names.get(0), map);
                }
                case 1: {
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(1), (Term)this.terms.get(n2), true, (String)this.names.get(1), map);
                }
                case 2: {
                    Integer[] integerArray = new Integer[]{100, 200, 300, 400, 500, 600, 700, 800, 900};
                    Term term = (Term)this.terms.get(n2);
                    if (term instanceof TermIdent) {
                        return DeclarationTransformer.this.genericProperty((Class)this.types.get(2), (TermIdent)term, true, map, (String)this.names.get(2));
                    }
                    if (term instanceof TermInteger) {
                        Integer n3;
                        int n4;
                        Integer n5 = ((TermInteger)term).getIntValue();
                        Integer[] integerArray2 = integerArray;
                        int n6 = integerArray2.length;
                        for (int i = 0; i < n6 && (n4 = n5.compareTo(n3 = integerArray2[i])) >= 0; ++i) {
                            if (n4 != 0) continue;
                            Object t = CSSProperty.Translator.valueOf((Class)this.types.get(2), "numeric_" + n5);
                            if (t == null) {
                                log.warn("Not found numeric values for FontWeight: numeric_ " + n5);
                                return false;
                            }
                            map.put((String)this.names.get(2), (CSSProperty)t);
                            return true;
                        }
                    }
                    return false;
                }
                case 3: {
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(3), (Term)this.terms.get(n2), true, (String)this.names.get(3), map) || DeclarationTransformer.this.genericTermLength((Term)this.terms.get(n2), (String)this.names.get(3), CSSProperty.FontSize.length, true, map, map2) || DeclarationTransformer.this.genericTerm(TermPercent.class, (Term)this.terms.get(n2), (String)this.names.get(3), CSSProperty.FontSize.percentage, true, map, map2);
                }
                case 4: {
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(4), (Term)this.terms.get(n2), true, (String)this.names.get(4), map) || DeclarationTransformer.this.genericTerm(TermNumber.class, (Term)this.terms.get(n2), (String)this.names.get(4), CSSProperty.LineHeight.number, true, map, map2) || DeclarationTransformer.this.genericTerm(TermInteger.class, (Term)this.terms.get(n2), (String)this.names.get(4), CSSProperty.LineHeight.number, true, map, map2) || DeclarationTransformer.this.genericTerm(TermPercent.class, (Term)this.terms.get(n2), (String)this.names.get(4), CSSProperty.LineHeight.percentage, true, map, map2) || DeclarationTransformer.this.genericTerm(TermLength.class, (Term)this.terms.get(n2), (String)this.names.get(4), CSSProperty.LineHeight.length, true, map, map2);
                }
                case 5: {
                    TermList termList = tf.createList();
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = false;
                    for (Term term : this.terms.subList(n2, this.terms.size())) {
                        if (term instanceof TermIdent && stringBuffer.length() == 0) {
                            stringBuffer.append(term.getValue());
                            bl = false;
                            continue;
                        }
                        if (term instanceof TermIdent && stringBuffer.length() != 0 && term.getOperator() != Term.Operator.COMMA) {
                            stringBuffer.append(" ").append(term.getValue());
                            bl = true;
                            continue;
                        }
                        if (term instanceof TermString || term instanceof TermIdent && term.getOperator() == Term.Operator.COMMA) {
                            this.storeFamilyName(termList, stringBuffer.toString(), bl);
                            stringBuffer = new StringBuffer();
                            bl = false;
                            if (term instanceof TermString) {
                                this.storeFamilyName(termList, (String)term.getValue(), true);
                                continue;
                            }
                            stringBuffer.append(term.getValue());
                            continue;
                        }
                        return false;
                    }
                    this.storeFamilyName(termList, stringBuffer.toString(), bl);
                    if (termList.isEmpty()) {
                        return false;
                    }
                    if (termList.size() == 1 && !(termList.toArray(new Term[0])[0] instanceof TermString)) {
                        map.put((String)this.names.get(5), (CSSProperty.FontFamily)termList.toArray(new Term[0])[0].getValue());
                        return true;
                    }
                    map.put((String)this.names.get(5), CSSProperty.FontFamily.list_values);
                    map2.put((String)this.names.get(5), termList);
                    integerRef.set(this.terms.size());
                    return true;
                }
            }
            return false;
        }

        @Override
        protected boolean variantCondition(int n, Variator.IntegerRef integerRef) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    return integerRef.get() < 3;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    if (!this.variantPassed[3]) {
                        return false;
                    }
                    return ((Term)this.terms.get(integerRef.get())).getOperator() == Term.Operator.SLASH;
                }
                case 5: {
                    return this.variantPassed[3];
                }
            }
            return false;
        }

        @Override
        public boolean vary(Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            if (this.terms.size() == 1 && this.terms.get(0) instanceof TermIdent) {
                if (this.checkInherit(-1, (Term)this.terms.get(0), map)) {
                    return true;
                }
                return DeclarationTransformer.this.genericTermIdent(CSSProperty.Font.class, (Term)this.terms.get(0), true, "font", map);
            }
            return super.vary(map, map2);
        }

        private void storeFamilyName(TermList termList, String string, boolean bl) {
            EnumSet<CSSProperty.FontFamily> enumSet = EnumSet.complementOf(EnumSet.of(CSSProperty.FontFamily.INHERIT, CSSProperty.FontFamily.list_values));
            if (string == null || "".equals(string) || string.length() == 0) {
                return;
            }
            string = string.trim();
            if (bl) {
                TermString termString = tf.createString(string);
                if (!termList.isEmpty()) {
                    termString.setOperator(Term.Operator.COMMA);
                }
                termList.add(termString);
            } else {
                CSSProperty.FontFamily fontFamily = DeclarationTransformer.this.genericPropertyRaw(CSSProperty.FontFamily.class, enumSet, tf.createIdent(string));
                if (fontFamily != null) {
                    Term<CSSProperty.FontFamily> term = tf.createTerm(fontFamily);
                    if (!termList.isEmpty()) {
                        term.setOperator(Term.Operator.COMMA);
                    }
                    termList.add(term);
                } else {
                    TermString termString = tf.createString(string);
                    if (!termList.isEmpty()) {
                        termString.setOperator(Term.Operator.COMMA);
                    }
                    termList.add(termString);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class OutlineVariator
    extends Variator {
        public static final int COLOR = 0;
        public static final int STYLE = 1;
        public static final int WIDTH = 2;

        public OutlineVariator() {
            super(3);
            this.names.add("outline-color");
            this.types.add(CSSProperty.OutlineColor.class);
            this.names.add("outline-style");
            this.types.add(CSSProperty.OutlineStyle.class);
            this.names.add("outline-width");
            this.types.add(CSSProperty.OutlineWidth.class);
        }

        @Override
        protected boolean variant(int n, Variator.IntegerRef integerRef, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            int n2 = integerRef.get();
            switch (n) {
                case 0: {
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(0), (Term)this.terms.get(n2), true, (String)this.names.get(0), map) || DeclarationTransformer.this.genericTermColor((Term)this.terms.get(n2), (String)this.names.get(0), CSSProperty.OutlineColor.color, map, map2);
                }
                case 1: {
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(1), (Term)this.terms.get(n2), true, (String)this.names.get(1), map);
                }
                case 2: {
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(2), (Term)this.terms.get(n2), true, (String)this.names.get(2), map) || DeclarationTransformer.this.genericTermLength((Term)this.terms.get(n2), (String)this.names.get(2), CSSProperty.OutlineWidth.length, true, map, map2);
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BorderSideVariator
    extends Variator {
        public static final int COLOR = 0;
        public static final int STYLE = 1;
        public static final int WIDTH = 2;

        public BorderSideVariator(String string) {
            super(3);
            this.names.add("border-" + string + "-color");
            this.types.add(CSSProperty.BorderColor.class);
            this.names.add("border-" + string + "-style");
            this.types.add(CSSProperty.BorderStyle.class);
            this.names.add("border-" + string + "-width");
            this.types.add(CSSProperty.BorderWidth.class);
        }

        @Override
        protected boolean variant(int n, Variator.IntegerRef integerRef, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            int n2 = integerRef.get();
            switch (n) {
                case 0: {
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(0), (Term)this.terms.get(n2), true, (String)this.names.get(0), map) || DeclarationTransformer.this.genericTermColor((Term)this.terms.get(n2), (String)this.names.get(0), CSSProperty.BorderColor.color, map, map2);
                }
                case 1: {
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(1), (Term)this.terms.get(n2), true, (String)this.names.get(1), map);
                }
                case 2: {
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(2), (Term)this.terms.get(n2), true, (String)this.names.get(2), map) || DeclarationTransformer.this.genericTermLength((Term)this.terms.get(n2), (String)this.names.get(2), CSSProperty.BorderWidth.length, true, map, map2);
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ListStyleVariator
    extends Variator {
        public static final int TYPE = 0;
        public static final int POSITION = 1;
        public static final int IMAGE = 2;

        public ListStyleVariator() {
            super(3);
            this.names.add("list-style-type");
            this.types.add(CSSProperty.ListStyleType.class);
            this.names.add("list-style-position");
            this.types.add(CSSProperty.ListStylePosition.class);
            this.names.add("list-style-image");
            this.types.add(CSSProperty.ListStyleImage.class);
        }

        @Override
        protected boolean variant(int n, Variator.IntegerRef integerRef, Map<String, CSSProperty> map, Map<String, Term<?>> map2) {
            int n2 = integerRef.get();
            switch (n) {
                case 0: {
                    return DeclarationTransformer.this.genericTermIdent(CSSProperty.ListStyleType.class, (Term)this.terms.get(n2), true, (String)this.names.get(0), map);
                }
                case 1: {
                    return DeclarationTransformer.this.genericTermIdent(CSSProperty.ListStylePosition.class, (Term)this.terms.get(n2), true, (String)this.names.get(1), map);
                }
                case 2: {
                    return DeclarationTransformer.this.genericTermIdent((Class)this.types.get(2), (Term)this.terms.get(n2), true, (String)this.names.get(2), map) || DeclarationTransformer.this.genericTerm(TermURI.class, (Term)this.terms.get(n2), (String)this.names.get(2), CSSProperty.ListStyleImage.uri, false, map, map2);
                }
            }
            return false;
        }
    }
}

