/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.PrettyOutput;
import cz.vutbr.web.css.Rule;
import cz.vutbr.web.css.RuleMedia;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.ElementUtil;
import cz.vutbr.web.domassign.AssignedDeclaration;
import cz.vutbr.web.domassign.DeclarationMap;
import cz.vutbr.web.domassign.StyleMap;
import cz.vutbr.web.domassign.Traversal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.TreeWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer {
    private static final Logger log = LoggerFactory.getLogger(Analyzer.class);
    protected static final String UNIVERSAL_HOLDER = "all";
    protected Map<String, Holder> rules = Collections.synchronizedMap(new HashMap());

    public Analyzer(StyleSheet styleSheet) {
        this.classifyRules(styleSheet);
    }

    public Analyzer(List<StyleSheet> list) {
        for (StyleSheet styleSheet : list) {
            this.classifyRules(styleSheet);
        }
    }

    public StyleMap evaluateDOM(Document document, String string, final boolean bl) {
        DeclarationMap declarationMap = this.assingDeclarationsToDOM(document, string, bl);
        StyleMap styleMap = new StyleMap(declarationMap.size());
        Traversal<StyleMap> traversal = new Traversal<StyleMap>(document, (Object)declarationMap, 1){

            @Override
            protected void processNode(StyleMap styleMap, Node node, Object object) {
                List list;
                NodeData nodeData = CSSFactory.createNodeData();
                if (node instanceof Element && ((Element)node).getAttribute("id").equals("mojo")) {
                    System.out.println("jo!");
                }
                if ((list = (List)((DeclarationMap)object).get((Element)node, null)) != null) {
                    for (Object object2 : list) {
                        nodeData.push((Declaration)object2);
                    }
                    if (bl) {
                        nodeData.inheritFrom((NodeData)styleMap.get((Element)this.walker.parentNode(), null));
                    }
                }
                styleMap.put((Element)node, null, nodeData.concretize());
                for (Object object2 : ((DeclarationMap)object).pseudoSet((Element)node)) {
                    NodeData nodeData2 = CSSFactory.createNodeData();
                    list = (List)((DeclarationMap)object).get((Element)node, object2);
                    if (list != null) {
                        for (Declaration declaration : list) {
                            nodeData2.push(declaration);
                        }
                        nodeData2.inheritFrom(nodeData);
                    }
                    styleMap.put((Element)node, object2, nodeData2.concretize());
                }
            }
        };
        traversal.levelTraversal(styleMap);
        return styleMap;
    }

    protected DeclarationMap assingDeclarationsToDOM(Document document, String string, boolean bl) {
        Holder holder = UNIVERSAL_HOLDER.equals(string) ? this.rules.get(UNIVERSAL_HOLDER) : Holder.union(this.rules.get(UNIVERSAL_HOLDER), this.rules.get(string));
        if (log.isTraceEnabled()) {
            log.trace("For media \"{}\" constructed holder:\n {}", (Object)string, (Object)holder);
        }
        DeclarationMap declarationMap = new DeclarationMap();
        if (holder != null && !holder.isEmpty()) {
            Traversal<DeclarationMap> traversal = new Traversal<DeclarationMap>(document, (Object)holder, 1){

                @Override
                protected void processNode(DeclarationMap declarationMap, Node node, Object object) {
                    Analyzer.this.assignDeclarationsToElement(declarationMap, this.walker, (Element)node, (Holder)object);
                }
            };
            if (!bl) {
                traversal.listTraversal(declarationMap);
            } else {
                traversal.levelTraversal(declarationMap);
            }
        }
        return declarationMap;
    }

    protected void assignDeclarationsToElement(DeclarationMap declarationMap, TreeWalker treeWalker, Element element, Holder holder) {
        List<RuleSet> list;
        List<RuleSet> list2;
        if (log.isDebugEnabled()) {
            log.debug("Traversal of {} {}.", (Object)element.getNodeName(), (Object)element.getNodeValue());
        }
        HashSet<RuleSet> hashSet = new HashSet<RuleSet>();
        for (String object2 : ElementUtil.elementClasses(element)) {
            list2 = holder.get(HolderItem.CLASS, object2.toLowerCase());
            if (list2 == null) continue;
            hashSet.addAll(list2);
        }
        log.trace("After CLASSes {} total candidates.", (Object)hashSet.size());
        String string = ElementUtil.elementID(element);
        if (string != null && string.length() != 0 && (list = holder.get(HolderItem.ID, string.toLowerCase())) != null) {
            hashSet.addAll(list);
        }
        log.trace("After IDs {} total candidates.", (Object)hashSet.size());
        String string2 = ElementUtil.elementName(element);
        if (string2 != null && (list2 = holder.get(HolderItem.ELEMENT, string2.toLowerCase())) != null) {
            hashSet.addAll(list2);
        }
        log.trace("After ELEMENTs {} total candidates.", (Object)hashSet.size());
        hashSet.addAll(holder.get(HolderItem.OTHER, null));
        list2 = new ArrayList<RuleSet>(hashSet);
        Collections.sort(list2);
        log.debug("Totally {} candidates.", (Object)hashSet.size());
        log.trace("With values: {}", (Object)list2);
        ArrayList<AssignedDeclaration> arrayList = new ArrayList<AssignedDeclaration>();
        HashSet<Selector.PseudoDeclaration> hashSet2 = new HashSet<Selector.PseudoDeclaration>();
        for (RuleSet ruleSet : list2) {
            StyleSheet styleSheet = ruleSet.getStyleSheet();
            StyleSheet.Origin origin = styleSheet == null ? StyleSheet.Origin.AGENT : styleSheet.getOrigin();
            for (CombinedSelector combinedSelector : ruleSet.getSelectors()) {
                if (!this.matchSelector(combinedSelector, element, treeWalker)) {
                    log.trace("CombinedSelector \"{}\" NOT matched!", (Object)combinedSelector);
                    continue;
                }
                log.trace("CombinedSelector \"{}\" matched", (Object)combinedSelector);
                Selector.PseudoDeclaration pseudoDeclaration = combinedSelector.getPseudoElement();
                CombinedSelector.Specificity specificity = combinedSelector.computeSpecificity();
                if (pseudoDeclaration == null) {
                    for (Declaration declaration : ruleSet) {
                        arrayList.add(new AssignedDeclaration(declaration, specificity, origin));
                    }
                    continue;
                }
                hashSet2.add(pseudoDeclaration);
                for (Declaration declaration : ruleSet) {
                    declarationMap.addDeclaration(element, pseudoDeclaration, new AssignedDeclaration(declaration, specificity, origin));
                }
            }
        }
        Collections.sort(arrayList);
        log.debug("Sorted {} declarations.", (Object)arrayList.size());
        log.trace("With values: {}", (Object)arrayList);
        for (Selector.PseudoDeclaration pseudoDeclaration : hashSet2) {
            declarationMap.sortDeclarations(element, pseudoDeclaration);
        }
        declarationMap.put(element, null, arrayList);
    }

    protected boolean matchSelector(CombinedSelector combinedSelector, Element element, TreeWalker treeWalker) {
        Node node = treeWalker.getCurrentNode();
        boolean bl = false;
        Selector.Combinator combinator = null;
        for (int i = combinedSelector.size() - 1; i >= 0; --i) {
            Element element2;
            Selector selector = (Selector)combinedSelector.get(i);
            if (combinator == null) {
                bl = selector.matches(element);
            } else if (combinator == Selector.Combinator.ADJACENT) {
                element2 = (Element)treeWalker.previousSibling();
                bl = false;
                if (element2 != null) {
                    bl = selector.matches(element2);
                }
            } else if (combinator == Selector.Combinator.PRECEDING) {
                bl = false;
                while (!bl && (element2 = (Element)treeWalker.previousSibling()) != null) {
                    bl = selector.matches(element2);
                }
            } else if (combinator == Selector.Combinator.DESCENDANT) {
                bl = false;
                while (!bl && (element2 = (Element)treeWalker.parentNode()) != null) {
                    bl = selector.matches(element2);
                }
            } else if (combinator == Selector.Combinator.CHILD) {
                element2 = (Element)treeWalker.parentNode();
                bl = false;
                if (element2 != null) {
                    bl = selector.matches(element2);
                }
            }
            combinator = selector.getCombinator();
            if (!bl) break;
        }
        treeWalker.setCurrentNode(node);
        return bl;
    }

    private void classifyRules(StyleSheet styleSheet) {
        Holder holder = this.rules.get(UNIVERSAL_HOLDER);
        if (holder == null) {
            holder = new Holder();
            this.rules.put(UNIVERSAL_HOLDER, holder);
        }
        for (Rule object : styleSheet) {
            PrettyOutput prettyOutput;
            if (object instanceof RuleSet) {
                prettyOutput = (RuleSet)object;
                for (CombinedSelector combinedSelector : prettyOutput.getSelectors()) {
                    this.insertClassified(holder, this.classifySelector(combinedSelector), (RuleSet)prettyOutput);
                }
            }
            if (!(object instanceof RuleMedia)) continue;
            prettyOutput = (RuleMedia)object;
            Iterator<CombinedSelector> iterator = prettyOutput.iterator();
            while (iterator.hasNext()) {
                RuleSet ruleSet = (RuleSet)((Object)iterator.next());
                for (CombinedSelector combinedSelector : ruleSet.getSelectors()) {
                    List<HolderSelector> list = this.classifySelector(combinedSelector);
                    if (prettyOutput.getMedia() == null || prettyOutput.getMedia().isEmpty()) {
                        this.insertClassified(this.rules.get(UNIVERSAL_HOLDER), list, ruleSet);
                        continue;
                    }
                    for (String string : prettyOutput.getMedia()) {
                        Holder holder2 = this.rules.get(string);
                        if (holder2 == null) {
                            holder2 = new Holder();
                            this.rules.put(string, holder2);
                        }
                        this.insertClassified(holder2, list, ruleSet);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Contains rules for {} medias.", (Object)this.rules.size());
            for (String string : this.rules.keySet()) {
                log.debug("For media \"{}\" it is {}", (Object)string, (Object)this.rules.get(string).contentCount());
                if (!log.isTraceEnabled()) continue;
                log.trace("Detailed view: \n{}", (Object)this.rules.get(string));
            }
        }
    }

    private List<HolderSelector> classifySelector(CombinedSelector combinedSelector) {
        ArrayList<HolderSelector> arrayList = new ArrayList<HolderSelector>();
        try {
            String string;
            String string2;
            Selector selector = combinedSelector.getLastSelector();
            String string3 = selector.getElementName();
            if (string3 != null) {
                if ("*".equals(string3)) {
                    arrayList.add(new HolderSelector(HolderItem.OTHER, null));
                } else {
                    arrayList.add(new HolderSelector(HolderItem.ELEMENT, string3.toLowerCase()));
                }
            }
            if ((string2 = selector.getClassName()) != null) {
                arrayList.add(new HolderSelector(HolderItem.CLASS, string2.toLowerCase()));
            }
            if ((string = selector.getIDName()) != null) {
                arrayList.add(new HolderSelector(HolderItem.ID, string.toLowerCase()));
            }
            if (arrayList.size() == 0) {
                arrayList.add(new HolderSelector(HolderItem.OTHER, null));
            }
            return arrayList;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            log.error("CombinedSelector does not include any selector, this should not happen!");
            return Collections.emptyList();
        }
    }

    private void insertClassified(Holder holder, List<HolderSelector> list, RuleSet ruleSet) {
        for (HolderSelector holderSelector : list) {
            holder.insert(holderSelector.item, holderSelector.key, ruleSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Holder {
        private List<Map<String, List<RuleSet>>> items = new ArrayList<Map<String, List<RuleSet>>>(HolderItem.values().length - 1);
        private List<RuleSet> others;

        public Holder() {
            for (HolderItem holderItem : HolderItem.values()) {
                if (holderItem == HolderItem.OTHER) {
                    this.others = new ArrayList<RuleSet>();
                    continue;
                }
                this.items.add(new HashMap());
            }
        }

        public boolean isEmpty() {
            for (HolderItem holderItem : HolderItem.values()) {
                if (!(holderItem == HolderItem.OTHER ? !this.others.isEmpty() : !this.items.get(holderItem.type).isEmpty())) continue;
                return false;
            }
            return true;
        }

        public static Holder union(Holder holder, Holder holder2) {
            Holder holder3 = new Holder();
            if (holder == null) {
                holder = new Holder();
            }
            if (holder2 == null) {
                holder2 = new Holder();
            }
            for (HolderItem holderItem : HolderItem.values()) {
                if (holderItem == HolderItem.OTHER) {
                    holder3.others.addAll(holder.others);
                    holder3.others.addAll(holder2.others);
                    continue;
                }
                Map<String, List<RuleSet>> map = holder.items.get(holderItem.type);
                Map<String, List<RuleSet>> map2 = holder2.items.get(holderItem.type);
                Map<String, List<RuleSet>> map3 = holder3.items.get(holderItem.type);
                map3.putAll(map);
                for (String string : map2.keySet()) {
                    if (map3.containsKey(string)) {
                        map3.get(string).addAll((Collection<RuleSet>)map2.get(string));
                        continue;
                    }
                    map3.put(string, map2.get(string));
                }
            }
            return holder3;
        }

        public void insert(HolderItem holderItem, String string, RuleSet ruleSet) {
            if (holderItem == HolderItem.OTHER) {
                this.others.add(ruleSet);
                return;
            }
            Map<String, List<RuleSet>> map = this.items.get(holderItem.type);
            List<RuleSet> list = map.get(string);
            if (list == null) {
                list = new ArrayList<RuleSet>();
                map.put(string, list);
            }
            list.add(ruleSet);
        }

        public List<RuleSet> get(HolderItem holderItem, String string) {
            if (holderItem == HolderItem.OTHER) {
                return this.others;
            }
            return this.items.get(holderItem.type()).get(string);
        }

        public String contentCount() {
            StringBuilder stringBuilder = new StringBuilder();
            for (HolderItem holderItem : HolderItem.values()) {
                if (holderItem == HolderItem.OTHER) {
                    stringBuilder.append(holderItem.name()).append(": ").append(this.others.size()).append(" ");
                    continue;
                }
                stringBuilder.append(holderItem.name()).append(":").append(this.items.get(holderItem.type).size()).append(" ");
            }
            return stringBuilder.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (HolderItem holderItem : HolderItem.values()) {
                if (holderItem == HolderItem.OTHER) {
                    stringBuilder.append(holderItem.name()).append(" (").append(this.others.size()).append("): ").append(this.others).append("\n");
                    continue;
                }
                stringBuilder.append(holderItem.name()).append(" (").append(this.items.get(holderItem.type).size()).append("): ").append(this.items.get(holderItem.type)).append("\n");
            }
            return stringBuilder.toString();
        }
    }

    protected class HolderSelector {
        public HolderItem item;
        public String key;

        public HolderSelector(HolderItem holderItem, String string) {
            this.item = holderItem;
            this.key = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HolderItem {
        ELEMENT(0),
        ID(1),
        CLASS(2),
        OTHER(3);

        private int type;

        private HolderItem(int n2) {
            this.type = n2;
        }

        public int type() {
            return this.type;
        }
    }
}

