/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.RuleFontFace;
import cz.vutbr.web.css.RuleMargin;
import cz.vutbr.web.css.RuleMedia;
import cz.vutbr.web.css.RulePage;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.RuleViewport;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.csskit.PriorityStrategy;
import cz.vutbr.web.csskit.antlr.Preparator;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePreparator
implements Preparator {
    protected static final Logger log = LoggerFactory.getLogger(SimplePreparator.class);
    private static RuleFactory rf = CSSFactory.getRuleFactory();
    private PriorityStrategy ps;
    private Element elem;
    private boolean inlinePriority;

    public SimplePreparator(PriorityStrategy priorityStrategy, Element element, boolean bl) {
        this.ps = priorityStrategy;
        this.elem = element;
        this.inlinePriority = bl;
    }

    @Override
    public RuleBlock<?> prepareRuleSet(List<CombinedSelector> list, List<Declaration> list2, boolean bl, List<String> list3) {
        if ((list == null || list.isEmpty()) && (list2 == null || list2.isEmpty())) {
            log.debug("Empty RuleSet was ommited");
            return null;
        }
        RuleBlock.Priority priority = this.ps.getAndIncrement();
        RuleSet ruleSet = rf.createSet(priority);
        ruleSet.setSelectors(list);
        ruleSet.replaceAll(list2);
        log.info("Created RuleSet as {}th with:\n{}", (Object)priority, (Object)ruleSet);
        if (bl) {
            priority = ruleSet.getPriority();
            ruleSet.setPriority(this.ps.getAndIncrement());
            RuleMedia ruleMedia = rf.createMedia(priority);
            log.debug("Wrapping RuleSet {} into RuleMedia: {}", (Object)ruleSet, (Object)list3);
            ruleMedia.unlock();
            ruleMedia.add(ruleSet);
            ruleMedia.setMedia(list3);
            return ruleMedia;
        }
        return ruleSet;
    }

    @Override
    public RuleBlock<?> prepareRuleMedia(RuleBlock.Priority priority, List<RuleSet> list, List<String> list2) {
        if (list == null || list.isEmpty()) {
            log.debug("Empty RuleMedia was ommited");
            return null;
        }
        RuleMedia ruleMedia = rf.createMedia(priority);
        ruleMedia.replaceAll(list);
        if (list2 != null && !list2.isEmpty()) {
            ruleMedia.setMedia(list2);
        }
        log.info("Create @media as {}th with:\n{}", (Object)priority, (Object)ruleMedia);
        return ruleMedia;
    }

    @Override
    public RuleBlock<?> prepareRulePage(List<Declaration> list, List<RuleMargin> list2, String string, String string2) {
        if ((list == null || list.isEmpty()) && (list2 == null || list2.isEmpty())) {
            log.debug("Empty RulePage was ommited");
            return null;
        }
        RuleBlock.Priority priority = this.ps.getAndIncrement();
        RulePage rulePage = rf.createPage(priority);
        if (list != null) {
            for (Declaration rule : list) {
                rulePage.add(rule);
            }
        }
        if (list2 != null) {
            for (RuleMargin ruleMargin : list2) {
                rulePage.add(ruleMargin);
            }
        }
        rulePage.setName(string);
        rulePage.setPseudo(string2);
        log.info("Create @page as {}th with:\n{}", (Object)priority, (Object)rulePage);
        return rulePage;
    }

    @Override
    public RuleMargin prepareRuleMargin(String string, List<Declaration> list) {
        if (list == null || list.isEmpty()) {
            log.debug("Empty RuleMargin was ommited");
            return null;
        }
        RuleBlock.Priority priority = this.ps.getAndIncrement();
        RuleMargin ruleMargin = rf.createMargin(string, priority);
        ruleMargin.replaceAll(list);
        log.info("Create @" + string + " as " + priority + "th with:\n" + ruleMargin);
        return ruleMargin;
    }

    @Override
    public RuleBlock<?> prepareRuleViewport(List<Declaration> list) {
        if (list == null || list.isEmpty()) {
            log.debug("Empty Viewport was ommited");
            return null;
        }
        RuleBlock.Priority priority = this.ps.getAndIncrement();
        RuleViewport ruleViewport = rf.createViewport(priority);
        ruleViewport.replaceAll(list);
        log.info("Create @viewport as {}th with:\n{}", (Object)priority, (Object)ruleViewport);
        return ruleViewport;
    }

    @Override
    public RuleBlock<?> prepareRuleFontFace(List<Declaration> list) {
        if (list == null || list.isEmpty()) {
            log.debug("Empty RuleFontFace was ommited");
            return null;
        }
        RuleBlock.Priority priority = this.ps.getAndIncrement();
        RuleFontFace ruleFontFace = rf.createFontFace(priority);
        ruleFontFace.replaceAll(list);
        log.info("Create @font-face as {}th with:\n{}", (Object)priority, (Object)ruleFontFace);
        return ruleFontFace;
    }

    @Override
    public RuleBlock.Priority markPriority() {
        return this.ps.markAndIncrement();
    }

    @Override
    public RuleBlock<?> prepareInlineRuleSet(List<Declaration> list, List<Selector.PseudoPage> list2) {
        if (list == null || list.isEmpty()) {
            log.debug("Empty RuleSet (inline) was ommited");
            return null;
        }
        CombinedSelector combinedSelector = (CombinedSelector)rf.createCombinedSelector().unlock();
        Selector selector = (Selector)rf.createSelector().unlock();
        selector.add(rf.createElementDOM(this.elem, this.inlinePriority));
        if (list2 != null) {
            selector.addAll(list2);
        }
        combinedSelector.add(selector);
        RuleBlock.Priority priority = this.ps.getAndIncrement();
        RuleSet ruleSet = rf.createSet(priority);
        ruleSet.replaceAll(list);
        ruleSet.setSelectors(Arrays.asList(combinedSelector));
        log.info("Create @media as {}th with:\n{}", (Object)priority, (Object)ruleSet);
        return ruleSet;
    }
}

