/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.PriorityStrategy;
import cz.vutbr.web.csskit.antlr.CSSInputStream;
import cz.vutbr.web.csskit.antlr.CSSLexer;
import cz.vutbr.web.csskit.antlr.CSSParser;
import cz.vutbr.web.csskit.antlr.CSSTreeParser;
import cz.vutbr.web.csskit.antlr.Preparator;
import cz.vutbr.web.csskit.antlr.SimplePreparator;
import cz.vutbr.web.csskit.antlr.TreeUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CSSParserFactory {
    private static final Logger log = LoggerFactory.getLogger(CSSParserFactory.class);
    private static RuleBlock.Priority lastPriority = null;

    private CSSParserFactory() {
        throw new AssertionError();
    }

    public static StyleSheet parse(Object object, String string, SourceType sourceType, Element element, boolean bl, URL uRL) throws IOException, CSSException {
        StyleSheet styleSheet = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        AtomicPriorityStrategy atomicPriorityStrategy = new AtomicPriorityStrategy(lastPriority);
        SimplePreparator simplePreparator = new SimplePreparator(atomicPriorityStrategy, element, bl);
        CSSTreeParser cSSTreeParser = CSSParserFactory.createParser(object, string, sourceType, simplePreparator, styleSheet, uRL);
        StyleSheet styleSheet2 = sourceType.parse(cSSTreeParser);
        lastPriority = styleSheet2.getLastMark();
        return styleSheet2;
    }

    public static StyleSheet parse(Object object, String string, SourceType sourceType, URL uRL) throws IOException, CSSException {
        if (sourceType == SourceType.INLINE) {
            throw new IllegalArgumentException("Missing element for INLINE input");
        }
        return CSSParserFactory.parse(object, string, sourceType, null, false, uRL);
    }

    public static StyleSheet append(Object object, String string, SourceType sourceType, Element element, boolean bl, StyleSheet styleSheet, URL uRL) throws IOException, CSSException {
        RuleBlock.Priority priority = styleSheet.getLastMark();
        if (priority == null) {
            priority = lastPriority;
        }
        AtomicPriorityStrategy atomicPriorityStrategy = new AtomicPriorityStrategy(priority);
        SimplePreparator simplePreparator = new SimplePreparator(atomicPriorityStrategy, element, bl);
        CSSTreeParser cSSTreeParser = CSSParserFactory.createParser(object, string, sourceType, simplePreparator, styleSheet, uRL);
        StyleSheet styleSheet2 = sourceType.parse(cSSTreeParser);
        lastPriority = styleSheet2.getLastMark();
        return styleSheet2;
    }

    public static StyleSheet append(Object object, String string, SourceType sourceType, StyleSheet styleSheet, URL uRL) throws IOException, CSSException {
        if (sourceType == SourceType.INLINE) {
            throw new IllegalArgumentException("Missing element for INLINE input");
        }
        return CSSParserFactory.append(object, string, sourceType, null, false, styleSheet, uRL);
    }

    public static void resetPriority() {
        lastPriority = null;
    }

    private static CSSTreeParser createParser(Object object, String string, SourceType sourceType, Preparator preparator, StyleSheet styleSheet, URL uRL) throws IOException, CSSException {
        CSSInputStream cSSInputStream = sourceType.getInput(object, string);
        cSSInputStream.setBase(uRL);
        CommonTokenStream commonTokenStream = CSSParserFactory.feedLexer(cSSInputStream, styleSheet);
        CommonTree commonTree = CSSParserFactory.feedParser(commonTokenStream, sourceType, styleSheet);
        return CSSParserFactory.feedAST(commonTokenStream, commonTree, preparator, styleSheet);
    }

    private static CommonTokenStream feedLexer(CSSInputStream cSSInputStream, StyleSheet styleSheet) throws CSSException {
        try {
            CSSLexer cSSLexer = new CSSLexer(cSSInputStream);
            cSSLexer.init(styleSheet);
            return new CommonTokenStream(cSSLexer);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof CSSException) {
                throw (CSSException)runtimeException.getCause();
            }
            log.error("LEXER THROWS:", runtimeException);
            throw runtimeException;
        }
    }

    private static CommonTree feedParser(CommonTokenStream commonTokenStream, SourceType sourceType, StyleSheet styleSheet) throws CSSException {
        CSSParser cSSParser = new CSSParser(commonTokenStream);
        cSSParser.init(styleSheet);
        return sourceType.getAST(cSSParser);
    }

    private static CSSTreeParser feedAST(CommonTokenStream commonTokenStream, CommonTree commonTree, Preparator preparator, StyleSheet styleSheet) {
        if (log.isTraceEnabled()) {
            log.trace("Feeding tree parser with AST:\n{}", (Object)TreeUtil.toStringTree(commonTree));
        }
        CommonTreeNodeStream commonTreeNodeStream = new CommonTreeNodeStream(commonTree);
        commonTreeNodeStream.setTokenStream(commonTokenStream);
        CSSTreeParser cSSTreeParser = new CSSTreeParser(commonTreeNodeStream);
        return cSSTreeParser.init(styleSheet, preparator);
    }

    private static final class PriorityImpl
    implements RuleBlock.Priority,
    Serializable {
        private static final long serialVersionUID = 1L;
        final int priority;

        public PriorityImpl(int n) {
            this.priority = n;
        }

        public int compareTo(RuleBlock.Priority priority) {
            PriorityImpl priorityImpl = (PriorityImpl)priority;
            return this.priority - priorityImpl.priority;
        }

        public String toString() {
            return String.valueOf(this.priority);
        }
    }

    private static final class SimplePriorityStrategy
    implements PriorityStrategy {
        private int counter;

        public SimplePriorityStrategy() {
            this.counter = 0;
        }

        public SimplePriorityStrategy(RuleBlock.Priority priority) {
            if (!(priority instanceof PriorityImpl)) {
                throw new ClassCastException("Unable to continue with priority class provided: " + priority.getClass());
            }
            this.counter = ((PriorityImpl)priority).priority;
        }

        public RuleBlock.Priority getAndIncrement() {
            return new PriorityImpl(this.counter++);
        }

        public RuleBlock.Priority markAndIncrement() {
            return new PriorityImpl(this.counter++);
        }
    }

    private static final class AtomicPriorityStrategy
    implements PriorityStrategy {
        private final AtomicInteger counter;

        public AtomicPriorityStrategy() {
            this.counter = new AtomicInteger(0);
        }

        public AtomicPriorityStrategy(RuleBlock.Priority priority) {
            if (priority == null) {
                this.counter = new AtomicInteger(0);
            } else {
                if (!(priority instanceof PriorityImpl)) {
                    throw new ClassCastException("Unable to continue with priority class provided: " + priority.getClass());
                }
                this.counter = new AtomicInteger(((PriorityImpl)priority).priority);
            }
        }

        public RuleBlock.Priority getAndIncrement() {
            return new PriorityImpl(this.counter.incrementAndGet());
        }

        public RuleBlock.Priority markAndIncrement() {
            return new PriorityImpl(this.counter.incrementAndGet());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceType {
        INLINE{

            public CommonTree getAST(CSSParser cSSParser) throws CSSException {
                try {
                    CSSParser.inlinestyle_return inlinestyle_return2 = cSSParser.inlinestyle();
                    return (CommonTree)inlinestyle_return2.getTree();
                }
                catch (RecognitionException recognitionException) {
                    throw SourceType.encapsulateException(recognitionException, "Unable to parse inline CSS style");
                }
                catch (RuntimeException runtimeException) {
                    throw SourceType.encapsulateException(runtimeException, "Unable to parse inline CSS style");
                }
            }

            public StyleSheet parse(CSSTreeParser cSSTreeParser) throws CSSException {
                try {
                    return cSSTreeParser.inlinestyle();
                }
                catch (RecognitionException recognitionException) {
                    throw SourceType.encapsulateException(recognitionException, "Unable to parse inline CSS style [AST]");
                }
                catch (RuntimeException runtimeException) {
                    throw SourceType.encapsulateException(runtimeException, "Unable to parse inline CSS style [AST]");
                }
            }

            public CSSInputStream getInput(Object object, String string) throws IOException {
                return CSSInputStream.stringStream((String)object);
            }
        }
        ,
        EMBEDDED{

            public CommonTree getAST(CSSParser cSSParser) throws CSSException {
                try {
                    CSSParser.stylesheet_return stylesheet_return2 = cSSParser.stylesheet();
                    return (CommonTree)stylesheet_return2.getTree();
                }
                catch (RecognitionException recognitionException) {
                    throw SourceType.encapsulateException(recognitionException, "Unable to parse embedded CSS style");
                }
                catch (RuntimeException runtimeException) {
                    throw SourceType.encapsulateException(runtimeException, "Unable to parse embedded CSS style");
                }
            }

            public StyleSheet parse(CSSTreeParser cSSTreeParser) throws CSSException {
                try {
                    return cSSTreeParser.stylesheet();
                }
                catch (RecognitionException recognitionException) {
                    throw SourceType.encapsulateException(recognitionException, "Unable to parse embedded CSS style [AST]");
                }
                catch (RuntimeException runtimeException) {
                    throw SourceType.encapsulateException(runtimeException, "Unable to parse embedded CSS style [AST]");
                }
            }

            public CSSInputStream getInput(Object object, String string) throws IOException {
                return CSSInputStream.stringStream((String)object);
            }
        }
        ,
        URL{

            public CommonTree getAST(CSSParser cSSParser) throws CSSException {
                try {
                    CSSParser.stylesheet_return stylesheet_return2 = cSSParser.stylesheet();
                    return (CommonTree)stylesheet_return2.getTree();
                }
                catch (RecognitionException recognitionException) {
                    throw SourceType.encapsulateException(recognitionException, "Unable to parse URL CSS style");
                }
                catch (RuntimeException runtimeException) {
                    throw SourceType.encapsulateException(runtimeException, "Unable to parse URL CSS style");
                }
            }

            public StyleSheet parse(CSSTreeParser cSSTreeParser) throws CSSException {
                try {
                    return cSSTreeParser.stylesheet();
                }
                catch (RecognitionException recognitionException) {
                    throw SourceType.encapsulateException(recognitionException, "Unable to parse file CSS style [AST]");
                }
                catch (RuntimeException runtimeException) {
                    throw SourceType.encapsulateException(runtimeException, "Unable to parse file CSS style [AST]");
                }
            }

            public CSSInputStream getInput(Object object, String string) throws IOException {
                return CSSInputStream.urlStream((URL)object, string);
            }
        };


        public abstract CSSInputStream getInput(Object var1, String var2) throws IOException;

        public abstract CommonTree getAST(CSSParser var1) throws CSSException;

        public abstract StyleSheet parse(CSSTreeParser var1) throws CSSException;

        private static CSSException encapsulateException(Throwable throwable, String string) {
            log.error("THROWN:", throwable);
            return new CSSException(string, throwable);
        }
    }
}

