/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;

public class CSSInputStream
implements CharStream {
    private CharStream input;
    private String rawData;
    private URL base = null;
    private URL url;
    private InputStream source = null;
    private String encoding;

    public static CSSInputStream stringStream(String string) throws IOException {
        CSSInputStream cSSInputStream = new CSSInputStream();
        cSSInputStream.rawData = string;
        cSSInputStream.encoding = Charset.defaultCharset().name();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(string.getBytes()), cSSInputStream.encoding));
        cSSInputStream.input = new ANTLRReaderStream(bufferedReader);
        return cSSInputStream;
    }

    public static CSSInputStream urlStream(URL uRL, String string) throws IOException {
        CSSInputStream cSSInputStream = new CSSInputStream();
        cSSInputStream.base = uRL;
        cSSInputStream.encoding = string != null ? string : Charset.defaultCharset().name();
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = "gzip".equalsIgnoreCase(uRLConnection.getContentEncoding()) ? new GZIPInputStream(uRLConnection.getInputStream()) : uRLConnection.getInputStream();
        cSSInputStream.input = new ANTLRInputStream(inputStream, cSSInputStream.encoding);
        cSSInputStream.source = inputStream;
        cSSInputStream.url = uRL;
        return cSSInputStream;
    }

    private CSSInputStream() {
    }

    public int LT(int n) {
        return this.input.LT(n);
    }

    public int getCharPositionInLine() {
        return this.input.getCharPositionInLine();
    }

    public int getLine() {
        return this.input.getLine();
    }

    public void setCharPositionInLine(int n) {
        this.input.setCharPositionInLine(n);
    }

    public void setLine(int n) {
        this.input.setLine(n);
    }

    public String substring(int n, int n2) {
        return this.input.substring(n, n2);
    }

    public int LA(int n) {
        return this.input.LA(n);
    }

    public void consume() {
        this.input.consume();
    }

    public int index() {
        return this.input.index();
    }

    public int mark() {
        return this.input.mark();
    }

    public void release(int n) {
        this.input.release(n);
    }

    public void rewind() {
        this.input.rewind();
    }

    public void rewind(int n) {
        this.input.rewind(n);
    }

    public void seek(int n) {
        this.input.seek(n);
    }

    public int size() {
        return this.input.size();
    }

    public String getSourceName() {
        return this.base != null ? this.base.toString() : "";
    }

    public URL getBase() {
        return this.base;
    }

    public void setBase(URL uRL) {
        this.base = uRL;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) throws IOException {
        if (this.source != null) {
            String string2 = this.encoding;
            if (string2 == null) {
                string2 = Charset.defaultCharset().name();
            }
            if (!string2.equalsIgnoreCase(string)) {
                this.source.close();
                this.encoding = string;
                CSSInputStream cSSInputStream = CSSInputStream.urlStream(this.url, this.encoding);
                this.input = cSSInputStream.input;
            }
        }
    }

    public String getRawData() {
        return this.rawData;
    }
}

