/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermAngle;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermExpression;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.css.TermFrequency;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermLength;
import cz.vutbr.web.css.TermList;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermNumeric;
import cz.vutbr.web.css.TermPair;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.css.TermString;
import cz.vutbr.web.css.TermTime;
import cz.vutbr.web.css.TermURI;
import cz.vutbr.web.csskit.TermAngleImpl;
import cz.vutbr.web.csskit.TermColorImpl;
import cz.vutbr.web.csskit.TermExpressionImpl;
import cz.vutbr.web.csskit.TermFrequencyImpl;
import cz.vutbr.web.csskit.TermFunctionImpl;
import cz.vutbr.web.csskit.TermIdentImpl;
import cz.vutbr.web.csskit.TermImpl;
import cz.vutbr.web.csskit.TermIntegerImpl;
import cz.vutbr.web.csskit.TermLengthImpl;
import cz.vutbr.web.csskit.TermListImpl;
import cz.vutbr.web.csskit.TermNumberImpl;
import cz.vutbr.web.csskit.TermPairImpl;
import cz.vutbr.web.csskit.TermPercentImpl;
import cz.vutbr.web.csskit.TermStringImpl;
import cz.vutbr.web.csskit.TermTimeImpl;
import cz.vutbr.web.csskit.TermURIImpl;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermFactoryImpl
implements TermFactory {
    private static final TermFactory instance = new TermFactoryImpl();

    public static final TermFactory getInstance() {
        return instance;
    }

    private TermFactoryImpl() {
    }

    @Override
    public TermAngle createAngle(Float f) {
        return (TermAngle)new TermAngleImpl().setValue(f);
    }

    @Override
    public TermAngle createAngle(String string, TermNumeric.Unit unit, int n) {
        return (TermAngle)new TermAngleImpl().setUnit(unit).setValue(this.convertFloat(string, unit.value(), n));
    }

    @Override
    public TermColor createColor(TermIdent termIdent) {
        return TermColorImpl.getColorByIdent(termIdent);
    }

    @Override
    public TermColor createColor(String string) {
        return TermColorImpl.getColorByHash(string);
    }

    @Override
    public TermColor createColor(int n, int n2, int n3) {
        return new TermColorImpl(n, n2, n3);
    }

    public TermColor createColor(int n, int n2, int n3, int n4) {
        return new TermColorImpl(n, n2, n3, n4);
    }

    @Override
    public TermColor createColor(TermFunction termFunction) {
        return TermColorImpl.getColorByFunction(termFunction);
    }

    @Override
    public TermFrequency createFrequency(Float f) {
        return new TermFrequencyImpl().setValue(f);
    }

    @Override
    public TermFrequency createFrequency(String string, TermNumeric.Unit unit, int n) {
        return (TermFrequency)new TermFrequencyImpl().setUnit(unit).setValue(this.convertFloat(string, unit.value(), n));
    }

    @Override
    public TermExpression createExpression(String string) {
        return new TermExpressionImpl().setValue(string);
    }

    @Override
    public TermFunction createFunction() {
        return new TermFunctionImpl();
    }

    @Override
    public TermIdent createIdent(String string) {
        return (TermIdent)new TermIdentImpl().setValue(string);
    }

    @Override
    public TermIdent createIdent(String string, boolean bl) {
        if (!bl) {
            return (TermIdent)new TermIdentImpl().setValue(string);
        }
        return (TermIdent)new TermIdentImpl().setValue("-" + string);
    }

    @Override
    public TermInteger createInteger(Integer n) {
        return new TermIntegerImpl().setValue(n);
    }

    @Override
    public TermInteger createInteger(String string, int n) {
        return new TermIntegerImpl().setValue(this.convertInteger(string, null, n));
    }

    @Override
    public TermLength createLength(Float f) {
        return (TermLength)new TermLengthImpl().setValue(f);
    }

    @Override
    public TermLength createLength(Float f, TermNumeric.Unit unit) {
        return (TermLength)new TermLengthImpl().setUnit(unit).setValue(f);
    }

    @Override
    public TermLength createLength(String string, TermNumeric.Unit unit, int n) {
        return (TermLength)new TermLengthImpl().setUnit(unit).setValue(this.convertFloat(string, unit.value(), n));
    }

    @Override
    public TermList createList() {
        return new TermListImpl();
    }

    @Override
    public TermList createList(int n) {
        return new TermListImpl(n);
    }

    @Override
    public TermNumber createNumber(Float f) {
        return (TermNumber)new TermNumberImpl().setValue(f);
    }

    @Override
    public TermNumber createNumber(String string, int n) {
        return (TermNumber)new TermNumberImpl().setValue(this.convertFloat(string, null, n));
    }

    @Override
    public TermNumeric<?> createNumeric(String string, int n) {
        try {
            return this.createInteger(string, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.createNumber(string, n);
        }
    }

    @Override
    public TermNumeric<Float> createDimension(String string, int n) {
        for (TermNumeric.Unit unit : TermNumeric.Unit.values()) {
            if (!string.matches("^[0-9]*\\.?[0-9]+" + unit.value() + "$")) continue;
            Float f = this.convertFloat(string, unit.value(), n);
            if (unit.isAngle()) {
                return (TermNumeric)new TermAngleImpl().setUnit(unit).setValue(f);
            }
            if (unit.isFrequency()) {
                return (TermNumeric)new TermFrequencyImpl().setUnit(unit).setValue(f);
            }
            if (unit.isLength()) {
                return (TermNumeric)new TermLengthImpl().setUnit(unit).setValue(f);
            }
            if (!unit.isTime()) continue;
            return (TermNumeric)new TermTimeImpl().setUnit(unit).setValue(f);
        }
        return null;
    }

    @Override
    public <K, V> TermPair<K, V> createPair(K k, V v) {
        return (TermPair)new TermPairImpl().setKey(k).setValue(v);
    }

    @Override
    public TermPercent createPercent(Float f) {
        return (TermPercent)new TermPercentImpl().setValue(f);
    }

    @Override
    public TermPercent createPercent(String string, int n) {
        return (TermPercent)new TermPercentImpl().setValue(this.convertFloat(string, "%", n));
    }

    @Override
    public TermString createString(String string) {
        return new TermStringImpl().setValue(string);
    }

    @Override
    public <V> Term<V> createTerm(V v) {
        return new TermImpl<V>().setValue(v);
    }

    @Override
    public TermTime createTime(Float f) {
        return new TermTimeImpl().setValue(f);
    }

    @Override
    public TermTime createTime(String string, TermNumeric.Unit unit, int n) {
        return (TermTime)new TermTimeImpl().setUnit(unit).setValue(this.convertFloat(string, unit.value(), n));
    }

    @Override
    public TermURI createURI(String string) {
        return new TermURIImpl().setValue(string);
    }

    @Override
    public TermURI createURI(String string, URL uRL) {
        return new TermURIImpl().setValue(string).setBase(uRL);
    }

    protected Float convertFloat(String string, String string2, int n) throws IllegalArgumentException {
        try {
            string = string.trim().toLowerCase();
            if (string2 != null) {
                string = string.replaceAll(string2 + "$", "");
            }
            return Float.valueOf(Float.parseFloat(string) * (float)n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid number format " + string, numberFormatException);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Invalid null format");
        }
    }

    protected Integer convertInteger(String string, String string2, int n) throws IllegalArgumentException {
        try {
            string = string.trim().toLowerCase();
            if (string2 != null) {
                string = string.replaceAll(string2 + "$", "");
            }
            return Integer.valueOf(string) * n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid number format " + string, numberFormatException);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Invalid null format");
        }
    }
}

