/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.Term;
import cz.vutbr.web.css.TermColor;
import cz.vutbr.web.css.TermFunction;
import cz.vutbr.web.css.TermIdent;
import cz.vutbr.web.css.TermInteger;
import cz.vutbr.web.css.TermNumber;
import cz.vutbr.web.css.TermPercent;
import cz.vutbr.web.csskit.ColorCard;
import cz.vutbr.web.csskit.TermImpl;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermColorImpl
extends TermImpl<Color>
implements TermColor {
    protected static final String COLOR_RGB_NAME = "rgb";
    protected static final String COLOR_RGBA_NAME = "rgba";
    protected static final String COLOR_HSL_NAME = "hsl";
    protected static final String COLOR_HSLA_NAME = "hsla";
    protected static final int COLOR_PARAMS_COUNT = 3;
    protected static final int MAX_VALUE = 255;
    protected static final int MIN_VALUE = 0;
    protected static final int PERCENT_CONVERSION = 100;
    protected static final int MAX_HUE = 360;

    protected TermColorImpl(int n, int n2, int n3) {
        this.value = new Color(n, n2, n3);
    }

    protected TermColorImpl(int n, int n2, int n3, int n4) {
        this.value = new Color(n, n2, n3, n4);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.operator != null) {
            stringBuilder.append(this.operator.value());
        }
        if (((Color)this.value).getAlpha() == 255) {
            String string = Integer.toHexString(((Color)this.value).getRGB() & 0xFFFFFF);
            if (string.length() < 6) {
                string = "000000".substring(0, 6 - string.length()) + string;
            }
            stringBuilder.append("#").append(string);
        } else {
            stringBuilder.append("rgba(");
            stringBuilder.append(((Color)this.value).getRed());
            stringBuilder.append(',');
            stringBuilder.append(((Color)this.value).getGreen());
            stringBuilder.append(',');
            stringBuilder.append(((Color)this.value).getBlue());
            stringBuilder.append(',');
            stringBuilder.append((double)Math.round((double)((Color)this.value).getAlpha() / 2.55) / 100.0);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static TermColor getColorByIdent(TermIdent termIdent) {
        return ColorCard.getTermColor((String)termIdent.getValue());
    }

    public static TermColor getColorByHash(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid hash value (null) for color construction");
        }
        if ((string = string.toLowerCase().replaceAll("^#", "")).matches("^[0-9a-f]{3}$")) {
            String string2 = string.substring(0, 1);
            String string3 = string.substring(1, 2);
            String string4 = string.substring(2, 3);
            return new TermColorImpl(Integer.parseInt(string2 + string2, 16), Integer.parseInt(string3 + string3, 16), Integer.parseInt(string4 + string4, 16));
        }
        if (string.matches("^[0-9a-f]{6}$")) {
            String string5 = string.substring(0, 2);
            String string6 = string.substring(2, 4);
            String string7 = string.substring(4, 6);
            return new TermColorImpl(Integer.parseInt(string5, 16), Integer.parseInt(string6, 16), Integer.parseInt(string7, 16));
        }
        return null;
    }

    public static TermColor getColorByFunction(TermFunction termFunction) {
        if (COLOR_RGB_NAME.equals(termFunction.getFunctionName()) && termFunction.size() == 3 || COLOR_RGBA_NAME.equals(termFunction.getFunctionName()) && termFunction.size() == 4) {
            Term term;
            int n;
            int[] nArray = new int[3];
            for (n = 0; n < 3; ++n) {
                term = (Term)termFunction.get(n);
                if (term instanceof TermInteger) {
                    nArray[n] = ((TermInteger)term).getIntValue();
                    continue;
                }
                if (term instanceof TermPercent) {
                    int n2 = ((Float)((TermPercent)term).getValue()).intValue();
                    nArray[n] = n2 * 255 / 100;
                    continue;
                }
                return null;
            }
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] < 0) {
                    nArray[n] = 0;
                }
                if (nArray[n] <= 255) continue;
                nArray[n] = 255;
            }
            n = 255;
            if (termFunction.size() > 3) {
                term = (Term)termFunction.get(3);
                if (term instanceof TermNumber || term instanceof TermInteger) {
                    float f = TermColorImpl.getFloatValue(term);
                    n = Math.round(f * 255.0f);
                    if (n < 0) {
                        n = 0;
                    }
                    if (n > 255) {
                        n = 255;
                    }
                } else {
                    return null;
                }
            }
            return new TermColorImpl(nArray[0], nArray[1], nArray[2], n);
        }
        if (COLOR_HSL_NAME.equals(termFunction.getFunctionName()) && termFunction.size() == 3 || COLOR_HSLA_NAME.equals(termFunction.getFunctionName()) && termFunction.size() == 4) {
            int n;
            int n3;
            float f;
            Term term = (Term)termFunction.get(0);
            if (term instanceof TermNumber || term instanceof TermInteger) {
                for (f = TermColorImpl.getFloatValue(term); f >= 360.0f; f -= 360.0f) {
                }
                while (f < 0.0f) {
                    f += 360.0f;
                }
                f /= 360.0f;
            } else {
                return null;
            }
            Term term2 = (Term)termFunction.get(1);
            if (term2 instanceof TermPercent) {
                n3 = ((Float)((TermPercent)term2).getValue()).intValue();
                if (n3 > 100) {
                    n3 = 100;
                } else if (n3 < 0) {
                    n3 = 0;
                }
            } else {
                return null;
            }
            float f2 = (float)n3 / 100.0f;
            Term term3 = (Term)termFunction.get(2);
            if (term3 instanceof TermPercent) {
                n = ((Float)((TermPercent)term3).getValue()).intValue();
                if (n > 100) {
                    n = 100;
                } else if (n < 0) {
                    n = 0;
                }
            } else {
                return null;
            }
            float f3 = (float)n / 100.0f;
            int[] nArray = TermColorImpl.hslToRgb(f, f2, f3);
            int n4 = 255;
            if (termFunction.size() > 3) {
                Term term4 = (Term)termFunction.get(3);
                if (term4 instanceof TermNumber || term4 instanceof TermInteger) {
                    float f4 = TermColorImpl.getFloatValue(term4);
                    n4 = Math.round(f4 * 255.0f);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n4 > 255) {
                        n4 = 255;
                    }
                } else {
                    return null;
                }
            }
            return new TermColorImpl(nArray[0], nArray[1], nArray[2], n4);
        }
        return null;
    }

    private static float getFloatValue(Term<?> term) {
        if (term instanceof TermNumber) {
            return ((Float)((TermNumber)term).getValue()).floatValue();
        }
        if (term instanceof TermInteger) {
            return ((Float)((TermInteger)term).getValue()).floatValue();
        }
        return 0.0f;
    }

    private static int[] hslToRgb(float f, float f2, float f3) {
        int[] nArray = new int[3];
        float f4 = f3 <= 0.5f ? f3 * (f2 + 1.0f) : f3 + f2 - f3 * f2;
        float f5 = f3 * 2.0f - f4;
        nArray[0] = Math.round(TermColorImpl.hueToRgb(f5, f4, f + 0.33333334f) * 255.0f);
        nArray[1] = Math.round(TermColorImpl.hueToRgb(f5, f4, f) * 255.0f);
        nArray[2] = Math.round(TermColorImpl.hueToRgb(f5, f4, f - 0.33333334f) * 255.0f);
        return nArray;
    }

    private static float hueToRgb(float f, float f2, float f3) {
        if (f3 < 0.0f) {
            f3 += 1.0f;
        }
        if (f3 > 1.0f) {
            f3 -= 1.0f;
        }
        if (f3 * 6.0f < 1.0f) {
            return f + (f2 - f) * f3 * 6.0f;
        }
        if (f3 * 2.0f < 1.0f) {
            return f2;
        }
        if (f3 * 3.0f < 2.0f) {
            return f + (f2 - f) * (0.6666667f - f3) * 6.0f;
        }
        return f;
    }
}

