/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.csskit.AbstractRule;
import cz.vutbr.web.csskit.ElementUtil;
import cz.vutbr.web.csskit.OutputUtil;
import java.io.Serializable;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorImpl
extends AbstractRule<Selector.SelectorPart>
implements Selector {
    private static final long serialVersionUID = 1L;
    protected Selector.Combinator combinator;

    @Override
    public Selector.Combinator getCombinator() {
        return this.combinator;
    }

    @Override
    public Selector setCombinator(Selector.Combinator combinator) {
        this.combinator = combinator;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.combinator != null) {
            stringBuilder.append(this.combinator.value());
        }
        stringBuilder = OutputUtil.appendList(stringBuilder, this.list, "");
        return stringBuilder.toString();
    }

    @Override
    public String getClassName() {
        String string = null;
        for (Selector.SelectorPart selectorPart : this.list) {
            if (!(selectorPart instanceof Selector.ElementClass)) continue;
            string = ((Selector.ElementClass)selectorPart).getClassName();
        }
        return string;
    }

    @Override
    public String getIDName() {
        String string = null;
        for (Selector.SelectorPart selectorPart : this.list) {
            if (!(selectorPart instanceof Selector.ElementID)) continue;
            string = ((Selector.ElementID)selectorPart).getID();
        }
        return string;
    }

    @Override
    public String getElementName() {
        String string = null;
        for (Selector.SelectorPart selectorPart : this.list) {
            if (!(selectorPart instanceof Selector.ElementName)) continue;
            string = ((Selector.ElementName)selectorPart).getName();
        }
        return string;
    }

    @Override
    public Selector.PseudoDeclaration getPseudoElement() {
        Selector.PseudoDeclaration pseudoDeclaration = null;
        for (Selector.SelectorPart selectorPart : this.list) {
            if (!(selectorPart instanceof Selector.PseudoPage)) continue;
            pseudoDeclaration = ((Selector.PseudoPage)selectorPart).getDeclaration();
            if (pseudoDeclaration.isPseudoElement()) break;
            pseudoDeclaration = null;
        }
        return pseudoDeclaration;
    }

    @Override
    public boolean matches(Element element) {
        for (Selector.SelectorPart selectorPart : this.list) {
            if (selectorPart != null && selectorPart.matches(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void computeSpecificity(CombinedSelector.Specificity specificity) {
        for (Selector.SelectorPart selectorPart : this.list) {
            selectorPart.computeSpecificity(specificity);
        }
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.combinator == null ? 0 : this.combinator.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof SelectorImpl)) {
            return false;
        }
        SelectorImpl selectorImpl = (SelectorImpl)object;
        return !(this.combinator == null ? selectorImpl.combinator != null : !this.combinator.equals((Object)selectorImpl.combinator));
    }

    public static class ElementDOMImpl
    implements Selector.ElementDOM,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Element elem;
        private boolean inlinePriority;

        protected ElementDOMImpl(Element element, boolean bl) {
            this.elem = element;
            this.inlinePriority = bl;
        }

        public Element getElement() {
            return this.elem;
        }

        public Selector.ElementDOM setElement(Element element) {
            this.elem = element;
            return this;
        }

        public void computeSpecificity(CombinedSelector.Specificity specificity) {
            if (this.inlinePriority) {
                specificity.add(CombinedSelector.Specificity.Level.A);
            }
        }

        public boolean matches(Element element) {
            return this.elem.equals(element);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.elem == null ? 0 : this.elem.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof ElementDOMImpl)) {
                return false;
            }
            ElementDOMImpl elementDOMImpl = (ElementDOMImpl)object;
            return !(this.elem == null ? elementDOMImpl.elem != null : !this.elem.equals(elementDOMImpl.elem));
        }
    }

    public static class ElementAttributeImpl
    implements Selector.ElementAttribute,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Selector.Operator operator;
        private String attribute;
        private String value;
        private boolean isStringValue;

        protected ElementAttributeImpl(String string, boolean bl, Selector.Operator operator, String string2) {
            this.isStringValue = bl;
            this.operator = operator;
            this.attribute = string2;
            this.setValue(string);
        }

        public Selector.Operator getOperator() {
            return this.operator;
        }

        public void setOperator(Selector.Operator operator) {
            this.operator = operator;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public Selector.ElementAttribute setAttribute(String string) {
            this.attribute = string;
            return this;
        }

        public void computeSpecificity(CombinedSelector.Specificity specificity) {
            specificity.add(CombinedSelector.Specificity.Level.C);
        }

        public boolean matches(Element element) {
            return ElementUtil.matchesAttribute(element, this.attribute, this.value, this.operator);
        }

        public String getValue() {
            return this.value;
        }

        public Selector.ElementAttribute setValue(String string) {
            this.value = string;
            return this;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[").append(this.attribute);
            stringBuilder.append(this.operator.value());
            if (this.isStringValue && this.value != null) {
                stringBuilder.append("'");
            }
            if (this.value != null) {
                stringBuilder.append(this.value);
            }
            if (this.isStringValue && this.value != null) {
                stringBuilder.append("'");
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.attribute == null ? 0 : this.attribute.hashCode());
            n = 31 * n + (this.isStringValue ? 1231 : 1237);
            n = 31 * n + (this.operator == null ? 0 : this.operator.hashCode());
            n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof ElementAttributeImpl)) {
                return false;
            }
            ElementAttributeImpl elementAttributeImpl = (ElementAttributeImpl)object;
            if (this.attribute == null ? elementAttributeImpl.attribute != null : !this.attribute.equals(elementAttributeImpl.attribute)) {
                return false;
            }
            if (this.isStringValue != elementAttributeImpl.isStringValue) {
                return false;
            }
            if (this.operator == null ? elementAttributeImpl.operator != null : !this.operator.equals((Object)elementAttributeImpl.operator)) {
                return false;
            }
            return !(this.value == null ? elementAttributeImpl.value != null : !this.value.equals(elementAttributeImpl.value));
        }
    }

    public static class ElementIDImpl
    implements Selector.ElementID,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String id;

        protected ElementIDImpl(String string) {
            this.setID(string);
        }

        public void computeSpecificity(CombinedSelector.Specificity specificity) {
            specificity.add(CombinedSelector.Specificity.Level.B);
        }

        public boolean matches(Element element) {
            return ElementUtil.matchesID(element, this.id);
        }

        public Selector.ElementID setID(String string) {
            if (string == null) {
                throw new IllegalArgumentException("Invalid element ID (null)");
            }
            this.id = string;
            return this;
        }

        public String getID() {
            return this.id;
        }

        public String toString() {
            return "#" + this.id;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.id == null ? 0 : this.id.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof ElementIDImpl)) {
                return false;
            }
            ElementIDImpl elementIDImpl = (ElementIDImpl)object;
            return !(this.id == null ? elementIDImpl.id != null : !this.id.equals(elementIDImpl.id));
        }
    }

    public static class PseudoPageImpl
    implements Selector.PseudoPage,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static HashMap<String, Selector.PseudoDeclaration> PSEUDO_DECLARATIONS = new HashMap(22);
        private String functionName;
        private String value;
        private Selector.PseudoDeclaration declaration;
        private int[] elementIndex;

        protected PseudoPageImpl(String string, String string2) {
            this.setValue(string);
            this.setFunctionName(string2);
        }

        public Selector.PseudoDeclaration getDeclaration() {
            return this.declaration;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public Selector.PseudoPage setFunctionName(String string) {
            this.functionName = string;
            this.inferDeclaration();
            this.decodeValue();
            return this;
        }

        public void computeSpecificity(CombinedSelector.Specificity specificity) {
            if (this.declaration != null) {
                if (this.declaration.isPseudoElement()) {
                    specificity.add(CombinedSelector.Specificity.Level.D);
                } else {
                    specificity.add(CombinedSelector.Specificity.Level.C);
                }
            }
        }

        public boolean matches(Element element) {
            if (this.declaration != null) {
                switch (this.declaration) {
                    case FIRST_CHILD: 
                    case LAST_CHILD: 
                    case ONLY_CHILD: {
                        if (element.getParentNode().getNodeType() == 1) {
                            Node node;
                            boolean bl = false;
                            boolean bl2 = false;
                            if (this.declaration != Selector.PseudoDeclaration.LAST_CHILD) {
                                node = element;
                                do {
                                    if ((node = node.getPreviousSibling()) != null) continue;
                                    bl = true;
                                    break;
                                } while (node.getNodeType() != 1);
                            }
                            if (this.declaration != Selector.PseudoDeclaration.FIRST_CHILD) {
                                node = element;
                                do {
                                    if ((node = node.getNextSibling()) != null) continue;
                                    bl2 = true;
                                    break;
                                } while (node.getNodeType() != 1);
                            }
                            switch (this.declaration) {
                                case FIRST_CHILD: {
                                    return bl;
                                }
                                case LAST_CHILD: {
                                    return bl2;
                                }
                            }
                            return bl && bl2;
                        }
                        return false;
                    }
                    case FIRST_OF_TYPE: 
                    case LAST_OF_TYPE: 
                    case ONLY_OF_TYPE: {
                        if (element.getParentNode().getNodeType() == 1) {
                            Node node;
                            boolean bl = false;
                            boolean bl3 = false;
                            if (this.declaration != Selector.PseudoDeclaration.LAST_OF_TYPE) {
                                node = element;
                                bl = true;
                                do {
                                    if ((node = node.getPreviousSibling()) == null || node.getNodeType() != 1 || !this.isSameElementType(element, (Element)node)) continue;
                                    bl = false;
                                } while (node != null && bl);
                            }
                            if (this.declaration != Selector.PseudoDeclaration.FIRST_OF_TYPE) {
                                node = element;
                                bl3 = true;
                                do {
                                    if ((node = node.getNextSibling()) == null || node.getNodeType() != 1 || !this.isSameElementType(element, (Element)node)) continue;
                                    bl3 = false;
                                } while (node != null && bl3);
                            }
                            switch (this.declaration) {
                                case FIRST_OF_TYPE: {
                                    return bl;
                                }
                                case LAST_OF_TYPE: {
                                    return bl3;
                                }
                            }
                            return bl && bl3;
                        }
                        return false;
                    }
                    case NTH_CHILD: {
                        return this.positionMatches(this.countSiblingsBefore(element, false) + 1, this.elementIndex);
                    }
                    case NTH_LAST_CHILD: {
                        return this.positionMatches(this.countSiblingsAfter(element, false) + 1, this.elementIndex);
                    }
                    case NTH_OF_TYPE: {
                        return this.positionMatches(this.countSiblingsBefore(element, true) + 1, this.elementIndex);
                    }
                    case NTH_LAST_OF_TYPE: {
                        return this.positionMatches(this.countSiblingsAfter(element, true) + 1, this.elementIndex);
                    }
                    case ROOT: {
                        return element.getParentNode().getNodeType() == 9;
                    }
                    case EMPTY: {
                        NodeList nodeList = element.getChildNodes();
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            short s = nodeList.item(i).getNodeType();
                            if (s != 1 && s != 3 && s != 4 && s != 5) continue;
                            return false;
                        }
                        return true;
                    }
                }
                if (this.declaration.isPseudoElement() || element.getTagName().equalsIgnoreCase("a") && this.declaration == Selector.PseudoDeclaration.LINK) {
                    return true;
                }
            }
            return false;
        }

        protected boolean positionMatches(int n, int[] nArray) {
            try {
                int n2 = n - nArray[1];
                if (nArray[0] == 0) {
                    return n2 == 0;
                }
                return n2 * nArray[0] >= 0 && n2 % nArray[0] == 0;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }

        protected int[] decodeIndex(String string) throws NumberFormatException {
            String string2 = string.toLowerCase().trim();
            if (string2.equals("odd")) {
                int[] nArray = new int[]{2, 1};
                return nArray;
            }
            if (string2.equals("even")) {
                int[] nArray = new int[]{2, 0};
                return nArray;
            }
            int[] nArray = new int[]{0, 0};
            int n = string2.indexOf(110);
            if (n != -1) {
                String string3 = string2.substring(0, n).trim();
                nArray[0] = string3.length() == 0 ? 1 : (string3.equals("-") ? -1 : Integer.parseInt(string3));
                ++n;
                StringBuilder stringBuilder = new StringBuilder();
                while (n < string2.length()) {
                    char c = string2.charAt(n);
                    if (c != '+' && !Character.isWhitespace(c)) {
                        stringBuilder.append(c);
                    }
                    ++n;
                }
                if (stringBuilder.length() > 0) {
                    nArray[1] = Integer.parseInt(stringBuilder.toString());
                }
            } else {
                nArray[1] = Integer.parseInt(string2);
            }
            return nArray;
        }

        protected int countSiblingsBefore(Element element, boolean bl) {
            int n = 0;
            Node node = element;
            do {
                if ((node = node.getPreviousSibling()) == null || node.getNodeType() != 1 || bl && !this.isSameElementType(element, (Element)node)) continue;
                ++n;
            } while (node != null);
            return n;
        }

        protected int countSiblingsAfter(Element element, boolean bl) {
            int n = 0;
            Node node = element;
            do {
                if ((node = node.getNextSibling()) == null || node.getNodeType() != 1 || bl && !this.isSameElementType(element, (Element)node)) continue;
                ++n;
            } while (node != null);
            return n;
        }

        protected boolean isSameElementType(Element element, Element element2) {
            return element.getNodeName().equalsIgnoreCase(element2.getNodeName());
        }

        public Selector.PseudoPage setValue(String string) {
            this.value = string;
            this.inferDeclaration();
            this.decodeValue();
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(":");
            if (this.functionName != null) {
                stringBuilder.append(this.functionName).append("(");
            }
            if (this.value != null) {
                stringBuilder.append(this.value);
            }
            if (this.functionName != null) {
                stringBuilder.append(")");
            }
            stringBuilder.append("");
            return stringBuilder.toString();
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.functionName == null ? 0 : this.functionName.hashCode());
            n = 31 * n + (this.value == null ? 0 : this.value.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof PseudoPageImpl)) {
                return false;
            }
            PseudoPageImpl pseudoPageImpl = (PseudoPageImpl)object;
            if (this.functionName == null ? pseudoPageImpl.functionName != null : !this.functionName.equals(pseudoPageImpl.functionName)) {
                return false;
            }
            return !(this.value == null ? pseudoPageImpl.value != null : !this.value.equals(pseudoPageImpl.value));
        }

        private void inferDeclaration() {
            this.declaration = this.functionName != null ? PSEUDO_DECLARATIONS.get(this.functionName.toLowerCase()) : (this.value != null ? PSEUDO_DECLARATIONS.get(this.value.toLowerCase()) : null);
        }

        private void decodeValue() {
            this.elementIndex = null;
            if (this.declaration == Selector.PseudoDeclaration.NTH_CHILD || this.declaration == Selector.PseudoDeclaration.NTH_LAST_CHILD || this.declaration == Selector.PseudoDeclaration.NTH_OF_TYPE || this.declaration == Selector.PseudoDeclaration.NTH_LAST_OF_TYPE) {
                try {
                    this.elementIndex = this.decodeIndex(this.value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        static {
            PSEUDO_DECLARATIONS.put("active", Selector.PseudoDeclaration.ACTIVE);
            PSEUDO_DECLARATIONS.put("focus", Selector.PseudoDeclaration.FOCUS);
            PSEUDO_DECLARATIONS.put("hover", Selector.PseudoDeclaration.HOVER);
            PSEUDO_DECLARATIONS.put("link", Selector.PseudoDeclaration.LINK);
            PSEUDO_DECLARATIONS.put("visited", Selector.PseudoDeclaration.VISITED);
            PSEUDO_DECLARATIONS.put("first-child", Selector.PseudoDeclaration.FIRST_CHILD);
            PSEUDO_DECLARATIONS.put("last-child", Selector.PseudoDeclaration.LAST_CHILD);
            PSEUDO_DECLARATIONS.put("only-child", Selector.PseudoDeclaration.ONLY_CHILD);
            PSEUDO_DECLARATIONS.put("only-of-type", Selector.PseudoDeclaration.ONLY_OF_TYPE);
            PSEUDO_DECLARATIONS.put("nth-child", Selector.PseudoDeclaration.NTH_CHILD);
            PSEUDO_DECLARATIONS.put("nth-last-child", Selector.PseudoDeclaration.NTH_LAST_CHILD);
            PSEUDO_DECLARATIONS.put("nth-of-type", Selector.PseudoDeclaration.NTH_OF_TYPE);
            PSEUDO_DECLARATIONS.put("nth-last-of-type", Selector.PseudoDeclaration.NTH_LAST_OF_TYPE);
            PSEUDO_DECLARATIONS.put("first-of-type", Selector.PseudoDeclaration.FIRST_OF_TYPE);
            PSEUDO_DECLARATIONS.put("last-of-type", Selector.PseudoDeclaration.LAST_OF_TYPE);
            PSEUDO_DECLARATIONS.put("root", Selector.PseudoDeclaration.ROOT);
            PSEUDO_DECLARATIONS.put("empty", Selector.PseudoDeclaration.EMPTY);
            PSEUDO_DECLARATIONS.put("lang", Selector.PseudoDeclaration.LANG);
            PSEUDO_DECLARATIONS.put("first-letter", Selector.PseudoDeclaration.FIRST_LETTER);
            PSEUDO_DECLARATIONS.put("first-line", Selector.PseudoDeclaration.FIRST_LINE);
            PSEUDO_DECLARATIONS.put("before", Selector.PseudoDeclaration.BEFORE);
            PSEUDO_DECLARATIONS.put("after", Selector.PseudoDeclaration.AFTER);
        }
    }

    public static class ElementClassImpl
    implements Selector.ElementClass,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String className;

        protected ElementClassImpl(String string) {
            this.setClassName(string);
        }

        public void computeSpecificity(CombinedSelector.Specificity specificity) {
            specificity.add(CombinedSelector.Specificity.Level.C);
        }

        public boolean matches(Element element) {
            return ElementUtil.matchesClass(element, this.className);
        }

        public String getClassName() {
            return this.className;
        }

        public Selector.ElementClass setClassName(String string) {
            if (string == null) {
                throw new IllegalArgumentException("Invalid element class (null)");
            }
            this.className = string;
            return this;
        }

        public String toString() {
            return "." + this.className;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.className == null ? 0 : this.className.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof ElementClassImpl)) {
                return false;
            }
            ElementClassImpl elementClassImpl = (ElementClassImpl)object;
            return !(this.className == null ? elementClassImpl.className != null : !this.className.equals(elementClassImpl.className));
        }
    }

    public static class ElementNameImpl
    implements Selector.ElementName,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String name;

        protected ElementNameImpl(String string) {
            this.setName(string);
        }

        public void computeSpecificity(CombinedSelector.Specificity specificity) {
            if (!"*".equals(this.name)) {
                specificity.add(CombinedSelector.Specificity.Level.D);
            }
        }

        public boolean matches(Element element) {
            if (this.name != null && "*".equals(this.name)) {
                return true;
            }
            return ElementUtil.matchesName(element, this.name);
        }

        public String getName() {
            return this.name;
        }

        public Selector.ElementName setName(String string) {
            if (string == null) {
                throw new IllegalArgumentException("Invalid element name (null)");
            }
            this.name = string;
            return this;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof ElementNameImpl)) {
                return false;
            }
            ElementNameImpl elementNameImpl = (ElementNameImpl)object;
            return !(this.name == null ? elementNameImpl.name != null : !this.name.equals(elementNameImpl.name));
        }
    }
}

