/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementUtil {
    public static final String CLASS_DELIM = " ";
    public static final String CLASS_ATTR = "class";
    public static final String ID_ATTR = "id";

    public static Collection<String> elementClasses(Element element) {
        if (element.hasAttribute(CLASS_ATTR)) {
            String string = element.getAttribute(CLASS_ATTR);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : string.toLowerCase().split(CLASS_DELIM)) {
                if ((string2 = string2.trim()).length() <= 0) continue;
                arrayList.add(string2);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    public static boolean matchesClass(Element element, String string) {
        if (element.hasAttribute(CLASS_ATTR)) {
            String string2 = element.getAttribute(CLASS_ATTR).toLowerCase();
            int n = string.length();
            int n2 = string2.indexOf(string.toLowerCase());
            if (n2 == -1) {
                return false;
            }
            return !(n2 != 0 && !Character.isWhitespace(string2.charAt(n2 - 1)) || n2 + n != string2.length() && !Character.isWhitespace(string2.charAt(n2 + n)));
        }
        return false;
    }

    public static String elementID(Element element) {
        String string = element.getAttribute(ID_ATTR);
        return string;
    }

    public static boolean matchesID(Element element, String string) {
        return string.equalsIgnoreCase(ElementUtil.elementID(element));
    }

    public static String elementName(Element element) {
        String string = element.getNodeName();
        return string;
    }

    public static boolean matchesName(Element element, String string) {
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(ElementUtil.elementName(element));
    }

    public static boolean matchesAttribute(Element element, String string, String string2, Selector.Operator operator) {
        Attr attr = element.getAttributeNode(string);
        if (attr != null && operator != null) {
            String string3 = attr.getNodeValue();
            switch (operator) {
                case EQUALS: {
                    return string3.equals(string2);
                }
                case INCLUDES: {
                    string3 = CLASS_DELIM + string3 + CLASS_DELIM;
                    return string3.matches(".* " + string2 + " .*");
                }
                case DASHMATCH: {
                    return string3.matches("^" + string2 + "(-.*|$)");
                }
                case CONTAINS: {
                    return string3.matches(".*" + string2 + ".*");
                }
                case STARTSWITH: {
                    return string3.matches("^" + string2 + ".*");
                }
                case ENDSWITH: {
                    return string3.matches(".*" + string2 + "$");
                }
            }
            return true;
        }
        return false;
    }
}

