/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.csskit.AbstractRule;
import cz.vutbr.web.csskit.OutputUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclarationImpl
extends AbstractRule<Term<?>>
implements Declaration {
    private static final long serialVersionUID = 1L;
    protected String property;
    protected boolean important;

    protected DeclarationImpl() {
        this.property = "";
        this.important = false;
    }

    protected DeclarationImpl(Declaration declaration) {
        this.property = declaration.getProperty();
        this.important = declaration.isImportant();
        this.replaceAll(declaration.asList());
    }

    public boolean isInherited(int n) {
        return false;
    }

    public int getInheritanceLevel() {
        return 0;
    }

    @Override
    public int compareTo(Declaration declaration) {
        if (this.isImportant() && !declaration.isImportant()) {
            return 1;
        }
        if (declaration.isImportant() && !this.isImportant()) {
            return -1;
        }
        return 0;
    }

    @Override
    public String getProperty() {
        return this.property;
    }

    @Override
    public void setProperty(String string) {
        this.property = string;
    }

    @Override
    public boolean isImportant() {
        return this.important;
    }

    @Override
    public void setImportant(boolean bl) {
        this.important = bl;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder = OutputUtil.appendTimes(stringBuilder, "\t", n);
        stringBuilder.append(this.property).append(": ");
        stringBuilder = OutputUtil.appendList(stringBuilder, this.list, "");
        if (this.important) {
            stringBuilder.append(" ").append("!important");
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.important ? 1231 : 1237);
        n = 31 * n + (this.property == null ? 0 : this.property.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof DeclarationImpl)) {
            return false;
        }
        DeclarationImpl declarationImpl = (DeclarationImpl)object;
        if (this.important != declarationImpl.important) {
            return false;
        }
        return !(this.property == null ? declarationImpl.property != null : !this.property.equals(declarationImpl.property));
    }
}

