/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.css;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.csskit.antlr.CSSParserFactory;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.DeclarationTransformer;
import cz.vutbr.web.domassign.StyleMap;
import cz.vutbr.web.domassign.Traversal;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CSSFactory {
    private static Logger log = LoggerFactory.getLogger(CSSFactory.class);
    private static final String DEFAULT_TERM_FACTORY = "cz.vutbr.web.csskit.TermFactoryImpl";
    private static final String DEFAULT_SUPPORTED_CSS = "cz.vutbr.web.domassign.SupportedCSS3";
    private static final String DEFAULT_RULE_FACTORY = "cz.vutbr.web.csskit.RuleFactoryImpl";
    private static final String DEFAULT_DECLARATION_TRANSFORMER = "cz.vutbr.web.domassign.DeclarationTransformer";
    private static final String DEFAULT_NODE_DATA_IMPL = "cz.vutbr.web.domassign.SingleMapNodeData";
    private static TermFactory tf;
    private static SupportedCSS css;
    private static RuleFactory rf;
    private static DeclarationTransformer dt;
    private static Class<? extends NodeData> ndImpl;
    private static boolean implyPixelLengths;

    public static final void setImplyPixelLength(boolean bl) {
        implyPixelLengths = bl;
    }

    public static final boolean getImplyPixelLength() {
        return implyPixelLengths;
    }

    public static final void registerTermFactory(TermFactory termFactory) {
        tf = termFactory;
    }

    public static final TermFactory getTermFactory() {
        if (tf == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_TERM_FACTORY);
                Method method = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerTermFactory((TermFactory)method.invoke(null, new Object[0]));
                log.debug("Retrived {} as default TermFactory implementation.", (Object)DEFAULT_TERM_FACTORY);
            }
            catch (Exception exception) {
                log.error("Unable to get TermFactory from default", exception);
                throw new RuntimeException("No TermFactory implementation registered!");
            }
        }
        return tf;
    }

    public static final void registerSupportedCSS(SupportedCSS supportedCSS) {
        css = supportedCSS;
    }

    public static final SupportedCSS getSupportedCSS() {
        if (css == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_SUPPORTED_CSS);
                Method method = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerSupportedCSS((SupportedCSS)method.invoke(null, new Object[0]));
                log.debug("Retrived {} as default SupportedCSS implementation.", (Object)DEFAULT_SUPPORTED_CSS);
            }
            catch (Exception exception) {
                log.error("Unable to get SupportedCSS from default", exception);
                throw new RuntimeException("No SupportedCSS implementation registered!");
            }
        }
        return css;
    }

    public static final void registerRuleFactory(RuleFactory ruleFactory) {
        rf = ruleFactory;
    }

    public static final RuleFactory getRuleFactory() {
        if (rf == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_RULE_FACTORY);
                Method method = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerRuleFactory((RuleFactory)method.invoke(null, new Object[0]));
                log.debug("Retrived {} as default RuleFactory implementation.", (Object)DEFAULT_RULE_FACTORY);
            }
            catch (Exception exception) {
                log.error("Unable to get RuleFactory from default", exception);
                throw new RuntimeException("No RuleFactory implementation registered!");
            }
        }
        return rf;
    }

    public static final void registerDeclarationTransformer(DeclarationTransformer declarationTransformer) {
        dt = declarationTransformer;
    }

    public static final DeclarationTransformer getDeclarationTransformer() {
        if (dt == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_DECLARATION_TRANSFORMER);
                Method method = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerDeclarationTransformer((DeclarationTransformer)method.invoke(null, new Object[0]));
                log.debug("Retrived {} as default DeclarationTransformer implementation.", (Object)DEFAULT_DECLARATION_TRANSFORMER);
            }
            catch (Exception exception) {
                log.error("Unable to get DeclarationTransformer from default", exception);
                throw new RuntimeException("No DeclarationTransformer implementation registered!");
            }
        }
        return dt;
    }

    public static final void registerNodeDataInstance(Class<? extends NodeData> clazz) {
        try {
            NodeData nodeData = clazz.newInstance();
            ndImpl = clazz;
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("NodeData implemenation (" + clazz.getName() + ") doesn't provide sole constructor", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("NodeData implementation (" + clazz.getName() + ") is not accesible", illegalAccessException);
        }
    }

    public static final NodeData createNodeData() {
        if (ndImpl == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_NODE_DATA_IMPL);
                CSSFactory.registerNodeDataInstance(clazz);
                log.debug("Registered {} as default NodeData instance.", (Object)DEFAULT_NODE_DATA_IMPL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return ndImpl.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("No NodeData implementation registered");
        }
    }

    public static final StyleSheet parse(URL uRL, String string) throws CSSException, IOException {
        return CSSParserFactory.parse(uRL, string, CSSParserFactory.SourceType.URL, uRL);
    }

    public static final StyleSheet parse(String string, String string2) throws CSSException, IOException {
        try {
            File file = new File(string);
            URL uRL = file.toURI().toURL();
            return CSSFactory.parse(uRL, string2);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = "Unable to construct URL from fileName: " + string;
            log.error(string3);
            throw new FileNotFoundException(string3);
        }
    }

    public static final StyleSheet parse(String string) throws IOException, CSSException {
        return CSSParserFactory.parse(string, null, CSSParserFactory.SourceType.EMBEDDED, null);
    }

    public static final StyleSheet getUsedStyles(Document document, URL uRL, String string) {
        return CSSFactory.getUsedStyles(document, null, uRL, string);
    }

    public static final StyleSheet getUsedStyles(Document document, String string, URL uRL, String string2) {
        Pair pair = new Pair(uRL, string2);
        CSSAssignTraversal cSSAssignTraversal = new CSSAssignTraversal(document, string, pair, 1);
        StyleSheet styleSheet = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        cSSAssignTraversal.listTraversal(styleSheet);
        return styleSheet;
    }

    public static final StyleMap assignDOM(Document document, URL uRL, String string, boolean bl) {
        return CSSFactory.assignDOM(document, null, uRL, string, bl);
    }

    public static final StyleMap assignDOM(Document document, String string, URL uRL, String string2, boolean bl) {
        Pair pair = new Pair(uRL, string2);
        CSSAssignTraversal cSSAssignTraversal = new CSSAssignTraversal(document, string, pair, 1);
        StyleSheet styleSheet = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        cSSAssignTraversal.listTraversal(styleSheet);
        Analyzer analyzer = new Analyzer(styleSheet);
        return analyzer.evaluateDOM(document, string2, bl);
    }

    static {
        implyPixelLengths = false;
    }

    private static final class Pair {
        public URL base;
        public String media;

        public Pair(URL uRL, String string) {
            this.base = uRL;
            this.media = string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CSSAssignTraversal
    extends Traversal<StyleSheet> {
        private String encoding;

        public CSSAssignTraversal(Document document, String string, Object object, int n) {
            super(document, object, n);
            this.encoding = string;
        }

        @Override
        protected void processNode(StyleSheet styleSheet, Node node, Object object) {
            URL uRL = ((Pair)object).base;
            String string = ((Pair)object).media;
            Element element = (Element)node;
            try {
                if (CSSAssignTraversal.isEmbeddedStyleSheet(element, string)) {
                    styleSheet = CSSParserFactory.append(CSSAssignTraversal.extractElementText(element), null, CSSParserFactory.SourceType.EMBEDDED, styleSheet, uRL);
                    log.debug("Matched embedded CSS style");
                } else if (CSSAssignTraversal.isLinkedStyleSheet(element, string)) {
                    URL uRL2 = DataURLHandler.createURL(uRL, element.getAttribute("href"));
                    styleSheet = CSSParserFactory.append(uRL2, this.encoding, CSSParserFactory.SourceType.URL, styleSheet, uRL2);
                    log.debug("Matched linked CSS style");
                } else {
                    if (element.getAttribute("style") != null && element.getAttribute("style").length() > 0) {
                        styleSheet = CSSParserFactory.append(element.getAttribute("style"), null, CSSParserFactory.SourceType.INLINE, element, true, styleSheet, uRL);
                        log.debug("Matched inline CSS style");
                    }
                    if (element.getAttribute("XDefaultStyle") != null && element.getAttribute("XDefaultStyle").length() > 0) {
                        styleSheet = CSSParserFactory.append(element.getAttribute("XDefaultStyle"), null, CSSParserFactory.SourceType.INLINE, element, false, styleSheet, uRL);
                        log.debug("Matched default CSS style");
                    }
                }
            }
            catch (CSSException cSSException) {
                log.error("THROWN:", cSSException);
            }
            catch (IOException iOException) {
                log.error("THROWN:", iOException);
            }
        }

        private static boolean isEmbeddedStyleSheet(Element element, String string) {
            return "style".equalsIgnoreCase(element.getNodeName()) && CSSAssignTraversal.isAllowedMedia(element, string);
        }

        private static boolean isLinkedStyleSheet(Element element, String string) {
            return element.getNodeName().equals("link") && element.getAttribute("rel").toLowerCase().contains("stylesheet") && (element.getAttribute("type").isEmpty() || "text/css".equalsIgnoreCase(element.getAttribute("type"))) && CSSAssignTraversal.isAllowedMedia(element, string);
        }

        private static String extractElementText(Element element) {
            Node node = element.getFirstChild();
            if (node != null && node.getNodeType() == 3) {
                return ((Text)node).getData();
            }
            return null;
        }

        private static boolean isAllowedMedia(Element element, String string) {
            String string2 = element.getAttribute("media");
            return string2 == null || string2.length() == 0 || string2.contains(string) || string2.contains("all");
        }
    }
}

