/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.x3d;

import com.ge.med.idc.XjVolumeModel;
import com.ge.med.terra.jami.JVolume;
import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import com.ge.med.terra.jami.j3d.T3DViewport;
import com.ge.med.terra.jami.j3d.vr.Preset;
import com.ge.med.terra.jami.j3d.vr.VrColorLut;
import com.ge.med.terra.jami.j3d.vr.VrPreset;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMVolume;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.x3d.controls.presetEditor.Histogram;
import java.awt.Component;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class PortGen {
    private static PortGen pj = new PortGen();

    public static void setPortJen(PortGen g) {
        pj = g;
    }

    public static XjVolumeModel makePort(XPscreen screen, int portno, XjVolumeModel model, DMObject dmo, String renderStyle, Preset p) {
        return pj.makeReformatPort(screen, portno, model, dmo, renderStyle, p);
    }

    public XjVolumeModel makeReformatPort(XPscreen screen, int portno, XjVolumeModel model, DMObject dmo, String renderStyle, Preset p) {
        T3DViewport vp;
        JComponent c = screen.getPort(portno);
        if (c instanceof T3DViewport) {
            vp = (T3DViewport)c;
        } else {
            vp = new T3DViewport(){

                @Override
                public void addMouseListener(MouseListener ml) {
                    this.getT3DComponent().addMouseListener(ml);
                    Component c = (Component)this.getClientProperty("scalpel");
                    if (c != null) {
                        c.addMouseListener(ml);
                    }
                    if ((c = (Component)this.getClientProperty("movieVc")) != null) {
                        c.addMouseListener(ml);
                    }
                }
            };
            screen.addPort(vp, portno);
        }
        vp.setRenderStyle(renderStyle);
        if (model == null) {
            DMVolume vol = DMVolume.buildVolume("DMObjectVolume", new Object[]{dmo});
            vp.setVolume(vol);
            model = vp.getVolumeModel();
        } else {
            vp.setVolumeModel(model);
        }
        if ("VOLUME".equals(renderStyle) && p != null) {
            double deltax = p.getDelta();
            double startx = p.getStartX();
            double[] opacity = p.fillOpacity();
            double[] clut = p.fillRGB();
            VrColorLut vrcl = new VrColorLut(clut, startx, deltax);
            VrPreset vrp = new VrPreset("CT", vrcl, opacity, startx, deltax);
            vp.getT3DComponent().setProperty("PRESET_PROPERTY", vrp);
            vp.putClientProperty("CNO_PROPERTY", p);
        }
        if ("VOLUME".equals(renderStyle)) {
            JVolume.LinearShort jvol = (JVolume.LinearShort)((J3DVolumeModel)vp.getVolumeModel()).j_vol;
            short[] vox = jvol.volume;
            Histogram h = new Histogram(0, 4095, 1.0, -1024.0);
            for (int pix = jvol.PAD; pix < jvol.PAD + jvol.dx * jvol.dy * jvol.dz; ++pix) {
                h.incrementRaw((int)vox[pix]);
            }
            vp.putClientProperty("HIST_PROPERTY", h);
        }
        vp.setName("MPR(" + dmo.getValue(16, 16) + ")");
        vp.putClientProperty("DATA", dmo);
        return model;
    }
}

