/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.x3d;

import com.ge.med.terra.jami.j3d.J3DVolumeModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class BingridEdit
extends AbstractUndoableEdit {
    private J3DVolumeModel volumeModel;
    private byte[] before;
    private byte[] after;
    private byte[] mask;
    private ChangeEvent event;
    List listeners = new ArrayList();

    public BingridEdit(J3DVolumeModel vm, byte[] before, byte[] after) {
        this.volumeModel = vm;
        if (before != null) {
            this.before = new byte[before.length];
            System.arraycopy(before, 0, this.before, 0, before.length);
        }
        if (after != null) {
            this.after = new byte[after.length];
            System.arraycopy(after, 0, this.after, 0, after.length);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        this.volumeModel.resetBingrid();
        if (this.before != null) {
            this.volumeModel.bingridAnd(this.before);
        }
        this.mask = this.before;
        this.fireStateChanged();
    }

    @Override
    public void redo() throws CannotRedoException {
        this.volumeModel.resetBingrid();
        if (this.after != null) {
            this.volumeModel.bingridAnd(this.after);
        }
        this.mask = this.after;
        this.fireStateChanged();
    }

    protected void fireStateChanged() {
        if (this.event == null) {
            this.event = new ChangeEvent(this);
        }
        for (ChangeListener element : this.listeners) {
            element.stateChanged(this.event);
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "Apply Segmentation";
    }

    public byte[] getMask() {
        return this.mask;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }
}

