/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import com.ge.med.terra.xpv.laf.LafUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JWindow;
import javax.swing.UIManager;

public class SplashWindow
extends JWindow {
    protected Image img;

    public SplashWindow(int size) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = screenSize.width / size;
        int height = screenSize.height / size;
        this.setBounds(screenSize.width / 2 - width / 2, screenSize.height / 2 - height / 2, width, height);
        this.setBackground(UIManager.getColor("P3"));
        try {
            this.img = ImageIO.read(SplashWindow.class.getResourceAsStream("/com/ge/med/terra/xpv/icons/GELOGO.GIF"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void paint(Graphics g) {
        Point loc = this.getLocationOnScreen();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        g.drawImage(this.img, this.getWidth() / 2 - this.img.getWidth(null) / 2, this.getHeight() / 2 - this.img.getHeight(null) / 2 - 50, this);
        g.setFont(new Font("Serif", 1, 20));
        g.setColor(Color.red);
        g.drawString("Non-Diagnostic Use Only", this.getWidth() / 2 - 115, this.getHeight() / 2);
        g.setColor(Color.black);
        g.setFont(new Font("Serif", 1, 14));
        g.drawString("Please Wait...   Starting EMViewer....   ", this.getWidth() / 2 - 123, this.getHeight() / 2 + 25);
    }

    public static void main(String[] args) {
        try {
            LafUtils.setupLAF();
            UIManager.getDefaults().put("Tree.expandedIcon", UIManager.get("Tree.openIcon"));
            UIManager.getDefaults().put("Tree.collapsedIcon", UIManager.get("Tree.closedIcon"));
            UIManager.getLookAndFeelDefaults().put("Tree.closedIcon", (Object)null);
            UIManager.getLookAndFeelDefaults().put("Tree.openIcon", (Object)null);
            UIManager.getDefaults().put("Tree.expandControlOffset", new Integer(0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SplashWindow s = new SplashWindow(3);
        s.setVisible(true);
    }
}

