/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

public class Prefs {
    private Prefs defaults;
    private File fd = null;
    private Properties repository = new Properties();
    private long lastModifiedDate = 0L;

    public Prefs() throws FileNotFoundException, IOException {
        this(null, null);
    }

    public Prefs(String file) throws FileNotFoundException, IOException {
        this(file, null);
    }

    public Prefs(Prefs defaults) throws FileNotFoundException, IOException {
        this(null, defaults);
    }

    public Prefs(String file, Prefs defaults) throws FileNotFoundException, IOException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(file);
        this.repository.load(is);
        this.defaults = defaults;
    }

    public void refreshContents() throws FileNotFoundException, IOException {
        if (this.fd.lastModified() > this.lastModifiedDate) {
            this.repository.load(new FileInputStream(this.fd));
            this.lastModifiedDate = this.fd.lastModified();
        }
    }

    public Hashtable getRepository() {
        return this.repository;
    }

    public List getKeys() {
        ArrayList<Object> listKeys = new ArrayList<Object>();
        Iterator<Object> iter = this.repository.keySet().iterator();
        while (iter.hasNext()) {
            listKeys.add(iter.next());
        }
        return listKeys;
    }

    public List getKeys(String prefix) {
        ArrayList<Object> listKeys = new ArrayList<Object>();
        for (Object key : this.repository.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith(prefix)) continue;
            listKeys.add(key);
        }
        return listKeys;
    }

    public int getNoKeys(String prefix) {
        return this.getKeys(prefix).size();
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getString(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(key + " doesn't map to a String object");
    }

    public boolean getBoolean(String key) {
        Boolean b = this.getBoolean(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException(key + " doesn't map to an existing object");
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, new Boolean(defaultValue));
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            Boolean b = new Boolean((String)value);
            return b;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(key + " doesn't map to a Boolean object");
    }

    public int getInteger(String key) {
        Integer i = this.getInteger(key, null);
        if (i != null) {
            return i;
        }
        throw new NoSuchElementException(key + " doesn't map to an existing object");
    }

    public int getInteger(String key, int defaultValue) {
        return this.getInteger(key, new Integer(defaultValue));
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            Integer i = new Integer((String)value);
            return i;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getInteger(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(key + " doesn't map to a Integer object");
    }

    public double getFloat(String key) {
        Double i = this.getFloat(key, null);
        if (i != null) {
            return i;
        }
        throw new NoSuchElementException(key + " doesn't map to an existing object");
    }

    public double getFloat(String key, double defaultValue) {
        return this.getFloat(key, new Double(defaultValue));
    }

    public Double getFloat(String key, Double defaultValue) {
        Object value = this.repository.get(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            Double i = new Double((String)value);
            return i;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getFloat(key, defaultValue);
            }
            return defaultValue;
        }
        throw new ClassCastException(key + " doesn't map to a Integer object");
    }

    public synchronized void savePrefs(String file) throws FileNotFoundException, IOException {
        try {
            this.repository.store(new FileOutputStream(file), null);
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    public static void main(String[] args) {
    }
}

