/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import com.ge.med.idc.Capable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.terra.xpv.laf.LafUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class Graph2DPort
extends JPanel
implements PanZoomCapable,
SelectionCapable {
    private int PlotType;
    public static final int LINE = 0;
    public static final int MARKS = 1;
    public static final int LINE_MARKS = 2;
    public static final int BARS = 3;
    public static final int FILLED_AREA = 4;
    private XYSeriesCollection dataset = new XYSeriesCollection();
    private JFreeChart chart = null;
    private BorderLayout borderLayout1 = new BorderLayout();
    private myChartPanel jPanel1;
    private double auto_x_min;
    private double auto_x_max;
    private double auto_y_min;
    private double auto_y_max;
    private double auto_x_mid;
    private double auto_y_mid;
    private double auto_x_range;
    private double auto_y_range;
    double oldZoom;
    double newZoom;
    double oldPanY;
    double newPanY;
    double oldPanX;
    double newPanX;
    private boolean autoRepaint = false;

    public Graph2DPort() {
        this.PlotType = 0;
        this.makeChart(null, null, null, this.PlotType);
        this.initGraph();
    }

    @Override
    public Capable getCapable(String capableIFName) {
        if (capableIFName.equals("com.ge.med.idc.PanZoomCapable") || capableIFName.equals("com.ge.med.idc.SelectionCapable")) {
            return this;
        }
        return null;
    }

    public Graph2DPort(int lineType) {
        this.PlotType = lineType;
        this.makeChart(null, null, null, this.PlotType);
        this.initGraph();
    }

    private void makeChart(String title, String tx, String ty, int type) {
        switch (type) {
            case 1: {
                System.err.println("Marks");
                this.chart = ChartFactory.createScatterPlot((String)title, (String)tx, (String)ty, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                break;
            }
            case 3: {
                System.err.println("Bars");
                this.chart = ChartFactory.createXYBarChart((String)title, (String)tx, (boolean)false, (String)ty, (IntervalXYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                break;
            }
            case 4: {
                System.err.println("filled Area");
                this.chart = ChartFactory.createXYAreaChart((String)title, (String)tx, (String)ty, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                break;
            }
            case 2: {
                this.chart = ChartFactory.createXYLineChart((String)title, (String)tx, (String)ty, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
                this.chart.getXYPlot().setRenderer((XYItemRenderer)new XYLineAndShapeRenderer());
                break;
            }
            default: {
                System.err.println("...Creating line graph....");
                this.chart = ChartFactory.createXYLineChart((String)title, (String)tx, (String)ty, (XYDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            }
        }
    }

    private void initGraph() {
        this.jPanel1 = new myChartPanel(this.chart, this);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBackgroundColor(Color.black);
        this.setForegroundColor(Color.cyan);
        this.setChartTitleColor(Color.white);
        this.setZoom(1.0);
        this.chart.getXYPlot().getDomainAxis().addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent axisChangeEvent) {
                double panX = Graph2DPort.this.getPanX();
                double zoom = Graph2DPort.this.getZoom();
                Graph2DPort.this.firePropertyChange("zoom", Graph2DPort.this.oldZoom, Graph2DPort.this.newZoom);
            }
        });
        this.chart.getXYPlot().getRangeAxis().addChangeListener(new AxisChangeListener(){

            public void axisChanged(AxisChangeEvent axisChangeEvent) {
                double panX = Graph2DPort.this.getPanX();
                double zoom = Graph2DPort.this.getZoom();
            }
        });
    }

    public Graph2DPort(String title, int type) {
        this.PlotType = type;
        this.makeChart(title, null, null, type);
        this.initGraph();
    }

    public Graph2DPort(String title, String tx, String ty, int type) {
        this.PlotType = type;
        this.makeChart(title, tx, ty, type);
        this.initGraph();
    }

    public void addDomainMarker(ValueMarker marker) {
        this.jPanel1.addDomainMarker(marker);
    }

    public void addRangeMarker(ValueMarker marker) {
        this.jPanel1.addRangeMarker(marker);
    }

    public static void main(String[] args) {
        Graph2DPort graph2DPort1 = new Graph2DPort("tina", 0);
        double[] xpt = new double[10];
        double[] ypt = new double[10];
        double[] ypt1 = new double[10];
        for (int i = 0; i < xpt.length; ++i) {
            xpt[i] = i;
            ypt[i] = i;
            ypt1[i] = 2 * i;
        }
        int index = graph2DPort1.addCurve(xpt, ypt);
        graph2DPort1.setCurveColor(index, Color.orange);
        index = graph2DPort1.addCurve(xpt, ypt1);
        System.err.println("index===" + index);
        graph2DPort1.setCurveColor(index, Color.yellow);
        graph2DPort1.setTitle("TEST CURVE");
        graph2DPort1.setTitlexaxis("x-axis");
        graph2DPort1.setTitleyaxis("y_axis");
        graph2DPort1.setChartTitleColor(Color.white);
        ValueMarker vm = new ValueMarker(3.0);
        vm.setPaint((Paint)Color.blue);
        graph2DPort1.addDomainMarker(vm);
        LafUtils.setupLAF();
        JFrame frame = new JFrame();
        frame.setTitle("JFree Panel");
        frame.setSize(400, 600);
        frame.setContentPane(graph2DPort1);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public int getPlotType() {
        return this.PlotType;
    }

    public String getTitle() {
        return this.chart.getTitle().getText();
    }

    public String getTitlexaxis() {
        return this.chart.getXYPlot().getDomainAxis().getLabel();
    }

    public String getTitleyaxis() {
        return this.chart.getXYPlot().getRangeAxis().getLabel();
    }

    public void setBackgroundColor(Color color) {
        this.chart.getXYPlot().setBackgroundPaint((Paint)color);
        this.chart.setBackgroundPaint((Paint)color);
    }

    public void setForegroundColor(Color color) {
        this.chart.getXYPlot().setOutlinePaint((Paint)color);
        this.chart.setBorderPaint((Paint)color);
    }

    public void setPlotTypel(int PlotType2) {
        this.PlotType = PlotType2;
        this.makeChart(this.chart.getTitle().getText(), this.chart.getXYPlot().getDomainAxis().getLabel(), this.chart.getXYPlot().getRangeAxis().getLabel(), PlotType2);
        this.initGraph();
        this.jPanel1.repaint();
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
    }

    public void setTitlexaxis(String titlexaxis) {
        this.chart.getXYPlot().getDomainAxis().setLabel(titlexaxis);
    }

    public void setTitleyaxis(String titleyaxis) {
        this.chart.getXYPlot().getRangeAxis().setLabel(titleyaxis);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)((Object)this.jPanel1), "Center");
    }

    public int addCurve(float[] xpoints, float[] points) {
        XYSeries xs = new XYSeries((Comparable)((Object)"series"));
        for (int i = 0; i < xpoints.length; ++i) {
            xs.add((double)xpoints[i], (double)points[i]);
        }
        this.dataset.addSeries(xs);
        return this.findSeriesID(xs);
    }

    public int addCurve(float[] ypoints) {
        XYSeries xs = new XYSeries((Comparable)((Object)"series"));
        for (int i = 0; i < ypoints.length; ++i) {
            xs.add((double)i, (double)ypoints[i]);
        }
        this.dataset.addSeries(xs);
        return this.findSeriesID(xs);
    }

    private int findSeriesID(XYSeries xs) {
        this.auto_x_max = this.chart.getXYPlot().getDomainAxis().getRange().getUpperBound();
        this.auto_x_min = this.chart.getXYPlot().getDomainAxis().getRange().getLowerBound();
        this.auto_y_max = this.chart.getXYPlot().getRangeAxis().getRange().getUpperBound();
        this.auto_y_min = this.chart.getXYPlot().getRangeAxis().getRange().getLowerBound();
        System.err.println("auto_x_max==" + this.auto_x_max + "auto_x_min=" + this.auto_x_min + "auto_y_max=" + this.auto_y_max + "auto_y_min=" + this.auto_y_min);
        this.auto_x_mid = this.chart.getXYPlot().getDomainAxis().getRange().getCentralValue();
        this.auto_y_mid = this.chart.getXYPlot().getRangeAxis().getRange().getCentralValue();
        this.auto_x_range = this.chart.getXYPlot().getDomainAxis().getRange().getLength();
        this.auto_y_range = this.chart.getXYPlot().getRangeAxis().getRange().getLength();
        System.err.println("auto_x_inteval=" + this.auto_x_mid + "auto_y_inteval=" + this.auto_y_mid);
        int dataS = this.dataset.getSeriesCount();
        for (int i = 0; i < dataS; ++i) {
            if (this.dataset.getSeries(i) != xs) continue;
            return i;
        }
        return -1;
    }

    public int addCurve(double[] xpoints, double[] ypoints) {
        XYSeries xs = new XYSeries((Comparable)((Object)"series"));
        for (int i = 0; i < xpoints.length; ++i) {
            xs.add(xpoints[i], ypoints[i]);
        }
        this.dataset.addSeries(xs);
        return this.findSeriesID(xs);
    }

    public int addCurve(double[] ypoints) {
        XYSeries xs = new XYSeries((Comparable)((Object)"series"));
        for (int i = 0; i < ypoints.length; ++i) {
            xs.add((double)i, ypoints[i]);
        }
        this.dataset.addSeries(xs);
        return this.findSeriesID(xs);
    }

    public void removeCurve(int curve) {
        this.dataset.removeSeries(curve);
    }

    public void setCurveColor(int curve, Color color) {
        this.chart.getXYPlot().getRenderer().setSeriesPaint(curve, (Paint)color);
    }

    public Color getCurveColor(int curve) {
        return (Color)this.chart.getXYPlot().getRenderer().getSeriesPaint(curve);
    }

    public Color getChartTitleColor() {
        return (Color)this.chart.getTitle().getPaint();
    }

    public void setChartTitleColor(Color color) {
        if (this.chart.getTitle() != null) {
            this.chart.getTitle().setPaint((Paint)color);
        }
        this.chart.getXYPlot().getDomainAxis().setLabelPaint((Paint)color);
        this.chart.getXYPlot().getRangeAxis().setLabelPaint((Paint)color);
        this.chart.getXYPlot().getDomainAxis().setTickLabelPaint((Paint)color);
        this.chart.getXYPlot().getRangeAxis().setTickLabelPaint((Paint)color);
    }

    @Override
    public void setZoom(double zoom) {
        if (this.chart.getXYPlot().getSeriesCount() == 0) {
            return;
        }
        double xInteval = this.auto_x_mid / zoom;
        double cDMid = this.chart.getXYPlot().getDomainAxis().getRange().getCentralValue();
        double cRMid = this.chart.getXYPlot().getRangeAxis().getRange().getCentralValue();
        this.chart.getXYPlot().getDomainAxis().setUpperBound(cDMid + xInteval);
        this.chart.getXYPlot().getDomainAxis().setLowerBound(cDMid - xInteval);
        this.oldZoom = this.newZoom;
        this.newZoom = zoom;
    }

    @Override
    public double getZoom() {
        return this.newZoom;
    }

    @Override
    public void setRotate(double rotate) {
    }

    @Override
    public double getRotate() {
        return 0.0;
    }

    @Override
    public void setPan(double pan_x, double pan_y) {
        this.setPanX(pan_x);
        this.setPanY(pan_y);
    }

    @Override
    public void setPanY(double pan_y) {
        double pany = this.getPanY();
        double midPoint = this.auto_y_mid + this.auto_y_range * (pan_y / 100.0);
        double extent = this.chart.getXYPlot().getRangeAxis().getRange().getLength() / 2.0;
        this.chart.getXYPlot().getRangeAxis().setUpperBound(midPoint + extent);
        this.chart.getXYPlot().getRangeAxis().setLowerBound(midPoint - extent);
        this.oldPanY = this.newPanY;
        this.newPanY = pan_y;
    }

    @Override
    public double getPanY() {
        return this.newPanY;
    }

    @Override
    public void setPanX(double pan_x) {
        double panx = this.getPanX();
        double midPoint = this.auto_x_mid + this.auto_x_range * (pan_x / 100.0);
        double extent = this.chart.getXYPlot().getDomainAxis().getRange().getLength() / 2.0;
        this.chart.getXYPlot().getDomainAxis().setUpperBound(midPoint + extent);
        this.chart.getXYPlot().getDomainAxis().setLowerBound(midPoint - extent);
        this.oldPanX = this.newPanX;
        this.newPanX = pan_x;
    }

    @Override
    public double getPanX() {
        return this.newPanX;
    }

    @Override
    public void flipVertical() {
    }

    @Override
    public void flipHorizontal() {
    }

    @Override
    public void resetPanZoom() {
        this.oldZoom = this.newZoom;
        this.newZoom = 1.0;
        this.oldPanX = this.newPanX;
        this.newPanX = 0.0;
        this.oldPanY = this.newPanY;
        this.newPanY = 0.0;
        this.chart.getXYPlot().getDomainAxis().setUpperBound(this.auto_x_max);
        this.chart.getXYPlot().getDomainAxis().setLowerBound(this.auto_x_min);
        this.chart.getXYPlot().getRangeAxis().setUpperBound(this.auto_y_max);
        this.chart.getXYPlot().getRangeAxis().setLowerBound(this.auto_y_min);
    }

    @Override
    public boolean isAutoRepaint() {
        return this.autoRepaint;
    }

    @Override
    public void setAutoRepaint(boolean autoRepaint) {
        this.autoRepaint = autoRepaint;
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    @Override
    public int getComponentSelection() {
        return 0;
    }

    @Override
    public void setComponentSelection(int int0) {
    }

    @Override
    public JComponent getViewportComponent(int int0) {
        return this;
    }

    private class myChartPanel
    extends ChartPanel {
        boolean autoRepaint;
        JPanel parent;
        Vector domainMarkers;
        Vector rangeMarkers;
        boolean domaninMarker;
        ValueMarker chosenMarker;

        public myChartPanel(JFreeChart chart, JPanel parent) {
            super(chart);
            this.domainMarkers = new Vector();
            this.rangeMarkers = new Vector();
            this.domaninMarker = false;
            this.chosenMarker = null;
            this.parent = parent;
        }

        public void addDomainMarker(ValueMarker marker) {
            this.domainMarkers.add(marker);
            this.getChart().getXYPlot().addDomainMarker((Marker)marker);
        }

        public void addRangeMarker(ValueMarker marker) {
            this.rangeMarkers.add(marker);
            this.getChart().getXYPlot().addRangeMarker((Marker)marker);
        }

        public void mouseClicked(MouseEvent event) {
            this.parent.firePropertyChange("ComponentSelection", -99, 0);
        }

        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (!e.isPopupTrigger()) {
                this.isMarkerPressed(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            System.err.println("mouseReleased...");
            if (!e.isPopupTrigger() && this.chosenMarker != null) {
                if (this.domaninMarker) {
                    this.getChart().getXYPlot().clearDomainMarkers();
                    ValueMarker vm = new ValueMarker(this.getXvalue(e.getX()));
                    vm.setPaint(this.chosenMarker.getPaint());
                    this.domainMarkers.add(vm);
                    for (ValueMarker vm1 : this.domainMarkers) {
                        this.getChart().getXYPlot().addDomainMarker((Marker)vm1);
                    }
                } else {
                    this.getChart().getXYPlot().clearRangeMarkers();
                    ValueMarker vm = new ValueMarker(this.getYvalue(e.getY()));
                    vm.setPaint(this.chosenMarker.getPaint());
                    this.rangeMarkers.add(vm);
                    for (ValueMarker vm1 : this.domainMarkers) {
                        this.getChart().getXYPlot().addRangeMarker((Marker)vm1);
                    }
                }
                this.chosenMarker = null;
            }
        }

        private double getXvalue(int xValue) {
            Rectangle2D dataArea = this.getChartRenderingInfo().getPlotInfo().getDataArea();
            Insets insets = this.getInsets();
            double x = dataArea.getX() * this.getScaleX() + (double)insets.left;
            double minX = dataArea.getMinX();
            double maxX = dataArea.getMaxX();
            double xSlop = (this.getChart().getXYPlot().getDomainAxis().getUpperBound() - Graph2DPort.this.chart.getXYPlot().getDomainAxis().getLowerBound()) / (maxX - minX);
            double xIC = this.getChart().getXYPlot().getDomainAxis().getUpperBound() - xSlop * maxX;
            return (double)xValue * xSlop + xIC;
        }

        private double getYvalue(int yValue) {
            Rectangle2D dataArea = this.getChartRenderingInfo().getPlotInfo().getDataArea();
            Insets insets = this.getInsets();
            double x = dataArea.getY() * this.getScaleY() + (double)insets.top;
            double minY = dataArea.getMinY();
            double maxY = dataArea.getMaxY();
            double ySlop = (this.getChart().getXYPlot().getRangeAxis().getUpperBound() - Graph2DPort.this.chart.getXYPlot().getRangeAxis().getLowerBound()) / (maxY - minY);
            double yIC = this.getChart().getXYPlot().getRangeAxis().getUpperBound() - ySlop * maxY;
            return (double)yValue * ySlop + yIC;
        }

        private void isMarkerPressed(MouseEvent event) {
            double value;
            Rectangle2D dataArea = this.getChartRenderingInfo().getPlotInfo().getDataArea();
            Insets insets = this.getInsets();
            double x = dataArea.getX() * this.getScaleX() + (double)insets.left;
            double y = dataArea.getY() * this.getScaleY() + (double)insets.top;
            double w = dataArea.getWidth() * this.getScaleX();
            double h = dataArea.getHeight() * this.getScaleY();
            double minX = dataArea.getMinX();
            double maxX = dataArea.getMaxX();
            double minY = dataArea.getMinY();
            double maxY = dataArea.getMaxY();
            double xSlop = (this.getChart().getXYPlot().getDomainAxis().getUpperBound() - Graph2DPort.this.chart.getXYPlot().getDomainAxis().getLowerBound()) / (maxX - minX);
            double xIC = this.getChart().getXYPlot().getDomainAxis().getUpperBound() - xSlop * maxX;
            double ySlop = (this.getChart().getXYPlot().getRangeAxis().getUpperBound() - Graph2DPort.this.chart.getXYPlot().getRangeAxis().getLowerBound()) / (maxY - minY);
            double yIC = this.getChart().getXYPlot().getRangeAxis().getUpperBound() - ySlop * maxY;
            double xVal = (double)event.getX() * xSlop + xIC;
            double yVal = (double)event.getY() * ySlop + yIC;
            System.err.println("xVal==" + xVal + "yVal=" + yVal + "slopX=" + xSlop + "xIC=" + xIC);
            for (ValueMarker vm : this.domainMarkers) {
                value = vm.getValue();
                if (!(xVal <= value + 0.05) || !(xVal >= value - 0.05)) continue;
                System.err.println("marker is pressed");
                this.domaninMarker = true;
                this.chosenMarker = vm;
                this.domainMarkers.remove(vm);
                return;
            }
            for (ValueMarker vm : this.rangeMarkers) {
                value = vm.getValue();
                if (!(yVal <= value + 0.05) || !(yVal >= value - 0.05)) continue;
                System.err.println("marker is pressed");
                this.domaninMarker = false;
                this.chosenMarker = vm;
                this.rangeMarkers.remove(vm);
                return;
            }
        }
    }
}

