/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.util;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.dicom.PersonName;

public class DMWrap {
    public DMObject dmo;
    public int n;
    public int numFrame;
    public int firstDisplayedFrame;
    public int lastDisplayedFrame;
    public boolean loaded = false;
    public boolean displayed = false;

    public DMWrap() {
    }

    public DMWrap(DMObject o, int n) {
        this.dmo = o;
        this.n = n;
        this.numFrame = 0;
        this.lastDisplayedFrame = 0;
        this.firstDisplayedFrame = 0;
    }

    public int getNumFrame() {
        return this.numFrame;
    }

    public void setNumFrame(int num) {
        this.numFrame = num;
    }

    public String toNum() {
        if (this.dmo == null) {
            return "...";
        }
        if (this.n == 0 && this.dmo.getValue(16, 16) != null) {
            return PersonName.toFormattedString(this.dmo.getValue(16, 16).toString());
        }
        if (this.n == 1) {
            if (this.dmo.getValue(32, 16) != null) {
                return PersonName.toFormattedString(this.dmo.getValue(32, 16).toString());
            }
            return "0";
        }
        if (this.n == 2) {
            String str = "0";
            if (this.dmo.getValue(32, 17) != null) {
                str = this.dmo.getValue(32, 17).toString();
            }
            try {
                int s1 = Integer.parseInt(str.toString());
            }
            catch (NumberFormatException ex) {
                str = "0";
            }
            return str;
        }
        String str = "0";
        if (this.dmo.getValue(32, 19) != null) {
            str = this.dmo.getValue(32, 19).toString();
        }
        try {
            int s1 = Integer.parseInt(str.toString());
        }
        catch (NumberFormatException ex) {
            str = "0";
        }
        return str;
    }

    public String toString() {
        if (this.dmo == null) {
            return "...";
        }
        if (this.n == 0 && this.dmo.getValue(16, 16) != null) {
            return PersonName.toFormattedString(this.dmo.getValue(16, 16).toString());
        }
        if (this.n == 1) {
            if (this.dmo.getValue(32, 16) != null) {
                String retVal = PersonName.toFormattedString(this.dmo.getValue(32, 16).toString());
                retVal = "ex" + retVal;
                return retVal;
            }
            return "ex0";
        }
        if (this.n == 2) {
            String str = "0";
            if (this.dmo.getValue(32, 17) != null) {
                str = this.dmo.getValue(32, 17).toString();
            }
            try {
                int s1 = Integer.parseInt(str.toString());
            }
            catch (NumberFormatException ex) {
                str = "0";
            }
            str = "se" + str;
            String modality = (String)this.dmo.getValue(8, 96);
            if (modality.lastIndexOf("PR") >= 0) {
                str = str + "[PR]";
            } else if (modality.lastIndexOf("PT") >= 0) {
                str = str + "[PT]";
            }
            return str;
        }
        String str = "0";
        if (this.dmo.getValue(32, 19) != null) {
            str = this.dmo.getValue(32, 19).toString();
        }
        try {
            int s1 = Integer.parseInt(str.toString());
        }
        catch (NumberFormatException ex) {
            str = "0";
        }
        str = "im" + str;
        String modality = (String)this.dmo.getValue(8, 96);
        if (modality.lastIndexOf("PR") >= 0) {
            str = str + "[PR]";
        } else if (modality.lastIndexOf("PT") >= 0) {
            str = str + "[PT]";
        }
        return str;
    }
}

