/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.ui;

import com.ge.med.idc.Capable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.terra.xpv.laf.LafUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;

public class RowColumnButton
extends JButton {
    JDialog popup = null;
    JList list = new JList();
    JLabel infoLabel = new JLabel();
    JPanel labelPanel = new JPanel();
    Border labelBorder = BorderFactory.createLineBorder(UIManager.getColor("P9"), 1);
    int rowsLimit = 8;
    int colsLimit = 8;
    private boolean drag;
    Icon icon_;
    private RowColCapable rcc;
    static final int SZ = 192;

    public void setLimit(int rows, int cols) {
        this.rowsLimit = rows;
        this.colsLimit = cols;
    }

    public Dimension getDimension() {
        return ((ListDataModel)this.list.getModel()).getSelected();
    }

    public void setDimension(Dimension value) {
        ((ListDataModel)this.list.getModel()).setSelected(value);
    }

    public void setMaximumDimension(Dimension max) {
        ((ListDataModel)this.list.getModel()).setDimension(max);
    }

    public RowColumnButton() {
        RowColumnListUI listui = new RowColumnListUI();
        ListDataModel model = new ListDataModel(new Dimension(5, 4));
        model.setSelected(new Dimension(2, 2));
        this.setToolTipText("2 x 2");
        this.list.setModel(model);
        this.list.setUI(listui);
        this.list.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                if (!RowColumnButton.this.drag) {
                    RowColumnButton.this.process(me);
                }
            }

            @Override
            public void mouseDragged(MouseEvent me) {
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                RowColumnButton.this.drag = false;
                Dimension sel = ((ListDataModel)RowColumnButton.this.list.getModel()).getSelected();
                int col = (int)sel.getWidth();
                int row = (int)sel.getHeight();
                if (RowColumnButton.this.rcc != null) {
                    RowColumnButton.this.rcc.setRowCol(row, col);
                }
                RowColumnButton.this.setToolTipText(row + " x " + col);
                RowColumnButton.this.repaint();
                RowColumnButton.this.popup.setVisible(false);
            }
        });
        this.labelPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.labelPanel.add(this.infoLabel);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void process(MouseEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (this.list == null) {
            return;
        }
        Point location = e.getPoint();
        int index = this.list.locationToIndex(location);
        if (index == -1) {
            index = location.y < 0 ? 0 : this.list.getModel().getSize() - 1;
        }
        Dimension dim = (Dimension)((ListDataModel)this.list.getModel()).getElementAt(index);
        Dimension sel = ((ListDataModel)this.list.getModel()).getSelected();
        if (dim.getWidth() != sel.getWidth() || dim.getHeight() != sel.getHeight()) {
            ((ListDataModel)this.list.getModel()).setSelected(dim);
        }
        Dimension max = ((ListDataModel)this.list.getModel()).getDimension();
        boolean change = false;
        int maxw = max.width;
        int maxh = max.height;
        if (this.drag && (maxw == dim.width || maxh == dim.height)) {
            change = true;
        }
        maxw = maxw == dim.width ? maxw + 1 : maxw;
        maxh = maxh == dim.height ? maxh + 1 : maxh;
        maxw = Math.min(maxw, this.colsLimit);
        maxh = Math.min(maxh, this.rowsLimit);
        if (change) {
            ((ListDataModel)this.list.getModel()).setDimension(new Dimension(maxw, maxh));
            this.list.invalidate();
            this.popup.pack();
        }
        this.updateLabelText();
        this.list.repaint();
    }

    private void jbInit() throws Exception {
        this.setFocusable(false);
        this.icon_ = new RowColIcon();
        this.setIcon(this.icon_);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RowColumnButton.this.this_mouseClicked(e);
            }
        });
    }

    void updateLabelText() {
        Dimension dim = ((ListDataModel)this.list.getModel()).getSelected();
        this.infoLabel.setText(dim.height + "x" + dim.width);
    }

    public void this_mouseClicked(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.popup == null) {
            JComponent src = (JComponent)e.getSource();
            this.popup = new JDialog((Frame)src.getTopLevelAncestor());
            this.popup.setUndecorated(true);
            JPanel popupContent = new JPanel(new BorderLayout());
            popupContent.add(this.list);
            popupContent.add((Component)this.labelPanel, "South");
            this.updateLabelText();
            this.popup.setContentPane(popupContent);
            this.popup.pack();
            this.popup.setLocation(src.getLocationOnScreen().x, src.getLocationOnScreen().y + src.getHeight());
            this.popup.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent fe) {
                    if (RowColumnButton.this.popup.isVisible()) {
                        Dimension sel = ((ListDataModel)RowColumnButton.this.list.getModel()).getSelected();
                        int col = (int)sel.getWidth();
                        int row = (int)sel.getHeight();
                        if (RowColumnButton.this.rcc != null) {
                            RowColumnButton.this.rcc.setRowCol(row, col);
                        }
                        RowColumnButton.this.setToolTipText(row + " x " + col);
                        RowColumnButton.this.repaint();
                        RowColumnButton.this.popup.setVisible(false);
                    }
                }
            });
        } else {
            JComponent src = (JComponent)e.getSource();
            this.popup.setLocation(src.getLocationOnScreen().x, src.getLocationOnScreen().y + src.getHeight());
        }
        this.popup.setVisible(true);
    }

    public void setRowColumnCapable(RowColCapable rcc) {
        this.rcc = rcc;
        this.setEnabled(rcc != null);
        if (rcc != null) {
            ((ListDataModel)this.list.getModel()).setSelected(new Dimension(rcc.getRows(), rcc.getCols()));
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (b) {
            Dimension sel = ((ListDataModel)this.list.getModel()).getSelected();
            int col = (int)sel.getWidth();
            int row = (int)sel.getHeight();
            this.setToolTipText(row + " x " + col);
        } else {
            this.setToolTipText("");
        }
    }

    public static void main(String[] args) {
        LafUtils.setupLAF();
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        JPanel p = new JPanel();
        RowColumnButton rcb = new RowColumnButton();
        rcb.setRowColumnCapable(new RowColCapable(){
            int rows = 1;
            int cols = 1;

            @Override
            public int getCols() {
                return this.cols;
            }

            @Override
            public int getRows() {
                return this.rows;
            }

            @Override
            public void setCols(int newCols) {
                this.cols = newCols;
            }

            @Override
            public void setRowCol(int row, int col) {
                this.cols = col;
                this.rows = row;
            }

            @Override
            public void setRows(int newRows) {
                this.rows = newRows;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener l) {
            }

            @Override
            public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
            }

            @Override
            public Capable getCapable(String capableIFName) {
                return "RowColCapable".equals(capableIFName) ? this : null;
            }

            @Override
            public boolean isAutoRepaint() {
                return false;
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener l) {
            }

            @Override
            public void repaint() {
            }

            @Override
            public void setAutoRepaint(boolean autoRepaint) {
            }

            @Override
            public void removePropertyChangeListener(String s, PropertyChangeListener l) {
            }
        });
        p.add(rcb);
        f.setContentPane(p);
        f.setSize(300, 200);
        f.setVisible(true);
    }

    public static class RowColumnListUI
    extends ListUI {
        static final int CELL_SIZE = 20;

        public static ComponentUI createUI(JComponent c) {
            return new RowColumnListUI();
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            Dimension dim = ((ListDataModel)((JList)c).getModel()).getDimension();
            return new Dimension(20 * dim.width, 20 * dim.height);
        }

        public Rectangle getCellBounds(JList list, int index1, int index2) {
            ListDataModel model = (ListDataModel)list.getModel();
            Dimension shown = model.getDimension();
            Dimension s = list.getSize();
            Insets i = list.getInsets();
            int index = Math.max(index1, index2);
            int r = index / shown.width;
            int c = index % shown.width;
            return new Rectangle(Math.round(c * 20), Math.round(r * 20), Math.round((c + 1) * 20), Math.round((r + 1) * 20));
        }

        public Point indexToLocation(JList list, int index) {
            return this.getCellBounds(list, index, index).getLocation();
        }

        public int locationToIndex(JList list, Point location) {
            ListDataModel model = (ListDataModel)list.getModel();
            Dimension shown = model.getDimension();
            Dimension s = list.getSize();
            Insets i = list.getInsets();
            double[] cellSize = new double[]{(double)(s.width - (i.left + i.right)) / (double)shown.width, (double)(s.height - (i.top + i.bottom)) / (double)shown.height};
            int c = (int)Math.floor((double)(location.x - i.left) / cellSize[0]);
            int r = (int)Math.floor((double)(location.y - i.top) / cellSize[1]);
            return r * shown.width + c;
        }

        @Override
        public void paint(Graphics g, JComponent component) {
            JList list = (JList)component;
            ListDataModel model = (ListDataModel)list.getModel();
            Dimension shown = model.getDimension();
            Dimension actual = model.getSelected();
            Dimension s = list.getSize();
            Insets i = list.getInsets();
            double[] cellSize = new double[]{(double)(s.width - (i.left + i.right)) / (double)shown.width, (double)(s.height - (i.top + i.bottom)) / (double)shown.height};
            for (int r = 0; r < shown.height; ++r) {
                for (int c = 0; c < shown.width; ++c) {
                    g.setColor(UIManager.getColor(r < actual.height && c < actual.width ? "P9" : "P2"));
                    g.fillRect((int)Math.round((double)c * cellSize[0]), (int)Math.round((double)r * cellSize[1]), (int)Math.round((double)(c + 1) * cellSize[0]), (int)Math.round((double)(r + 1) * cellSize[1]));
                    g.setColor(UIManager.getColor("P3"));
                    g.drawRect((int)Math.round((double)c * cellSize[0]), (int)Math.round((double)r * cellSize[1]), (int)Math.round((double)(c + 1) * cellSize[0]), (int)Math.round((double)(r + 1) * cellSize[1]));
                }
            }
        }
    }

    public static class ListDataModel
    implements ListModel {
        protected Dimension selected_ = new Dimension(1, 1);
        protected Dimension dimension_ = new Dimension(2, 2);
        protected List listeners_ = new ArrayList();

        public ListDataModel(Dimension dimension) {
            this.selected_ = new Dimension(dimension.width, dimension.height);
            this.dimension_ = new Dimension(dimension.width, dimension.height);
        }

        public ListDataModel() {
            this(new Dimension(1, 1));
        }

        public Dimension getSelected() {
            return this.selected_;
        }

        public void setSelected(Dimension selected) {
            this.selected_ = new Dimension(selected.width, selected.height);
            if (this.selected_.width > this.dimension_.width || this.selected_.height > this.dimension_.height) {
                this.dimension_ = new Dimension(Math.max(this.selected_.width, this.dimension_.width), Math.max(this.selected_.height, this.dimension_.height));
            }
            this.fireListDataChanged();
        }

        public Dimension getDimension() {
            return this.dimension_;
        }

        public void setDimension(Dimension dimension) {
            this.dimension_ = new Dimension(dimension.width, dimension.height);
            if (this.selected_.width > this.dimension_.width || this.selected_.height > this.dimension_.height) {
                this.selected_ = new Dimension(Math.min(this.selected_.width, this.dimension_.width), Math.min(this.selected_.height, this.dimension_.height));
            }
            this.fireListDataChanged();
        }

        protected void fireListDataChanged() {
            ListDataEvent event = new ListDataEvent(this, 0, 0, this.getSize() - 1);
            Iterator i = this.listeners_.iterator();
            while (i.hasNext()) {
                ((ListDataListener)i.next()).contentsChanged(event);
            }
        }

        @Override
        public int getSize() {
            return this.dimension_.width * this.dimension_.height;
        }

        public Object getElementAt(int index) {
            return new Dimension(index % this.dimension_.width + 1, index / this.dimension_.width + 1);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners_.add(l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners_.remove(l);
        }
    }

    private class RowColIcon
    implements Icon {
        static final int size = 24;

        private RowColIcon() {
        }

        @Override
        public int getIconHeight() {
            return 24;
        }

        @Override
        public int getIconWidth() {
            return 24;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int i;
            g.setColor(Color.GRAY.darker());
            g.fillRect(x, y, 24, 24);
            g.setColor(Color.WHITE.darker());
            Dimension dim = RowColumnButton.this.getDimension();
            dim = new Dimension(2, 2);
            for (i = 0; i < dim.width - 1; ++i) {
                g.drawLine((i + 1) * 24 / dim.width + x, y, (i + 1) * 24 / dim.width + x, y + 24 - 1);
            }
            for (i = 0; i < dim.height - 1; ++i) {
                g.drawLine(x, y + (i + 1) * 24 / dim.height, x + 24 - 1, y + (i + 1) * 24 / dim.height);
            }
        }
    }
}

