/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.template;

import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpMultiImageViewport;
import com.ge.med.terra.jami.annotation.XpAnnotationManager;
import com.ge.med.terra.jami.annotation.XpApdAnnotationGenerator;
import com.ge.med.terra.jami.platform.dm.XpMedicalDmImage;
import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.xpv.base.ScreenHeader;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPdisplayArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.template.Template;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.RenderingHints;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JComponent;

public class BasicTemplate
implements Template {
    Properties prop;
    DMQuery query = null;
    int uGroup;
    int uElem;
    boolean[] dataUsed = null;
    DMTag[] tagList;

    @Override
    public void setConfigProp(Properties prop) {
        String unique;
        this.prop = prop;
        String filter = prop.getProperty("filter");
        if (filter != null) {
            this.query = new DMQuery(filter);
        }
        if ((unique = prop.getProperty("uniqueTag")) != null) {
            StringTokenizer st = new StringTokenizer(unique, "() ,");
            this.uGroup = Integer.decode(st.nextToken());
            this.uElem = Integer.decode(st.nextToken());
        }
    }

    @Override
    public String getSeriesName() {
        return null;
    }

    @Override
    public String getName() {
        return this.prop.getProperty("name", "BasicTemplate");
    }

    @Override
    public String[] getScans(DMObject[] dmo) {
        HashSet<Object> hs = new HashSet<Object>();
        for (int i = 0; i < dmo.length; ++i) {
            DMObject[] ser = dmo[i].getRelated("series", this.query);
            for (int j = 0; j < ser.length; ++j) {
                Object o = ser[j].getValue(this.uGroup, this.uElem);
                if (o == null) continue;
                hs.add(o);
            }
        }
        return hs.toArray(new String[0]);
    }

    @Override
    public void run(DMObject[] series, XPscreen screen, XPcontrolArea ctlArea, String name) {
        this.fillPort(series, screen, name);
    }

    DMObject[] filterData(DMObject[] data, String level, DMQuery q) {
        DMObject[][] dmo = new DMObject[data.length][];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            dmo[i] = data[i].getRelated(level, q);
            count += dmo[i].length;
        }
        DMObject[] ret = new DMObject[count];
        count = 0;
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(dmo[i], 0, ret, count, dmo[i].length);
            count += dmo[i].length;
        }
        return ret;
    }

    private DMImage[] filterFrames(DMImage[] iset, int en, int det) {
        DMImage[] dmi = new DMImage[iset.length];
        int count = 0;
        for (int i = 0; i < iset.length; ++i) {
            Object energy = iset[i].getValue(84, 16);
            Object detect = iset[i].getValue(84, 32);
            if (en >= 0 && BasicTemplate.getIndexValue(energy, i) != en || det >= 0 && BasicTemplate.getIndexValue(detect, i) != det) continue;
            dmi[count] = iset[i];
            ++count;
        }
        DMImage[] ret = new DMImage[count];
        System.arraycopy(dmi, 0, ret, 0, count);
        return ret;
    }

    public static int getIndexValue(Object vector, int index) {
        if (vector instanceof Integer[]) {
            Integer[] shorts = (Integer[])vector;
            return shorts[index];
        }
        if (vector instanceof short[]) {
            short[] shorts = (short[])vector;
            return shorts[index];
        }
        if (vector instanceof Short) {
            return ((Short)vector).intValue();
        }
        if (vector instanceof Integer) {
            return (Integer)vector;
        }
        if (vector instanceof int[]) {
            int[] shorts = (int[])vector;
            return shorts[index];
        }
        if (vector instanceof Short[]) {
            Short[] shorts = (Short[])vector;
            return shorts[index].intValue();
        }
        if (vector instanceof String) {
            return Integer.parseInt((String)vector);
        }
        return -1;
    }

    private int getTailInt(String name, String sval) {
        try {
            if (sval == null) {
                return -1;
            }
            int pos = sval.indexOf(name);
            if (pos == -1) {
                return -1;
            }
            String sub = sval.substring(pos += name.length(), pos + 1);
            int val = Integer.parseInt(sub);
            return val;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    protected void fillPort(DMObject[] data, XPscreen screen, String name) {
        String filter;
        String layout = this.prop.getProperty("layout");
        int nop = 1;
        DMObject[] sdata = this.filterData(data, "series", new DMQuery("(" + this.uGroup + "," + this.uElem + ") = " + name));
        if (layout != null) {
            XPscreenLayout lay = new XPscreenLayout(layout);
            nop = lay.getNoOfPorts();
            screen.setLayout(lay);
        }
        String tagStr = this.prop.getProperty("TAGS_TO_LOAD");
        DMTag[] tagsNM = XPutil.parseTags(tagStr);
        DMTag[] tags = this.getNeededTags();
        if (tagsNM != null) {
            int i;
            int len = tagsNM.length + tags.length;
            DMTag[] compTag = new DMTag[len];
            for (i = 0; i < tagsNM.length; ++i) {
                compTag[i] = tagsNM[i];
            }
            for (i = 0; i < tags.length; ++i) {
                compTag[tagsNM.length + i] = tags[i];
            }
            tags = compTag;
        }
        DMQuery genFilter = (filter = this.prop.getProperty("filter")) == null ? null : new DMQuery(filter);
        for (int p = 0; p < nop; ++p) {
            JComponent c = screen.getPort(p);
            String sFilter = this.prop.getProperty("port" + (p + 1) + ".seriesFilter");
            String iFilter = this.prop.getProperty("port" + (p + 1) + ".imageFilter");
            String fFilter = this.prop.getProperty("port" + (p + 1) + ".frameFilter");
            int en = this.getTailInt("energy", fFilter);
            int det = this.getTailInt("detector", fFilter);
            DMQuery sQuery = sFilter == null ? null : new DMQuery(sFilter);
            DMQuery iQuery = iFilter == null ? null : new DMQuery(iFilter);
            for (int i = 0; i < sdata.length; ++i) {
                if (sQuery != null && !sQuery.valid(sdata[i])) continue;
                DMObject[] idata = sdata[i].getRelated("image");
                DMImage[] iset = new DMImage[]{};
                for (int j = 0; j < idata.length; ++j) {
                    DMImage[] fdata;
                    if (iQuery != null && !iQuery.valid(idata[j])) continue;
                    DMImage[] img = fdata = this.filterFrames(idata[j].getImages(tags), en, det);
                    DMImage[] tmp = new DMImage[iset.length + img.length];
                    System.arraycopy(iset, 0, tmp, 0, iset.length);
                    System.arraycopy(img, 0, tmp, iset.length, img.length);
                    iset = tmp;
                }
                String header = this.prop.getProperty("port" + (p + 1) + ".header");
                if (header != null) {
                    try {
                        Class<?> hdrClass = Class.forName(header);
                        ScreenHeader hdr = (ScreenHeader)hdrClass.newInstance();
                        screen.addPort(hdr, p);
                        hdr.setProperties(this.prop);
                        if (idata == null) continue;
                        hdr.setData(idata);
                    }
                    catch (Exception ex) {}
                    continue;
                }
                if (iset.length != 0) {
                    XpMultiImageViewport port = new XpMultiImageViewport();
                    XpMedicalImage[] mi = new XpMedicalImage[iset.length];
                    port.setPrimaryBorder(null);
                    for (int ii = 0; ii < iset.length; ++ii) {
                        XpMedicalDmImage dmi = new XpMedicalDmImage(iset[ii]);
                        mi[ii] = dmi;
                    }
                    port.setImages(mi);
                    port.setAnnotationGenerator(XpApdAnnotationGenerator.class, this.prop);
                    port.setCineQuality(RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    port.setRowCol(iset.length > 1 ? 2 : 1, iset.length > 2 ? 2 : 1);
                    String dimString = this.prop.getProperty("port" + (p + 1) + ".frameorg");
                    if (dimString != null) {
                        String str = dimString.substring(0, 1);
                        int col = Integer.parseInt(str);
                        str = dimString.substring(2, 3);
                        int row = Integer.parseInt(str);
                        port.setRowCol(row, col);
                    }
                    screen.addPort(port, p);
                    continue;
                }
                screen.addPort(new XPscreen.EmptyPort(), p);
            }
        }
        if (screen.getParent() instanceof XPdisplayArea) {
            XPdisplayArea xps = (XPdisplayArea)screen.getParent();
            xps.setProperties(this.prop);
            xps.setDataSet(data[0]);
        } else {
            System.err.println("no xpscreen!");
        }
    }

    protected void loadTags() {
        String tagStr = (String)this.prop.get("TAGS_TO_LOAD");
        this.tagList = BasicTemplate.getNeededTags();
    }

    public static DMTag[] getNeededTags() {
        DMTag[] dmTags = null;
        String[] tags = XpAnnotationManager.getNeededTags("CT", "");
        if (tags != null) {
            int len = tags.length;
            dmTags = new DMTag[len];
            for (int i = 0; i < len; ++i) {
                StringTokenizer st = new StringTokenizer(tags[i], ",");
                String groupStr = st.nextToken();
                String elemStr = st.nextToken();
                int group = Integer.parseInt(groupStr);
                int element = Integer.parseInt(elemStr);
                dmTags[i] = new DMTag(group, element);
            }
        }
        return dmTags;
    }

    protected void loadLayout(XPscreen screen) {
        String layout = this.prop.getProperty("layout");
        if (layout == null) {
            return;
        }
        screen.setLayout(new XPscreenLayout(layout));
    }
}

