/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.remote;

import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.jami.XpImageUtils;
import com.ge.med.terra.jami.XpLog;
import com.ge.med.terra.jami.XpMedicalImage;
import com.ge.med.terra.jami.XpSlice;
import com.ge.med.terra.jami.render.XpImageRenderAttributes;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmServiceAdapter;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import com.ge.med.terra.xpv.remote.ClientViewport;
import com.ge.med.terra.xpv.remote.DualImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class RemoteImage
extends XmServiceAdapter
implements XpMedicalImage {
    private DMObject dmoImage;
    private ClientViewport vp;
    private static XmSession xms;
    static Vector renderCommands;
    boolean isServer;
    private double[] minmax = new double[2];
    RenderedImage original;
    DualImage image_;
    XpImageRenderAttributes lastAttrib;
    boolean init;
    XpSlice slice;
    private double deflevel;
    private boolean loadedDefWL;
    private double defwidth;
    private boolean loadedDefWW;
    private double rescaleIntercept;
    private double rescaleSlope;
    private double azimuth;
    static long renderCommandID_;

    public RemoteImage(DMObject image, XmSession session, ClientViewport vp2) {
        this.vp = vp2;
        this.dmoImage = image;
        session.installHandle(this);
        xms = session;
    }

    public RemoteImage() {
    }

    @Override
    public int getValue(XpDicomElement value) {
        Object v;
        value.value = v = this.dmoImage.getValue(value.group, value.element);
        return v != null ? 0 : 1;
    }

    @Override
    public void setParent(XmSession client) {
        this.isServer = !client.isClient();
    }

    @Override
    public int readMessage(InputStream is) throws IOException {
        if (this.isServer) {
            System.out.println("RemoteImage.readMessage()");
            boolean count = false;
            byte[] idbuf = new byte[8];
            long id = Utils.readLong(is, idbuf);
            int pathLen = Utils.readInt(is, idbuf);
            byte[] pathArray = new byte[pathLen];
            Utils.readFully(is, pathArray);
            String path = new String(pathArray);
            int attriblen = Utils.readInt(is, idbuf);
            byte[] attribs = new byte[attriblen];
            ByteArrayInputStream bis = new ByteArrayInputStream(attribs);
            ObjectInputStream in = new ObjectInputStream(bis);
            try {
                XpImageRenderAttributes attrib = (XpImageRenderAttributes)in.readObject();
                System.out.println("RemoteImage.readMessage()" + attrib);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            return 16 + pathLen + attriblen;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeMessage(OutputStream os, short mid) throws IOException {
        System.out.println("RemoteImage.writeMessage()" + this.dmoImage.getID());
        RenderCommand cmd = null;
        Vector vector = renderCommands;
        synchronized (vector) {
            if (renderCommands.size() > 0) {
                cmd = (RenderCommand)renderCommands.elementAt(0);
                renderCommands.removeElementAt(0);
            }
        }
        if (cmd != null) {
            byte[] idarray = new byte[8];
            byte[] lenarray = new byte[4];
            byte[] imagePathLen = new byte[4];
            Utils.putLong(idarray, 0, cmd.id);
            os.write(idarray);
            byte[] pathB = this.dmoImage.getID().getBytes();
            Utils.putInt(imagePathLen, 0, pathB.length);
            os.write(imagePathLen);
            os.write(pathB);
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bos);
                out.writeObject(cmd);
                out.close();
                byte[] attribBuf = bos.toByteArray();
                Utils.putInt(lenarray, 0, attribBuf.length);
                os.write(lenarray);
                os.write(attribBuf);
                System.err.println("RemoteImage.writeMessage(): ends");
                return 16 + attribBuf.length + pathB.length;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int getValues(XpDicomElement[] values) {
        boolean filled = true;
        for (int j = 0; j < values.length; ++j) {
            Object v;
            values[j].value = v = this.dmoImage.getValue(values[j].group, values[j].element);
            if (v != null) continue;
            filled = false;
        }
        return filled ? 0 : 1;
    }

    @Override
    public double getAzimuth() {
        this.initImage();
        return this.azimuth;
    }

    @Override
    public double getDefaultWindowLevel() {
        this.initImage();
        if (!this.loadedDefWL) {
            int subsample = 16;
            if (this.slice.width <= 128 && this.slice.height <= 128) {
                subsample = 4;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.deflevel;
    }

    @Override
    public double getDefaultWindowWidth() {
        this.initImage();
        if (!this.loadedDefWW) {
            int subsample = 17;
            if (this.slice.width <= 128 && this.slice.height <= 128) {
                subsample = 5;
            }
            XpImageUtils.getMinMax(this, subsample, this.minmax);
            double min = this.minmax[0];
            double max = this.minmax[1];
            double ww = max - min;
            double wl = (max + min) / 2.0;
            this.defwidth = ww;
            this.deflevel = wl;
            this.loadedDefWL = true;
            this.loadedDefWW = true;
        }
        return this.defwidth;
    }

    @Override
    public RenderedImage getPixelData() {
        this.initImage();
        if (this.image_ == null) {
            this.image_ = new DualImage(1, 1, 2);
        }
        System.out.println("RemoteImage.getPixelData()" + this.dmoImage.getID());
        return this.image_;
    }

    @Override
    public double getPixelDimensionX() {
        return this.getSlice().pixelSizeX;
    }

    @Override
    public double getPixelDimensionY() {
        return this.getSlice().pixelSizeY;
    }

    @Override
    public double getRescaleIntercept() {
        this.initImage();
        return this.rescaleIntercept;
    }

    @Override
    public double getRescaleSlope() {
        this.initImage();
        return this.rescaleSlope;
    }

    @Override
    public XpSlice getSlice() {
        this.initImage();
        return this.slice;
    }

    protected void initImage() {
        StringTokenizer st;
        String snum;
        StringTokenizer st2;
        if (this.init) {
            return;
        }
        this.slice = new XpSlice(this);
        Object obj = this.dmoImage.getValue(40, 4176);
        if (obj instanceof String) {
            st2 = new StringTokenizer((String)obj, "\\");
            try {
                this.deflevel = (int)Float.parseFloat(st2.nextToken());
                this.loadedDefWL = true;
            }
            catch (Exception e) {
                XpLog.warning("Invalid tag in image (0x0028,0x1050)");
            }
        } else if (obj instanceof Integer) {
            this.deflevel = ((Integer)obj).intValue();
            this.loadedDefWL = true;
        }
        if ((obj = this.dmoImage.getValue(40, 4177)) instanceof String) {
            st2 = new StringTokenizer((String)obj, "\\");
            try {
                this.defwidth = (int)Float.parseFloat(st2.nextToken());
                this.loadedDefWW = true;
            }
            catch (Exception e) {
                XpLog.warning("Invalid tag in image (0x0028,0x1051)");
            }
        } else if (obj instanceof Integer) {
            this.defwidth = ((Integer)obj).intValue();
            this.loadedDefWW = true;
        }
        if ((obj = this.dmoImage.getValue(40, 4178)) instanceof String) {
            snum = (String)obj;
            if (snum.length() <= 0) {
                snum = "0";
            }
            st = new StringTokenizer(snum, "\\");
            try {
                this.rescaleIntercept = Double.parseDouble(st.nextToken());
            }
            catch (Exception e) {
                XpLog.warning("Invalid tag in image (0x0028,0x1052)");
            }
        } else if (obj instanceof Number) {
            this.rescaleIntercept = ((Number)obj).doubleValue();
        }
        if ((obj = this.dmoImage.getValue(40, 4179)) instanceof String) {
            snum = (String)obj;
            if (snum.length() <= 0) {
                snum = "1";
            }
            st = new StringTokenizer(snum, "\\");
            try {
                this.rescaleSlope = Double.parseDouble(st.nextToken());
            }
            catch (Exception e) {
                XpLog.warning("Invalid tag in image (0x0028,0x1053)");
            }
        } else if (obj instanceof Number) {
            this.rescaleSlope = ((Number)obj).doubleValue();
        }
        if (this.rescaleSlope == 0.0) {
            this.rescaleSlope = 1.0;
        }
        this.azimuth = XpImageUtils.gehcAzimuth(this);
        this.init = true;
    }

    public BufferedImage getRenderedImage() {
        return null;
    }

    public void setPixelData(BufferedImage clientImage_) {
        this.image_.setSurrogateImage(clientImage_);
    }

    static {
        renderCommands = new Vector();
        renderCommandID_ = 0L;
    }

    static class RenderCommand {
        XpImageRenderAttributes ra;
        long id;

        public RenderCommand(long id, XpImageRenderAttributes attrib) {
            this.id = id;
            this.ra = attrib;
        }
    }
}

