/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.remote;

import com.ge.med.idc.TaskMonitor;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dmui.DmuBrowser;
import com.ge.med.terra.tap.dmui.table.DmuTableHeaderRenderer;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import com.ge.med.terra.xpv.laf.LafUtils;
import com.ge.med.terra.xpv.remote.BaseFrame;
import com.ge.med.terra.xpv.remote.Viewer2D;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class RemoteBrowser
extends JPanel {
    DmuBrowser jPexams = new DmuBrowser();
    JPanel launchBar = new JPanel();
    BaseFrame base;
    String remote;
    JButton launch2d = new JButton("2D Viewer");
    public static Cursor WAIT_CURSOR = new Cursor(3);
    public static Cursor DEFAULT_CURSOR = new Cursor(0);
    boolean SeriesLevelOk = true;

    public RemoteBrowser() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.jPexams, "Center");
        this.add((Component)this.launchBar, "South");
        this.launchBar.add(this.launch2d);
        this.launch2d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RemoteBrowser.this.start3DPort();
            }
        });
        DmuTableHeaderRenderer.TableHeaderRendererConfig hdr_cfg = new DmuTableHeaderRenderer.TableHeaderRendererConfig(){

            @Override
            public void configButton(JButton jButton, boolean sort, boolean down, boolean pressed) {
                LafUtils.installButtonGroupBorder(new JComponent[]{null, jButton, null}, 1, 3, true);
                jButton.getModel().setPressed(pressed);
                jButton.getModel().setArmed(pressed);
            }
        };
        this.jPexams.jtab1.setTableHeaderModifier(hdr_cfg);
        this.jPexams.jtab2.setTableHeaderModifier(hdr_cfg);
        this.jPexams.jtab3.setTableHeaderModifier(hdr_cfg);
        ListSelectionModel sm = this.jPexams.jtab2.getSelectionModel();
        sm.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                RemoteBrowser.this.validateSelection(e);
            }
        });
        this.jPexams.addTaskMonitor(new TaskMonitor(){

            @Override
            public void taskBegin(String taskName, int totalWork) {
                RemoteBrowser.this.jPexams.setCursor(WAIT_CURSOR);
                System.out.println("taskDone=" + taskName);
            }

            @Override
            public void taskDone(String taskName) {
                RemoteBrowser.this.jPexams.setCursor(DEFAULT_CURSOR);
            }

            @Override
            public void taskProgress(String taskName, int units) {
            }

            @Override
            public void taskFailed(String taskName, String reason, Exception e) {
            }
        });
    }

    public void validateSelection(ListSelectionEvent e) {
        this.launch2d.setEnabled(true);
    }

    public void setBase(BaseFrame base) {
        this.base = base;
    }

    public DMObject getSelection() {
        return this.jPexams.getSelection()[0];
    }

    public void setup(String remote) {
        this.remote = System.getProperty("remote.xmserver", "localhost:5248");
        String dir = "/images/pesi/images";
        String[] args = new String[]{"remote", this.remote, "pesi", dir};
        DMSession dms = new DMSession(args);
        System.out.println("dms = " + dms);
        dms.send("PCACHE=(0x10,0x10) AND (0x10,0x0020) AND (0x0020,0x0010) AND (0x0008,0x0020) AND (0x0008,0x1030)");
        dms.send("ECACHE=(0x10,0x10) AND (0x10,0x30) AND (0x10,0x0020) AND (0x0020,0x0011) AND (0x0008,0x1030) AND (0x0008,0x0020) AND (0x0020,0x10)");
        dms.send("SCACHE=(0x0020,0x0011) AND (0x8,0x0008) AND (0x25,0x1007) AND (0x8,0x103E) AND (0x8,0x60) AND (0x0008,0x0070)");
        dms.send("ICACHE=(0x0020,0x0013) AND (0x0020,0x1041) AND (0x0018,0x050) AND (0x008,0x32) AND (0x0028,0x0030) AND (0x0008,0x0060) AND (0x0054,0x0410)");
        this.jPexams.setDB(dms);
    }

    public void start3DPort() {
        if (this.base == null) {
            System.err.println("base = null");
            return;
        }
        final Viewer2D viewerPane = new Viewer2D();
        final DMObject dmo = this.getSelection();
        this.base.addTab(viewerPane, "2D " + dmo.getValue(16, 16) + " ");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                viewerPane.setDataset(XmSession.factory(RemoteBrowser.this.remote), dmo);
            }
        });
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("RemoteBrowser");
        RemoteBrowser p = new RemoteBrowser();
        f.setContentPane(p);
        f.setDefaultCloseOperation(3);
        f.setBounds(10, 10, 512, 512);
        f.setVisible(true);
        p.jPexams.setDB(new DMSession(new String[]{"pesi", "D:\\dev\\images\\pesi"}));
    }
}

