/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.onport;

import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.terra.xpv.laf.LafUtils;
import com.ge.med.terra.xpv.onport.XPopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BoundedRangeModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XPoppScrollBar
extends XPopPanel
implements ActionListener {
    public static final String NO_SKIP_MODE = "NO_SKIP_MODE";
    public static final String SCROLL_VALUE = "SCROLL_VALUE";
    public FramePositioningCapable port;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    boolean enabled = true;
    Timer adjustScrollBar = new Timer(100, this);
    JPanel panel = new JPanel(new FlowLayout(1));
    JSlider frameCtl = new JSlider();
    Icon noSkipIcon = new ImageIcon(XPoppScrollBar.class.getResource("no_skip.png"));
    JToggleButton noSkipBtn = new JToggleButton(this.noSkipIcon){

        @Override
        public Insets getMargin() {
            return new Insets(0, 0, 0, 0);
        }
    };
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "FrameIndex") {
                XPoppScrollBar.this.updateSlider();
            }
        }
    };

    public XPoppScrollBar() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.adjustScrollBar.setRepeats(false);
        this.setStayOnMouseEnter(true);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.frameCtl.setOrientation(1);
        this.frameCtl.setOpaque(false);
        int size = Math.max(this.noSkipIcon.getIconWidth(), this.noSkipIcon.getIconHeight());
        this.noSkipBtn.setPreferredSize(new Dimension(size + 2, size + 2));
        Border b = LafUtils.createRaisedBorder();
        if (b != null) {
            this.noSkipBtn.setBorder(b);
        }
        this.noSkipBtn.setToolTipText("Turn on No-Skip");
        this.noSkipBtn.setFocusPainted(false);
        this.panel.add(this.noSkipBtn);
        this.panel.setOpaque(false);
        this.add((Component)this.frameCtl, "Center");
        this.add((Component)this.panel, "North");
        this.setPreferredSize(new Dimension(30, 300));
        this.setMinimumSize(new Dimension(20, 150));
        this.setOpaque(false);
        this.frameCtl.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() == XPoppScrollBar.this.frameCtl) {
                    XPoppScrollBar.this.updatePort();
                }
            }
        });
        this.frameCtl.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((JComponent)((Object)XPoppScrollBar.this.port)).putClientProperty("continousPlay", Boolean.TRUE);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ((JComponent)((Object)XPoppScrollBar.this.port)).putClientProperty("continousPlay", Boolean.FALSE);
                if (XPoppScrollBar.this.noSkipBtn.isSelected()) {
                    XPoppScrollBar.this.adjustScrollBar.restart();
                }
                XPoppScrollBar.this.port.repaint();
            }
        });
        this.noSkipBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isSelected = ((JToggleButton)e.getSource()).isSelected();
                ((JComponent)((Object)XPoppScrollBar.this.port)).putClientProperty(XPoppScrollBar.NO_SKIP_MODE, isSelected);
                if (isSelected) {
                    Border b = LafUtils.createLoweredBorder();
                    if (b != null) {
                        XPoppScrollBar.this.noSkipBtn.setBorder(b);
                    }
                    XPoppScrollBar.this.noSkipBtn.setToolTipText("Turn off No-Skip");
                } else {
                    Border b = LafUtils.createRaisedBorder();
                    if (b != null) {
                        XPoppScrollBar.this.noSkipBtn.setBorder(b);
                    }
                    XPoppScrollBar.this.noSkipBtn.setToolTipText("Turn on No-Skip");
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enabled = enabled;
    }

    @Override
    public void fire() {
        if (this.enabled) {
            super.fire();
        }
    }

    @Override
    public final void removePropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(propName, pcl);
    }

    @Override
    public final void addPropertyChangeListener(String propName, PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(propName, pcl);
    }

    @Override
    public void setCapable(Capable capable) {
        CineCapable cine;
        if (capable instanceof FramePositioningCapable) {
            this.port = (FramePositioningCapable)capable;
            this.updateSlider();
            this.port.addPropertyChangeListener(this.viewPortListener);
        }
        if ((cine = (CineCapable)capable.getCapable("com.ge.med.idc.CineCapable")) != null) {
            cine.addPropertyChangeListener("Cine", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    XPoppScrollBar.this.setEnabled((Boolean)evt.getNewValue() == false);
                }
            });
        }
    }

    void updateSlider() {
        if (this.port == null) {
            return;
        }
        int n = this.port.getNumFrames();
        BoundedRangeModel model = this.frameCtl.getModel();
        int newSliderValue = n - this.port.getFrameIndex();
        this.frameCtl.getModel().setRangeProperties(newSliderValue, 0, 1, n, model.getValueIsAdjusting());
    }

    void updatePort() {
        int id = this.port.getNumFrames() - this.frameCtl.getValue();
        if (this.noSkipBtn.isSelected()) {
            int diff = id - this.port.getFrameIndex();
            if (diff != 0) {
                int newFrameIndex = this.port.getFrameIndex() + (diff > 0 ? 1 : -1);
                this.port.setFrameIndex(newFrameIndex);
                this.fire();
            }
        } else if (id != this.port.getFrameIndex()) {
            this.port.setFrameIndex(id);
        }
    }

    @Override
    public boolean isSupported(Capable capable) {
        return capable instanceof FramePositioningCapable;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateSlider();
        this.adjustScrollBar.stop();
        this.frameCtl.updateUI();
    }
}

