/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.onport;

import com.ge.med.idc.Capable;
import com.ge.med.idc.OnPortControl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.Beans;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public abstract class XPopPanel
extends JPanel
implements OnPortControl {
    int uiLevel;
    Timer timer2 = null;
    static int maxValue = 120;
    private static int backGroundR = 100;
    private static int backGroundG = 128;
    private static int backGroundB = 180;
    static int minDecayRate = 20;
    static int maxDecayRate = 50;
    static int startDelay = 50;
    private boolean firstTime = true;
    protected int level = 0;
    boolean in_ = false;
    int goAwayRate = maxDecayRate;
    long lastEvent;
    long firstEvent;
    Rectangle bounds = new Rectangle();
    protected boolean ctlAdded = false;
    protected Component listenTo = null;
    MouseInputListener mouseAdapter = new MouseInputAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            XPopPanel.this.this_mouseMoved(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getSource() == XPopPanel.this) {
                XPopPanel.this.this_mouseMoved(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            XPopPanel.this.this_mouseMoved(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            XPopPanel.this.this_mouseMoved(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            XPopPanel.this.this_mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            XPopPanel.this.this_mouseReleased(e);
        }
    };
    private boolean setStayOnMouseEnter_ = false;

    public static void setProperties(Properties prop) {
        String value = prop.getProperty("minDecayRate");
        if (value != null) {
            minDecayRate = Integer.parseInt(value);
        }
        if ((value = prop.getProperty("maxValue")) != null) {
            maxValue = Integer.parseInt(value);
        }
        if ((value = prop.getProperty("backGroundR")) != null) {
            XPopPanel.setBackGroundR(Integer.parseInt(value));
        }
        if ((value = prop.getProperty("backGroundG")) != null) {
            XPopPanel.setBackGroundG(Integer.parseInt(value));
        }
        if ((value = prop.getProperty("backGroundB")) != null) {
            XPopPanel.setBackGroundB(Integer.parseInt(value));
        }
        if ((value = prop.getProperty("maxDecayRate")) != null) {
            maxDecayRate = Integer.parseInt(value);
        }
        if ((value = prop.getProperty("startDelay")) != null) {
            startDelay = Integer.parseInt(value);
        }
    }

    public XPopPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (XPopPanel.this.firstTime) {
                    XPopPanel.this.firstTime = false;
                    XPopPanel.this.addMouseListeners();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.displayLevel(0);
    }

    private void addMouseListeners() {
        this.realAddMouseListeners(this);
    }

    private void realAddMouseListeners(JComponent comp) {
        comp.addMouseListener(this.mouseAdapter);
        comp.addMouseMotionListener(this.mouseAdapter);
        Component[] children = comp.getComponents();
        int len = children.length;
        for (int i = 0; i < len; ++i) {
            this.realAddMouseListeners((JComponent)children[i]);
        }
    }

    public int getLevel() {
        return this.level;
    }

    protected void displayLevel(int level) {
        this.level = level;
        if (Beans.isDesignTime()) {
            return;
        }
        Color c = new Color(XPopPanel.getBackGroundR(), XPopPanel.getBackGroundG(), XPopPanel.getBackGroundB(), level);
        this.setVisible(level > 0);
        this.setBackground(c);
    }

    public void fire() {
        this.goAwayRate -= 20;
        if (this.goAwayRate < minDecayRate) {
            this.goAwayRate = minDecayRate;
        }
        if (this.timer2 == null) {
            this.timer2 = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int value;
                    XPopPanel.this.uiLevel = XPopPanel.this.uiLevel - (XPopPanel.this.setStayOnMouseEnter_ && XPopPanel.this.in_ ? 0 : XPopPanel.this.goAwayRate);
                    if (XPopPanel.this.uiLevel <= 0) {
                        XPopPanel.this.timer2.stop();
                        XPopPanel.this.uiLevel = 0;
                        XPopPanel.this.firstEvent = 0L;
                    }
                    int n = !XPopPanel.this.setStayOnMouseEnter_ || !XPopPanel.this.in_ ? (XPopPanel.this.uiLevel > 100 ? maxValue : maxValue * XPopPanel.this.uiLevel / 100) : (value = maxValue);
                    if (value == 0) {
                        XPopPanel.this.goAwayRate = maxDecayRate;
                    }
                    XPopPanel.this.displayLevel(value);
                }
            });
        }
        this.uiLevel = 255;
        this.displayLevel(maxValue);
        this.timer2.setDelay(100);
        this.timer2.setRepeats(true);
        this.timer2.start();
    }

    protected void this_mouseMoved(MouseEvent e) {
        Point popPt = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this);
        this.in_ = this.contains(popPt);
        if (e.getWhen() - this.lastEvent < 2000L && e.getWhen() - this.firstEvent > (long)startDelay) {
            if (e.getSource() == this) {
                this.fire();
            } else if (e.getSource() == this.listenTo && this.getBounds(this.bounds).contains(e.getX(), e.getY())) {
                this.fire();
            }
        }
        if (this.firstEvent == 0L) {
            this.firstEvent = e.getWhen();
        }
        this.lastEvent = e.getWhen();
    }

    private void jbInit() throws Exception {
        this.setPreferredSize(new Dimension(140, 80));
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    public void setPort(JComponent c) {
        this.listenTo = c;
        if (c != null) {
            c.addMouseMotionListener(this.mouseAdapter);
            c.addMouseListener(this.mouseAdapter);
            this.ctlAdded = true;
            if (c instanceof Capable) {
                this.setCapable((Capable)((Object)c));
            }
        }
    }

    @Override
    public void listenTo(Component c) {
        this.listenTo = c;
        c.addMouseMotionListener(this.mouseAdapter);
        c.addMouseListener(this.mouseAdapter);
        this.ctlAdded = true;
    }

    @Override
    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    @Override
    public void paintChildren(Graphics g) {
        if (this.getBackground().getAlpha() == 0) {
            return;
        }
        super.paintChildren(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        g.setColor(this.getBackground());
        g.fillRoundRect(2, 2, this.getWidth() - 2, this.getHeight() - 2, 20, 20);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.level == 0) {
            return false;
        }
        return super.contains(x, y);
    }

    @Override
    public void setCapable(Capable capable) {
    }

    protected void this_mousePressed(MouseEvent e) {
    }

    protected void this_mouseReleased(MouseEvent e) {
    }

    public abstract boolean isSupported(Capable var1);

    public Rectangle getActivationBounds(Rectangle rv) {
        rv = this.getBounds(rv);
        rv.x -= 10;
        rv.y -= 10;
        rv.width += 20;
        rv.height += 20;
        return rv;
    }

    public static void setBackGroundR(int backGroundR) {
        XPopPanel.backGroundR = backGroundR;
    }

    public static int getBackGroundR() {
        return backGroundR;
    }

    public static void setBackGroundG(int backGroundG) {
        XPopPanel.backGroundG = backGroundG;
    }

    public static int getBackGroundG() {
        return backGroundG;
    }

    public static void setBackGroundB(int backGroundB) {
        XPopPanel.backGroundB = backGroundB;
    }

    public static int getBackGroundB() {
        return backGroundB;
    }

    public final void setStayOnMouseEnter(boolean b) {
        this.setStayOnMouseEnter_ = b;
    }
}

