/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.laf;

import com.ge.med.terra.xpv.laf.AbstractNumberedThumSliderUI;
import com.ge.med.terra.xpv.laf.Title;
import com.ge.med.terra.xpv.laf.ptk.PtkUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class LafUtils {
    private LafUtils() {
    }

    public static void antiAlias(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, g.getFont().getSize() >= 12 ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    public static void handleVersionQuery(String[] argv, String version2) {
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].equals("-version") && !argv[i].equals("-v")) continue;
            System.out.println(version2);
            System.exit(0);
        }
    }

    public static Dimension getUIPropertyDimension(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Dimension) {
            return (Dimension)value;
        }
        value = UIManager.get(key);
        if (value instanceof Dimension) {
            return (Dimension)value;
        }
        return null;
    }

    public static int getUIPropertyInt(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Integer) {
            return (Integer)value;
        }
        value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return 0;
    }

    public static final void setupLAF() {
        System.err.print("LAF set up ....");
        String defaultLaf = System.getProperty("swing.defaultlaf");
        if (defaultLaf == null) {
            if (LafUtils.setupLAFclass("com.ge.med.iungo.laf.HDxLightsOnLookAndFeel")) {
                System.out.println("Look and Feel set to IUNGO");
                return;
            }
            if (LafUtils.setupLAFclass("com.ge.med.ptk.laf.CuiLookAndFeel")) {
                System.out.println("Look and Feel set to PTK");
                return;
            }
        }
    }

    private static boolean setupLAFclass(String className) {
        try {
            Class.forName(className);
            UIManager.setLookAndFeel(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Border getUIPropertyBorder(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Border) {
            return (Border)value;
        }
        value = UIManager.get(key);
        if (value instanceof Border) {
            return (Border)value;
        }
        return null;
    }

    public static Insets getUIPropertyInsets(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Insets) {
            return (Insets)value;
        }
        value = UIManager.get(key);
        if (value instanceof Insets) {
            return (Insets)value;
        }
        return null;
    }

    public static boolean getUIPropertyBoolean(JComponent component, String key) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Boolean) {
            return (Boolean)value;
        }
        value = UIManager.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public static Color getUIPropertyColor(JComponent component, String key) {
        return LafUtils.getUIPropertyColor(component, key, null);
    }

    public static Color getUIPropertyColor(JComponent component, String key, Color fallback) {
        Object value;
        if (component != null && (value = component.getClientProperty(key)) instanceof Color || (value = UIManager.get(key)) instanceof Color) {
            return (Color)value;
        }
        return fallback;
    }

    public static void installButtonBorder(JComponent c, boolean top, boolean left, boolean bottom, boolean right) {
        if (LafUtils.isPtkInstalled()) {
            c.setBorder(PtkUtils.createPtkButtonBorder((boolean)top, (boolean)left, (boolean)bottom, (boolean)right));
        }
    }

    public static Border createButtonBorder(boolean top, boolean left, boolean bottom, boolean right) {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.createPtkButtonBorder((boolean)top, (boolean)left, (boolean)bottom, (boolean)right);
        }
        return null;
    }

    private static final boolean isPtkInstalled() {
        return UIManager.getLookAndFeel().getName().indexOf("CUI") >= 0;
    }

    public static Border createRaisedBorder() {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.createRaisedBorder();
        }
        return BorderFactory.createRaisedBevelBorder();
    }

    public static Border createLoweredBorder() {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.createLoweredBorder();
        }
        return BorderFactory.createLoweredBevelBorder();
    }

    public static void installButtonGroupBorder(JComponent[] components, int rows, int cols, boolean roundedBorder) {
        if (LafUtils.isPtkInstalled()) {
            if (!roundedBorder) {
                Border b = PtkUtils.createPtkButtonBorder((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                for (int i = 0; i < components.length; ++i) {
                    components[i].setBorder(b);
                }
                return;
            }
            for (int row = 0; row < rows; ++row) {
                for (int col = 0; col < cols; ++col) {
                    boolean t = row == 0;
                    boolean b = row == rows - 1;
                    boolean l = col == 0;
                    boolean r = col == cols - 1;
                    Border border = PtkUtils.createPtkButtonBorder((boolean)t, (boolean)l, (boolean)b, (boolean)r);
                    int i = row * cols + col;
                    if (components[i] == null) continue;
                    components[i].setBorder(border);
                }
            }
        }
    }

    public static void installToolButtonBorder(JComponent c) {
        if (LafUtils.isPtkInstalled()) {
            Border b = PtkUtils.createToolButtonBorder();
            c.setBorder(b);
        }
    }

    public static void showComponent(JComponent comp) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setContentPane(comp);
        f.pack();
        f.setVisible(true);
    }

    public static void installButtonBorder1(AbstractButton button) {
        if (LafUtils.isPtkInstalled()) {
            button.setBorder(PtkUtils.createPtkButtonBorder1());
        } else {
            button.setBorder(UIManager.getBorder("Button.border"));
        }
    }

    public static Border createInternalBorder() {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.createCuiInternalBorder();
        }
        return new EmptyBorder(0, 0, 0, 0);
    }

    public static void installBorderLessTabbedPaneUI(JTabbedPane jTabbedPane) {
        if (LafUtils.isPtkInstalled()) {
            jTabbedPane.setUI(PtkUtils.createBorderlessTabbedPaneUI());
        }
    }

    public static Border createSideButtonBorder(int side) {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.createSideBorder((int)side);
        }
        return new BevelBorder(0);
    }

    public static String getRowColComboUIClassName() {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.getRowColComboUIClassName();
        }
        return BasicComboBoxUI.class.getName();
    }

    public static AbstractNumberedThumSliderUI getNumberedThumbSliderUI() {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.createNumberThumbSliderUI();
        }
        return new DefaultNumberedThumbSliderUI();
    }

    public static Border[][] getStaticBorder(boolean cbb) {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.getPtkStaticBorder((boolean)cbb);
        }
        return null;
    }

    public static Border getPaletteComboButtonBorder(boolean left, Border[][] staticBorders, boolean borderline) {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.getPaletteComboButtonBorder((boolean)left, (Border[][])staticBorders, (boolean)borderline);
        }
        return null;
    }

    public static Title getSubTitleBorder(String title) {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.createSubTitleBorder((String)title);
        }
        return new DefaultTitledBorder(title);
    }

    public static Title getSubTitleBorder() {
        return LafUtils.getSubTitleBorder("");
    }

    public static Title createTitlePanelBorder(boolean square, int alignment) {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.createTitlePanelBorder((boolean)square, (int)alignment);
        }
        return new DefaultTitledBorder();
    }

    public static Insets getSoftInsets(Border border) {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.getSoftInsets((Border)border);
        }
        return new Insets(0, 0, 0, 0);
    }

    public static int getComboButtonTop(Border b) {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.getComboButtonTop((Border)b);
        }
        return 0;
    }

    public static int getComboButtonBottom(Border b) {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.getComboButtonBottom((Border)b);
        }
        return 0;
    }

    public static int getComboButtonRight(Border b) {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.getComboButtonRight((Border)b);
        }
        return 0;
    }

    public static Border createFrameBorder(int width) {
        if (LafUtils.isPtkInstalled()) {
            return PtkUtils.createFrameBorder((int)width);
        }
        return BorderFactory.createLineBorder(Color.BLACK, width);
    }

    public static void installTreeCellRenderer(JTree tree) {
        if (LafUtils.isPtkInstalled()) {
            tree.setCellRenderer(PtkUtils.getTreeCellRenderer());
        }
    }

    private static class DefaultTitledBorder
    extends TitledBorder
    implements Title {
        public DefaultTitledBorder(String title) {
            super(title);
        }

        public DefaultTitledBorder() {
            super("");
        }
    }

    private static class DefaultNumberedThumbSliderUI
    extends BasicSliderUI
    implements AbstractNumberedThumSliderUI {
        public DefaultNumberedThumbSliderUI() {
            super(null);
        }

        @Override
        public Rectangle getThumbRect() {
            return this.thumbRect;
        }

        @Override
        public Rectangle getTrackRect() {
            return this.trackRect;
        }

        @Override
        public int getTrackWidth() {
            double kIdealTrackWidth = 7.0;
            double kIdealThumbHeight = 16.0;
            double kWidthScalar = 0.4375;
            if (this.slider.getOrientation() == 0) {
                return (int)(0.4375 * (double)this.thumbRect.height);
            }
            return (int)(0.4375 * (double)this.thumbRect.width);
        }

        @Override
        public int xPositionForValue(int v) {
            return super.xPositionForValue(v);
        }

        @Override
        public int yPositionForValue(int v) {
            return super.yPositionForValue(v);
        }
    }
}

