/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.jfc;

import com.ge.med.terra.tap.util.er.EREvent;
import com.ge.med.terra.tap.util.er.EREventListener;
import com.ge.med.terra.tap.util.er.EventRouter;
import com.ge.med.terra.xpv.jfc.FilmPage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public class JFCServer {
    public static final int PORT_NUM = 10005;
    ServerSocket listen;
    File FilmDir;
    File PageSetup;
    static EventRouter er;
    JFrame frame = null;
    int currentPageRow = 1;
    int currentPageCol = 1;
    FilmPage currentPage;
    File pageFile;
    File tempPageFile;
    FileOutputStream pageOutputStream;
    FileInputStream pageInputStream;
    LinkedList pageList = new LinkedList();
    boolean FilmComposerUp = false;

    public JFCServer() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            userHome = System.getProperty("user.dir");
        }
        this.FilmDir = new File(userHome, "jfc");
        this.pageFile = new File(this.FilmDir, "pageFile");
        this.tempPageFile = new File(this.FilmDir, "tempPageFile");
        if (this.FilmDir.exists() && this.pageFile.exists()) {
            this.readPages();
        } else {
            this.FilmDir.mkdir();
            FilmPage startPage = new FilmPage();
            this.pageList.add(startPage);
            System.err.println("FilmDir.name===" + this.FilmDir.getAbsolutePath());
            System.err.println("pageFile====" + this.pageFile.getAbsolutePath());
            this.currentPage = startPage;
            this.writePages();
        }
        this.setupEvents();
        try {
            this.listen = new ServerSocket(10005);
            System.err.println("server started");
            while (true) {
                this.connect(this.listen.accept());
            }
        }
        catch (IOException ex) {
            System.out.println("Exception..." + ex);
            return;
        }
    }

    private void writePages() {
        try {
            if (this.tempPageFile.exists()) {
                this.tempPageFile.delete();
            }
            this.tempPageFile.createNewFile();
            this.pageOutputStream = new FileOutputStream(this.tempPageFile);
            PrintStream pw = new PrintStream(this.pageOutputStream);
            pw.println(this.pageList.indexOf(this.currentPage));
            pw.println(this.pageList.size());
            for (int i = 0; i < this.pageList.size(); ++i) {
                ((FilmPage)this.pageList.get(i)).writeThis(pw);
            }
            this.pageOutputStream.close();
            if (this.pageFile.exists()) {
                this.pageFile.delete();
            }
            this.tempPageFile.renameTo(this.pageFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void readPages() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(this.pageFile)));
            this.pageList.clear();
            int currentPageIndex = Integer.parseInt(br.readLine());
            int numPages = Integer.parseInt(br.readLine());
            for (int i = 0; i < numPages; ++i) {
                FilmPage page = new FilmPage();
                page.readThis(br);
                this.pageList.add(page);
            }
            br.close();
            this.currentPage = (FilmPage)this.pageList.get(currentPageIndex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setupEvents() {
        try {
            EventRouter.startServer(5879);
        }
        catch (Exception e) {
            // empty catch block
        }
        er = EventRouter.createClient();
        er.connect("127.0.0.1", 5879);
        EREventListener cl = new EREventListener(){

            @Override
            public void event(EREvent[] e) {
                for (int i = 0; i < e.length; ++i) {
                    if (e[i].getType().equals("CurrentPage")) {
                        int currentPageIndex = Integer.parseInt(e[i].getMessageAsString());
                        JFCServer.this.currentPage = (FilmPage)JFCServer.this.pageList.get(currentPageIndex);
                        continue;
                    }
                    if (!e[i].getType().equals("Reload")) continue;
                    JFCServer.this.readPages();
                }
            }
        };
        er.addEREventListener("Reload", 0, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(Socket s) {
        System.out.println("connection");
        try {
            String request;
            BufferedReader is = new BufferedReader(new InputStreamReader(s.getInputStream()));
            DataOutputStream os = new DataOutputStream(s.getOutputStream());
            while ((request = is.readLine()) != null) {
                String status = this.proceess(request);
                System.err.println("status===" + status);
                os.writeBytes(status + "\n");
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                s.close();
            }
            catch (IOException ex) {}
        }
    }

    private String proceess(String request) {
        try {
            System.err.println("request====" + request);
            StringTokenizer st = new StringTokenizer(request, "|");
            if (st.countTokens() == 2) {
                if (st.nextToken().equals("Print_Image")) {
                    String fileName = st.nextToken();
                    File imageFile = File.createTempFile("scimage", "dcm", this.FilmDir);
                    imageFile.delete();
                    File oldFile = new File(fileName);
                    System.err.println("oldFile.name===" + oldFile.getAbsolutePath());
                    boolean rename = oldFile.renameTo(new File(imageFile.getAbsolutePath()));
                    System.err.println("rename==" + rename);
                    System.err.println("imageFile.name===" + imageFile.getAbsolutePath());
                    System.err.println("currentPage index====" + this.pageList.indexOf(this.currentPage));
                    if (this.currentPage.isFull()) {
                        FilmPage lastPage = (FilmPage)this.pageList.getLast();
                        if (lastPage.isFull()) {
                            FilmPage addedPage = new FilmPage();
                            addedPage.addImage(imageFile.getAbsolutePath(), 0, 0);
                            this.pageList.addLast(addedPage);
                            this.currentPage = addedPage;
                        } else {
                            lastPage.addImage(imageFile.getAbsolutePath());
                            this.currentPage = lastPage;
                        }
                    } else {
                        System.err.println("adding images to currentPage... index===" + this.pageList.indexOf(this.currentPage));
                        this.currentPage.addImage(imageFile.getAbsolutePath());
                    }
                    this.writePages();
                    er.sendEvent("Reload", Integer.toString(this.pageList.indexOf(this.currentPage)));
                    this.printPages();
                    System.err.println("sending...Print_Image_Success");
                    return "Print_Image_Success";
                }
                if (st.nextToken().equals("Set_RowCol")) {
                    return "Set_RowCol_Success";
                }
                if (st.nextToken().equals("Next_Page")) {
                    return "Next_Page_Success";
                }
            } else {
                String token;
                if (st.countTokens() == 1) {
                    String token2 = st.nextToken();
                    if (token2.equals("Print_Pages")) {
                        this.printPages();
                    } else if (token2.equals("Show_FilmComposer")) {
                        this.showFilmComposer();
                    }
                    return "unknown";
                }
                if (st.countTokens() == 4 && (token = st.nextToken()).equals("Drop_Image")) {
                    String fileName = st.nextToken();
                    File imageFile = File.createTempFile("scimage", "dcm", this.FilmDir);
                    imageFile.delete();
                    File oldFile = new File(fileName);
                    oldFile.renameTo(new File(imageFile.getAbsolutePath()));
                    int row = Integer.parseInt(st.nextToken());
                    int col = Integer.parseInt(st.nextToken());
                    if (this.currentPage.addImage(imageFile.getAbsolutePath(), row, col)) {
                        this.writePages();
                        er.sendEvent("Reload", Integer.toString(this.pageList.indexOf(this.currentPage)));
                    } else {
                        new File(imageFile.getAbsolutePath()).delete();
                    }
                    return "Drop_Image_Success";
                }
            }
            return "unknown";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Exception: " + ex);
            return null;
        }
    }

    private void showFilmComposer() {
        if (!this.FilmComposerUp) {
            String cp = System.getProperty("java.class.path");
            String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            String str = java + " -Xmx100m  -cp \"" + cp + "\" com.ge.med.terra.xpv.jfc.JavaFilmComposer";
            try {
                System.err.println("starting str==" + str);
                Process p = Runtime.getRuntime().exec(str);
                p.waitFor();
                int status = p.exitValue();
                this.FilmComposerUp = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void printPages() {
        Iterator it = this.pageList.iterator();
        int i = 0;
        while (it.hasNext()) {
            FilmPage pg = (FilmPage)it.next();
            System.err.println("printing page[" + i + "]");
            pg.print();
            ++i;
        }
    }

    public static void main(String[] args) {
        JFCServer JFCServer1 = new JFCServer();
    }
}

