/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.cuiPanels;

import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.XpDicomElement;
import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.autoControls.XPwInvertControl;
import com.ge.med.terra.xpv.autoControls.XPwPresetGroupControl;
import com.ge.med.terra.xpv.autoControls.XPwWinMaxField;
import com.ge.med.terra.xpv.autoControls.XPwWinMinField;
import com.ge.med.terra.xpv.autoControls.XPwWindowLevelSpinner;
import com.ge.med.terra.xpv.autoControls.XPwWindowWidthSpinner;
import com.ge.med.terra.xpv.base.ViewportContext;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelResources;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelUtils;
import com.ge.med.terra.xpv.cuiPanels.ListDataModel;
import com.ge.med.terra.xpv.cuiPanels.PresetEditorPanel;
import com.ge.med.terra.xpv.cuiPanels.PresetSaveConfirmPanel;
import com.ge.med.terra.xpv.cuiPanels.TransactionLogName;
import com.ge.med.terra.xpv.laf.LafUtils;
import com.ge.med.terra.xpv.ui.SubTitlePanel;
import com.ge.med.terra.xpv.util.FactoryPreferenceCapble;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class WindowingPanel
extends XPcaAutoControlPanel {
    static ResourceBundle res = CuiPanelResources.STRING_RESOURCES;
    ArrayList presetModel = null;
    ListDataModel model = null;
    String mainPanel = "MainPanel";
    String editPanel = "EditorPanel";
    String confirmPanel = "ConfirmPanel";
    XPwPresetGroupControl presetGroups = new XPwPresetGroupControl();
    CardLayout cardLayout = new CardLayout();
    PresetEditorPanel editorPanel = new PresetEditorPanel(this);
    PresetSaveConfirmPanel editorConfirmPanel = new PresetSaveConfirmPanel(this.editorPanel);
    String modality_ = "mr";
    XpDicomElement modalityTag = new XpDicomElement(8, 96);
    private String[] presetLabels = null;
    private SpinnerNumberModel wwModel;
    private SpinnerNumberModel wlModel;
    JPanel wminmaxPanel = new JPanel(new BorderLayout(10, 10));
    SubTitlePanel subTitlePanel = new SubTitlePanel();
    JPanel subPanel = new JPanel();
    JPanel wlPanel = new JPanel();
    JPanel listPanel = new JPanel();
    JPanel levelPanel = new JPanel();
    GridLayout gridLayout = new GridLayout();
    JPanel widthPanel = new JPanel();
    JLabel levelLabel = new JLabel();
    XPwWindowLevelSpinner wlSpinner = new XPwWindowLevelSpinner();
    XPwWindowWidthSpinner wwSpinner = new XPwWindowWidthSpinner();
    XPwWinMinField wminField = new XPwWinMinField();
    XPwWinMaxField wmaxField = new XPwWinMaxField();
    JLabel widthLabel = new JLabel();
    JLabel presetLabel = new JLabel();
    JPanel scrollPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JScrollPane jScrollPane = new JScrollPane(this.presetGroups);
    Border wlBorder = BorderFactory.createEmptyBorder(10, 0, 0, 0);
    JButton editButton = new JButton();
    Border listBorder = BorderFactory.createEmptyBorder(10, 40, 20, 40);
    Border scrollBorder = BorderFactory.createEmptyBorder(5, 0, 0, 0);
    XPwInvertControl btInvert = new XPwInvertControl();
    public static final String CONTENT_CHANGED = "CONTENT_CHANGED";
    public static final String ANCESTOR = "ancestor";
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == WindowingPanel.ANCESTOR) {
                WindowingPanel.this.updateWindowSetting();
            } else if (evt.getPropertyName() == "winMax") {
                WindowingPanel.this.updateWindowSetting();
            } else if (evt.getPropertyName() == "data_changed") {
                WindowingPanel.this.updatePresets();
                WindowingPanel.this.updateWindowSetting();
            } else if (evt.getPropertyName() == "winMin") {
                WindowingPanel.this.updateWindowSetting();
            } else if (evt.getPropertyName() == WindowingPanel.CONTENT_CHANGED) {
                WindowingPanel.this.updatePresets();
                WindowingPanel.this.updateWindowSetting();
            } else if (evt.getPropertyName().equals("ComponentSelection")) {
                WindowingPanel.this.updateWindowSetting();
            } else if (evt.getPropertyName().equals("parent_port_changed")) {
                WindowingPanel.this.updatePresets();
                WindowingPanel.this.updateWindowSetting();
            }
        }
    };
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private JComponent port;
    boolean showMinMax;

    public WindowingPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setBackground(null);
        this.cardLayout.show(this, this.mainPanel);
        this.repaint();
    }

    private void jbInit() throws Exception {
        this.setIcon(CuiPanelUtils.getIcon("BRIGHT_CONTRAST_ICO"));
        this.setLayout(this.cardLayout);
        this.subTitlePanel.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new BorderLayout());
        this.subPanel.setLayout(new BorderLayout());
        this.subPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
        this.wlPanel.setLayout(this.gridLayout);
        this.gridLayout.setColumns(1);
        this.gridLayout.setRows(2);
        this.gridLayout.setVgap(10);
        this.levelPanel.setLayout(new GridBagLayout());
        this.levelLabel.setText(res.getString("WindowingPanel.LEVEL_TEXT"));
        this.widthPanel.setLayout(new GridBagLayout());
        this.widthLabel.setText(res.getString("WindowingPanel.WIDTH_TEXT"));
        this.listPanel.setLayout(new BorderLayout());
        this.presetLabel.setText(res.getString("WindowingPanel.PRESETS_TEXT"));
        this.scrollPanel.setLayout(new BorderLayout());
        this.wlSpinner.setPreferredSize(new Dimension(80, 25));
        this.wwSpinner.setPreferredSize(new Dimension(80, 25));
        JPanel lPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        lPanel.setOpaque(false);
        lPanel.setBackground(null);
        lPanel.add(new JLabel("Min"));
        lPanel.add(new JLabel("Max"));
        JPanel rPanel = new JPanel(new GridLayout(0, 1, 10, 10));
        rPanel.setOpaque(false);
        rPanel.setBackground(null);
        rPanel.add(this.wminField);
        rPanel.add(this.wmaxField);
        this.wminmaxPanel.add((Component)lPanel, "West");
        this.wminmaxPanel.add(rPanel);
        this.wminmaxPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.wminmaxPanel.setOpaque(false);
        this.wminmaxPanel.setBackground(null);
        this.wlPanel.setBackground(null);
        this.wlPanel.setOpaque(false);
        this.wlPanel.setBorder(this.wlBorder);
        this.editButton.setText(res.getString("WindowingPanel.EDIT_BUTTON"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WindowingPanel.this.editButton_actionPerformed(e);
            }
        });
        this.listPanel.setBorder(this.listBorder);
        this.scrollPanel.setBorder(this.scrollBorder);
        this.add((Component)this.editorConfirmPanel, this.confirmPanel);
        this.add((Component)this.editorPanel, this.editPanel);
        this.add((Component)this.subTitlePanel, this.mainPanel);
        this.subTitlePanel.add((Component)this.listPanel, "Center");
        this.subTitlePanel.add((Component)this.subPanel, "North");
        JPanel invertButtonPanel = new JPanel(new GridBagLayout());
        invertButtonPanel.add((Component)this.btInvert, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.subPanel.add((Component)invertButtonPanel, "East");
        this.widthPanel.setOpaque(false);
        this.widthPanel.setBackground(null);
        this.levelPanel.setOpaque(false);
        this.levelPanel.setBackground(null);
        this.wlPanel.add(this.widthPanel);
        this.wlPanel.add(this.levelPanel);
        this.levelPanel.add((Component)this.levelLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.widthPanel.add((Component)this.widthLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.scrollPanel.add((Component)this.jScrollPane, "Center");
        this.listPanel.add((Component)this.scrollPanel, "Center");
        this.levelPanel.add((Component)this.wlSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        this.widthPanel.add((Component)this.wwSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.listPanel.add((Component)this.editButton, "South");
        this.listPanel.add((Component)this.presetLabel, "North");
        this.levelLabel.setIcon(CuiPanelUtils.getIcon("CONTRAST_ICO"));
        this.widthLabel.setIcon(CuiPanelUtils.getIcon("BRIGHT_ICO"));
        this.wwModel = new SpinnerNumberModel(new Double(0.0), new Double(0.0), new Double(65535.0), new Double(1.0));
        this.wlModel = new SpinnerNumberModel(new Double(0.0), new Double(-32767.0), new Double(32767.0), new Double(1.0));
        this.wlSpinner.setModel(this.wlModel);
        this.wwSpinner.setModel(this.wwModel);
        this.subTitlePanel.setTitle(res.getString("WindowingPanel.WINDOW_TITLE"));
        super.setTitle(res.getString("WindowingPanel.WINDOW_TITLE"));
        this.levelLabel.setIconTextGap(19);
        this.widthLabel.setIconTextGap(15);
        LafUtils.installButtonGroupBorder(new JComponent[]{null, this.editButton}, 2, 1, true);
    }

    void updateSelectedPreset() {
        double[] wwwl;
        int selPreset = this.presetGroups.getSelectedIndex();
        if (selPreset < 0) {
            return;
        }
        try {
            wwwl = FactoryPreferenceCapble.getInstance().getWLPreset(this.modality_, selPreset + 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        if (wwwl != null) {
            this.wwSpinner.setValue(new Double(wwwl[0]));
            this.wlSpinner.setValue(new Double(wwwl[1]));
            this.setWindowing();
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen_ = screen;
        this.screen_.removePropertyChangeListener(this.viewPortListener);
        this.screen_.addPropertyChangeListener(this.viewPortListener);
        this.updatePresets();
    }

    @Override
    public void ViewportContextChanged(ViewportContext context) {
        this.modality_ = context.getModality();
        this.updatePresets();
    }

    public void updatePresets() {
        this.presetModel = new ArrayList();
        this.presetLabels = FactoryPreferenceCapble.getInstance().getPresetLabels(this.modality_);
        if (this.presetLabels != null) {
            for (int i = 0; i < this.presetLabels.length; ++i) {
                this.presetModel.add(this.presetLabels[i]);
            }
        } else {
            this.presetModel.add("Predef1");
            this.presetModel.add("Predef2");
            this.presetModel.add("Predef3");
            this.presetModel.add("Predef4");
            this.presetModel.add("Predef5");
            this.presetModel.add("Predef6");
        }
        this.model = new ListDataModel(this.presetModel);
        this.presetGroups.setModel(this.model);
    }

    public void editButton_actionPerformed(ActionEvent e) {
        this.editorPanel.setPresets();
        this.editorPanel.setSelectedPreset(this.presetGroups.getSelectedIndex());
        this.showEditorPanel();
    }

    public void showEditorPanel() {
        this.cardLayout.show(this, this.editPanel);
        this.repaint();
    }

    public void showMainPanel() {
        this.cardLayout.show(this, this.mainPanel);
        this.repaint();
    }

    public void showConfirmPanel(String preset) {
        this.editorConfirmPanel.setCurrentPreset(preset);
        this.cardLayout.show(this, this.confirmPanel);
        this.repaint();
    }

    private void setWindowing() {
        TransactionLogName tln = new TransactionLogName("TID=SD_windowing");
        WindowLevelCapable wlc = (WindowLevelCapable)this.getCapable("com.ge.med.idc.WindowLevelCapable");
        if (wlc == null) {
            this.logger.log(Level.SEVERE, "{0} SEV5 Not WindowLevelCapable", tln);
            return;
        }
        double ww = (Double)this.wwSpinner.getValue();
        if (ww > 65535.0) {
            ww = 65535.0;
            this.wwSpinner.setValue(new Double(ww));
        } else if (ww < 0.0) {
            ww = 0.0;
            this.wwSpinner.setValue(new Double(ww));
        }
        double wl = (Double)this.wlSpinner.getValue();
        if (wl > 32767.0) {
            wl = 32767.0;
            this.wlSpinner.setValue(new Double(wl));
        } else if (wl < -32767.0) {
            wl = -32767.0;
            this.wlSpinner.setValue(new Double(wl));
        }
        wlc.setWinMinMax(wl - ww * 0.5, wl + ww * 0.5);
        this.logger.log(Level.FINEST, "{0} Set WWWL", tln);
    }

    private void updateWindowSetting() {
        WindowLevelCapable wl = this.getWLPort();
        if (wl == null) {
            return;
        }
        double min = wl.getWinMin();
        double max = wl.getWinMax();
        this.wwSpinner.setValue(new Double(max - min));
        this.wlSpinner.setValue(new Double((max + min) / 2.0));
    }

    public static void main(String[] args) {
        LafUtils.setupLAF();
        JFrame f = new JFrame();
        f.setContentPane(new WindowingPanel());
        f.setSize(256, 400);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    @Override
    public void selectionChanged(int oldPortNum, int newPortNum) {
        boolean b;
        this.port = this.screen_.getPort(newPortNum);
        Object smm = this.port.getClientProperty("WindowLevel.showMinMax");
        if (smm != null && smm instanceof Boolean && (b = ((Boolean)smm).booleanValue()) != this.showMinMax) {
            this.showMinMax = b;
        }
        this.refreshUI();
    }

    private void refreshUI() {
        this.subPanel.remove(this.wminmaxPanel);
        this.subPanel.remove(this.wlPanel);
        this.subPanel.validate();
        this.subPanel.add((Component)(this.showMinMax ? this.wminmaxPanel : this.wlPanel), "Center");
        this.subPanel.validate();
    }
}

