/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.cuiPanels;

import com.ge.med.terra.xpv.autoControls.XPcaAutoControlPanel;
import com.ge.med.terra.xpv.autoControls.XPwWindowLevelSpinner;
import com.ge.med.terra.xpv.autoControls.XPwWindowWidthSpinner;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelResources;
import com.ge.med.terra.xpv.cuiPanels.CuiPanelUtils;
import com.ge.med.terra.xpv.cuiPanels.ListComboBoxModel;
import com.ge.med.terra.xpv.cuiPanels.WindowingPanel;
import com.ge.med.terra.xpv.ui.SubTitlePanel;
import com.ge.med.terra.xpv.util.FactoryPreferenceCapble;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;

public class PresetEditorPanel
extends XPcaAutoControlPanel {
    WindowingPanel parent;
    static ResourceBundle res = CuiPanelResources.STRING_RESOURCES;
    ArrayList model = null;
    int index = 0;
    String selected = null;
    ListComboBoxModel mod = null;
    SubTitlePanel subTitlePanel = new SubTitlePanel();
    JPanel comboPanel = new JPanel();
    JPanel wlPanel = new JPanel();
    JPanel buttonPanel = new JPanel();
    JComboBox presetComboBox = new JComboBox();
    GridLayout gridLayout = new GridLayout();
    JPanel levelPanel = new JPanel();
    JPanel widthPanel = new JPanel();
    JButton cancelButton = new JButton();
    JButton saveButton = new JButton();
    JLabel levelLabel = new JLabel();
    XPwWindowLevelSpinner wlSpinner = new XPwWindowLevelSpinner();
    JLabel widthLabel = new JLabel();
    XPwWindowWidthSpinner wwSpinner = new XPwWindowWidthSpinner();
    Border comboBorder = BorderFactory.createEmptyBorder(20, 0, 0, 0);
    Border wlBorder = BorderFactory.createEmptyBorder(20, 0, 20, 0);
    Border buttonBorder = BorderFactory.createEmptyBorder(20, 0, 0, 0);

    public PresetEditorPanel(WindowingPanel parent) {
        this.parent = parent;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setBackground(null);
    }

    private void jbInit() throws Exception {
        this.wlSpinner.removeChangeListener();
        this.wwSpinner.removeChangeListener();
        this.setLayout(new BorderLayout());
        this.subTitlePanel.setLayout(new BorderLayout());
        this.wlPanel.setLayout(this.gridLayout);
        this.gridLayout.setColumns(1);
        this.gridLayout.setRows(2);
        this.gridLayout.setVgap(10);
        this.cancelButton.setPreferredSize(new Dimension(70, 30));
        this.cancelButton.setText(res.getString("CANCEL_BUTTON"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PresetEditorPanel.this.cancelButton_actionPerformed(e);
            }
        });
        this.saveButton.setPreferredSize(new Dimension(70, 30));
        this.saveButton.setText(res.getString("SAVE_BUTTON"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PresetEditorPanel.this.saveButton_actionPerformed(e);
            }
        });
        this.presetComboBox.setPreferredSize(new Dimension(100, 25));
        this.presetComboBox.setEditable(true);
        this.levelPanel.setLayout(new GridBagLayout());
        this.widthPanel.setLayout(new GridBagLayout());
        this.levelLabel.setText(res.getString("PresetEditorPanel.LEVEL_TEXT"));
        this.widthLabel.setText(res.getString("PresetEditorPanel.WIDTH_TEXT"));
        this.wlSpinner.setPreferredSize(new Dimension(100, 25));
        this.wwSpinner.setPreferredSize(new Dimension(100, 25));
        this.wlSpinner.setModel(new SpinnerNumberModel(0.0, -32767.0, 32767.0, 1.0));
        this.wwSpinner.setModel(new SpinnerNumberModel(0.0, 0.0, 65535.0, 1.0));
        this.comboPanel.setBorder(this.comboBorder);
        this.wlPanel.setBorder(this.wlBorder);
        this.buttonPanel.setBorder(this.buttonBorder);
        this.add((Component)this.subTitlePanel, "Center");
        this.subTitlePanel.add((Component)this.comboPanel, "North");
        this.comboPanel.add(this.presetComboBox);
        this.subTitlePanel.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.cancelButton);
        this.subTitlePanel.add((Component)this.wlPanel, "Center");
        this.wlPanel.add(this.widthPanel);
        this.wlPanel.add(this.levelPanel);
        this.levelPanel.add((Component)this.levelLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.levelPanel.add((Component)this.wlSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.widthPanel.add((Component)this.widthLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.widthPanel.add((Component)this.wwSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.levelLabel.setIcon(CuiPanelUtils.getIcon("CONTRAST_ICO"));
        this.widthLabel.setIcon(CuiPanelUtils.getIcon("BRIGHT_ICO"));
        this.levelLabel.setIconTextGap(19);
        this.widthLabel.setIconTextGap(15);
        this.subTitlePanel.setTitle(res.getString("PresetEditorPanel.PRE_EDIT_TITLE"));
        this.presetComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent item) {
                if (item.getStateChange() == 1) {
                    PresetEditorPanel.this.index = PresetEditorPanel.this.presetComboBox.getSelectedIndex();
                    double[] wwwl = FactoryPreferenceCapble.getInstance().getWLPreset(PresetEditorPanel.this.parent.modality_, item.getItem().toString());
                    if (wwwl == null) {
                        return;
                    }
                    PresetEditorPanel.this.wwSpinner.setValue(new Double(wwwl[0]));
                    PresetEditorPanel.this.wlSpinner.setValue(new Double(wwwl[1]));
                }
            }
        });
    }

    void setPresets() {
        this.model = new ArrayList();
        for (int i = 0; i < this.parent.presetGroups.getModel().getSize(); ++i) {
            final String toString = (String)this.parent.presetGroups.getModel().getElementAt(i);
            this.model.add(new Object(){

                public String toString() {
                    return toString;
                }
            });
        }
        this.mod = new ListComboBoxModel(this.model);
        this.presetComboBox.setModel(this.mod);
    }

    void setSelectedPreset(int index) {
        double[] wwwl;
        if (index < 0) {
            this.presetComboBox.setSelectedIndex(0);
            wwwl = FactoryPreferenceCapble.getInstance().getWLPreset(this.parent.modality_, 1);
        } else {
            this.presetComboBox.setSelectedIndex(index);
            wwwl = FactoryPreferenceCapble.getInstance().getWLPreset(this.parent.modality_, index + 1);
        }
        this.presetComboBox.getEditor().setItem(this.presetComboBox.getSelectedItem());
        if (wwwl != null) {
            this.wwSpinner.setValue(new Double(wwwl[0]));
            this.wlSpinner.setValue(new Double(wwwl[1]));
        }
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.parent.showMainPanel();
    }

    public void saveButton_actionPerformed(ActionEvent e) {
        this.parent.showConfirmPanel(this.presetComboBox.getSelectedItem().toString());
    }
}

