/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import com.ge.med.terra.xpv.base.XPcaPanel;
import com.ge.med.terra.xpv.base.XpSelector;
import com.ge.med.terra.xpv.laf.LafUtils;
import com.ge.med.terra.xpv.ui.XPui;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;

public class XpPlasmaSelector
extends XpSelector {
    String[] tabNames = null;
    HashMap tabsLookup = null;
    Properties prop;
    JTabbedPane tabs = new JTabbedPane();
    JPanel[] bPanel;
    int count = 0;
    JToggleButton selected;
    ButtonGroup bg = new ButtonGroup();
    ActionListener al = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            XpPlasmaSelector.this.selected = (JToggleButton)e.getSource();
            System.out.println(">" + XpPlasmaSelector.this.selected.getName());
            XpPlasmaSelector.this.fireActionListener(e);
        }
    };
    Vector listeners = new Vector();

    @Override
    public void setProperties(Properties prop) {
        this.prop = prop;
        String s = prop.getProperty("plasmaTabs");
        this.tabNames = s.split("\\,");
        this.tabsLookup = new HashMap();
        for (int i = 0; i < this.tabNames.length; ++i) {
            String propname = "tab" + (i + 1);
            String tablist = prop.getProperty(propname);
            if (tablist == null) continue;
            String[] tlist = tablist.split("\\,");
            Integer pos = new Integer(i);
            for (int j = 0; j < tlist.length; ++j) {
                String tab = prop.getProperty(tlist[j]);
                this.tabsLookup.put(tab, pos);
            }
        }
        this.setTabNames(this.tabNames);
    }

    public XpPlasmaSelector() {
        this.tabs.setBackground(XPui.p6());
        this.setLayout(new BorderLayout());
        this.add(this.tabs);
    }

    public void select(String name) {
        name = this.prop.getProperty(name, name);
        int index = (Integer)this.tabsLookup.get(name);
        this.tabs.setSelectedIndex(index);
        Enumeration<AbstractButton> e = this.bg.getElements();
        while (e.hasMoreElements()) {
            JToggleButton b = (JToggleButton)e.nextElement();
            XPcaPanel pan = (XPcaPanel)b.getClientProperty("panel");
            if (pan == null || !pan.getClass().getName().equals(name)) continue;
            b.doClick();
        }
    }

    public static void main(String[] args) {
        LafUtils.setupLAF();
        JFrame f = new JFrame("XpSelector");
        XpPlasmaSelector p = new XpPlasmaSelector();
        f.setContentPane(p);
        f.setBounds(100, 100, 255, 200);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        p.addFakeIcons(new String[]{"bright.png", "cine.gif", "close.png", "contrast.png", "down.PNG", "expand.gif", "first.png", "flip-rot.gif", "flip-rot.png", "horz-flip.gif", "icoangle_24_1.png", "icoannotation_22_1.png", "icobrightcontrastb1.gif", "icocolorinvert1.gif", "icoGRID_24_1.png", "icoMATellipse_24_1.png", "icoMATrectangle_24_1.png", "icomeasurement_24_1.png", "icomodecursorarrow_24_3.png", "icomodecursorhand_24_1.png", "icomodecursorpaging_24_1.png", "icomodecursorwindowlevels_24_1.png", "icomodecursorzoom_24_1.png", "icopause1.gif", "icoplay1.gificopreferences1_28_1.png", "icoreportcursor_24_1.png", "icoreset1.gif", "icoROIellipse_24_1.png", "icoROIrectangle_24_1.png", "icorooming1.gif", "icorotateleft_24_1.png", "icorotateright_24_1.png", "icoscreencapture_22_1.png", "icoTICK_24_1.png", "icotrace1_31_1.png", "icovecteurs_bgtransp_28_1.png", "icoviewcolor1_26_1.png", "icoviewcolor2_21_1.png", "last.png", "left.png", "link.gif", "loop.png", "maximize.png", "maximize1.PNG", "next.png", "pandown16.png", "pingpong.png", "previous.png", "right.png", "up.png", "vert-flip.gif", "zoompan.png"});
    }

    public void addFakeIcons(String[] ficon) {
        for (int i = 0; i < this.bPanel.length; ++i) {
            this.bPanel[i].setLayout(new GridLayout(2, 5));
        }
        boolean pos = false;
        int max = ficon.length / this.bPanel.length;
        for (int k = 0; k < this.bPanel.length; ++k) {
            for (int i = 0; i < 10; ++i) {
                this.bPanel[k].add(new JLabel());
            }
        }
        for (int i = 0; i < ficon.length; ++i) {
            URL u = this.getClass().getResource("/com/ge/med/terra/xpv/icons/plasma/" + ficon[i]);
            if (u == null) continue;
            ImageIcon ico = new ImageIcon(u);
            this.addItem(i % this.bPanel.length, ficon[i], ico, u.toString(), null);
            this.repaint();
        }
    }

    @Override
    public String getSelectedItem() {
        if (this.selected == null) {
            return null;
        }
        return this.selected.getName();
    }

    public void addItem(XPcaPanel pan, String name, Icon icon, String description) {
        if (this.tabsLookup == null) {
            this.addItem(this.count, name, icon, description, pan);
            this.count = (this.count + 1) % this.bPanel.length;
        } else {
            Integer portNo = (Integer)this.tabsLookup.get(pan.getClass().getName());
            if (portNo != null) {
                this.addItem(portNo, name, icon, description, pan);
            } else {
                this.addItem(0, name, icon, description, pan);
            }
        }
    }

    public void addItem(int k, String name, Icon icon, String description, XPcaPanel pan) {
        JToggleButton jb = new JToggleButton(icon);
        this.bg.add(jb);
        jb.putClientProperty("panel", pan);
        jb.setName(pan.getClass().getName());
        LafUtils.installButtonBorder(jb, false, false, false, false);
        jb.addActionListener(this.al);
        jb.setToolTipText(description);
        Component[] c = this.bPanel[k].getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof JLabel)) continue;
            this.bPanel[k].remove(c[i]);
            break;
        }
        this.bPanel[k].add(jb);
    }

    public String[] getTabNames() {
        return this.tabNames;
    }

    public void setTabNames(String[] tabNames) {
        this.tabNames = tabNames;
        this.setupTabs();
    }

    protected void setupTabs() {
        this.tabs.removeAll();
        this.bPanel = new JPanel[this.tabNames.length];
        for (int i = 0; i < this.bPanel.length; ++i) {
            JPanel p = this.bPanel[i] = new JPanel();
            this.tabs.add((Component)this.bPanel[i], this.tabNames[i]);
            p.setLayout(new GridLayout());
        }
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    protected void fireActionListener(ActionEvent ev) {
        for (ActionListener l : this.listeners) {
            l.actionPerformed(ev);
        }
    }

    @Override
    public void setSelectedItem(String name) {
        this.select(name);
    }

    @Override
    public void addElement(XPcaPanel pan, String name, Icon icon, String desc) {
        this.addItem(pan, name, icon, desc);
    }

    @Override
    public void setSelectedApplication(String appName) {
    }
}

