/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import com.ge.med.idc.Capable;
import com.ge.med.idc.CineCapable;
import com.ge.med.idc.ColorMapCapable;
import com.ge.med.idc.ComponentCreator;
import com.ge.med.idc.DelayedPrintCapable;
import com.ge.med.idc.FramePositioningCapable;
import com.ge.med.idc.PanZoomCapable;
import com.ge.med.idc.RowColCapable;
import com.ge.med.idc.Selectable;
import com.ge.med.idc.SelectionCapable;
import com.ge.med.idc.WindowLevelCapable;
import com.ge.med.terra.jami.RoiActor;
import com.ge.med.terra.jami.annotation.XpAnnotationGenerator;
import com.ge.med.terra.jami.capable.AnnotCapable;
import com.ge.med.terra.jami.capable.ImageOpCapable;
import com.ge.med.terra.jami.capable.ROICapable;
import com.ge.med.terra.jami.filter.XpImageOp;
import com.ge.med.terra.xpv.base.ViewportContext;
import com.ge.med.terra.xpv.base.XPscreenLayout;
import com.ge.med.terra.xpv.onport.XPopPanel;
import com.ge.med.terra.xpv.ui.FadeAwayOverLay;
import com.ge.med.terra.xpv.util.XPutil;
import com.ge.med.terra.xpv.util.XpColorConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class XPscreen
extends JPanel
implements Printable,
AnnotCapable,
ColorMapCapable,
PanZoomCapable,
RowColCapable,
CineCapable,
WindowLevelCapable,
FramePositioningCapable,
ROICapable,
DelayedPrintCapable,
ImageOpCapable,
SelectionCapable {
    public static Border selectedBorder = BorderFactory.createLineBorder(Color.white, 2);
    public static Border unselectedBorder = BorderFactory.createLineBorder(Color.black, 2);
    JComponent[] pport = new JComponent[0];
    XPscreenLayout layout = XPscreenLayout.layout2x2();
    private int selectedPortNumber = 0;
    public static final String PARENT_PORT_CHANGE = "parent_port_changed";
    public static final String DATA_CHANGE = "data_changed";
    public static final String LAYOUT_CHANGE = "layout_changed";
    Properties prop;
    Color selectedPortBorderColor = Color.lightGray;
    Class[] onPort = null;
    String[] location = null;
    PropertyChangeListener vpContextListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ViewportContext context = (ViewportContext)((JComponent)evt.getSource()).getClientProperty("ViewportContext");
            XPscreen.this.firePropertyChange("ViewportContext", null, context);
        }
    };
    Class[] capables = new Class[]{PanZoomCapable.class, CineCapable.class, RowColCapable.class, WindowLevelCapable.class, FramePositioningCapable.class};
    private PropertyChangeListener portPropertyChange = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            XPscreen.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    };

    public void reset() {
        for (int i = 0; i < this.pport.length; ++i) {
            this.pport[i] = new EmptyPort();
            this.addPort(this.pport[i], i);
        }
        this.setSelectedPortNumber(0);
    }

    public void setLayout(XPscreenLayout layout) {
        super.setLayout(layout);
        int selNo = this.getSelectedPortNumber();
        int len = layout.getNoOfPorts();
        if (len > this.pport.length) {
            JComponent[] tmp = new JComponent[len];
            System.arraycopy(this.pport, 0, tmp, 0, this.pport.length);
            for (int i = this.pport.length; i < len; ++i) {
                tmp[i] = new EmptyPort();
                this.addPort(tmp[i], i);
            }
            this.pport = tmp;
            this.setSelectedPortNumber(selNo);
        }
        if (this.getSelectedPortNumber() >= layout.getNoOfPorts()) {
            this.setSelectedPortNumber(0);
        }
        for (int i = 0; i < len; ++i) {
            this.pport[i].setVisible(true);
        }
        this.layout = layout;
        this.firePropertyChange(LAYOUT_CHANGE, null, layout);
    }

    public XPscreenLayout getScreenLayout() {
        return this.layout;
    }

    public void clearScreen() {
        this.removeAll();
        this.pport = new JComponent[0];
    }

    @Override
    public Capable getCapable(String capableIFName) {
        String[] cap = new String[]{"Printable", "AnnotCapable", "ColorMapCapable", "PanZoomCapable", "RowColCapable", "CineCapable", "WindowLevelCapable", "FramePositioningCapable", "ROICapable", "DelayedPrintCapable", "ImageOpCapable"};
        for (int i = 0; i < cap.length; ++i) {
            if (capableIFName.indexOf(cap[i]) < 0) continue;
            return this;
        }
        return null;
    }

    @Override
    public boolean isAutoRepaint() {
        JComponent c = this.getSelectedPort();
        if (c instanceof Capable) {
            return ((Capable)((Object)c)).isAutoRepaint();
        }
        return false;
    }

    @Override
    public void setAutoRepaint(boolean stat) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof Capable)) continue;
            ((Capable)((Object)this.pport[i])).setAutoRepaint(stat);
        }
    }

    public int getNumPorts() {
        return this.pport.length;
    }

    @Override
    public int getNumComponents() {
        return this.getNumPorts();
    }

    public XPscreen() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            XPutil.getLogger().log(Level.SEVERE, "XPscreen creation failed", ex);
        }
        XPutil.getLogger().log(Level.FINEST, "XPscreen is created", new Exception());
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layout);
        this.setOpaque(false);
        this.setBackground(Color.black);
        this.setSelectedPortNumber(0);
    }

    @Override
    public void paintComponent(Graphics g) {
        Insets insets = this.getInsets();
        g.setColor(this.getBackground());
        g.fillRect(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
    }

    public JComponent getPort(int n) {
        if (n < 0 || n >= this.pport.length) {
            return null;
        }
        return this.pport[n];
    }

    @Override
    public JComponent getViewportComponent(int selection) {
        return this.getPort(selection);
    }

    public void setProperties(Properties properties) {
        String uport_porder;
        this.prop = properties;
        String portCtls = properties.getProperty("PortControls");
        String borderColor = properties.getProperty("PORT_SELECTION_BORDER_COLOR");
        if (borderColor != null) {
            this.selectedPortBorderColor = XpColorConverter.getColor(borderColor);
            if (this.selectedPortBorderColor == null) {
                this.selectedPortBorderColor = Color.lightGray;
            }
            selectedBorder = BorderFactory.createLineBorder(this.selectedPortBorderColor, 2);
        }
        if ((uport_porder = properties.getProperty("UNSLECT_PORT_NO_BORDER")) != null) {
            unselectedBorder = null;
        }
        if (portCtls == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(portCtls, ",");
        this.onPort = new Class[st.countTokens()];
        this.location = new String[st.countTokens()];
        int count = 0;
        while (st.hasMoreTokens()) {
            String thisport = st.nextToken();
            int index = thisport.lastIndexOf(64);
            String className = thisport.substring(0, index);
            String gloc = thisport.substring(index + 1, thisport.length());
            try {
                Class<?> c;
                this.onPort[count] = c = Class.forName(className);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.location[count] = gloc;
            ++count;
        }
    }

    public void dataChanged() {
        this.firePropertyChange(DATA_CHANGE, this.selectedPortNumber, -1);
    }

    public void addPort(JComponent comp, int index) {
        if (this.pport.length <= index) {
            JComponent[] port = new JComponent[index + 1];
            System.arraycopy(this.pport, 0, port, 0, this.pport.length);
            for (int i = this.pport.length; i <= index; ++i) {
                port[i] = new EmptyPort();
                this.add(port[i]);
            }
            this.pport = port;
        }
        this.pport[index].setVisible(false);
        this.remove(index);
        this.pport[index] = comp;
        if (comp instanceof Capable) {
            FadeAwayOverLay f = (FadeAwayOverLay)comp.getClientProperty("FadeAwayOverLay");
            if (f == null) {
                f = new FadeAwayOverLay();
                f.addBase(comp);
                comp.putClientProperty("FadeAwayOverLay", f);
                XPopPanel op = null;
                try {
                    if (this.onPort != null) {
                        for (int cIndex = 0; cIndex < this.onPort.length; ++cIndex) {
                            op = (XPopPanel)this.onPort[cIndex].newInstance();
                            if (!op.isSupported((Capable)((Object)comp))) continue;
                            if (this.location[cIndex].compareToIgnoreCase("west") == 0) {
                                f.addOnPortCtl(op, "West");
                            } else if (this.location[cIndex].compareToIgnoreCase("east") == 0) {
                                f.addOnPortCtl(op, "East");
                            } else if (this.location[cIndex].compareToIgnoreCase("north") == 0) {
                                f.addOnPortCtl(op, "North");
                            } else if (this.location[cIndex].compareToIgnoreCase("south") == 0) {
                                f.addOnPortCtl(op, "South");
                            }
                            op.setPort(comp);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    XPutil.getLogger().log(Level.INFO, "XPscreen.addPort()", ex);
                }
            }
            super.add((Component)f, index);
        } else {
            super.add((Component)comp, index);
        }
        comp.setVisible(true);
        if (comp instanceof Capable) {
            SelectionCapable sc = (SelectionCapable)((Capable)((Object)comp)).getCapable("com.ge.med.idc.SelectionCapable");
            Selectable selectable = (Selectable)((Object)((Capable)((Object)comp)).getCapable("com.ge.med.idc.Selectable"));
            if (sc != null) {
                sc.addPropertyChangeListener("ComponentSelection", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        if (!e.getPropertyName().equals("ComponentSelection")) {
                            return;
                        }
                        if ((Integer)e.getNewValue() == -1) {
                            return;
                        }
                        XPscreen.this.selectionChangeOnChild(e.getSource());
                    }
                });
            } else if (selectable != null) {
                selectable.addPropertyChangeListener("COMPONENT_SELECTED", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        XPscreen.this.selectionChangeOnChild(e.getSource());
                    }
                });
            } else {
                comp.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        XPscreen.this.selectionChangeOnChild(e.getSource());
                    }
                });
            }
        } else {
            comp.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    XPscreen.this.selectionChangeOnChild(e.getSource());
                }
            });
        }
        this.selectionChangeOnChild(comp);
        comp.removePropertyChangeListener(this.vpContextListener);
        comp.addPropertyChangeListener("ViewportContext", this.vpContextListener);
        if (comp instanceof Capable) {
            ((Capable)((Object)comp)).setAutoRepaint(true);
        }
        this.revalidate();
    }

    protected void selectionChangeOnChild(Object source) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (this.pport[i] == source || source instanceof Component && this.pport[i].isAncestorOf((Component)source)) {
                this.setSelectedPortNumber(i);
                this.pport[i].setBorder(selectedBorder);
                continue;
            }
            if (this.pport[i] instanceof SelectionCapable) {
                ((SelectionCapable)((Object)this.pport[i])).setComponentSelection(-1);
            }
            this.pport[i].setBorder(unselectedBorder);
        }
    }

    public void updateSelection() {
        int sel = this.getSelectedPortNumber();
        for (int i = 0; i < this.pport.length; ++i) {
            if (sel == i) {
                this.pport[i].setBorder(selectedBorder);
                continue;
            }
            if (this.pport[i] instanceof SelectionCapable) {
                ((SelectionCapable)((Object)this.pport[i])).setComponentSelection(-1);
            }
            this.pport[i].setBorder(unselectedBorder);
        }
    }

    public JComponent[] getAllPorts() {
        return this.pport;
    }

    public void switchPort(int n1, int n2) {
        JComponent sPort;
        JComponent fPort = this.getPort(n1);
        this.pport[n1] = sPort = this.getPort(n2);
        this.pport[n2] = fPort;
        this.removeAll();
        for (int i = 0; i < this.pport.length; ++i) {
            FadeAwayOverLay f = (FadeAwayOverLay)this.pport[i].getClientProperty("FadeAwayOverLay");
            if (f != null) {
                this.add((Component)f, i);
                continue;
            }
            this.add((Component)this.pport[i], i);
        }
        if (this.getSelectedPortNumber() != n2) {
            this.setSelectedPortNumber(n2);
        } else {
            this.setSelectedPortNumber(n1);
        }
        this.revalidate();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
    }

    public void setSelectedPortNumber(int selectedPort) {
        int oldSelectedPortNumber = this.selectedPortNumber;
        this.selectedPortNumber = selectedPort;
        JComponent port = this.getPort(oldSelectedPortNumber);
        JComponent newport = this.getPort(selectedPort);
        for (int i = 0; i < this.capables.length; ++i) {
            if (this.capables[i].isInstance(port)) {
                ((Capable)((Object)port)).removePropertyChangeListener(this.portPropertyChange);
            }
            if (!this.capables[i].isInstance(newport)) continue;
            ((Capable)((Object)newport)).addPropertyChangeListener(this.portPropertyChange);
            break;
        }
        this.firePropertyChange(PARENT_PORT_CHANGE, oldSelectedPortNumber, selectedPort);
        this.firePropertyChange("ComponentSelection", oldSelectedPortNumber, selectedPort);
        this.repaint();
    }

    @Override
    public void setComponentSelection(int selection) {
        this.setSelectedPortNumber(selection);
    }

    public int getSelectedPortNumber() {
        return this.selectedPortNumber;
    }

    @Override
    public int getComponentSelection() {
        return this.getSelectedPortNumber();
    }

    public JComponent getSelectedPort() {
        if (this.selectedPortNumber < 0 || this.selectedPortNumber >= this.pport.length) {
            return null;
        }
        return this.pport[this.selectedPortNumber];
    }

    @Override
    public int print(Graphics g, PageFormat format, int pageIndex) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(format.getImageableX(), format.getImageableY());
        double sx = format.getImageableWidth() / (double)this.getWidth();
        double sy = format.getImageableHeight() / (double)this.getHeight();
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        g2d.scale(sx, sy);
        this.printAll(g2d);
        return 0;
    }

    @Override
    public String[] getAnnotationGroups() {
        JComponent c = this.getSelectedPort();
        if (c instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c)).getAnnotationGroups();
        }
        return null;
    }

    @Override
    public String[] getAnnotationItems() {
        JComponent c = this.getSelectedPort();
        if (c instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c)).getAnnotationItems();
        }
        return null;
    }

    @Override
    public String[] getAnnotationItems(String groupName) {
        JComponent c = this.getSelectedPort();
        if (c instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c)).getAnnotationItems(groupName);
        }
        return null;
    }

    @Override
    public int[] getColorMap() {
        JComponent c = this.getSelectedPort();
        if (c instanceof ColorMapCapable) {
            return ((ColorMapCapable)((Object)c)).getColorMap();
        }
        return null;
    }

    @Override
    public void setColorMap(int[] cmap) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof ColorMapCapable)) continue;
            ((ColorMapCapable)((Object)this.pport[i])).setColorMap(cmap);
        }
    }

    @Override
    public void setZoom(double zoom) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i])).setZoom(zoom);
        }
    }

    @Override
    public void resetPanZoom() {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i])).resetPanZoom();
        }
    }

    @Override
    public double getZoom() {
        JComponent c = this.getSelectedPort();
        if (c instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)c)).getZoom();
        }
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof PanZoomCapable)) continue;
            return ((PanZoomCapable)((Object)this.pport[i])).getZoom();
        }
        return 1.0;
    }

    @Override
    public void setRotate(double rotate) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i])).setRotate(rotate);
        }
    }

    @Override
    public double getRotate() {
        JComponent c = this.getSelectedPort();
        if (c instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)c)).getRotate();
        }
        return 0.0;
    }

    @Override
    public void setPanY(double pan_y) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i])).setPanY(pan_y);
        }
    }

    @Override
    public double getPanY() {
        JComponent c = this.getSelectedPort();
        if (c instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)c)).getPanY();
        }
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof PanZoomCapable)) continue;
            return ((PanZoomCapable)((Object)this.pport[i])).getPanY();
        }
        return 0.0;
    }

    @Override
    public void setPanX(double pan_x) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i])).setPanX(pan_x);
        }
    }

    @Override
    public double getPanX() {
        JComponent c = this.getSelectedPort();
        if (c instanceof PanZoomCapable) {
            return ((PanZoomCapable)((Object)c)).getPanX();
        }
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof PanZoomCapable)) continue;
            return ((PanZoomCapable)((Object)this.pport[i])).getPanX();
        }
        return 0.0;
    }

    @Override
    public void setPan(double x, double y) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i])).setPan(x, y);
        }
    }

    @Override
    public void flipHorizontal() {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i])).flipHorizontal();
        }
    }

    @Override
    public void flipVertical() {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof PanZoomCapable)) continue;
            ((PanZoomCapable)((Object)this.pport[i])).flipVertical();
        }
    }

    @Override
    public void setRowCol(int row, int col) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof RowColCapable)) continue;
            ((RowColCapable)((Object)this.pport[i])).setRowCol(row, col);
        }
    }

    @Override
    public void setRows(int newRows) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof RowColCapable)) continue;
            ((RowColCapable)((Object)this.pport[i])).setRows(newRows);
        }
    }

    @Override
    public int getRows() {
        JComponent c = this.getSelectedPort();
        if (c instanceof RowColCapable) {
            return ((RowColCapable)((Object)c)).getRows();
        }
        return 1;
    }

    @Override
    public void setCols(int newCols) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof RowColCapable)) continue;
            ((RowColCapable)((Object)this.pport[i])).setCols(newCols);
        }
    }

    @Override
    public int getCols() {
        JComponent c = this.getSelectedPort();
        if (c instanceof RowColCapable) {
            return ((RowColCapable)((Object)c)).getCols();
        }
        return 1;
    }

    @Override
    public double[] getRange() {
        JComponent c = this.getSelectedPort();
        if (c instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)c)).getRange();
        }
        return new double[]{0.0, 100.0};
    }

    @Override
    public void resetWindowing() {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i])).resetWindowing();
        }
    }

    @Override
    public void setWinUpperLimit(double um) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i])).setWinUpperLimit(um);
        }
    }

    @Override
    public double getWinUpperLimit() {
        if (this.getSelectedPort() instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)this.getSelectedPort())).getWinUpperLimit();
        }
        return 0.0;
    }

    @Override
    public void setWinLowerLimit(double um) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i])).setWinLowerLimit(um);
        }
    }

    @Override
    public double getWinLowerLimit() {
        if (this.getSelectedPort() instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)this.getSelectedPort())).getWinLowerLimit();
        }
        return 0.0;
    }

    @Override
    public void setWinMinMax(double parm1, double parm2) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i])).setWinMinMax(parm1, parm2);
        }
    }

    @Override
    public double getWinMin() {
        JComponent c = this.getSelectedPort();
        if (c instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)c)).getWinMin();
        }
        return 0.0;
    }

    @Override
    public void setWinMin(double parm1) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i])).setWinMin(parm1);
        }
    }

    @Override
    public double getWinMax() {
        JComponent c = this.getSelectedPort();
        if (c instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)c)).getWinMax();
        }
        return 100.0;
    }

    @Override
    public void setWinMax(double parm1) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i])).setWinMax(parm1);
        }
    }

    @Override
    public void setVideoInverted(boolean parm1) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof WindowLevelCapable)) continue;
            ((WindowLevelCapable)((Object)this.pport[i])).setVideoInverted(parm1);
        }
    }

    @Override
    public boolean isVideoInverted() {
        JComponent c = this.getSelectedPort();
        if (c instanceof WindowLevelCapable) {
            return ((WindowLevelCapable)((Object)c)).isVideoInverted();
        }
        return false;
    }

    @Override
    public void setCine(boolean parm1) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i])).setCine(parm1);
        }
    }

    @Override
    public boolean getCine() {
        JComponent c = this.getSelectedPort();
        if (c instanceof CineCapable) {
            return ((CineCapable)((Object)c)).getCine();
        }
        return false;
    }

    @Override
    public int getCineMode() {
        JComponent c = this.getSelectedPort();
        if (c instanceof CineCapable) {
            return ((CineCapable)((Object)c)).getCineMode();
        }
        return 0;
    }

    @Override
    public void setCineMode(int cineMode) {
        JComponent c = this.getSelectedPort();
        if (c instanceof CineCapable) {
            ((CineCapable)((Object)c)).setCineMode(cineMode);
        }
    }

    @Override
    public void setCineRate(int parm1) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i])).setCineRate(parm1);
        }
    }

    @Override
    public int getCineRate() {
        JComponent c = this.getSelectedPort();
        if (c instanceof CineCapable) {
            return ((CineCapable)((Object)c)).getCineRate();
        }
        return 1;
    }

    @Override
    public void setOffset(int parm1) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i])).setOffset(parm1);
        }
    }

    @Override
    public int getOffset() {
        JComponent c = this.getSelectedPort();
        if (c instanceof CineCapable) {
            return ((CineCapable)((Object)c)).getOffset();
        }
        return 0;
    }

    @Override
    public void setStartOffset(int parm1) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i])).setStartOffset(parm1);
        }
    }

    @Override
    public int getStartOffset() {
        JComponent c = this.getSelectedPort();
        if (c instanceof CineCapable) {
            return ((CineCapable)((Object)c)).getStartOffset();
        }
        return 0;
    }

    @Override
    public void setEndOffset(int parm1) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i])).setEndOffset(parm1);
        }
    }

    @Override
    public int getEndOffset() {
        JComponent c = this.getSelectedPort();
        if (c instanceof CineCapable) {
            return ((CineCapable)((Object)c)).getEndOffset();
        }
        return 0;
    }

    @Override
    public int getMaxFrame() {
        JComponent c = this.getSelectedPort();
        if (c instanceof CineCapable) {
            return ((CineCapable)((Object)c)).getMaxFrame();
        }
        return 0;
    }

    @Override
    public int getNumberShown() {
        JComponent c = this.getSelectedPort();
        if (c instanceof CineCapable) {
            return ((CineCapable)((Object)c)).getNumberShown();
        }
        return 0;
    }

    @Override
    public int getCineSkip() {
        JComponent c = this.getSelectedPort();
        if (c instanceof CineCapable) {
            return ((CineCapable)((Object)c)).getCineSkip();
        }
        return 0;
    }

    @Override
    public void setCineSkip(int parm1) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof CineCapable)) continue;
            ((CineCapable)((Object)this.pport[i])).setCineSkip(parm1);
        }
    }

    @Override
    public void setAnnotationGenerator(Class agClass, Properties props) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof AnnotCapable)) continue;
            ((AnnotCapable)((Object)this.pport[i])).setAnnotationGenerator(agClass, props);
        }
    }

    @Override
    public boolean isAnnotationVisible() {
        JComponent c = this.getSelectedPort();
        if (c instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c)).isAnnotationVisible();
        }
        return false;
    }

    @Override
    public void setAnnotationGroup(String group, boolean status) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof AnnotCapable)) continue;
            ((AnnotCapable)((Object)this.pport[i])).setAnnotationGroup(group, status);
        }
    }

    @Override
    public void setAnnotationItems(String[] items, boolean status) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof AnnotCapable)) continue;
            ((AnnotCapable)((Object)this.pport[i])).setAnnotationItems(items, status);
        }
    }

    @Override
    public void setAnnotationVisible(boolean bool) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof AnnotCapable)) continue;
            ((AnnotCapable)((Object)this.pport[i])).setAnnotationVisible(bool);
        }
    }

    @Override
    public XpAnnotationGenerator getAnnotationGenerator() {
        JComponent c = this.getSelectedPort();
        if (c instanceof AnnotCapable) {
            AnnotCapable ac = (AnnotCapable)((Object)c);
            return ac.getAnnotationGenerator();
        }
        return null;
    }

    @Override
    public int getNumFrames() {
        JComponent c = this.getSelectedPort();
        if (c instanceof PanZoomCapable) {
            FramePositioningCapable ac = (FramePositioningCapable)((Object)c);
            return ac.getNumFrames();
        }
        return 0;
    }

    @Override
    public void setFrameIndex(int parm1) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof FramePositioningCapable)) continue;
            ((FramePositioningCapable)((Object)this.pport[i])).setFrameIndex(parm1);
        }
    }

    @Override
    public int getFrameIndex() {
        JComponent c = this.getSelectedPort();
        if (c instanceof FramePositioningCapable) {
            FramePositioningCapable ac = (FramePositioningCapable)((Object)c);
            return ac.getFrameIndex();
        }
        return 0;
    }

    @Override
    public Color getAnnotationColor() {
        return Color.white;
    }

    @Override
    public void setAnnotationColor(Color col) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof AnnotCapable)) continue;
            ((AnnotCapable)((Object)this.pport[i])).setAnnotationColor(col);
        }
    }

    @Override
    public void queryAnnotationItems(String[] items, boolean[] status) {
        JComponent c = this.getSelectedPort();
        if (c instanceof AnnotCapable) {
            ((AnnotCapable)((Object)c)).queryAnnotationItems(items, status);
        }
    }

    @Override
    public boolean queryAnnotationItem(String item) {
        JComponent c = this.getSelectedPort();
        if (c instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c)).queryAnnotationItem(item);
        }
        return false;
    }

    @Override
    public void add(RoiActor ra) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof ROICapable)) continue;
            ((ROICapable)((Object)this.pport[i])).add(ra);
        }
    }

    @Override
    public List getRois() {
        JComponent c = this.getSelectedPort();
        if (c instanceof ROICapable) {
            return ((ROICapable)((Object)c)).getRois();
        }
        return null;
    }

    @Override
    public boolean remove(RoiActor ra) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof ROICapable)) continue;
            ((ROICapable)((Object)this.pport[i])).remove(ra);
        }
        return true;
    }

    @Override
    public RoiActor getRoi() {
        JComponent c = this.getSelectedPort();
        if (c instanceof ROICapable) {
            return ((ROICapable)((Object)c)).getRoi();
        }
        return null;
    }

    @Override
    public void setComponentCreator(ComponentCreator rc) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof ROICapable)) continue;
            ((ROICapable)((Object)this.pport[i])).setComponentCreator(rc);
        }
    }

    @Override
    public ComponentCreator getComponentCreator() {
        JComponent c = this.getSelectedPort();
        if (c instanceof ROICapable) {
            return ((ROICapable)((Object)c)).getComponentCreator();
        }
        return null;
    }

    @Override
    public Printable getPrintable() {
        Printable pt = new Printable(){

            @Override
            public int print(Graphics graphics, PageFormat pf, int pageIndex) throws PrinterException {
                if (pageIndex > 0) {
                    return 1;
                }
                Graphics2D g2d = (Graphics2D)graphics;
                g2d.translate(pf.getImageableX(), pf.getImageableY());
                Rectangle bound = XPscreen.this.getBounds();
                double sx = pf.getImageableWidth() / bound.getWidth();
                double sy = pf.getImageableHeight() / bound.getHeight();
                if (sx > sy) {
                    sx = sy;
                } else {
                    sy = sx;
                }
                g2d.scale(sx, sy);
                Graphics sg = graphics.create();
                Rectangle clipBound = sg.getClipBounds();
                for (int i = 0; i < XPscreen.this.getComponentCount(); ++i) {
                    Component c = XPscreen.this.getComponent(i);
                    if (!c.isVisible()) continue;
                    Rectangle cr = c.getBounds();
                    SwingUtilities.computeIntersection(clipBound.x, clipBound.y, clipBound.width, clipBound.height, cr);
                    Graphics cg = sg.create(cr.x, cr.y, cr.width, cr.height);
                    new ImagePrintComponent(c).print(cg, pf, pageIndex);
                }
                return 0;
            }
        };
        return pt;
    }

    @Override
    public void addImageOp(XpImageOp imageOp) {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof ImageOpCapable)) continue;
            ((ImageOpCapable)((Object)this.pport[i])).addImageOp(imageOp);
        }
    }

    @Override
    public List getImageOps() {
        JComponent c = this.getSelectedPort();
        if (c instanceof ImageOpCapable) {
            return ((ImageOpCapable)((Object)c)).getImageOps();
        }
        return null;
    }

    @Override
    public void clearImageOps() {
        for (int i = 0; i < this.pport.length; ++i) {
            if (!(this.pport[i] instanceof ImageOpCapable)) continue;
            ((ImageOpCapable)((Object)this.pport[i])).clearImageOps();
        }
    }

    @Override
    public String getAnnotationGroup() {
        JComponent c = this.getSelectedPort();
        if (c instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c)).getAnnotationGroup();
        }
        return null;
    }

    @Override
    public Map<String, Boolean> getAnnotationItemStates() {
        JComponent c = this.getSelectedPort();
        if (c instanceof AnnotCapable) {
            return ((AnnotCapable)((Object)c)).getAnnotationItemStates();
        }
        return null;
    }

    class ImagePrintComponent {
        BufferedImage buff;
        Rectangle bounds;

        public ImagePrintComponent(BufferedImage img) {
            this.bounds = new Rectangle(img.getWidth(), img.getHeight());
            this.buff = img;
        }

        public ImagePrintComponent(Component c) {
            this.bounds = c.getBounds();
            this.buff = new BufferedImage(this.bounds.width, this.bounds.height, 1);
            Graphics g = this.buff.getGraphics();
            g.clearRect(0, 0, this.bounds.width, this.bounds.height);
            c.print(g);
        }

        public int print(Graphics g, PageFormat format, int pageIndex) {
            g.clearRect(0, 0, this.bounds.width, this.bounds.height);
            g.drawImage(this.buff, 0, 0, this.bounds.width, this.bounds.height, null);
            return 0;
        }
    }

    public static class EmptyPort
    extends JPanel {
        public EmptyPort() {
            this.setBackground(Color.black);
        }
    }
}

