/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import com.ge.med.terra.xpv.laf.LafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;

public class CuiStackedTabsUI
extends TabbedPaneUI
implements SwingConstants {
    protected static boolean initialized_ = false;
    protected JTabbedPane tabPane_;
    protected Color dummyColor_;
    protected JComponent dummyComponent_ = new JComponent(){

        @Override
        public boolean isOpaque() {
            return true;
        }

        @Override
        public Color getBackground() {
            return CuiStackedTabsUI.this.dummyColor_;
        }
    };
    protected Dimension tabMinimumSize_;
    protected Color selectedBackground_;
    protected Color unselectedBackground_;
    protected Insets tabInsets_;
    protected Border tabBorder_;
    protected Border contentBorder_;
    protected boolean blendBorders_ = true;
    protected int verticalAlignment_;
    protected int horizontalAlignment_;
    protected int verticalTextPosition_;
    protected int horizontalTextPosition_;
    protected int textIconGap_;
    protected MouseListener mouseListener_ = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            int index = CuiStackedTabsUI.this.tabForCoordinate(pane, e.getX(), e.getY());
            int count = pane.getTabCount();
            int selected = pane.getSelectedIndex();
            if (index < 0 || index >= count || index == selected) {
                return;
            }
            pane.setSelectedIndex(index);
            pane.revalidate();
            pane.repaint();
        }
    };
    protected PropertyChangeListener propertyChangeListener_ = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (!("StackedTabs.tabMinimumSize".equals(name) || "StackedTabs.tabInsets".equals(name) || "StackedTabs.tabBorder".equals(name) || "StackedTabs.contentBorder".equals(name) || "StackedTabs.blendBorders".equals(name) || "StackedTabs.selected".equals(name) || "StackedTabs.unselected".equals(name) || "StackedTabs.verticalAlignment".equals(name) || "StackedTabs.horizontalAlignment".equals(name) || "StackedTabs.verticalTextPosition".equals(name) || "StackedTabs.horizontalTextPosition".equals(name) || "StackedTabs.textIconGap".equals(name))) {
                return;
            }
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            CuiStackedTabsUI.this.uninstallUI(tabPane);
            CuiStackedTabsUI.this.installUI(tabPane);
            tabPane.revalidate();
            tabPane.repaint();
        }
    };

    public static void main(String[] argv) {
        LafUtils.handleVersionQuery(argv, "@(#)@BUILD_INFO@");
    }

    public static ComponentUI createUI(JComponent c) {
        if (!initialized_) {
            UIManager.getLookAndFeelDefaults().put("StackedTabs.verticalAlignment", new Integer(0));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.horizontalAlignment", new Integer(10));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.verticalTextPosition", new Integer(0));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.horizontalTextPosition", new Integer(11));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.textIconGap", new Integer(4));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.tabInsets", new Insets(1, 4, 0, 0));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.tabBorder", LafUtils.createRaisedBorder());
            UIManager.getLookAndFeelDefaults().put("StackedTabs.contentBorder", LafUtils.createRaisedBorder());
            UIManager.getLookAndFeelDefaults().put("StackedTabs.blendBorders", Boolean.TRUE);
            UIManager.getLookAndFeelDefaults().put("StackedTabs.selected", UIManager.getColor("P8"));
            UIManager.getLookAndFeelDefaults().put("StackedTabs.unselected", UIManager.getColor("P9"));
            initialized_ = true;
        }
        return new CuiStackedTabsUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.tabPane_ = (JTabbedPane)c;
        this.tabMinimumSize_ = LafUtils.getUIPropertyDimension(c, "StackedTabs.tabMinimumSize");
        if (this.tabMinimumSize_ == null) {
            this.tabMinimumSize_ = new Dimension(0, 0);
        }
        this.tabInsets_ = LafUtils.getUIPropertyInsets(c, "StackedTabs.tabInsets");
        if (this.tabInsets_ == null) {
            this.tabInsets_ = new Insets(0, 0, 0, 0);
        }
        this.tabBorder_ = LafUtils.getUIPropertyBorder(c, "StackedTabs.tabBorder");
        if (this.tabBorder_ == null) {
            this.tabBorder_ = new EmptyBorder(0, 0, 0, 0);
        }
        this.contentBorder_ = LafUtils.getUIPropertyBorder(c, "StackedTabs.contentBorder");
        if (this.contentBorder_ == null) {
            this.contentBorder_ = new EmptyBorder(0, 0, 0, 0);
        }
        this.blendBorders_ = LafUtils.getUIPropertyBoolean(c, "StackedTabs.blendBorders");
        this.selectedBackground_ = LafUtils.getUIPropertyColor(c, "StackedTabs.selected");
        this.unselectedBackground_ = LafUtils.getUIPropertyColor(c, "StackedTabs.unselected");
        this.verticalAlignment_ = LafUtils.getUIPropertyInt(c, "StackedTabs.verticalAlignment");
        this.horizontalAlignment_ = LafUtils.getUIPropertyInt(c, "StackedTabs.horizontalAlignment");
        this.verticalTextPosition_ = LafUtils.getUIPropertyInt(c, "StackedTabs.verticalTextPosition");
        this.horizontalTextPosition_ = LafUtils.getUIPropertyInt(c, "StackedTabs.horizontalTextPosition");
        this.textIconGap_ = LafUtils.getUIPropertyInt(c, "StackedTabs.textIconGap");
        super.installUI(c);
        c.setOpaque(true);
        c.addPropertyChangeListener(this.propertyChangeListener_);
        c.addMouseListener(this.mouseListener_);
        c.setLayout(new StackedTabLayout());
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removeMouseListener(this.mouseListener_);
        c.removePropertyChangeListener(this.propertyChangeListener_);
        c.setOpaque(false);
        super.uninstallUI(c);
    }

    protected Rectangle[] calculateBounds(JTabbedPane pane) {
        Insets insets = pane.getInsets();
        int width = pane.getWidth() - (insets.left + insets.right);
        int height = pane.getHeight() - (insets.top + insets.bottom);
        int count = pane.getTabCount();
        int selected = pane.getSelectedIndex();
        int tabHeight = this.calculateTabMinimum((JTabbedPane)pane).height;
        Rectangle[] bounds = new Rectangle[count];
        int totalHeight = 0;
        int i = 0;
        while (i < count) {
            bounds[i] = new Rectangle(insets.left, totalHeight + insets.top, width, tabHeight);
            if (this.blendBorders_ && i == selected) {
                bounds[i].height -= this.tabBorder_.getBorderInsets((Component)this.dummyComponent_).bottom;
            }
            totalHeight += bounds[++i - 1].height;
        }
        int selectedHeight = height - totalHeight;
        for (int i2 = selected + 1; i2 < count; ++i2) {
            bounds[i2].y += selectedHeight;
        }
        return bounds;
    }

    protected Rectangle calculateContentBounds(JTabbedPane pane) {
        Insets insets = pane.getInsets();
        int width = pane.getWidth() - (insets.left + insets.right);
        int height = pane.getHeight() - (insets.top + insets.bottom);
        int count = pane.getTabCount();
        int selected = pane.getSelectedIndex();
        int tabHeight = this.calculateTabMinimum((JTabbedPane)pane).height;
        int overlap = this.blendBorders_ ? this.tabBorder_.getBorderInsets((Component)this.dummyComponent_).bottom : 0;
        Rectangle bounds = new Rectangle(insets.left, (selected + 1) * tabHeight + insets.top - overlap, width, height - (count * tabHeight - overlap));
        return bounds;
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        Rectangle[] bounds = this.calculateBounds(pane);
        for (int i = 0; i < bounds.length; ++i) {
            if (!bounds[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int index) {
        Rectangle[] bounds = this.calculateBounds(pane);
        return bounds[index];
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        return 1;
    }

    protected void paintContentBorder(Graphics g, int x, int y, int w, int h) {
        this.contentBorder_.paintBorder(this.tabPane_.getSelectedComponent(), g, x, y, w, h);
    }

    protected Color getTabColor(int index, boolean selected) {
        if (selected) {
            Color color;
            Component component = this.tabPane_.getSelectedComponent();
            if (component != null && component.isOpaque() && (color = component.getBackground()) != null) {
                return color;
            }
            color = this.selectedBackground_;
            if (color != null) {
                return color;
            }
            return this.tabPane_.getBackground();
        }
        return this.unselectedBackground_ != null ? this.unselectedBackground_ : this.tabPane_.getBackgroundAt(index);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int overlap;
        Graphics2D g2d = (Graphics2D)g;
        JTabbedPane pane = (JTabbedPane)c;
        Rectangle[] bounds = this.calculateBounds(pane);
        Rectangle content = this.calculateContentBounds(pane);
        int selected = pane.getSelectedIndex();
        Insets tbi = this.tabBorder_.getBorderInsets(this.dummyComponent_);
        Insets ti = new Insets(tbi.top + this.tabInsets_.top, tbi.left + this.tabInsets_.left, tbi.bottom + this.tabInsets_.bottom, tbi.right + this.tabInsets_.right);
        for (int i = 0; i < bounds.length; ++i) {
            this.dummyColor_ = this.getTabColor(i, i == selected);
            g.setColor(this.dummyColor_);
            overlap = i == selected && this.blendBorders_ ? tbi.bottom : 0;
            Shape clip = g.getClip();
            g.fillRect(bounds[i].x + tbi.left, bounds[i].y + tbi.top, bounds[i].width - (tbi.left + tbi.right), bounds[i].height - (tbi.top + tbi.bottom) + overlap);
            g.clipRect(bounds[i].x, bounds[i].y, bounds[i].width, bounds[i].height);
            this.tabBorder_.paintBorder(this.dummyComponent_, g, bounds[i].x, bounds[i].y, bounds[i].width, bounds[i].height + overlap);
            g.setClip(clip);
            Rectangle viewR = new Rectangle(bounds[i].x + ti.left, bounds[i].y + ti.top, bounds[i].width - (ti.left + ti.right), bounds[i].height - (ti.top + ti.bottom));
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            g.setFont(pane.getFont());
            String title = pane.getTitleAt(i);
            Icon icon = pane.getIconAt(i);
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            String text = SwingUtilities.layoutCompoundLabel(pane, g.getFontMetrics(), pane.getTitleAt(i), pane.getIconAt(i), this.verticalAlignment_, this.horizontalAlignment_, this.verticalTextPosition_, this.horizontalTextPosition_, viewR, iconR, textR, icon != null && title != null && title.length() > 0 ? this.textIconGap_ : 0);
            this.dummyColor_ = this.getTabColor(i, i == selected);
            g.setColor(this.dummyColor_);
            if (icon != null) {
                icon.paintIcon(this.dummyComponent_, g, iconR.x, iconR.y);
            }
            if (i == selected) {
                g.setColor(Color.white);
            } else {
                g.setColor(pane.getForeground());
            }
            if (title == null || title.length() <= 0) continue;
            g.drawString(title, textR.x, textR.y + g.getFontMetrics().getAscent());
        }
        Shape clip = g.getClip();
        overlap = this.blendBorders_ ? this.contentBorder_.getBorderInsets((Component)this.dummyComponent_).top : 0;
        g.clipRect(content.x, content.y, content.width, content.height);
        this.paintContentBorder(g, content.x, content.y - overlap, content.width, content.height + overlap);
        g.setClip(clip);
    }

    protected Dimension calculateTabMinimum(JTabbedPane pane) {
        FontMetrics metrics = pane.getFontMetrics(pane.getFont());
        Rectangle big = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        int count = pane.getTabCount();
        int width = 0;
        int height = 0;
        for (int i = 0; i < count; ++i) {
            Icon icon;
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            String title = pane.getTitleAt(i);
            SwingUtilities.layoutCompoundLabel(pane, metrics, title, icon, this.verticalAlignment_, this.horizontalAlignment_, this.verticalTextPosition_, this.horizontalTextPosition_, big, iconR, textR, (icon = pane.getIconAt(i)) != null && title != null && title.length() > 0 ? this.textIconGap_ : 0);
            Rectangle bounds = iconR.union(textR);
            width = Math.max(width, bounds.width);
            height = Math.max(height, bounds.height);
        }
        Insets bi = this.tabBorder_.getBorderInsets(this.dummyComponent_);
        height += bi.top + bi.bottom;
        width += bi.left + bi.right;
        return new Dimension(Math.max(width += this.tabInsets_.left + this.tabInsets_.right, this.tabMinimumSize_.width), Math.max(height += this.tabInsets_.top + this.tabInsets_.bottom, this.tabMinimumSize_.height));
    }

    protected class StackedTabLayout
    implements LayoutManager {
        protected StackedTabLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JTabbedPane pane = (JTabbedPane)parent;
            Insets insets = pane.getInsets();
            Insets cbi = CuiStackedTabsUI.this.contentBorder_.getBorderInsets(CuiStackedTabsUI.this.dummyComponent_);
            Component[] children = parent.getComponents();
            int width = 0;
            int height = 0;
            for (int i = 0; i < children.length; ++i) {
                Dimension d = children[i].getPreferredSize();
                width = Math.max(width, d.width + cbi.left + cbi.right);
                height = Math.max(height, d.height + cbi.top + cbi.bottom);
            }
            Dimension tabMinimum = CuiStackedTabsUI.this.calculateTabMinimum(pane);
            width = Math.max(width, tabMinimum.width);
            height += children.length * tabMinimum.height;
            if (CuiStackedTabsUI.this.blendBorders_) {
                height -= CuiStackedTabsUI.this.tabBorder_.getBorderInsets((Component)CuiStackedTabsUI.this.dummyComponent_).bottom + CuiStackedTabsUI.this.contentBorder_.getBorderInsets((Component)CuiStackedTabsUI.this.dummyComponent_).top;
            }
            return new Dimension(width + (insets.left + insets.right), height + (insets.top + insets.bottom));
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            JTabbedPane pane = (JTabbedPane)parent;
            Insets insets = pane.getInsets();
            Insets cbi = CuiStackedTabsUI.this.contentBorder_.getBorderInsets(CuiStackedTabsUI.this.dummyComponent_);
            Component[] children = parent.getComponents();
            int width = 0;
            int height = 0;
            for (int i = 0; i < children.length; ++i) {
                Dimension d = children[i].getMinimumSize();
                width = Math.max(width, d.width + cbi.left + cbi.right);
                height = Math.max(height, d.height + cbi.top + cbi.bottom);
            }
            Dimension tabMinimum = CuiStackedTabsUI.this.calculateTabMinimum(pane);
            width = Math.max(width, tabMinimum.width);
            height += children.length * tabMinimum.height;
            if (CuiStackedTabsUI.this.blendBorders_) {
                height -= CuiStackedTabsUI.this.tabBorder_.getBorderInsets((Component)CuiStackedTabsUI.this.dummyComponent_).bottom + CuiStackedTabsUI.this.contentBorder_.getBorderInsets((Component)CuiStackedTabsUI.this.dummyComponent_).top;
            }
            return new Dimension(width + (insets.left + insets.right), height + (insets.top + insets.bottom));
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            JTabbedPane pane = (JTabbedPane)parent;
            int selected = pane.getSelectedIndex();
            Insets cbi = CuiStackedTabsUI.this.contentBorder_.getBorderInsets(CuiStackedTabsUI.this.dummyComponent_);
            Rectangle contentBounds = CuiStackedTabsUI.this.calculateContentBounds(pane);
            Component[] children = parent.getComponents();
            int overlap = CuiStackedTabsUI.this.blendBorders_ ? cbi.top : 0;
            children[selected].setBounds(contentBounds.x + cbi.left, contentBounds.y + cbi.top - overlap, contentBounds.width - (cbi.left + cbi.right), contentBounds.height - (cbi.top + cbi.bottom) + overlap);
            for (int i = 0; i < children.length; ++i) {
                children[i].setVisible(i == selected);
            }
        }
    }
}

