/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.base;

import com.ge.med.terra.tap.dm.DMSystem;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPdisplayArea;
import com.ge.med.terra.xpv.laf.LafUtils;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class BasicDMApp {
    XPcontrolArea ca = new XPcontrolArea();
    XPdisplayArea da = new XPdisplayArea();
    public Properties prop;
    String[] args = null;
    JButton quit = new JButton();
    JPanel quitTclPanel = new JPanel();
    public JFrame mainWindow;
    public JFrame uiWindow;
    public DMSystem dms = null;

    public BasicDMApp(URL propFile, String appName, String[] args) {
        LafUtils.setupLAF();
        System.setProperty("tap.dm.ImageMemory", "100");
        String s = System.getProperty("xpv.resources");
        try {
            if (s != null) {
                propFile = new URL(s);
            }
            this.prop = XPutil.loadXPVAppProperties(propFile.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.args = args;
        String systemName = System.getProperty("System");
        this.dms = systemName != null ? DMSystem.getDMSystem(systemName) : DMSystem.getDMSystem(null);
        this.prop.setProperty("Appname", appName);
        String screenMode = System.getProperty("ScreenMode");
        if (screenMode != null) {
            this.prop.setProperty("ScreenMode", screenMode);
        }
        try {
            this.dms.init("DemoXPV", this.prop, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void registerShortCuts() {
        KeyStroke printImage = KeyStroke.getKeyStroke(112, 0, true);
        KeyStroke printMid = KeyStroke.getKeyStroke(114, 0, true);
        KeyStroke windowLevelPlusByTwo = KeyStroke.getKeyStroke(38, 0);
        KeyStroke windowLevelMinusByTwo = KeyStroke.getKeyStroke(40, 0);
        KeyStroke windowWidthPlusByTwo = KeyStroke.getKeyStroke(39, 0);
        KeyStroke windowWidthMinusByTwo = KeyStroke.getKeyStroke(37, 0);
    }

    public void start() {
        this.registerShortCuts();
        this.quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.quit.setText("Quit");
        this.quitTclPanel.setLayout(new BorderLayout());
        this.quit.setMargin(new Insets(1, 10, 1, 10));
        this.quitTclPanel.setLayout(new GridBagLayout());
        this.quitTclPanel.add((Component)this.quit, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 15, 2, new Insets(10, 10, 0, 10), 0, 0));
        this.da.getScreen().putClientProperty("DMSystem", this.dms);
        this.ca.setProperties(this.prop);
        this.da.setProperties(this.prop);
        this.ca.setScreen(this.da.getScreen());
        this.ca.setHeader(this.da.getHeader());
        this.ca.setData(this.dms.getSelection());
        this.dms.setControlAndDisplayAreaBounds(this.ca, new JPanel[]{this.da});
        this.da.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent expv) {
                BasicDMApp.this.ca.setData(BasicDMApp.this.dms.getSelection());
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
    }

    public void setVisible(boolean b) {
        this.mainWindow.setVisible(b);
        this.uiWindow.setVisible(b);
    }

    static {
        try {
            String lang = System.getProperty("GE_LANG");
            if (lang != null) {
                String[] str = lang.split("_");
                Locale.setDefault(new Locale(str[0], str[1]));
            } else {
                lang = System.getProperty("LOCALE");
                if (lang != null) {
                    Locale.setDefault(new Locale(lang));
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger("DemoXPV").log(Level.WARNING, "obtaining i18n resource bundle failed", e);
        }
    }
}

