/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.RowColCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.AutoControlResources;
import com.ge.med.terra.xpv.autoControls.Messages;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.ui.RowColumnCombo;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class XPwRowColCombo
extends RowColumnCombo
implements CapableListener {
    static ResourceBundle res = AutoControlResources.STRING_RESOURCES;
    XPscreen screen = null;
    AutoControlPanelSeek panelSeek = null;
    private PropertyChangeListener viewPortListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "data_changed") {
                XPwRowColCombo.this.updateThis();
            } else if (evt.getPropertyName() == "RowColumnProperty") {
                Dimension dim = (Dimension)evt.getNewValue();
                XPwRowColCombo.this.updateThis(dim.height, dim.width);
            }
        }
    };

    public XPwRowColCombo() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setValue(new Dimension(2, 2));
        this.setFocusable(false);
    }

    public void setData(DMObject[] objs) {
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
        RowColCapable rc = (RowColCapable)this.panelSeek.getCapable("com.ge.med.idc.RowColCapable");
        if (rc != null) {
            this.setValue(new Dimension(rc.getCols(), rc.getRows()));
        }
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        screen.addPropertyChangeListener(this.viewPortListener);
    }

    private void updateThis(final int rows, final int cols) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                XPwRowColCombo.this.setValue(new Dimension(cols, rows));
                XPwRowColCombo.this.repaint();
            }
        });
    }

    private void updateThis() {
        RowColCapable rc = this.panelSeek.getRCPort();
        if (rc == null) {
            return;
        }
        this.setValue(new Dimension(rc.getCols(), rc.getRows()));
    }

    public void this_actionPerformed(ActionEvent e) {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwRowColCombo> " + Tid.newTid());
        Dimension d = this.getValue();
        RowColCapable rc = this.panelSeek.getRCPort();
        if (rc != null) {
            rc.setRowCol(d.height, d.width);
            rc.repaint();
        }
        XPutil.getLogger().log(Level.FINEST, "End <XPwRowColCombo> ");
        Tid.popTID();
    }

    private void jbInit() throws Exception {
        this.setToolTipText(Messages.getString("XPwRowColCombo.selectViewportLayout"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                XPwRowColCombo.this.this_mouseClicked(e);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XPwRowColCombo.this.this_actionPerformed(e);
            }
        });
    }

    public boolean verifyScreen() {
        int row = (int)this.getValue().getHeight();
        int col = (int)this.getValue().getWidth();
        RowColCapable rc = this.panelSeek.getRCPort();
        if (rc == null) {
            return true;
        }
        return row == rc.getRows() && col == rc.getCols();
    }

    public void this_mouseClicked(MouseEvent e) {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwRowColCombo> " + Tid.newTid());
        Dimension d = this.getValue();
        RowColCapable rc = this.panelSeek.getRCPort();
        if (rc != null) {
            rc.setRowCol(d.height, d.width);
            rc.repaint();
        }
        XPutil.getLogger().log(Level.FINEST, "End <XPwRowColCombo> ");
        Tid.popTID();
    }
}

