/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.autoControls;

import com.ge.med.idc.CineCapable;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.util.log.Tid;
import com.ge.med.terra.xpv.autoControls.AutoControlPanelSeek;
import com.ge.med.terra.xpv.autoControls.AutoControlResources;
import com.ge.med.terra.xpv.autoControls.XPwCine;
import com.ge.med.terra.xpv.base.CapableListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPscreen;
import com.ge.med.terra.xpv.laf.LafUtils;
import com.ge.med.terra.xpv.util.XPutil;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class XPwCineFrameControl
extends JPanel
implements CapableListener,
Serializable,
ActionListener {
    static ResourceBundle res = AutoControlResources.STRING_RESOURCES;
    transient XPscreen screen = null;
    transient AutoControlPanelSeek panelSeek = null;
    Icon beginIcon = new ImageIcon(XPwCine.class.getResource("/com/ge/med/terra/xpv/cuiIcons/begining_latest.png"));
    Icon endIcon = new ImageIcon(XPwCine.class.getResource("/com/ge/med/terra/xpv/cuiIcons/end_latest.png"));
    Icon nextIcon = new ImageIcon(XPwCine.class.getResource("/com/ge/med/terra/xpv/cuiIcons/step-forward_latest.png"));
    Icon previousIcon = new ImageIcon(XPwCine.class.getResource("/com/ge/med/terra/xpv/cuiIcons/step-back_latest.png"));
    JButton beginButton = new JButton();
    JButton endButton = new JButton();
    JButton previousButton = new JButton();
    JButton nextButton = new JButton();

    public XPwCineFrameControl() {
        this.panelSeek = new AutoControlPanelSeek(this);
        this.addAncestorListener(this.panelSeek);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setData(DMObject[] objs) {
    }

    private void jbInit() throws Exception {
        this.setOpaque(false);
        JPanel p = new JPanel(new GridLayout(1, 0));
        p.setOpaque(false);
        p.add(this.beginButton);
        p.add(this.previousButton);
        p.add(this.nextButton);
        p.add(this.endButton);
        this.add(p);
        this.beginButton.setIcon(this.beginIcon);
        this.previousButton.setIcon(this.previousIcon);
        this.nextButton.setIcon(this.nextIcon);
        this.endButton.setIcon(this.endIcon);
        LafUtils.installButtonGroupBorder(new JComponent[]{this.beginButton, this.previousButton, this.nextButton, this.endButton}, 1, 4, true);
        this.beginButton.addActionListener(this);
        this.endButton.addActionListener(this);
        this.previousButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.beginButton.setFocusable(false);
        this.endButton.setFocusable(false);
        this.previousButton.setFocusable(false);
        this.nextButton.setFocusable(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        XPutil.getLogger().log(Level.FINEST, "Start <XPwCine>  " + Tid.newTid());
        CineCapable cinePort = (CineCapable)this.panelSeek.getCapable("com.ge.med.idc.CineCapable");
        if (cinePort != null) {
            Object src = e.getSource();
            if (src == this.beginButton) {
                cinePort.setOffset(cinePort.getStartOffset());
            } else if (src == this.endButton) {
                cinePort.setOffset(cinePort.getEndOffset());
            } else if (src == this.previousButton) {
                cinePort.setOffset(cinePort.getOffset() - cinePort.getCineSkip());
            } else {
                cinePort.setOffset(cinePort.getOffset() + cinePort.getCineSkip());
            }
        }
        XPutil.getLogger().log(Level.FINEST, "End <XPwCine>");
        Tid.popTID();
    }

    void setButtonProp(boolean cine) {
        this.beginButton.setEnabled(!cine);
        this.endButton.setEnabled(!cine);
        this.previousButton.setEnabled(!cine);
        this.nextButton.setEnabled(!cine);
    }

    @Override
    public void setProperties(Properties properties) {
    }

    @Override
    public void selectionChanged(JComponent oldPort, JComponent newPort) {
    }

    @Override
    public void setScreen(XPscreen screen) {
        this.screen = screen;
        if (screen != null) {
            screen.addPropertyChangeListener("Cine", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    XPwCineFrameControl.this.setButtonProp(XPwCineFrameControl.this.isCine());
                }
            });
        }
    }

    @Override
    public void setControlArea(XPcontrolArea ca) {
    }

    public boolean isCine() {
        CineCapable cinePort = (CineCapable)this.panelSeek.getCapable("com.ge.med.idc.CineCapable");
        if (cinePort == null) {
            return false;
        }
        if (cinePort.getMaxFrame() == 0) {
            return false;
        }
        return cinePort.getCine();
    }
}

