/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.xpv.apps;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.xpv.base.Selection;
import com.ge.med.terra.xpv.base.SelectionListener;
import com.ge.med.terra.xpv.base.XPcontrolArea;
import com.ge.med.terra.xpv.base.XPdisplayArea;
import com.ge.med.terra.xpv.laf.LafUtils;
import com.ge.med.terra.xpv.onport.XPopPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileInputStream;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class xpv
extends JPanel {
    XPcontrolArea ca;
    XPdisplayArea da = new XPdisplayArea();
    Properties prop = new Properties();
    Selection sel;
    String[] args = null;
    JButton quit = new JButton();

    public xpv(String[] args) {
        this.args = args;
        this.setup();
    }

    public xpv() {
        this.setup();
    }

    private void setup() {
        try {
            this.prop.load(this.getClass().getResourceAsStream("xpvpet.properties"));
            String config = System.getProperties().getProperty("XPVCONFIG");
            if (config != null) {
                this.prop.load(new FileInputStream(config));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        XPopPanel.setProperties(this.prop);
        this.ca = new XPcontrolArea();
        this.quit.setText("Print");
        this.quit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 1) > 0) {
                    System.exit(0);
                }
            }
        });
        this.quit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                xpv.this.print_actionPerformed(e);
            }
        });
        this.ca.add((Component)this.quit, "South");
        this.ca.setProperties(this.prop);
        this.da.setProperties(this.prop);
        this.ca.setScreen(this.da.getScreen());
        this.ca.setHeader(this.da.getHeader());
        int cutH = 147;
        int cutW = 256;
        this.ca.setBounds(0, cutH, cutW, 1024 - cutH);
        this.ca.setPreferredSize(new Dimension(cutW, 1024 - cutH));
        this.da.setBounds(0, 0, 1024, 1024);
        this.da.putClientProperty("PEF_CONTROL", this.ca);
        this.putClientProperty("PEF_CONTROL", this.ca);
        this.setLayout(new BorderLayout());
        this.add((Component)this.da, "Center");
        this.add((Component)this.ca, "West");
        String sname = this.prop.getProperty("SELECTION_CLASS", "xpv.simpleSelection");
        try {
            Class<?> c = Class.forName(sname);
            this.sel = (Selection)c.newInstance();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.sel.setArgs(this.args);
        this.sel.setJComponent(this);
        this.sel.addSelectionListener(new SelectionListener(){

            @Override
            public void ObjectsSelected(DMObject[] dmo) {
                xpv.this.ca.setData(dmo);
            }
        });
        this.addPropertyChangeListener("PEF_CORNER", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                xpv.this.adjustLayout();
            }
        });
    }

    public void adjustLayout() {
        Dimension d = (Dimension)this.getClientProperty("PEF_CORNER");
        int cutH = d.height;
        int cutW = d.width;
        this.ca.setBounds(0, cutH, cutW, 1024 - cutH);
        this.da.setBounds(cutW, 0, 1024, 1024);
    }

    public static void main(String[] args) {
        LafUtils.setupLAF();
        JFrame base = new JFrame();
        Container c = base.getContentPane();
        xpv xpv1 = new xpv(args);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        base.setBounds(0, 0, screenSize.width, screenSize.height);
        c.add(xpv1);
        base.setVisible(true);
        base.setDefaultCloseOperation(3);
    }

    void print_actionPerformed(ActionEvent e) {
        final PrinterJob printerJob = PrinterJob.getPrinterJob();
        Book book = new Book();
        book.append(this.da.getScreen(), new PageFormat());
        printerJob.setPageable(book);
        final boolean doPrint = printerJob.printDialog();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                if (doPrint) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException printerException) {
                        // empty catch block
                    }
                }
            }
        });
        t.start();
    }
}

