/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.xlib;

import com.ge.med.terra.tap.util.xlib.DesktopChangeListener;
import com.ge.med.terra.tap.util.xlib.JXDisplay;
import com.ge.med.terra.tap.util.xlib.JXEvent;
import com.ge.med.terra.tap.util.xlib.JXEventListener;
import com.ge.med.terra.tap.util.xlib.JXWindow;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFrame;

public class XRooms {
    String XROOMS = System.getProperty("KEY_PROPERTY", "_XROOMS_CURRENT");
    int screen = Integer.parseInt(System.getProperty("KEY_SCREEN", "0"));
    int window_id = Integer.parseInt(System.getProperty("KEY_WID", "-1"));
    JXDisplay disp = new JXDisplay();
    String host = "localhost";
    ArrayList listeners = new ArrayList(5);

    public XRooms() throws IOException {
        this.handleDesktopSwitch();
    }

    public XRooms(String host, int screen) throws IOException {
        this.host = host;
        this.screen = screen;
        this.handleDesktopSwitch();
    }

    public synchronized String getDesktop() throws IOException {
        JXWindow window = this.window_id == -1 ? this.disp.getScreen(this.screen).getRoot() : new JXWindow(this.disp.getScreen(this.screen), this.window_id);
        int xrooms = this.disp.internAtom(this.XROOMS, true);
        int desktopname = this.disp.getProperty(window, xrooms, 0, 0, 4, false);
        String desktop = this.disp.getAtomName(desktopname);
        return desktop;
    }

    public void addDesktopChangeListener(DesktopChangeListener l) {
        this.listeners.add(l);
    }

    public void removeDesktopChangeListener(DesktopChangeListener l) {
        this.listeners.remove(l);
    }

    private void handleDesktopSwitch() throws IOException {
        this.disp.connect(this.host + ":0");
        try {
            if (this.window_id == -1) {
                this.disp.SelectInput(this.disp.getScreen(this.screen).getRoot(), 0x400000);
            } else {
                this.disp.SelectInput(new JXWindow(this.disp.getScreen(this.screen), this.window_id), 0x400000);
            }
            this.disp.addEventHandle(28, new JXEventListener(){

                @Override
                public void event(JXEvent e) {
                    try {
                        for (int i = 0; i < XRooms.this.listeners.size(); ++i) {
                            ((DesktopChangeListener)XRooms.this.listeners.get(i)).desktopChanged(XRooms.this.getDesktop());
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        final JFrame f = new JFrame("Dummy App");
        final String desktopToDisplayOn = args.length > 0 ? args[0] : "Scan";
        f.setBounds(100, 100, 250, 250);
        f.setDefaultCloseOperation(3);
        try {
            XRooms xrooms = new XRooms(args.length > 1 ? args[1] : "localhost", 0);
            f.setVisible(xrooms.getDesktop().equals(desktopToDisplayOn));
            xrooms.addDesktopChangeListener(new DesktopChangeListener(){

                @Override
                public void desktopChanged(String desktopName) {
                    f.setVisible(desktopName.equals(desktopToDisplayOn));
                }
            });
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

