/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.xlib;

import com.ge.med.terra.tap.util.xlib.JXDisplay;
import com.ge.med.terra.tap.util.xlib.JXVisual;
import com.ge.med.terra.tap.util.xlib.JXWindow;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class JXScreen {
    private JXDisplay display;
    private JXWindow root;
    private int white;
    private int black;
    private int currentInputMasks;
    private int width;
    private int height;
    private int widthInMM;
    private int heightInMM;
    private int pixelWidth;
    private int pixelHeight;
    private int minInstalledMaps;
    private int maxInstalledMaps;
    private int backingStores;
    private int saveUnders;
    JXVisual[] visualArray;
    int visuals = 0;

    public JXWindow getRoot() {
        return this.root;
    }

    JXDisplay getDisplay() {
        return this.display;
    }

    public int getWhite() {
        return this.white;
    }

    public int getBlack() {
        return this.black;
    }

    public int getCurrentInputMasks() {
        return this.currentInputMasks;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidthInMM() {
        return this.widthInMM;
    }

    public int getHeightInMM() {
        return this.heightInMM;
    }

    public int getPixelWidth() {
        return this.pixelWidth;
    }

    public int getPixelHeight() {
        return this.pixelHeight;
    }

    public int getMinInstalledMaps() {
        return this.minInstalledMaps;
    }

    public int getMaxInstalledMaps() {
        return this.maxInstalledMaps;
    }

    public int backingStores() {
        return this.backingStores;
    }

    public int saveUnders() {
        return this.saveUnders;
    }

    public String toString() {
        return "Screen(" + this.width + "x" + this.height + ")";
    }

    JXScreen(JXDisplay display, int[] bpp, int[] bitPad) throws IOException {
        DataInputStream in = display.in;
        this.display = display;
        int rootId = in.readInt();
        System.out.println("root ID=" + rootId);
        int paletteResource = in.readInt();
        this.white = in.readInt();
        this.black = in.readInt();
        this.currentInputMasks = in.readInt();
        this.width = in.readShort();
        this.height = in.readShort();
        this.widthInMM = in.readShort();
        this.heightInMM = in.readShort();
        this.pixelWidth = this.widthInMM / this.width;
        this.pixelHeight = this.heightInMM / this.height;
        this.minInstalledMaps = in.readShort();
        this.maxInstalledMaps = in.readShort();
        int rootVisualResource = in.readInt();
        this.backingStores = in.readByte();
        this.saveUnders = in.readByte();
        byte rootBits = in.readByte();
        int depths = in.readByte();
        ArrayList<JXVisual> visualList = new ArrayList<JXVisual>();
        for (int d = 0; d < depths; ++d) {
            byte depth = in.readByte();
            in.skipBytes(1);
            int dvisuals = in.readShort();
            in.skipBytes(4);
            for (int v = 0; v < dvisuals; ++v) {
                visualList.add(JXVisual.createVisualFromStream(this, display, depth, bpp[depth], bitPad[depth]));
            }
        }
        this.visuals = visualList.size();
        this.visualArray = visualList.toArray(new JXVisual[this.visuals]);
        this.root = new JXWindow(this, rootId);
    }
}

