/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.util.tport.TPortAnnot;
import com.ge.med.terra.tap.util.tport.TPortScene;
import com.ge.med.terra.tap.util.tport.XResponseCurve;
import com.ge.med.terra.tap.util.tport.color.ColorTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class XPort
extends JPanel {
    private TPortScene s = new TPortScene();
    Object r_hint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
    private DMImage[] imgSet = new DMImage[0];
    private int frame;
    private boolean cine = false;
    private int cineRate = 100;
    Timer timer1;
    private boolean lock = false;
    boolean highValClip = true;
    boolean invert = false;
    private static Color selectColor;
    TPortAnnot annot = TPortAnnot.getDefault();
    Graphics2D g2 = null;
    Graphics mainG = null;
    private boolean hasChildren = false;
    int saved_min;
    int saved_max;
    private boolean useModalityInfo = true;
    private boolean oldInvertFlag = true;
    boolean wlFirst = true;
    public static final int BILINEAR = 1;
    public static final int NEAREST_NEIGHBOR = 0;
    public static final int BICUBIC = 2;
    int wlDir = 0;
    int SLO = 0;
    boolean rotateEnabled = true;
    boolean cineEnabled = true;
    static short[] toLogSpace;
    static int[] GrayScale;
    int[] rgb = new int[65536];
    long[] t = new long[10];
    int c = 0;
    static int paintCount;
    Graphics scrGr = null;
    static BufferedImage screenBuffer;
    Dimension _d = new Dimension();
    AffineTransform _tx = new AffineTransform();
    IndexColorModel cm;
    BufferedImage finalimage;
    int old_max;
    int old_min;
    DMImage oldimgSet = null;
    int mx;
    int my;
    int mouse;
    int orig_w_max = 0;
    int orig_w_min = 0;
    double orig_zoom = 0.0;
    double orig_panX = 0.0;
    double orig_panY = 0.0;
    private String namedColorMap;
    private int[] colorMap = GrayScale;
    private boolean autoLeveled;
    private boolean showWL = true;
    private boolean inWL = false;
    private boolean alwaysShowWL = false;

    public void setHasChildren(boolean children) {
        this.hasChildren = children;
    }

    public boolean getHasChildren() {
        return this.hasChildren;
    }

    public XPort() {
        this.resetTransForm();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setRendering(int render) {
        if (render == 1) {
            this.r_hint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        } else if (render <= 0) {
            this.r_hint = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        } else if (render > 1) {
            this.r_hint = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
        }
        this.repaint();
    }

    public int getRendering() {
        if (this.r_hint == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
            return 1;
        }
        if (this.r_hint == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
            return 0;
        }
        if (this.r_hint == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
            return 2;
        }
        return 0;
    }

    void cineStep() {
        if (this.imgSet.length == 0) {
            return;
        }
        ++this.frame;
        this.frame %= this.imgSet.length;
        this.repaint();
    }

    public void setCineRate(int delay) {
        this.cineRate = delay;
        if (this.timer1 != null) {
            this.timer1.setDelay(delay);
        }
    }

    public int getCineRate() {
        return this.cineRate;
    }

    public boolean getCine() {
        return this.cine;
    }

    public void setCine(boolean cine) {
        this.cine = cine;
        if (this.timer1 == null) {
            this.timer1 = new Timer(this.cineRate, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XPort.this.cineStep();
                }
            });
        }
        if (cine) {
            this.timer1.start();
        } else {
            this.timer1.stop();
        }
    }

    public void setWLdir(int wlDir) {
        this.wlDir = wlDir;
    }

    public int getWLdir() {
        return this.wlDir;
    }

    public void setWindowMax(int max) {
        this.s.window_max = max;
        this.repaint();
    }

    public int getWindowMax() {
        return this.s.window_max;
    }

    public void setWindowMin(int min) {
        this.s.window_min = min;
        this.repaint();
    }

    public int getWindowMin() {
        return this.s.window_min;
    }

    public void setSelection(int sel) {
        if (this.s.selection == sel) {
            return;
        }
        this.s.selection = sel;
        this.paintSelection();
    }

    public int getSelection() {
        return this.s.selection;
    }

    public void setShownLevelOffset(int SLO) {
        this.SLO = SLO;
    }

    public int getShownLevelOffset() {
        return this.SLO;
    }

    void paintSelection() {
        if (this.s.selection == 0) {
            this.repaint();
            return;
        }
        Graphics gr = this.getGraphics();
        gr.setColor(selectColor);
        gr.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public TPortAnnot getAnnot() {
        return this.annot;
    }

    public void setAnnot(TPortAnnot annot) {
        this.annot = annot;
    }

    public void setZoom(double zoom) {
        this.s.zoom = zoom;
        this.repaint();
    }

    public double getZoom() {
        return this.s.zoom;
    }

    public void setRotate(double rotate) {
        this.s.rotate = rotate;
        this.repaint();
    }

    public double getRotate() {
        return this.s.rotate;
    }

    public void setFrame(int frame) {
        this.frame = frame;
        this.repaint();
    }

    public int getFrame() {
        return this.frame;
    }

    public void setPanY(double pan_y) {
        this.s.pan_y = pan_y;
        this.repaint();
    }

    public double getPanY() {
        return this.s.pan_y;
    }

    public void setPanX(double pan_x) {
        this.s.pan_x = pan_x;
        this.repaint();
    }

    public double getPanX() {
        return this.s.pan_x;
    }

    public boolean isRotateEnabled() {
        return this.rotateEnabled;
    }

    public void setRotateEnabled(boolean enabled) {
        this.rotateEnabled = enabled;
    }

    public boolean isCineEnabled() {
        return this.cineEnabled;
    }

    public void setCineEnabled(boolean enabled) {
        this.cineEnabled = enabled;
    }

    public boolean isLock() {
        return this.lock;
    }

    public void setLock(boolean lock) {
        this.lock = lock;
        this.repaint();
    }

    public void resetTransForm() {
        TPortScene.resetScene(this.s);
        this.frame = 0;
    }

    public void setImages(DMImage[] imgSet, int frame) {
        this.imgSet = imgSet;
        this.frame = frame % imgSet.length;
    }

    public void setImages(DMImage[] imgSet) {
        this.imgSet = imgSet;
        this.frame = imgSet.length == 0 ? 0 : this.frame % imgSet.length;
    }

    public TPortScene getScene() {
        return this.s;
    }

    public DMImage[] getImages() {
        return this.imgSet;
    }

    public void setScene(TPortScene s) {
        this.s = s;
        this.repaint();
    }

    public boolean getUseModalityInfo() {
        return this.useModalityInfo;
    }

    public void setUseModalityInfo(boolean b) {
        this.useModalityInfo = b;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean b) {
        this.oldInvertFlag = this.invert;
        this.invert = b;
    }

    private void fillRGB() {
        int max;
        if (this.s.window_min < Short.MIN_VALUE) {
            this.s.window_min = Short.MIN_VALUE;
        }
        if (this.s.window_max < Short.MIN_VALUE) {
            this.s.window_max = Short.MIN_VALUE;
        }
        if (this.s.window_min > Short.MAX_VALUE) {
            this.s.window_min = Short.MAX_VALUE;
        }
        if (this.s.window_max > Short.MAX_VALUE) {
            this.s.window_max = Short.MAX_VALUE;
        }
        int min = this.s.window_min < 0 ? 0 : this.s.window_min;
        int n = max = this.s.window_max < 0 ? 0 : this.s.window_max;
        if (!this.invert) {
            int i;
            for (i = 0; i < this.s.window_min; ++i) {
                this.rgb[i] = 0;
            }
            for (i = min; i < max; ++i) {
                this.rgb[i] = this.colorMap[255 * (i - this.s.window_min) / (this.s.window_max - this.s.window_min)];
            }
            for (i = max; i < 32768; ++i) {
                this.rgb[i] = this.colorMap[255];
            }
            if (this.highValClip) {
                for (i = 32768; i < 65536; ++i) {
                    this.rgb[i] = this.colorMap[0];
                }
            } else {
                for (i = 32768; i < 65536; ++i) {
                    this.rgb[i] = this.colorMap[255];
                }
            }
        } else {
            int i;
            for (i = 0; i < min; ++i) {
                this.rgb[i] = this.colorMap[255];
            }
            for (i = min; i < max; ++i) {
                this.rgb[i] = this.colorMap[255 - 255 * (i - this.s.window_min) / (this.s.window_max - this.s.window_min)];
            }
            for (i = max; i < 32768; ++i) {
                this.rgb[i] = this.colorMap[0];
            }
            if (this.highValClip) {
                for (i = 32768; i < 65536; ++i) {
                    this.rgb[i] = this.colorMap[255];
                }
            } else {
                for (i = 32768; i < 65536; ++i) {
                    this.rgb[i] = this.colorMap[0];
                }
            }
        }
    }

    public void greyScaleInvert() {
        System.out.println("Doing grey scale inversion");
        for (int i = 0; i < this.rgb.length; ++i) {
            int temp = this.rgb[i];
            this.rgb[i] = this.rgb[this.rgb.length - i - 1];
            this.rgb[this.rgb.length - i - 1] = temp;
        }
    }

    @Override
    public void paint(Graphics gr) {
        if (this.wlFirst) {
            this.paintWLfirst(gr);
        } else {
            this.paintPZfirst(gr);
        }
    }

    public void paintWLfirst(Graphics gr) {
        if (!this.lock) {
            this.t[this.c] = System.currentTimeMillis();
            this.getSize(this._d);
            if (!super.isDoubleBuffered()) {
                gr.setColor(Color.black);
                gr.fillRect(0, 0, this._d.width, this._d.height);
            }
            if (this.frame >= 0 && this.imgSet != null && this.imgSet.length > 0) {
                int f = this.frame % this.imgSet.length;
                if (this.imgSet[f] != null) {
                    int iHeight;
                    double normy;
                    int iWidth = this.imgSet[f].getWidth();
                    double normx = (double)this._d.width / (double)iWidth;
                    double norm = normx > (normy = (double)this._d.height / (double)(iHeight = this.imgSet[f].getHeight())) ? normy : normx;
                    this.g2 = (Graphics2D)gr.create();
                    this.fillRGB();
                    this._tx.setToIdentity();
                    this._tx.translate(this._d.width / 2, this._d.height / 2);
                    this._tx.translate(this.s.pan_x * (double)this._d.width, this.s.pan_y * (double)this._d.height);
                    this._tx.scale(norm, norm);
                    this._tx.rotate(this.s.rotate * Math.PI / 180.0);
                    this._tx.scale(this.s.zoom, this.s.zoom);
                    this._tx.translate(-iWidth / 2, -iHeight / 2);
                    this.g2.transform(this._tx);
                    if (this.imgSet[this.frame].getPixelData().getColorModel().getPixelSize() == 16) {
                        if (this.old_max != this.s.window_max || this.old_min != this.s.window_min || this.oldimgSet != this.imgSet[f] || this.oldInvertFlag != this.invert) {
                            this.cm = new IndexColorModel(16, 65536, this.rgb, 0, false, -1, 1);
                            this.finalimage = new BufferedImage(this.cm, this.imgSet[f].getPixelData().getRaster(), false, null);
                            this.old_max = this.s.window_max;
                            this.old_min = this.s.window_min;
                            this.oldimgSet = this.imgSet[f];
                        }
                    } else {
                        this.finalimage = this.imgSet[f].getPixelData();
                    }
                    this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.r_hint);
                    if (super.isDoubleBuffered()) {
                        Image offScreen = this.createImage(this.getWidth(), this.getHeight());
                        Graphics2D goff = (Graphics2D)offScreen.getGraphics();
                        goff.fillRect(0, 0, this.getWidth(), this.getHeight());
                        goff.setTransform(this._tx);
                        goff.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.r_hint);
                        goff.drawImage((Image)this.finalimage, 0, 0, null);
                        gr.drawImage(offScreen, 0, 0, this.getWidth(), this.getHeight(), null);
                    } else {
                        this.g2.drawImage((Image)this.finalimage, 0, 0, null);
                    }
                    if (this.annot != null) {
                        this.annot.draw(this.imgSet[f].getPixelData(), gr, this._d.width, this._d.height);
                        if (this.alwaysShowWL) {
                            int width = this.s.window_max - this.s.window_min;
                            int level = (this.s.window_max + this.s.window_min) / 2;
                            TPortAnnot.annotDraw(gr, this._d.width - 80, this._d.height - 11, "W:" + width + "L:" + (level + this.SLO));
                        } else if (this.showWL && this.inWL) {
                            int width = this.s.window_max - this.s.window_min;
                            int level = (this.s.window_max + this.s.window_min) / 2;
                            TPortAnnot.annotDraw(gr, this._d.width - 80, this._d.height - 11, "W:" + width + "L:" + (level + this.SLO));
                        }
                    }
                }
                if (this.s.selection > 0) {
                    gr.setColor(selectColor);
                    gr.drawRect(0, 0, this._d.width - 1, this._d.height - 1);
                }
            }
        }
        if (this.hasChildren) {
            this.paintChildren(gr);
        }
    }

    public void paintPZfirst(Graphics gr) {
        if (!this.lock) {
            this.t[this.c] = System.currentTimeMillis();
            this.getSize(this._d);
            if (!super.isDoubleBuffered()) {
                gr.setColor(Color.black);
                gr.fillRect(0, 0, this._d.width, this._d.height);
            }
            if (this.frame >= 0 && this.imgSet != null && this.imgSet.length > 0) {
                int f = this.frame % this.imgSet.length;
                if (this.imgSet[f] != null) {
                    int iHeight;
                    double normy;
                    int iWidth = this.imgSet[f].getWidth();
                    double normx = (double)this._d.width / (double)iWidth;
                    double norm = normx > (normy = (double)this._d.height / (double)(iHeight = this.imgSet[f].getHeight())) ? normy : normx;
                    this.g2 = (Graphics2D)gr.create();
                    this.fillRGB();
                    this._tx.setToIdentity();
                    this._tx.translate(this._d.width / 2, this._d.height / 2);
                    this._tx.translate(this.s.pan_x * (double)this._d.width, this.s.pan_y * (double)this._d.height);
                    this._tx.scale(norm, norm);
                    this._tx.rotate(this.s.rotate * Math.PI / 180.0);
                    this._tx.scale(this.s.zoom, this.s.zoom);
                    this._tx.translate(-iWidth / 2, -iHeight / 2);
                    this.g2.transform(this._tx);
                    if (this.imgSet[this.frame].getPixelData().getColorModel().getPixelSize() == 16) {
                        if (this.old_max != this.s.window_max || this.old_min != this.s.window_min || this.oldimgSet != this.imgSet[f] || this.oldInvertFlag != this.invert) {
                            this.cm = new IndexColorModel(16, 65536, this.rgb, 0, false, -1, 1);
                            this.finalimage = new BufferedImage(this.cm, this.imgSet[f].getPixelData().getRaster(), false, null);
                            this.old_max = this.s.window_max;
                            this.old_min = this.s.window_min;
                            this.oldimgSet = this.imgSet[f];
                        }
                    } else {
                        this.finalimage = this.imgSet[f].getPixelData();
                    }
                    this.g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.r_hint);
                    if (super.isDoubleBuffered()) {
                        Image offScreen = this.createImage(this.getWidth(), this.getHeight());
                        Graphics2D goff = (Graphics2D)offScreen.getGraphics();
                        goff.fillRect(0, 0, this.getWidth(), this.getHeight());
                        goff.setTransform(this._tx);
                        goff.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.r_hint);
                        goff.drawImage((Image)this.finalimage, 0, 0, null);
                        gr.drawImage(offScreen, 0, 0, this.getWidth(), this.getHeight(), null);
                    } else {
                        this.g2.drawImage((Image)this.finalimage, 0, 0, null);
                    }
                    if (this.annot != null) {
                        this.annot.draw(this.imgSet[f].getPixelData(), gr, this._d.width, this._d.height);
                        if (this.alwaysShowWL) {
                            int width = this.s.window_max - this.s.window_min;
                            int level = (this.s.window_max + this.s.window_min) / 2;
                            TPortAnnot.annotDraw(gr, this._d.width - 80, this._d.height - 11, "W:" + width + "L:" + (level + this.SLO));
                        } else if (this.showWL && this.inWL) {
                            int width = this.s.window_max - this.s.window_min;
                            int level = (this.s.window_max + this.s.window_min) / 2;
                            TPortAnnot.annotDraw(gr, this._d.width - 80, this._d.height - 11, "W:" + width + "L:" + (level + this.SLO));
                        }
                    }
                }
                if (this.s.selection > 0) {
                    gr.setColor(selectColor);
                    gr.drawRect(0, 0, this._d.width - 1, this._d.height - 1);
                }
            }
        }
        if (this.hasChildren) {
            this.paintChildren(gr);
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.setDoubleBuffered(false);
        this.setOpaque(false);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                XPort.this.mykeyPressed(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                XPort.this.this_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                XPort.this.grabFocus();
                XPort.this.inWL = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                XPort.this.this_mouseDragged(e);
            }
        });
    }

    void this_mouseDragged(MouseEvent e) {
        if (0 != (this.mouse & 0x10)) {
            this.s.pan_x = this.orig_panX + (double)(e.getX() - this.mx) / (double)this.getWidth();
            this.s.pan_y = this.orig_panY + (double)(e.getY() - this.my) / (double)this.getHeight();
            double max_pan = 0.9 * Math.sqrt(this.s.zoom);
            if (this.s.pan_x > max_pan) {
                this.s.pan_x = max_pan;
            } else if (this.s.pan_x < -max_pan) {
                this.s.pan_x = -max_pan;
            }
            if (this.s.pan_y > max_pan) {
                this.s.pan_y = max_pan;
            } else if (this.s.pan_y < -max_pan) {
                this.s.pan_y = -max_pan;
            }
            this.repaint();
        }
        if (0 != (this.mouse & 8)) {
            int delta_level = e.getY() - this.my;
            int delta_width = this.mx - e.getX();
            switch (this.wlDir) {
                case 0: {
                    this.s.window_max = this.orig_w_max + delta_level + delta_width;
                    this.s.window_min = this.orig_w_min + delta_level - delta_width;
                    break;
                }
                case 1: {
                    int width = this.orig_w_max - this.orig_w_min;
                    int level = (this.orig_w_max + this.orig_w_min) / 2;
                    width = XResponseCurve.response(width, -delta_width);
                    level = XResponseCurve.response(level, -delta_level);
                    this.s.window_max = level + width / 2;
                    this.s.window_min = level - width / 2;
                    break;
                }
                case 2: {
                    int width = this.orig_w_max - this.orig_w_min;
                    int level = (this.orig_w_max + this.orig_w_min) / 2;
                    width = XResponseCurve.response(width, -delta_width);
                    level = XResponseCurve.response(level, delta_level);
                    this.s.window_max = level + width / 2;
                    this.s.window_min = level - width / 2;
                    break;
                }
                default: {
                    int width = this.orig_w_max - this.orig_w_min;
                    int level = (this.orig_w_max + this.orig_w_min) / 2;
                    width = XResponseCurve.response(width, -delta_width);
                    level = XResponseCurve.response(level, delta_level);
                    this.s.window_max = level + width / 2;
                    this.s.window_min = level - width / 2;
                }
            }
            if (this.s.window_max <= this.s.window_min) {
                this.s.window_min = (this.s.window_max + this.s.window_min) / 2;
                this.s.window_max = this.s.window_min - 1;
            }
            this.repaint();
        }
        if (0 != (this.mouse & 4)) {
            double delta = 1.0 + (double)(this.my - e.getY()) / 100.0;
            if (delta <= 0.0) {
                delta = 0.01;
            }
            this.s.zoom = this.orig_zoom * delta;
            if (this.s.zoom < 0.1) {
                this.s.zoom = 0.1;
            }
            if (this.s.zoom > 20.0) {
                this.s.zoom = 20.0;
            }
            this.repaint();
        }
    }

    void this_mousePressed(MouseEvent e) {
        this.mx = e.getX();
        this.my = e.getY();
        this.orig_w_max = this.s.window_max;
        this.orig_w_min = this.s.window_min;
        this.orig_zoom = this.s.zoom;
        this.orig_panX = this.s.pan_x;
        this.orig_panY = this.s.pan_y;
        this.mouse = e.getModifiers();
        if (0 != (this.mouse & 8)) {
            this.inWL = true;
        }
    }

    public void mykeyPressed(KeyEvent e) {
        if (this.cineEnabled) {
            if (e.getKeyCode() == 39) {
                this.setCine(true);
                this.repaint();
            }
            if (e.getKeyCode() == 37) {
                this.setCine(false);
                this.repaint();
            }
        }
        if (this.rotateEnabled) {
            if (e.getKeyCode() == 40) {
                this.s.rotate -= 0.2;
                this.repaint();
            }
            if (e.getKeyCode() == 38) {
                this.s.rotate += 0.2;
                this.repaint();
            }
        }
    }

    public static double[] panZoomToDicom(double pan_x, double pan_y, double zoom, int imgW, int imgH, int scrW, int scrH) {
        double norm;
        double normx = (double)scrW / (double)imgW;
        double normy = (double)scrH / (double)imgH;
        double d = norm = normx > normy ? normy : normx;
        if (pan_x == 0.0 && pan_y == 0.0 && zoom == 1.0) {
            return new double[]{0.0, 0.0, imgW, imgH};
        }
        AffineTransform _tx = new AffineTransform();
        _tx.setToIdentity();
        _tx.translate(scrW / 2, scrH / 2);
        _tx.translate(pan_x * (double)scrW, pan_y * (double)scrH);
        _tx.scale(norm, norm);
        _tx.scale(zoom, zoom);
        _tx.translate(-imgW / 2, -imgH / 2);
        double[] screen = new double[]{0.0, 0.0, scrW, scrH};
        double[] img = new double[4];
        try {
            _tx.inverseTransform(screen, 0, img, 0, 2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return img;
    }

    public void setNamedColorMap(String namedColorMap) {
        this.namedColorMap = namedColorMap;
        this.colorMap = ColorTable.getColorTable((String)namedColorMap);
    }

    public String getNamedColorMap() {
        return this.namedColorMap;
    }

    @Override
    public void setDoubleBuffered(boolean doubleBuffered) {
        super.setDoubleBuffered(doubleBuffered);
    }

    @Override
    public boolean isDoubleBuffered() {
        return super.isDoubleBuffered();
    }

    public void autoLevel() {
        int[] b = XPort.calcMinMax(this.imgSet[this.frame].getPixelData(), 10);
        this.saved_min = this.getWindowMin();
        this.saved_max = this.getWindowMax();
        this.autoLeveled = true;
        this.setWindowMin(b[0]);
        this.setWindowMax(b[1]);
    }

    public void resetLevel() {
        this.setWindowMin(this.saved_min);
        this.setWindowMax(this.saved_max);
        this.autoLeveled = false;
    }

    public static int[] calcMinMax(BufferedImage img) {
        return XPort.calcMinMax(img, 1);
    }

    public static int[] calcMinMax(BufferedImage img, int skip) {
        int[] data = new int[1];
        int[] minmax = new int[2];
        minmax[1] = Integer.MIN_VALUE;
        minmax[0] = Integer.MAX_VALUE;
        for (int y = 0; y < img.getHeight(); y += skip) {
            for (int x = 0; x < img.getWidth(); x += skip) {
                data = img.getRaster().getPixel(x, y, data);
                if (minmax[0] > data[0]) {
                    minmax[0] = data[0];
                    continue;
                }
                if (minmax[1] >= data[0]) continue;
                minmax[1] = data[0];
            }
        }
        return minmax;
    }

    public void setAutoLeveled(boolean autoLeveled) {
        if (autoLeveled) {
            this.autoLevel();
        } else {
            this.resetLevel();
        }
    }

    public boolean isAutoLeveled() {
        return this.autoLeveled;
    }

    public void setShowWL(boolean showWL) {
        this.showWL = showWL;
    }

    public boolean isShowWL() {
        return this.showWL;
    }

    public void setAlwaysShowWL(boolean alwaysShowWL) {
        this.alwaysShowWL = alwaysShowWL;
    }

    public boolean isAlwaysShowWL() {
        return this.alwaysShowWL;
    }

    static {
        int i;
        selectColor = Color.cyan;
        toLogSpace = new short[65536];
        GrayScale = new int[256];
        for (i = Short.MIN_VALUE; i < Short.MAX_VALUE; ++i) {
            XPort.toLogSpace[i & 0xFFFF] = (short)(16383.0 * Math.pow((double)i / 16383.0, 0.2));
        }
        for (i = 0; i < 256; ++i) {
            XPort.GrayScale[i] = 0x1010101 * i;
        }
        paintCount = 0;
        screenBuffer = null;
    }
}

