/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.tport.SDpram;
import com.ge.med.terra.tap.util.tport.TPort;
import com.ge.med.terra.tap.util.tport.TPortAnnot;
import com.ge.med.terra.tap.util.tport.TPortScene;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class PrismTPort
extends JPanel {
    GridLayout gridLayout1 = new GridLayout();
    SDpram p = new SDpram();
    SDpram op = new SDpram();
    TPort[] ports = new TPort[0];
    int[] index = null;
    TPortScene[] scenes = new TPortScene[0];
    BufferedImage[] imgSet;
    int offset = 0;
    boolean oneScene = false;
    private int changeMode = 2;
    private TPortAnnot annot = TPortAnnot.getDefault();
    boolean cineEnabled = false;
    boolean rotateEnabled = false;
    MouseAdapter ma = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            PrismTPort.this.mouseClick(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PrismTPort.this.mouseDown(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            PrismTPort.this.mouseUp(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    };
    long when;
    final long minTime = 180L;
    int lastScene = 0;
    private int skip = 0;
    int wlDir = 0;

    public int[] getSelection() {
        int count = 0;
        for (int i = 0; i < this.scenes.length; ++i) {
            if (this.scenes[i].selection <= 0) continue;
            ++count;
        }
        int[] sel = new int[count];
        count = 0;
        for (int i = 0; i < this.scenes.length; ++i) {
            if (this.scenes[i].selection <= 0) continue;
            sel[count++] = i;
        }
        return sel;
    }

    public void setSelection(int[] sel) {
        for (int i = 0; i < sel.length; ++i) {
            if (this.scenes.length < sel[i] || 0 > sel[i]) continue;
            this.scenes[sel[i]].selection = 1;
        }
    }

    public void setWLmode(int mode) {
        this.changeMode = mode;
    }

    public int getWLmode() {
        return this.changeMode;
    }

    public TPort getTport(int i) {
        return this.ports[i];
    }

    public TPortAnnot getAnnot() {
        return this.annot;
    }

    public void setAnnot(TPortAnnot annot) {
        this.annot = annot;
        for (int i = 0; i < this.ports.length; ++i) {
            this.ports[i].setAnnot(annot);
        }
        this.repaint();
    }

    protected void mouseDown(MouseEvent e) {
        this.when = e.getWhen();
    }

    protected void mouseClick(MouseEvent e) {
        TPort p = (TPort)e.getSource();
        if (p == null) {
            return;
        }
        int mouse = e.getModifiers();
        TPortScene gs = p.getScene();
        int cc = e.getClickCount();
        switch (cc) {
            case 1: {
                int k;
                int sel;
                int i;
                boolean shift = (mouse & 1) > 0;
                boolean ctl = (mouse & 2) > 0;
                boolean left = (mouse & 0x10) > 0;
                boolean middle = (mouse & 8) > 0;
                boolean right = (mouse & 4) > 0;
                int clickPort = 0;
                int clickScene = 0;
                for (i = 0; i < this.ports.length; ++i) {
                    if (p != this.ports[i]) continue;
                    clickPort = i;
                }
                for (i = 0; i < this.scenes.length; ++i) {
                    if (gs != this.scenes[i]) continue;
                    clickScene = i;
                }
                if (left && !shift && !ctl) {
                    this.lastScene = clickScene;
                    for (i = 0; i < this.scenes.length; ++i) {
                        int n = sel = clickScene == i ? 1 : 0;
                        if (sel == this.scenes[i].selection) continue;
                        this.scenes[i].selection = sel;
                        for (k = 0; k < this.ports.length; ++k) {
                            if (this.scenes[i] != this.ports[k].getScene()) continue;
                            this.ports[k].paintSelection();
                        }
                    }
                }
                if (left && !shift && ctl) {
                    this.lastScene = clickScene;
                    gs.selection = (gs.selection + 1) % 2;
                    p.paintSelection();
                }
                if (left && shift && !ctl) {
                    for (i = 0; i < this.scenes.length; ++i) {
                        int n = sel = (this.lastScene - i) * (clickScene - i) <= 0 ? 1 : 0;
                        if (sel == this.scenes[i].selection) continue;
                        this.scenes[i].selection = sel;
                        for (k = 0; k < this.ports.length; ++k) {
                            if (this.scenes[i] != this.ports[k].getScene()) continue;
                            this.ports[k].paintSelection();
                        }
                    }
                }
                return;
            }
            case 2: {
                boolean clickPort = false;
                boolean clickScene = false;
                Object ser = this.imgSet[p.getFrame()].getProperty("32,17");
                if (ser == null) {
                    return;
                }
                for (int i = 0; i < this.imgSet.length; ++i) {
                    this.scenes[i].selection = ser.equals(this.imgSet[i].getProperty("32,17")) ? 1 : 0;
                }
                for (int k = 0; k < this.ports.length; ++k) {
                    this.ports[k].paintSelection();
                }
                return;
            }
            case 3: {
                for (int i = 0; i < this.imgSet.length; ++i) {
                    this.scenes[i].selection = 1;
                }
                for (int k = 0; k < this.ports.length; ++k) {
                    this.ports[k].paintSelection();
                }
                return;
            }
        }
    }

    protected void mouseUp(MouseEvent e) {
        int range;
        int delta;
        int i;
        TPort p = (TPort)e.getSource();
        if (p == null) {
            return;
        }
        int mouse = e.getModifiers();
        TPortScene gs = p.getScene();
        if (e.getWhen() - this.when < 180L) {
            return;
        }
        if (0 == this.changeMode) {
            return;
        }
        if (0 != (mouse & 0x10)) {
            for (i = 0; i < this.scenes.length; ++i) {
                if (this.scenes[i].selection <= 0 && this.changeMode != 2) continue;
                delta = (this.skip & 1) == 1 ? (this.skip + 1) / 2 : this.skip / 2;
                for (range = -delta; range <= delta; ++range) {
                    if (i + delta < 0 || i + delta >= this.scenes.length) continue;
                    this.scenes[i + delta].pan_x = gs.pan_x;
                    this.scenes[i + delta].pan_y = gs.pan_y;
                }
            }
        }
        if (0 != (mouse & 8)) {
            for (i = 0; i < this.scenes.length; ++i) {
                if (this.scenes[i].selection <= 0 && this.changeMode != 2) continue;
                delta = (this.skip & 1) == 1 ? (this.skip + 1) / 2 : this.skip / 2;
                for (range = -delta; range <= delta; ++range) {
                    if (i + delta < 0 || i + delta >= this.scenes.length) continue;
                    this.scenes[i].window_max = gs.window_max;
                    this.scenes[i].window_min = gs.window_min;
                }
            }
        }
        if (0 != (mouse & 4)) {
            for (i = 0; i < this.scenes.length; ++i) {
                if (this.scenes[i].selection <= 0 && this.changeMode != 2) continue;
                delta = (this.skip & 1) == 1 ? (this.skip + 1) / 2 : this.skip / 2;
                for (range = -delta; range <= delta; ++range) {
                    if (i + delta < 0 || i + delta >= this.scenes.length) continue;
                    this.scenes[i].zoom = gs.zoom;
                }
            }
        }
        this.repaint();
    }

    void update() {
        boolean update_layout = false;
        if (this.p.cols != this.op.cols) {
            update_layout = true;
        }
        if (this.p.rows != this.op.rows) {
            update_layout = true;
        }
        if (update_layout) {
            int i;
            this.op.rows = this.p.rows;
            this.op.cols = this.p.cols;
            int size = this.op.cols * this.op.rows;
            TPort[] nports = new TPort[size];
            this.removeAll();
            for (i = 0; i < size; ++i) {
                nports[i] = new TPort();
                nports[i].setWLdir(this.wlDir);
                nports[i].setLock(true);
                nports[i].addMouseListener(this.ma);
                nports[i].setAnnot(this.annot);
                nports[i].setCineEnabled(this.cineEnabled);
                nports[i].setRotateEnabled(this.rotateEnabled);
            }
            this.gridLayout1 = new GridLayout(this.op.rows, this.op.cols);
            this.setLayout(this.gridLayout1);
            for (i = 0; i < size; ++i) {
                this.add(nports[i]);
            }
            this.ports = nports;
            this.setImages();
            this.validate();
            for (i = 0; i < size; ++i) {
                nports[i].setLock(false);
            }
            this.repaint();
        }
    }

    public void lockPorts(boolean lock) {
        for (int i = 0; i < this.ports.length; ++i) {
            this.ports[i].setLock(lock);
        }
    }

    public int[] getIndex() {
        return this.index;
    }

    public PrismTPort() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DMTag[] neededTags() {
        DMTag[] neededTags = new DMTag[]{new DMTag(8, 22), new DMTag(8, 24), new DMTag(32, 14), new DMTag(32, 17), new DMTag(32, 19)};
        return neededTags;
    }

    public static Comparator SrImSorter() {
        Comparator compareImgNo = new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)((BufferedImage)o1).getProperty("32,17");
                String s2 = (String)((BufferedImage)o2).getProperty("32,17");
                int val = Integer.parseInt(s1) - Integer.parseInt(s2);
                if (val != 0) {
                    return val;
                }
                s1 = (String)((BufferedImage)o1).getProperty("32,19");
                s2 = (String)((BufferedImage)o2).getProperty("32,19");
                return Integer.parseInt(s1) - Integer.parseInt(s2);
            }
        };
        return compareImgNo;
    }

    public TPort[] getPorts() {
        return this.ports;
    }

    public static void main(String[] args) {
        final PrismTPort p = new PrismTPort();
        JFrame frame = new JFrame("prismPort");
        JPanel pan = new JPanel();
        JPanel pan2 = new JPanel();
        JButton[] b = new JButton[]{new JButton("2x1"), new JButton("4x2"), new JButton("8x4"), new JButton("all"), new JButton("one"), new JButton("4")};
        p.setCineEnabled(true);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton b = (JButton)e.getSource();
                if (b.getText().equals("2x1")) {
                    p.setRowCol(1, 2);
                }
                if (b.getText().equals("4x2")) {
                    p.setRowCol(2, 4);
                }
                if (b.getText().equals("8x4")) {
                    p.setRowCol(4, 8);
                }
                if (b.getText().equals("all")) {
                    p.setIndex(null);
                }
                if (b.getText().equals("one")) {
                    p.setIndex(new int[]{0, -1, -1, -1, -1});
                }
                if (b.getText().equals("4")) {
                    p.setIndex(new int[]{0, 1, 2, 3, -1});
                }
            }
        };
        for (int i = 0; i < b.length; ++i) {
            pan2.add(b[i]);
            b[i].addActionListener(al);
        }
        final JScrollBar sbar = new JScrollBar(1, 0, 1, 0, 14);
        pan.setLayout(new BorderLayout());
        pan.add(sbar);
        sbar.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                p.setOffset(sbar.getValue());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        sbar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                p.setOffset(sbar.getValue());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        p.setRowCol(2, 1);
        DMSession ses = new DMSession("file", "D:/dev/ves_exams/ct/e65/s180", null);
        DMObject patient2 = ses.getChildren()[0];
        BufferedImage[] iset = patient2.getPixelData(PrismTPort.neededTags());
        Arrays.sort(iset, PrismTPort.SrImSorter());
        p.setImages(iset);
        frame.getContentPane().add(p);
        frame.getContentPane().add((Component)pan, "East");
        frame.getContentPane().add((Component)pan2, "North");
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 500);
        frame.validate();
        frame.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.black);
        this.setDoubleBuffered(false);
        this.setLayout(this.gridLayout1);
    }

    public void setOffset(int offset) {
        this.offset = offset;
        this.layoutImages();
    }

    public void setImages(BufferedImage[] imgSet, int frame) {
        this.imgSet = imgSet;
        if (imgSet != null && !this.oneScene) {
            this.scenes = new TPortScene[imgSet.length];
        }
        for (int i = 0; i < this.scenes.length; ++i) {
            this.scenes[i] = new TPortScene(imgSet[i]);
        }
        this.offset = frame;
        this.setImages();
    }

    public void setImages(BufferedImage[] imgSet) {
        this.imgSet = imgSet;
        if (imgSet != null && !this.oneScene) {
            this.scenes = new TPortScene[imgSet.length];
        }
        for (int i = 0; i < this.scenes.length; ++i) {
            this.scenes[i] = new TPortScene(imgSet[i]);
        }
        this.setImages();
    }

    public BufferedImage[] getImages() {
        return this.imgSet;
    }

    private void setImages() {
        if (this.imgSet == null) {
            return;
        }
        this.lockPorts(true);
        for (int i = 0; i < this.ports.length; ++i) {
            this.ports[i].setImages(this.imgSet);
        }
        this.layoutImages();
        this.lockPorts(false);
    }

    private void layoutImages() {
        if (this.imgSet == null) {
            return;
        }
        for (int i = 0; i < this.ports.length; ++i) {
            int f = this.calcFrame(i + this.offset);
            this.ports[i].setFrame(f);
            if (this.oneScene || f == -1) continue;
            this.ports[i].setScene(this.scenes[f]);
        }
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setIndex(int[] index) {
        this.index = index;
        this.lockPorts(true);
        this.layoutImages();
        this.lockPorts(false);
    }

    private int calcFrame(int i) {
        if (this.imgSet == null) {
            return -1;
        }
        if (this.index == null) {
            int slice = i * (this.skip + 1);
            return slice < this.imgSet.length ? slice : -1;
        }
        if (i >= this.index.length) {
            return -1;
        }
        if (this.index[i] > this.imgSet.length) {
            return -1;
        }
        return this.index[i];
    }

    public void setRowCol(int row, int col) {
        this.p.cols = col;
        this.p.rows = row;
        this.update();
    }

    public void setRows(int newRows) {
        this.p.rows = newRows;
        this.update();
    }

    public int getRows() {
        return this.p.rows;
    }

    public void setCols(int newCols) {
        this.p.cols = newCols;
        this.update();
    }

    public int getCols() {
        return this.p.cols;
    }

    public void setCineEnabled(boolean cineon) {
        for (int i = 0; i < this.ports.length; ++i) {
            this.ports[i].setCineEnabled(cineon);
        }
        this.cineEnabled = cineon;
    }

    public boolean isCineEnabled() {
        return this.cineEnabled;
    }

    public void setRotateEnabled(boolean rotateon) {
        for (int i = 0; i < this.ports.length; ++i) {
            this.ports[i].setRotateEnabled(rotateon);
        }
        this.rotateEnabled = rotateon;
    }

    public boolean isRotateEnabled() {
        return this.rotateEnabled;
    }

    public void clearSelection() {
        for (int i = 0; i < this.scenes.length; ++i) {
            this.scenes[i].selection = 0;
        }
    }

    public void setWLdir(int wlDir) {
        this.wlDir = wlDir;
        for (int i = 0; i < this.ports.length; ++i) {
            this.ports[i].setWLdir(wlDir);
        }
    }

    public int getWLdir() {
        return this.wlDir;
    }

    public void setScene(int i, TPortScene s) {
        this.scenes[i].copyScene(s);
    }

    public TPortScene getScene(int i) {
        return this.scenes[i];
    }

    @Override
    public void paint(Graphics g) {
        if (this.imgSet != null) {
            super.paint(g);
        } else {
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }
}

